/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var Node = /** @class */ (function () {
    function Node(data) {
        this.incoming = new Map();
        this.outgoing = new Map();
        this.data = data;
    }
    return Node;
}());
export { Node };
var Graph = /** @class */ (function () {
    function Graph(_hashFn) {
        this._hashFn = _hashFn;
        this._nodes = new Map();
        // empty
    }
    Graph.prototype.roots = function () {
        var e_1, _a;
        var ret = [];
        try {
            for (var _b = __values(this._nodes.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var node = _c.value;
                if (node.outgoing.size === 0) {
                    ret.push(node);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return ret;
    };
    Graph.prototype.insertEdge = function (from, to) {
        var fromNode = this.lookupOrInsertNode(from);
        var toNode = this.lookupOrInsertNode(to);
        fromNode.outgoing.set(this._hashFn(to), toNode);
        toNode.incoming.set(this._hashFn(from), fromNode);
    };
    Graph.prototype.removeNode = function (data) {
        var e_2, _a;
        var key = this._hashFn(data);
        this._nodes.delete(key);
        try {
            for (var _b = __values(this._nodes.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var node = _c.value;
                node.outgoing.delete(key);
                node.incoming.delete(key);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    Graph.prototype.lookupOrInsertNode = function (data) {
        var key = this._hashFn(data);
        var node = this._nodes.get(key);
        if (!node) {
            node = new Node(data);
            this._nodes.set(key, node);
        }
        return node;
    };
    Graph.prototype.lookup = function (data) {
        return this._nodes.get(this._hashFn(data));
    };
    Graph.prototype.isEmpty = function () {
        return this._nodes.size === 0;
    };
    Graph.prototype.toString = function () {
        var e_3, _a;
        var data = [];
        try {
            for (var _b = __values(this._nodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = __read(_c.value, 2), key = _d[0], value = _d[1];
                data.push(key + ", (incoming)[" + __spreadArray([], __read(value.incoming.keys())).join(', ') + "], (outgoing)[" + __spreadArray([], __read(value.outgoing.keys())).join(',') + "]");
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return data.join('\n');
    };
    return Graph;
}());
export { Graph };
