/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { localize } from '../../../nls';
import { sep } from '../../../base/common/path';
import { URI } from '../../../base/common/uri';
import { createDecorator } from '../../instantiation/common/instantiation';
import { startsWithIgnoreCase } from '../../../base/common/strings';
import { isNumber, isUndefinedOrNull } from '../../../base/common/types';
import { TernarySearchTree } from '../../../base/common/map';
export var IFileService = createDecorator('fileService');
export var FileType;
(function (FileType) {
    FileType[FileType["Unknown"] = 0] = "Unknown";
    FileType[FileType["File"] = 1] = "File";
    FileType[FileType["Directory"] = 2] = "Directory";
    FileType[FileType["SymbolicLink"] = 64] = "SymbolicLink";
})(FileType || (FileType = {}));
export function hasReadWriteCapability(provider) {
    return !!(provider.capabilities & 2 /* FileReadWrite */);
}
export function hasFileFolderCopyCapability(provider) {
    return !!(provider.capabilities & 8 /* FileFolderCopy */);
}
export function hasOpenReadWriteCloseCapability(provider) {
    return !!(provider.capabilities & 4 /* FileOpenReadWriteClose */);
}
export function hasFileReadStreamCapability(provider) {
    return !!(provider.capabilities & 16 /* FileReadStream */);
}
export var FileSystemProviderErrorCode;
(function (FileSystemProviderErrorCode) {
    FileSystemProviderErrorCode["FileExists"] = "EntryExists";
    FileSystemProviderErrorCode["FileNotFound"] = "EntryNotFound";
    FileSystemProviderErrorCode["FileNotADirectory"] = "EntryNotADirectory";
    FileSystemProviderErrorCode["FileIsADirectory"] = "EntryIsADirectory";
    FileSystemProviderErrorCode["FileExceedsMemoryLimit"] = "EntryExceedsMemoryLimit";
    FileSystemProviderErrorCode["FileTooLarge"] = "EntryTooLarge";
    FileSystemProviderErrorCode["NoPermissions"] = "NoPermissions";
    FileSystemProviderErrorCode["Unavailable"] = "Unavailable";
    FileSystemProviderErrorCode["Unknown"] = "Unknown";
})(FileSystemProviderErrorCode || (FileSystemProviderErrorCode = {}));
var FileSystemProviderError = /** @class */ (function (_super) {
    __extends(FileSystemProviderError, _super);
    function FileSystemProviderError(message, code) {
        var _this = _super.call(this, message) || this;
        _this.code = code;
        return _this;
    }
    return FileSystemProviderError;
}(Error));
export { FileSystemProviderError };
export function createFileSystemProviderError(error, code) {
    var providerError = new FileSystemProviderError(error.toString(), code);
    markAsFileSystemProviderError(providerError, code);
    return providerError;
}
export function ensureFileSystemProviderError(error) {
    if (!error) {
        return createFileSystemProviderError(localize('unknownError', "Unknown Error"), FileSystemProviderErrorCode.Unknown); // https://github.com/microsoft/vscode/issues/72798
    }
    return error;
}
export function markAsFileSystemProviderError(error, code) {
    error.name = code ? code + " (FileSystemError)" : "FileSystemError";
    return error;
}
export function toFileSystemProviderErrorCode(error) {
    // Guard against abuse
    if (!error) {
        return FileSystemProviderErrorCode.Unknown;
    }
    // FileSystemProviderError comes with the code
    if (error instanceof FileSystemProviderError) {
        return error.code;
    }
    // Any other error, check for name match by assuming that the error
    // went through the markAsFileSystemProviderError() method
    var match = /^(.+) \(FileSystemError\)$/.exec(error.name);
    if (!match) {
        return FileSystemProviderErrorCode.Unknown;
    }
    switch (match[1]) {
        case FileSystemProviderErrorCode.FileExists: return FileSystemProviderErrorCode.FileExists;
        case FileSystemProviderErrorCode.FileIsADirectory: return FileSystemProviderErrorCode.FileIsADirectory;
        case FileSystemProviderErrorCode.FileNotADirectory: return FileSystemProviderErrorCode.FileNotADirectory;
        case FileSystemProviderErrorCode.FileNotFound: return FileSystemProviderErrorCode.FileNotFound;
        case FileSystemProviderErrorCode.FileExceedsMemoryLimit: return FileSystemProviderErrorCode.FileExceedsMemoryLimit;
        case FileSystemProviderErrorCode.FileTooLarge: return FileSystemProviderErrorCode.FileTooLarge;
        case FileSystemProviderErrorCode.NoPermissions: return FileSystemProviderErrorCode.NoPermissions;
        case FileSystemProviderErrorCode.Unavailable: return FileSystemProviderErrorCode.Unavailable;
    }
    return FileSystemProviderErrorCode.Unknown;
}
export function toFileOperationResult(error) {
    // FileSystemProviderError comes with the result already
    if (error instanceof FileOperationError) {
        return error.fileOperationResult;
    }
    // Otherwise try to find from code
    switch (toFileSystemProviderErrorCode(error)) {
        case FileSystemProviderErrorCode.FileNotFound:
            return 1 /* FILE_NOT_FOUND */;
        case FileSystemProviderErrorCode.FileIsADirectory:
            return 0 /* FILE_IS_DIRECTORY */;
        case FileSystemProviderErrorCode.FileNotADirectory:
            return 10 /* FILE_NOT_DIRECTORY */;
        case FileSystemProviderErrorCode.NoPermissions:
            return 6 /* FILE_PERMISSION_DENIED */;
        case FileSystemProviderErrorCode.FileExists:
            return 4 /* FILE_MOVE_CONFLICT */;
        case FileSystemProviderErrorCode.FileExceedsMemoryLimit:
            return 9 /* FILE_EXCEEDS_MEMORY_LIMIT */;
        case FileSystemProviderErrorCode.FileTooLarge:
            return 7 /* FILE_TOO_LARGE */;
        default:
            return 11 /* FILE_OTHER_ERROR */;
    }
}
var FileOperationEvent = /** @class */ (function () {
    function FileOperationEvent(resource, operation, target) {
        this.resource = resource;
        this.operation = operation;
        this.target = target;
    }
    FileOperationEvent.prototype.isOperation = function (operation) {
        return this.operation === operation;
    };
    return FileOperationEvent;
}());
export { FileOperationEvent };
var FileChangesEvent = /** @class */ (function () {
    function FileChangesEvent(changes, ignorePathCasing) {
        var e_1, _a;
        var _this = this;
        this.ignorePathCasing = ignorePathCasing;
        this.added = undefined;
        this.updated = undefined;
        this.deleted = undefined;
        this.changes = changes;
        try {
            for (var changes_1 = __values(changes), changes_1_1 = changes_1.next(); !changes_1_1.done; changes_1_1 = changes_1.next()) {
                var change = changes_1_1.value;
                switch (change.type) {
                    case 1 /* ADDED */:
                        if (!this.added) {
                            this.added = TernarySearchTree.forUris(function () { return _this.ignorePathCasing; });
                        }
                        this.added.set(change.resource, change);
                        break;
                    case 0 /* UPDATED */:
                        if (!this.updated) {
                            this.updated = TernarySearchTree.forUris(function () { return _this.ignorePathCasing; });
                        }
                        this.updated.set(change.resource, change);
                        break;
                    case 2 /* DELETED */:
                        if (!this.deleted) {
                            this.deleted = TernarySearchTree.forUris(function () { return _this.ignorePathCasing; });
                        }
                        this.deleted.set(change.resource, change);
                        break;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (changes_1_1 && !changes_1_1.done && (_a = changes_1.return)) _a.call(changes_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    /**
     * Find out if the file change events match the provided resource.
     *
     * Note: when passing `FileChangeType.DELETED`, we consider a match
     * also when the parent of the resource got deleted.
     */
    FileChangesEvent.prototype.contains = function (resource) {
        var types = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            types[_i - 1] = arguments[_i];
        }
        return this.doContains.apply(this, __spreadArray([resource, { includeChildren: false }], __read(types)));
    };
    /**
     * Find out if the file change events either match the provided
     * resource, or contain a child of this resource.
     */
    FileChangesEvent.prototype.affects = function (resource) {
        var types = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            types[_i - 1] = arguments[_i];
        }
        return this.doContains.apply(this, __spreadArray([resource, { includeChildren: true }], __read(types)));
    };
    FileChangesEvent.prototype.doContains = function (resource, options) {
        var _a, _b, _c, _d, _e, _f;
        var types = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            types[_i - 2] = arguments[_i];
        }
        if (!resource) {
            return false;
        }
        var hasTypesFilter = types.length > 0;
        // Added
        if (!hasTypesFilter || types.includes(1 /* ADDED */)) {
            if ((_a = this.added) === null || _a === void 0 ? void 0 : _a.get(resource)) {
                return true;
            }
            if (options.includeChildren && ((_b = this.added) === null || _b === void 0 ? void 0 : _b.findSuperstr(resource))) {
                return true;
            }
        }
        // Updated
        if (!hasTypesFilter || types.includes(0 /* UPDATED */)) {
            if ((_c = this.updated) === null || _c === void 0 ? void 0 : _c.get(resource)) {
                return true;
            }
            if (options.includeChildren && ((_d = this.updated) === null || _d === void 0 ? void 0 : _d.findSuperstr(resource))) {
                return true;
            }
        }
        // Deleted
        if (!hasTypesFilter || types.includes(2 /* DELETED */)) {
            if ((_e = this.deleted) === null || _e === void 0 ? void 0 : _e.findSubstr(resource) /* deleted also considers parent folders */) {
                return true;
            }
            if (options.includeChildren && ((_f = this.deleted) === null || _f === void 0 ? void 0 : _f.findSuperstr(resource))) {
                return true;
            }
        }
        return false;
    };
    /**
     * @deprecated use the `contains()` method to efficiently find out if the event
     * relates to a given resource. this method ensures:
     * - that there is no expensive lookup needed by using a `TernarySearchTree`
     * - correctly handles `FileChangeType.DELETED` events
     */
    FileChangesEvent.prototype.getAdded = function () {
        return this.getOfType(1 /* ADDED */);
    };
    /**
     * Returns if this event contains added files.
     */
    FileChangesEvent.prototype.gotAdded = function () {
        return !!this.added;
    };
    /**
     * @deprecated use the `contains()` method to efficiently find out if the event
     * relates to a given resource. this method ensures:
     * - that there is no expensive lookup needed by using a `TernarySearchTree`
     * - correctly handles `FileChangeType.DELETED` events
     */
    FileChangesEvent.prototype.getDeleted = function () {
        return this.getOfType(2 /* DELETED */);
    };
    /**
     * Returns if this event contains deleted files.
     */
    FileChangesEvent.prototype.gotDeleted = function () {
        return !!this.deleted;
    };
    /**
     * @deprecated use the `contains()` method to efficiently find out if the event
     * relates to a given resource. this method ensures:
     * - that there is no expensive lookup needed by using a `TernarySearchTree`
     * - correctly handles `FileChangeType.DELETED` events
     */
    FileChangesEvent.prototype.getUpdated = function () {
        return this.getOfType(0 /* UPDATED */);
    };
    /**
     * Returns if this event contains updated files.
     */
    FileChangesEvent.prototype.gotUpdated = function () {
        return !!this.updated;
    };
    FileChangesEvent.prototype.getOfType = function (type) {
        var e_2, _a;
        var changes = [];
        var eventsForType = type === 1 /* ADDED */ ? this.added : type === 0 /* UPDATED */ ? this.updated : this.deleted;
        if (eventsForType) {
            try {
                for (var eventsForType_1 = __values(eventsForType), eventsForType_1_1 = eventsForType_1.next(); !eventsForType_1_1.done; eventsForType_1_1 = eventsForType_1.next()) {
                    var _b = __read(eventsForType_1_1.value, 2), change = _b[1];
                    changes.push(change);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (eventsForType_1_1 && !eventsForType_1_1.done && (_a = eventsForType_1.return)) _a.call(eventsForType_1);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        return changes;
    };
    /**
     * @deprecated use the `contains()` method to efficiently find out if the event
     * relates to a given resource. this method ensures:
     * - that there is no expensive lookup needed by using a `TernarySearchTree`
     * - correctly handles `FileChangeType.DELETED` events
     */
    FileChangesEvent.prototype.filter = function (filterFn) {
        return new FileChangesEvent(this.changes.filter(function (change) { return filterFn(change); }), this.ignorePathCasing);
    };
    return FileChangesEvent;
}());
export { FileChangesEvent };
export function isParent(path, candidate, ignoreCase) {
    if (!path || !candidate || path === candidate) {
        return false;
    }
    if (candidate.length > path.length) {
        return false;
    }
    if (candidate.charAt(candidate.length - 1) !== sep) {
        candidate += sep;
    }
    if (ignoreCase) {
        return startsWithIgnoreCase(path, candidate);
    }
    return path.indexOf(candidate) === 0;
}
var FileOperationError = /** @class */ (function (_super) {
    __extends(FileOperationError, _super);
    function FileOperationError(message, fileOperationResult, options) {
        var _this = _super.call(this, message) || this;
        _this.fileOperationResult = fileOperationResult;
        _this.options = options;
        return _this;
    }
    FileOperationError.isFileOperationError = function (obj) {
        return obj instanceof Error && !isUndefinedOrNull(obj.fileOperationResult);
    };
    return FileOperationError;
}(Error));
export { FileOperationError };
export var AutoSaveConfiguration = {
    OFF: 'off',
    AFTER_DELAY: 'afterDelay',
    ON_FOCUS_CHANGE: 'onFocusChange',
    ON_WINDOW_CHANGE: 'onWindowChange'
};
export var HotExitConfiguration = {
    OFF: 'off',
    ON_EXIT: 'onExit',
    ON_EXIT_AND_WINDOW_CLOSE: 'onExitAndWindowClose'
};
export var FILES_ASSOCIATIONS_CONFIG = 'files.associations';
export var FILES_EXCLUDE_CONFIG = 'files.exclude';
export var FileKind;
(function (FileKind) {
    FileKind[FileKind["FILE"] = 0] = "FILE";
    FileKind[FileKind["FOLDER"] = 1] = "FOLDER";
    FileKind[FileKind["ROOT_FOLDER"] = 2] = "ROOT_FOLDER";
})(FileKind || (FileKind = {}));
/**
 * A hint to disable etag checking for reading/writing.
 */
export var ETAG_DISABLED = '';
export function etag(stat) {
    if (typeof stat.size !== 'number' || typeof stat.mtime !== 'number') {
        return undefined;
    }
    return stat.mtime.toString(29) + stat.size.toString(31);
}
export function whenProviderRegistered(file, fileService) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            if (fileService.canHandleResource(URI.from({ scheme: file.scheme }))) {
                return [2 /*return*/];
            }
            return [2 /*return*/, new Promise(function (resolve) {
                    var disposable = fileService.onDidChangeFileSystemProviderRegistrations(function (e) {
                        if (e.scheme === file.scheme && e.added) {
                            disposable.dispose();
                            resolve();
                        }
                    });
                })];
        });
    });
}
/**
 * Native only: limits for memory sizes
 */
export var MIN_MAX_MEMORY_SIZE_MB = 2048;
export var FALLBACK_MAX_MEMORY_SIZE_MB = 4096;
/**
 * Helper to format a raw byte size into a human readable label.
 */
var ByteSize = /** @class */ (function () {
    function ByteSize() {
    }
    ByteSize.formatSize = function (size) {
        if (!isNumber(size)) {
            size = 0;
        }
        if (size < ByteSize.KB) {
            return localize('sizeB', "{0}B", size.toFixed(0));
        }
        if (size < ByteSize.MB) {
            return localize('sizeKB', "{0}KB", (size / ByteSize.KB).toFixed(2));
        }
        if (size < ByteSize.GB) {
            return localize('sizeMB', "{0}MB", (size / ByteSize.MB).toFixed(2));
        }
        if (size < ByteSize.TB) {
            return localize('sizeGB', "{0}GB", (size / ByteSize.GB).toFixed(2));
        }
        return localize('sizeTB', "{0}TB", (size / ByteSize.TB).toFixed(2));
    };
    ByteSize.KB = 1024;
    ByteSize.MB = ByteSize.KB * ByteSize.KB;
    ByteSize.GB = ByteSize.MB * ByteSize.KB;
    ByteSize.TB = ByteSize.GB * ByteSize.KB;
    return ByteSize;
}());
export { ByteSize };
