/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import * as json from '../../../base/common/json';
import { ResourceMap, getOrSet } from '../../../base/common/map';
import * as arrays from '../../../base/common/arrays';
import * as types from '../../../base/common/types';
import * as objects from '../../../base/common/objects';
import { URI } from '../../../base/common/uri';
import { OVERRIDE_PROPERTY_PATTERN, Extensions, overrideIdentifierFromKey } from './configurationRegistry';
import { addToValueTree, toValuesTree, getConfigurationValue, getDefaultValues, getConfigurationKeys, removeFromValueTree, toOverrides, compare } from './configuration';
import { Registry } from '../../registry/common/platform';
import { Disposable } from '../../../base/common/lifecycle';
import { Emitter, Event } from '../../../base/common/event';
var ConfigurationModel = /** @class */ (function () {
    function ConfigurationModel(_contents, _keys, _overrides) {
        if (_contents === void 0) { _contents = {}; }
        if (_keys === void 0) { _keys = []; }
        if (_overrides === void 0) { _overrides = []; }
        this._contents = _contents;
        this._keys = _keys;
        this._overrides = _overrides;
        this.isFrozen = false;
    }
    Object.defineProperty(ConfigurationModel.prototype, "contents", {
        get: function () {
            return this.checkAndFreeze(this._contents);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigurationModel.prototype, "overrides", {
        get: function () {
            return this.checkAndFreeze(this._overrides);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigurationModel.prototype, "keys", {
        get: function () {
            return this.checkAndFreeze(this._keys);
        },
        enumerable: false,
        configurable: true
    });
    ConfigurationModel.prototype.isEmpty = function () {
        return this._keys.length === 0 && Object.keys(this._contents).length === 0 && this._overrides.length === 0;
    };
    ConfigurationModel.prototype.getValue = function (section) {
        return section ? getConfigurationValue(this.contents, section) : this.contents;
    };
    ConfigurationModel.prototype.getOverrideValue = function (section, overrideIdentifier) {
        var overrideContents = this.getContentsForOverrideIdentifer(overrideIdentifier);
        return overrideContents
            ? section ? getConfigurationValue(overrideContents, section) : overrideContents
            : undefined;
    };
    ConfigurationModel.prototype.getKeysForOverrideIdentifier = function (identifier) {
        var e_1, _a;
        try {
            for (var _b = __values(this.overrides), _c = _b.next(); !_c.done; _c = _b.next()) {
                var override = _c.value;
                if (override.identifiers.indexOf(identifier) !== -1) {
                    return override.keys;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return [];
    };
    ConfigurationModel.prototype.override = function (identifier) {
        var e_2, _a;
        var overrideContents = this.getContentsForOverrideIdentifer(identifier);
        if (!overrideContents || typeof overrideContents !== 'object' || !Object.keys(overrideContents).length) {
            // If there are no valid overrides, return self
            return this;
        }
        var contents = {};
        try {
            for (var _b = __values(arrays.distinct(__spreadArray(__spreadArray([], __read(Object.keys(this.contents))), __read(Object.keys(overrideContents))))), _c = _b.next(); !_c.done; _c = _b.next()) {
                var key = _c.value;
                var contentsForKey = this.contents[key];
                var overrideContentsForKey = overrideContents[key];
                // If there are override contents for the key, clone and merge otherwise use base contents
                if (overrideContentsForKey) {
                    // Clone and merge only if base contents and override contents are of type object otherwise just override
                    if (typeof contentsForKey === 'object' && typeof overrideContentsForKey === 'object') {
                        contentsForKey = objects.deepClone(contentsForKey);
                        this.mergeContents(contentsForKey, overrideContentsForKey);
                    }
                    else {
                        contentsForKey = overrideContentsForKey;
                    }
                }
                contents[key] = contentsForKey;
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return new ConfigurationModel(contents, this.keys, this.overrides);
    };
    ConfigurationModel.prototype.merge = function () {
        var e_3, _a, e_4, _b, e_5, _c;
        var others = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            others[_i] = arguments[_i];
        }
        var contents = objects.deepClone(this.contents);
        var overrides = objects.deepClone(this.overrides);
        var keys = __spreadArray([], __read(this.keys));
        try {
            for (var others_1 = __values(others), others_1_1 = others_1.next(); !others_1_1.done; others_1_1 = others_1.next()) {
                var other = others_1_1.value;
                this.mergeContents(contents, other.contents);
                var _loop_1 = function (otherOverride) {
                    var _h = __read(overrides.filter(function (o) { return arrays.equals(o.identifiers, otherOverride.identifiers); }), 1), override = _h[0];
                    if (override) {
                        this_1.mergeContents(override.contents, otherOverride.contents);
                    }
                    else {
                        overrides.push(objects.deepClone(otherOverride));
                    }
                };
                var this_1 = this;
                try {
                    for (var _d = (e_4 = void 0, __values(other.overrides)), _e = _d.next(); !_e.done; _e = _d.next()) {
                        var otherOverride = _e.value;
                        _loop_1(otherOverride);
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (_e && !_e.done && (_b = _d.return)) _b.call(_d);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
                try {
                    for (var _f = (e_5 = void 0, __values(other.keys)), _g = _f.next(); !_g.done; _g = _f.next()) {
                        var key = _g.value;
                        if (keys.indexOf(key) === -1) {
                            keys.push(key);
                        }
                    }
                }
                catch (e_5_1) { e_5 = { error: e_5_1 }; }
                finally {
                    try {
                        if (_g && !_g.done && (_c = _f.return)) _c.call(_f);
                    }
                    finally { if (e_5) throw e_5.error; }
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (others_1_1 && !others_1_1.done && (_a = others_1.return)) _a.call(others_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return new ConfigurationModel(contents, keys, overrides);
    };
    ConfigurationModel.prototype.freeze = function () {
        this.isFrozen = true;
        return this;
    };
    ConfigurationModel.prototype.mergeContents = function (source, target) {
        var e_6, _a;
        try {
            for (var _b = __values(Object.keys(target)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var key = _c.value;
                if (key in source) {
                    if (types.isObject(source[key]) && types.isObject(target[key])) {
                        this.mergeContents(source[key], target[key]);
                        continue;
                    }
                }
                source[key] = objects.deepClone(target[key]);
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_6) throw e_6.error; }
        }
    };
    ConfigurationModel.prototype.checkAndFreeze = function (data) {
        if (this.isFrozen && !Object.isFrozen(data)) {
            return objects.deepFreeze(data);
        }
        return data;
    };
    ConfigurationModel.prototype.getContentsForOverrideIdentifer = function (identifier) {
        var e_7, _a;
        try {
            for (var _b = __values(this.overrides), _c = _b.next(); !_c.done; _c = _b.next()) {
                var override = _c.value;
                if (override.identifiers.indexOf(identifier) !== -1) {
                    return override.contents;
                }
            }
        }
        catch (e_7_1) { e_7 = { error: e_7_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_7) throw e_7.error; }
        }
        return null;
    };
    ConfigurationModel.prototype.toJSON = function () {
        return {
            contents: this.contents,
            overrides: this.overrides,
            keys: this.keys
        };
    };
    // Update methods
    ConfigurationModel.prototype.setValue = function (key, value) {
        this.addKey(key);
        addToValueTree(this.contents, key, value, function (e) { throw new Error(e); });
    };
    ConfigurationModel.prototype.removeValue = function (key) {
        if (this.removeKey(key)) {
            removeFromValueTree(this.contents, key);
        }
    };
    ConfigurationModel.prototype.addKey = function (key) {
        var index = this.keys.length;
        for (var i = 0; i < index; i++) {
            if (key.indexOf(this.keys[i]) === 0) {
                index = i;
            }
        }
        this.keys.splice(index, 1, key);
    };
    ConfigurationModel.prototype.removeKey = function (key) {
        var index = this.keys.indexOf(key);
        if (index !== -1) {
            this.keys.splice(index, 1);
            return true;
        }
        return false;
    };
    return ConfigurationModel;
}());
export { ConfigurationModel };
var DefaultConfigurationModel = /** @class */ (function (_super) {
    __extends(DefaultConfigurationModel, _super);
    function DefaultConfigurationModel() {
        var e_8, _a;
        var _this = this;
        var contents = getDefaultValues();
        var keys = getConfigurationKeys();
        var overrides = [];
        try {
            for (var _b = __values(Object.keys(contents)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var key = _c.value;
                if (OVERRIDE_PROPERTY_PATTERN.test(key)) {
                    overrides.push({
                        identifiers: [overrideIdentifierFromKey(key).trim()],
                        keys: Object.keys(contents[key]),
                        contents: toValuesTree(contents[key], function (message) { return console.error("Conflict in default settings file: " + message); }),
                    });
                }
            }
        }
        catch (e_8_1) { e_8 = { error: e_8_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_8) throw e_8.error; }
        }
        _this = _super.call(this, contents, keys, overrides) || this;
        return _this;
    }
    return DefaultConfigurationModel;
}(ConfigurationModel));
export { DefaultConfigurationModel };
var ConfigurationModelParser = /** @class */ (function () {
    function ConfigurationModelParser(_name, _scopes) {
        this._name = _name;
        this._scopes = _scopes;
        this._raw = null;
        this._configurationModel = null;
        this._parseErrors = [];
    }
    Object.defineProperty(ConfigurationModelParser.prototype, "configurationModel", {
        get: function () {
            return this._configurationModel || new ConfigurationModel();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigurationModelParser.prototype, "errors", {
        get: function () {
            return this._parseErrors;
        },
        enumerable: false,
        configurable: true
    });
    ConfigurationModelParser.prototype.parseContent = function (content) {
        if (!types.isUndefinedOrNull(content)) {
            var raw = this.doParseContent(content);
            this.parseRaw(raw);
        }
    };
    ConfigurationModelParser.prototype.parseRaw = function (raw) {
        this._raw = raw;
        var configurationModel = this.doParseRaw(raw);
        this._configurationModel = new ConfigurationModel(configurationModel.contents, configurationModel.keys, configurationModel.overrides);
    };
    ConfigurationModelParser.prototype.parse = function () {
        if (this._raw) {
            this.parseRaw(this._raw);
        }
    };
    ConfigurationModelParser.prototype.doParseContent = function (content) {
        var raw = {};
        var currentProperty = null;
        var currentParent = [];
        var previousParents = [];
        var parseErrors = [];
        function onValue(value) {
            if (Array.isArray(currentParent)) {
                currentParent.push(value);
            }
            else if (currentProperty) {
                currentParent[currentProperty] = value;
            }
        }
        var visitor = {
            onObjectBegin: function () {
                var object = {};
                onValue(object);
                previousParents.push(currentParent);
                currentParent = object;
                currentProperty = null;
            },
            onObjectProperty: function (name) {
                currentProperty = name;
            },
            onObjectEnd: function () {
                currentParent = previousParents.pop();
            },
            onArrayBegin: function () {
                var array = [];
                onValue(array);
                previousParents.push(currentParent);
                currentParent = array;
                currentProperty = null;
            },
            onArrayEnd: function () {
                currentParent = previousParents.pop();
            },
            onLiteralValue: onValue,
            onError: function (error, offset, length) {
                parseErrors.push({ error: error, offset: offset, length: length });
            }
        };
        if (content) {
            try {
                json.visit(content, visitor);
                raw = currentParent[0] || {};
            }
            catch (e) {
                console.error("Error while parsing settings file " + this._name + ": " + e);
                this._parseErrors = [e];
            }
        }
        return raw;
    };
    ConfigurationModelParser.prototype.doParseRaw = function (raw) {
        var _this = this;
        if (this._scopes) {
            var configurationProperties = Registry.as(Extensions.Configuration).getConfigurationProperties();
            raw = this.filterByScope(raw, configurationProperties, true, this._scopes);
        }
        var contents = toValuesTree(raw, function (message) { return console.error("Conflict in settings file " + _this._name + ": " + message); });
        var keys = Object.keys(raw);
        var overrides = toOverrides(raw, function (message) { return console.error("Conflict in settings file " + _this._name + ": " + message); });
        return { contents: contents, keys: keys, overrides: overrides };
    };
    ConfigurationModelParser.prototype.filterByScope = function (properties, configurationProperties, filterOverriddenProperties, scopes) {
        var result = {};
        for (var key in properties) {
            if (OVERRIDE_PROPERTY_PATTERN.test(key) && filterOverriddenProperties) {
                result[key] = this.filterByScope(properties[key], configurationProperties, false, scopes);
            }
            else {
                var scope = this.getScope(key, configurationProperties);
                // Load unregistered configurations always.
                if (scope === undefined || scopes.indexOf(scope) !== -1) {
                    result[key] = properties[key];
                }
            }
        }
        return result;
    };
    ConfigurationModelParser.prototype.getScope = function (key, configurationProperties) {
        var propertySchema = configurationProperties[key];
        return propertySchema ? typeof propertySchema.scope !== 'undefined' ? propertySchema.scope : 3 /* WINDOW */ : undefined;
    };
    return ConfigurationModelParser;
}());
export { ConfigurationModelParser };
var UserSettings = /** @class */ (function (_super) {
    __extends(UserSettings, _super);
    function UserSettings(userSettingsResource, scopes, extUri, fileService) {
        var _this = _super.call(this) || this;
        _this.userSettingsResource = userSettingsResource;
        _this.scopes = scopes;
        _this.fileService = fileService;
        _this._onDidChange = _this._register(new Emitter());
        _this.onDidChange = _this._onDidChange.event;
        _this.parser = new ConfigurationModelParser(_this.userSettingsResource.toString(), _this.scopes);
        _this._register(_this.fileService.watch(extUri.dirname(_this.userSettingsResource)));
        _this._register(Event.filter(_this.fileService.onDidFilesChange, function (e) { return e.contains(_this.userSettingsResource); })(function () { return _this._onDidChange.fire(); }));
        return _this;
    }
    UserSettings.prototype.loadConfiguration = function () {
        return __awaiter(this, void 0, void 0, function () {
            var content, e_9;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.fileService.readFile(this.userSettingsResource)];
                    case 1:
                        content = _a.sent();
                        this.parser.parseContent(content.value.toString() || '{}');
                        return [2 /*return*/, this.parser.configurationModel];
                    case 2:
                        e_9 = _a.sent();
                        return [2 /*return*/, new ConfigurationModel()];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    UserSettings.prototype.reprocess = function () {
        this.parser.parse();
        return this.parser.configurationModel;
    };
    return UserSettings;
}(Disposable));
export { UserSettings };
var Configuration = /** @class */ (function () {
    function Configuration(_defaultConfiguration, _localUserConfiguration, _remoteUserConfiguration, _workspaceConfiguration, _folderConfigurations, _memoryConfiguration, _memoryConfigurationByResource, _freeze) {
        if (_remoteUserConfiguration === void 0) { _remoteUserConfiguration = new ConfigurationModel(); }
        if (_workspaceConfiguration === void 0) { _workspaceConfiguration = new ConfigurationModel(); }
        if (_folderConfigurations === void 0) { _folderConfigurations = new ResourceMap(); }
        if (_memoryConfiguration === void 0) { _memoryConfiguration = new ConfigurationModel(); }
        if (_memoryConfigurationByResource === void 0) { _memoryConfigurationByResource = new ResourceMap(); }
        if (_freeze === void 0) { _freeze = true; }
        this._defaultConfiguration = _defaultConfiguration;
        this._localUserConfiguration = _localUserConfiguration;
        this._remoteUserConfiguration = _remoteUserConfiguration;
        this._workspaceConfiguration = _workspaceConfiguration;
        this._folderConfigurations = _folderConfigurations;
        this._memoryConfiguration = _memoryConfiguration;
        this._memoryConfigurationByResource = _memoryConfigurationByResource;
        this._freeze = _freeze;
        this._workspaceConsolidatedConfiguration = null;
        this._foldersConsolidatedConfigurations = new ResourceMap();
        this._userConfiguration = null;
    }
    Configuration.prototype.getValue = function (section, overrides, workspace) {
        var consolidateConfigurationModel = this.getConsolidateConfigurationModel(overrides, workspace);
        return consolidateConfigurationModel.getValue(section);
    };
    Configuration.prototype.updateValue = function (key, value, overrides) {
        if (overrides === void 0) { overrides = {}; }
        var memoryConfiguration;
        if (overrides.resource) {
            memoryConfiguration = this._memoryConfigurationByResource.get(overrides.resource);
            if (!memoryConfiguration) {
                memoryConfiguration = new ConfigurationModel();
                this._memoryConfigurationByResource.set(overrides.resource, memoryConfiguration);
            }
        }
        else {
            memoryConfiguration = this._memoryConfiguration;
        }
        if (value === undefined) {
            memoryConfiguration.removeValue(key);
        }
        else {
            memoryConfiguration.setValue(key, value);
        }
        if (!overrides.resource) {
            this._workspaceConsolidatedConfiguration = null;
        }
    };
    Configuration.prototype.inspect = function (key, overrides, workspace) {
        var consolidateConfigurationModel = this.getConsolidateConfigurationModel(overrides, workspace);
        var folderConfigurationModel = this.getFolderConfigurationModelForResource(overrides.resource, workspace);
        var memoryConfigurationModel = overrides.resource ? this._memoryConfigurationByResource.get(overrides.resource) || this._memoryConfiguration : this._memoryConfiguration;
        var defaultValue = overrides.overrideIdentifier ? this._defaultConfiguration.freeze().override(overrides.overrideIdentifier).getValue(key) : this._defaultConfiguration.freeze().getValue(key);
        var userValue = overrides.overrideIdentifier ? this.userConfiguration.freeze().override(overrides.overrideIdentifier).getValue(key) : this.userConfiguration.freeze().getValue(key);
        var userLocalValue = overrides.overrideIdentifier ? this.localUserConfiguration.freeze().override(overrides.overrideIdentifier).getValue(key) : this.localUserConfiguration.freeze().getValue(key);
        var userRemoteValue = overrides.overrideIdentifier ? this.remoteUserConfiguration.freeze().override(overrides.overrideIdentifier).getValue(key) : this.remoteUserConfiguration.freeze().getValue(key);
        var workspaceValue = workspace ? overrides.overrideIdentifier ? this._workspaceConfiguration.freeze().override(overrides.overrideIdentifier).getValue(key) : this._workspaceConfiguration.freeze().getValue(key) : undefined; //Check on workspace exists or not because _workspaceConfiguration is never null
        var workspaceFolderValue = folderConfigurationModel ? overrides.overrideIdentifier ? folderConfigurationModel.freeze().override(overrides.overrideIdentifier).getValue(key) : folderConfigurationModel.freeze().getValue(key) : undefined;
        var memoryValue = overrides.overrideIdentifier ? memoryConfigurationModel.override(overrides.overrideIdentifier).getValue(key) : memoryConfigurationModel.getValue(key);
        var value = consolidateConfigurationModel.getValue(key);
        var overrideIdentifiers = arrays.distinct(arrays.flatten(consolidateConfigurationModel.overrides.map(function (override) { return override.identifiers; }))).filter(function (overrideIdentifier) { return consolidateConfigurationModel.getOverrideValue(key, overrideIdentifier) !== undefined; });
        return {
            defaultValue: defaultValue,
            userValue: userValue,
            userLocalValue: userLocalValue,
            userRemoteValue: userRemoteValue,
            workspaceValue: workspaceValue,
            workspaceFolderValue: workspaceFolderValue,
            memoryValue: memoryValue,
            value: value,
            default: defaultValue !== undefined ? { value: this._defaultConfiguration.freeze().getValue(key), override: overrides.overrideIdentifier ? this._defaultConfiguration.freeze().getOverrideValue(key, overrides.overrideIdentifier) : undefined } : undefined,
            user: userValue !== undefined ? { value: this.userConfiguration.freeze().getValue(key), override: overrides.overrideIdentifier ? this.userConfiguration.freeze().getOverrideValue(key, overrides.overrideIdentifier) : undefined } : undefined,
            userLocal: userLocalValue !== undefined ? { value: this.localUserConfiguration.freeze().getValue(key), override: overrides.overrideIdentifier ? this.localUserConfiguration.freeze().getOverrideValue(key, overrides.overrideIdentifier) : undefined } : undefined,
            userRemote: userRemoteValue !== undefined ? { value: this.remoteUserConfiguration.freeze().getValue(key), override: overrides.overrideIdentifier ? this.remoteUserConfiguration.freeze().getOverrideValue(key, overrides.overrideIdentifier) : undefined } : undefined,
            workspace: workspaceValue !== undefined ? { value: this._workspaceConfiguration.freeze().getValue(key), override: overrides.overrideIdentifier ? this._workspaceConfiguration.freeze().getOverrideValue(key, overrides.overrideIdentifier) : undefined } : undefined,
            workspaceFolder: workspaceFolderValue !== undefined ? { value: folderConfigurationModel === null || folderConfigurationModel === void 0 ? void 0 : folderConfigurationModel.freeze().getValue(key), override: overrides.overrideIdentifier ? folderConfigurationModel === null || folderConfigurationModel === void 0 ? void 0 : folderConfigurationModel.freeze().getOverrideValue(key, overrides.overrideIdentifier) : undefined } : undefined,
            memory: memoryValue !== undefined ? { value: memoryConfigurationModel.getValue(key), override: overrides.overrideIdentifier ? memoryConfigurationModel.getOverrideValue(key, overrides.overrideIdentifier) : undefined } : undefined,
            overrideIdentifiers: overrideIdentifiers.length ? overrideIdentifiers : undefined
        };
    };
    Configuration.prototype.keys = function (workspace) {
        var folderConfigurationModel = this.getFolderConfigurationModelForResource(undefined, workspace);
        return {
            default: this._defaultConfiguration.freeze().keys,
            user: this.userConfiguration.freeze().keys,
            workspace: this._workspaceConfiguration.freeze().keys,
            workspaceFolder: folderConfigurationModel ? folderConfigurationModel.freeze().keys : []
        };
    };
    Configuration.prototype.updateDefaultConfiguration = function (defaultConfiguration) {
        this._defaultConfiguration = defaultConfiguration;
        this._workspaceConsolidatedConfiguration = null;
        this._foldersConsolidatedConfigurations.clear();
    };
    Configuration.prototype.updateLocalUserConfiguration = function (localUserConfiguration) {
        this._localUserConfiguration = localUserConfiguration;
        this._userConfiguration = null;
        this._workspaceConsolidatedConfiguration = null;
        this._foldersConsolidatedConfigurations.clear();
    };
    Configuration.prototype.updateRemoteUserConfiguration = function (remoteUserConfiguration) {
        this._remoteUserConfiguration = remoteUserConfiguration;
        this._userConfiguration = null;
        this._workspaceConsolidatedConfiguration = null;
        this._foldersConsolidatedConfigurations.clear();
    };
    Configuration.prototype.updateWorkspaceConfiguration = function (workspaceConfiguration) {
        this._workspaceConfiguration = workspaceConfiguration;
        this._workspaceConsolidatedConfiguration = null;
        this._foldersConsolidatedConfigurations.clear();
    };
    Configuration.prototype.updateFolderConfiguration = function (resource, configuration) {
        this._folderConfigurations.set(resource, configuration);
        this._foldersConsolidatedConfigurations.delete(resource);
    };
    Configuration.prototype.deleteFolderConfiguration = function (resource) {
        this.folderConfigurations.delete(resource);
        this._foldersConsolidatedConfigurations.delete(resource);
    };
    Configuration.prototype.compareAndUpdateDefaultConfiguration = function (defaults, keys) {
        var _this = this;
        var overrides = keys
            .filter(function (key) { return OVERRIDE_PROPERTY_PATTERN.test(key); })
            .map(function (key) {
            var overrideIdentifier = overrideIdentifierFromKey(key);
            var fromKeys = _this._defaultConfiguration.getKeysForOverrideIdentifier(overrideIdentifier);
            var toKeys = defaults.getKeysForOverrideIdentifier(overrideIdentifier);
            var keys = __spreadArray(__spreadArray(__spreadArray([], __read(toKeys.filter(function (key) { return fromKeys.indexOf(key) === -1; }))), __read(fromKeys.filter(function (key) { return toKeys.indexOf(key) === -1; }))), __read(fromKeys.filter(function (key) { return !objects.equals(_this._defaultConfiguration.override(overrideIdentifier).getValue(key), defaults.override(overrideIdentifier).getValue(key)); })));
            return [overrideIdentifier, keys];
        });
        this.updateDefaultConfiguration(defaults);
        return { keys: keys, overrides: overrides };
    };
    Configuration.prototype.compareAndUpdateLocalUserConfiguration = function (user) {
        var _a = compare(this.localUserConfiguration, user), added = _a.added, updated = _a.updated, removed = _a.removed, overrides = _a.overrides;
        var keys = __spreadArray(__spreadArray(__spreadArray([], __read(added)), __read(updated)), __read(removed));
        if (keys.length) {
            this.updateLocalUserConfiguration(user);
        }
        return { keys: keys, overrides: overrides };
    };
    Configuration.prototype.compareAndUpdateRemoteUserConfiguration = function (user) {
        var _a = compare(this.remoteUserConfiguration, user), added = _a.added, updated = _a.updated, removed = _a.removed, overrides = _a.overrides;
        var keys = __spreadArray(__spreadArray(__spreadArray([], __read(added)), __read(updated)), __read(removed));
        if (keys.length) {
            this.updateRemoteUserConfiguration(user);
        }
        return { keys: keys, overrides: overrides };
    };
    Configuration.prototype.compareAndUpdateWorkspaceConfiguration = function (workspaceConfiguration) {
        var _a = compare(this.workspaceConfiguration, workspaceConfiguration), added = _a.added, updated = _a.updated, removed = _a.removed, overrides = _a.overrides;
        var keys = __spreadArray(__spreadArray(__spreadArray([], __read(added)), __read(updated)), __read(removed));
        if (keys.length) {
            this.updateWorkspaceConfiguration(workspaceConfiguration);
        }
        return { keys: keys, overrides: overrides };
    };
    Configuration.prototype.compareAndUpdateFolderConfiguration = function (resource, folderConfiguration) {
        var currentFolderConfiguration = this.folderConfigurations.get(resource);
        var _a = compare(currentFolderConfiguration, folderConfiguration), added = _a.added, updated = _a.updated, removed = _a.removed, overrides = _a.overrides;
        var keys = __spreadArray(__spreadArray(__spreadArray([], __read(added)), __read(updated)), __read(removed));
        if (keys.length || !currentFolderConfiguration) {
            this.updateFolderConfiguration(resource, folderConfiguration);
        }
        return { keys: keys, overrides: overrides };
    };
    Configuration.prototype.compareAndDeleteFolderConfiguration = function (folder) {
        var folderConfig = this.folderConfigurations.get(folder);
        if (!folderConfig) {
            throw new Error('Unknown folder');
        }
        this.deleteFolderConfiguration(folder);
        var _a = compare(folderConfig, undefined), added = _a.added, updated = _a.updated, removed = _a.removed, overrides = _a.overrides;
        return { keys: __spreadArray(__spreadArray(__spreadArray([], __read(added)), __read(updated)), __read(removed)), overrides: overrides };
    };
    Object.defineProperty(Configuration.prototype, "defaults", {
        get: function () {
            return this._defaultConfiguration;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Configuration.prototype, "userConfiguration", {
        get: function () {
            if (!this._userConfiguration) {
                this._userConfiguration = this._remoteUserConfiguration.isEmpty() ? this._localUserConfiguration : this._localUserConfiguration.merge(this._remoteUserConfiguration);
                if (this._freeze) {
                    this._userConfiguration.freeze();
                }
            }
            return this._userConfiguration;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Configuration.prototype, "localUserConfiguration", {
        get: function () {
            return this._localUserConfiguration;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Configuration.prototype, "remoteUserConfiguration", {
        get: function () {
            return this._remoteUserConfiguration;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Configuration.prototype, "workspaceConfiguration", {
        get: function () {
            return this._workspaceConfiguration;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Configuration.prototype, "folderConfigurations", {
        get: function () {
            return this._folderConfigurations;
        },
        enumerable: false,
        configurable: true
    });
    Configuration.prototype.getConsolidateConfigurationModel = function (overrides, workspace) {
        var configurationModel = this.getConsolidatedConfigurationModelForResource(overrides, workspace);
        return overrides.overrideIdentifier ? configurationModel.override(overrides.overrideIdentifier) : configurationModel;
    };
    Configuration.prototype.getConsolidatedConfigurationModelForResource = function (_a, workspace) {
        var resource = _a.resource;
        var consolidateConfiguration = this.getWorkspaceConsolidatedConfiguration();
        if (workspace && resource) {
            var root = workspace.getFolder(resource);
            if (root) {
                consolidateConfiguration = this.getFolderConsolidatedConfiguration(root.uri) || consolidateConfiguration;
            }
            var memoryConfigurationForResource = this._memoryConfigurationByResource.get(resource);
            if (memoryConfigurationForResource) {
                consolidateConfiguration = consolidateConfiguration.merge(memoryConfigurationForResource);
            }
        }
        return consolidateConfiguration;
    };
    Configuration.prototype.getWorkspaceConsolidatedConfiguration = function () {
        if (!this._workspaceConsolidatedConfiguration) {
            this._workspaceConsolidatedConfiguration = this._defaultConfiguration.merge(this.userConfiguration, this._workspaceConfiguration, this._memoryConfiguration);
            if (this._freeze) {
                this._workspaceConfiguration = this._workspaceConfiguration.freeze();
            }
        }
        return this._workspaceConsolidatedConfiguration;
    };
    Configuration.prototype.getFolderConsolidatedConfiguration = function (folder) {
        var folderConsolidatedConfiguration = this._foldersConsolidatedConfigurations.get(folder);
        if (!folderConsolidatedConfiguration) {
            var workspaceConsolidateConfiguration = this.getWorkspaceConsolidatedConfiguration();
            var folderConfiguration = this._folderConfigurations.get(folder);
            if (folderConfiguration) {
                folderConsolidatedConfiguration = workspaceConsolidateConfiguration.merge(folderConfiguration);
                if (this._freeze) {
                    folderConsolidatedConfiguration = folderConsolidatedConfiguration.freeze();
                }
                this._foldersConsolidatedConfigurations.set(folder, folderConsolidatedConfiguration);
            }
            else {
                folderConsolidatedConfiguration = workspaceConsolidateConfiguration;
            }
        }
        return folderConsolidatedConfiguration;
    };
    Configuration.prototype.getFolderConfigurationModelForResource = function (resource, workspace) {
        if (workspace && resource) {
            var root = workspace.getFolder(resource);
            if (root) {
                return this._folderConfigurations.get(root.uri);
            }
        }
        return undefined;
    };
    Configuration.prototype.toData = function () {
        var _this = this;
        return {
            defaults: {
                contents: this._defaultConfiguration.contents,
                overrides: this._defaultConfiguration.overrides,
                keys: this._defaultConfiguration.keys
            },
            user: {
                contents: this.userConfiguration.contents,
                overrides: this.userConfiguration.overrides,
                keys: this.userConfiguration.keys
            },
            workspace: {
                contents: this._workspaceConfiguration.contents,
                overrides: this._workspaceConfiguration.overrides,
                keys: this._workspaceConfiguration.keys
            },
            folders: __spreadArray([], __read(this._folderConfigurations.keys())).reduce(function (result, folder) {
                var _a = _this._folderConfigurations.get(folder), contents = _a.contents, overrides = _a.overrides, keys = _a.keys;
                result.push([folder, { contents: contents, overrides: overrides, keys: keys }]);
                return result;
            }, [])
        };
    };
    Configuration.prototype.allKeys = function () {
        var keys = new Set();
        this._defaultConfiguration.freeze().keys.forEach(function (key) { return keys.add(key); });
        this.userConfiguration.freeze().keys.forEach(function (key) { return keys.add(key); });
        this._workspaceConfiguration.freeze().keys.forEach(function (key) { return keys.add(key); });
        this._folderConfigurations.forEach(function (folderConfiguraiton) { return folderConfiguraiton.freeze().keys.forEach(function (key) { return keys.add(key); }); });
        return __spreadArray([], __read(keys.values()));
    };
    Configuration.prototype.getAllKeysForOverrideIdentifier = function (overrideIdentifier) {
        var keys = new Set();
        this._defaultConfiguration.getKeysForOverrideIdentifier(overrideIdentifier).forEach(function (key) { return keys.add(key); });
        this.userConfiguration.getKeysForOverrideIdentifier(overrideIdentifier).forEach(function (key) { return keys.add(key); });
        this._workspaceConfiguration.getKeysForOverrideIdentifier(overrideIdentifier).forEach(function (key) { return keys.add(key); });
        this._folderConfigurations.forEach(function (folderConfiguraiton) { return folderConfiguraiton.getKeysForOverrideIdentifier(overrideIdentifier).forEach(function (key) { return keys.add(key); }); });
        return __spreadArray([], __read(keys.values()));
    };
    Configuration.parse = function (data) {
        var _this = this;
        var defaultConfiguration = this.parseConfigurationModel(data.defaults);
        var userConfiguration = this.parseConfigurationModel(data.user);
        var workspaceConfiguration = this.parseConfigurationModel(data.workspace);
        var folders = data.folders.reduce(function (result, value) {
            result.set(URI.revive(value[0]), _this.parseConfigurationModel(value[1]));
            return result;
        }, new ResourceMap());
        return new Configuration(defaultConfiguration, userConfiguration, new ConfigurationModel(), workspaceConfiguration, folders, new ConfigurationModel(), new ResourceMap(), false);
    };
    Configuration.parseConfigurationModel = function (model) {
        return new ConfigurationModel(model.contents, model.keys, model.overrides).freeze();
    };
    return Configuration;
}());
export { Configuration };
export function mergeChanges() {
    var e_10, _a;
    var changes = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        changes[_i] = arguments[_i];
    }
    if (changes.length === 0) {
        return { keys: [], overrides: [] };
    }
    if (changes.length === 1) {
        return changes[0];
    }
    var keysSet = new Set();
    var overridesMap = new Map();
    try {
        for (var changes_1 = __values(changes), changes_1_1 = changes_1.next(); !changes_1_1.done; changes_1_1 = changes_1.next()) {
            var change = changes_1_1.value;
            change.keys.forEach(function (key) { return keysSet.add(key); });
            change.overrides.forEach(function (_a) {
                var _b = __read(_a, 2), identifier = _b[0], keys = _b[1];
                var result = getOrSet(overridesMap, identifier, new Set());
                keys.forEach(function (key) { return result.add(key); });
            });
        }
    }
    catch (e_10_1) { e_10 = { error: e_10_1 }; }
    finally {
        try {
            if (changes_1_1 && !changes_1_1.done && (_a = changes_1.return)) _a.call(changes_1);
        }
        finally { if (e_10) throw e_10.error; }
    }
    var overrides = [];
    overridesMap.forEach(function (keys, identifier) { return overrides.push([identifier, __spreadArray([], __read(keys.values()))]); });
    return { keys: __spreadArray([], __read(keysSet.values())), overrides: overrides };
}
var ConfigurationChangeEvent = /** @class */ (function () {
    function ConfigurationChangeEvent(change, previous, currentConfiguraiton, currentWorkspace) {
        this.change = change;
        this.previous = previous;
        this.currentConfiguraiton = currentConfiguraiton;
        this.currentWorkspace = currentWorkspace;
        this._previousConfiguration = undefined;
        var keysSet = new Set();
        change.keys.forEach(function (key) { return keysSet.add(key); });
        change.overrides.forEach(function (_a) {
            var _b = __read(_a, 2), keys = _b[1];
            return keys.forEach(function (key) { return keysSet.add(key); });
        });
        this.affectedKeys = __spreadArray([], __read(keysSet.values()));
        var configurationModel = new ConfigurationModel();
        this.affectedKeys.forEach(function (key) { return configurationModel.setValue(key, {}); });
        this.affectedKeysTree = configurationModel.contents;
    }
    Object.defineProperty(ConfigurationChangeEvent.prototype, "previousConfiguration", {
        get: function () {
            if (!this._previousConfiguration && this.previous) {
                this._previousConfiguration = Configuration.parse(this.previous.data);
            }
            return this._previousConfiguration;
        },
        enumerable: false,
        configurable: true
    });
    ConfigurationChangeEvent.prototype.affectsConfiguration = function (section, overrides) {
        var _a;
        if (this.doesAffectedKeysTreeContains(this.affectedKeysTree, section)) {
            if (overrides) {
                var value1 = this.previousConfiguration ? this.previousConfiguration.getValue(section, overrides, (_a = this.previous) === null || _a === void 0 ? void 0 : _a.workspace) : undefined;
                var value2 = this.currentConfiguraiton.getValue(section, overrides, this.currentWorkspace);
                return !objects.equals(value1, value2);
            }
            return true;
        }
        return false;
    };
    ConfigurationChangeEvent.prototype.doesAffectedKeysTreeContains = function (affectedKeysTree, section) {
        var _a;
        var requestedTree = toValuesTree((_a = {}, _a[section] = true, _a), function () { });
        var key;
        while (typeof requestedTree === 'object' && (key = Object.keys(requestedTree)[0])) { // Only one key should present, since we added only one property
            affectedKeysTree = affectedKeysTree[key];
            if (!affectedKeysTree) {
                return false; // Requested tree is not found
            }
            requestedTree = requestedTree[key];
        }
        return true;
    };
    return ConfigurationChangeEvent;
}());
export { ConfigurationChangeEvent };
var AllKeysConfigurationChangeEvent = /** @class */ (function (_super) {
    __extends(AllKeysConfigurationChangeEvent, _super);
    function AllKeysConfigurationChangeEvent(configuration, workspace, source, sourceConfig) {
        var _this = _super.call(this, { keys: configuration.allKeys(), overrides: [] }, undefined, configuration, workspace) || this;
        _this.source = source;
        _this.sourceConfig = sourceConfig;
        return _this;
    }
    return AllKeysConfigurationChangeEvent;
}(ConfigurationChangeEvent));
export { AllKeysConfigurationChangeEvent };
