/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import './media/suggest.css';
import '../../../base/browser/ui/codicons/codiconStyles'; // The codicon symbol styles are defined here and must be loaded
import '../symbolIcons/symbolIcons'; // The codicon symbol colors are defined here and must be loaded to get colors
import * as nls from '../../../nls';
import * as strings from '../../../base/common/strings';
import * as dom from '../../../base/browser/dom';
import { Emitter } from '../../../base/common/event';
import { onUnexpectedError } from '../../../base/common/errors';
import { DisposableStore } from '../../../base/common/lifecycle';
import { List } from '../../../base/browser/ui/list/listWidget';
import { IContextKeyService } from '../../../platform/contextkey/common/contextkey';
import { Context as SuggestContext } from './suggest';
import { attachListStyler } from '../../../platform/theme/common/styler';
import { IThemeService, registerThemingParticipant } from '../../../platform/theme/common/themeService';
import { registerColor, editorWidgetBackground, quickInputListFocusBackground, activeContrastBorder, listHighlightForeground, editorForeground, editorWidgetBorder, focusBorder, textLinkForeground, textCodeBlockBackground } from '../../../platform/theme/common/colorRegistry';
import { IStorageService } from '../../../platform/storage/common/storage';
import { TimeoutTimer, createCancelablePromise, disposableTimeout } from '../../../base/common/async';
import { IInstantiationService } from '../../../platform/instantiation/common/instantiation';
import { SuggestDetailsWidget, canExpandCompletionItem, SuggestDetailsOverlay } from './suggestWidgetDetails';
import { SuggestWidgetStatus } from './suggestWidgetStatus';
import { getAriaId, ItemRenderer } from './suggestWidgetRenderer';
import { ResizableHTMLElement } from './resizable';
import { EmbeddedCodeEditorWidget } from '../../browser/widget/embeddedCodeEditorWidget';
import { clamp } from '../../../base/common/numbers';
/**
 * Suggest widget colors
 */
export var editorSuggestWidgetBackground = registerColor('editorSuggestWidget.background', { dark: editorWidgetBackground, light: editorWidgetBackground, hc: editorWidgetBackground }, nls.localize('editorSuggestWidgetBackground', 'Background color of the suggest widget.'));
export var editorSuggestWidgetBorder = registerColor('editorSuggestWidget.border', { dark: editorWidgetBorder, light: editorWidgetBorder, hc: editorWidgetBorder }, nls.localize('editorSuggestWidgetBorder', 'Border color of the suggest widget.'));
export var editorSuggestWidgetForeground = registerColor('editorSuggestWidget.foreground', { dark: editorForeground, light: editorForeground, hc: editorForeground }, nls.localize('editorSuggestWidgetForeground', 'Foreground color of the suggest widget.'));
export var editorSuggestWidgetSelectedBackground = registerColor('editorSuggestWidget.selectedBackground', { dark: quickInputListFocusBackground, light: quickInputListFocusBackground, hc: quickInputListFocusBackground }, nls.localize('editorSuggestWidgetSelectedBackground', 'Background color of the selected entry in the suggest widget.'));
export var editorSuggestWidgetHighlightForeground = registerColor('editorSuggestWidget.highlightForeground', { dark: listHighlightForeground, light: listHighlightForeground, hc: listHighlightForeground }, nls.localize('editorSuggestWidgetHighlightForeground', 'Color of the match highlights in the suggest widget.'));
var PersistedWidgetSize = /** @class */ (function () {
    function PersistedWidgetSize(_service, editor) {
        this._service = _service;
        this._key = "suggestWidget.size/" + editor.getEditorType() + "/" + (editor instanceof EmbeddedCodeEditorWidget);
    }
    PersistedWidgetSize.prototype.restore = function () {
        var _a;
        var raw = (_a = this._service.get(this._key, 0 /* GLOBAL */)) !== null && _a !== void 0 ? _a : '';
        try {
            var obj = JSON.parse(raw);
            if (dom.Dimension.is(obj)) {
                return dom.Dimension.lift(obj);
            }
        }
        catch (_b) {
            // ignore
        }
        return undefined;
    };
    PersistedWidgetSize.prototype.store = function (size) {
        this._service.store(this._key, JSON.stringify(size), 0 /* GLOBAL */, 1 /* MACHINE */);
    };
    PersistedWidgetSize.prototype.reset = function () {
        this._service.remove(this._key, 0 /* GLOBAL */);
    };
    return PersistedWidgetSize;
}());
var SuggestWidget = /** @class */ (function () {
    function SuggestWidget(editor, _storageService, _contextKeyService, _themeService, instantiationService) {
        var _this = this;
        this.editor = editor;
        this._storageService = _storageService;
        this._state = 0 /* Hidden */;
        this._isAuto = false;
        this._ignoreFocusEvents = false;
        this._explainMode = false;
        this._showTimeout = new TimeoutTimer();
        this._disposables = new DisposableStore();
        this._onDidSelect = new Emitter();
        this._onDidFocus = new Emitter();
        this._onDidHide = new Emitter();
        this._onDidShow = new Emitter();
        this.onDidSelect = this._onDidSelect.event;
        this.onDidFocus = this._onDidFocus.event;
        this.onDidHide = this._onDidHide.event;
        this.onDidShow = this._onDidShow.event;
        this._onDetailsKeydown = new Emitter();
        this.onDetailsKeyDown = this._onDetailsKeydown.event;
        this.element = new ResizableHTMLElement();
        this.element.domNode.classList.add('editor-widget', 'suggest-widget');
        this._contentWidget = new SuggestContentWidget(this, editor);
        this._persistedSize = new PersistedWidgetSize(_storageService, editor);
        var ResizeState = /** @class */ (function () {
            function ResizeState(persistedSize, currentSize, persistHeight, persistWidth) {
                if (persistHeight === void 0) { persistHeight = false; }
                if (persistWidth === void 0) { persistWidth = false; }
                this.persistedSize = persistedSize;
                this.currentSize = currentSize;
                this.persistHeight = persistHeight;
                this.persistWidth = persistWidth;
            }
            return ResizeState;
        }());
        var state;
        this._disposables.add(this.element.onDidWillResize(function () {
            _this._contentWidget.lockPreference();
            state = new ResizeState(_this._persistedSize.restore(), _this.element.size);
        }));
        this._disposables.add(this.element.onDidResize(function (e) {
            var _a, _b, _c, _d;
            _this._resize(e.dimension.width, e.dimension.height);
            if (state) {
                state.persistHeight = state.persistHeight || !!e.north || !!e.south;
                state.persistWidth = state.persistWidth || !!e.east || !!e.west;
            }
            if (!e.done) {
                return;
            }
            if (state) {
                // only store width or height value that have changed and also
                // only store changes that are above a certain threshold
                var _e = _this.getLayoutInfo(), itemHeight = _e.itemHeight, defaultSize = _e.defaultSize;
                var threshold = Math.round(itemHeight / 2);
                var _f = _this.element.size, width = _f.width, height = _f.height;
                if (!state.persistHeight || Math.abs(state.currentSize.height - height) <= threshold) {
                    height = (_b = (_a = state.persistedSize) === null || _a === void 0 ? void 0 : _a.height) !== null && _b !== void 0 ? _b : defaultSize.height;
                }
                if (!state.persistWidth || Math.abs(state.currentSize.width - width) <= threshold) {
                    width = (_d = (_c = state.persistedSize) === null || _c === void 0 ? void 0 : _c.width) !== null && _d !== void 0 ? _d : defaultSize.width;
                }
                _this._persistedSize.store(new dom.Dimension(width, height));
            }
            // reset working state
            _this._contentWidget.unlockPreference();
            state = undefined;
        }));
        this._messageElement = dom.append(this.element.domNode, dom.$('.message'));
        this._listElement = dom.append(this.element.domNode, dom.$('.tree'));
        var details = instantiationService.createInstance(SuggestDetailsWidget, this.editor);
        details.onDidClose(this.toggleDetails, this, this._disposables);
        this._details = new SuggestDetailsOverlay(details, this.editor);
        var applyIconStyle = function () { return _this.element.domNode.classList.toggle('no-icons', !_this.editor.getOption(101 /* suggest */).showIcons); };
        applyIconStyle();
        var renderer = instantiationService.createInstance(ItemRenderer, this.editor);
        this._disposables.add(renderer);
        this._disposables.add(renderer.onDidToggleDetails(function () { return _this.toggleDetails(); }));
        this._list = new List('SuggestWidget', this._listElement, {
            getHeight: function (_element) { return _this.getLayoutInfo().itemHeight; },
            getTemplateId: function (_element) { return 'suggestion'; }
        }, [renderer], {
            alwaysConsumeMouseWheel: true,
            useShadows: false,
            mouseSupport: false,
            accessibilityProvider: {
                getRole: function () { return 'option'; },
                getAriaLabel: function (item) {
                    var textLabel = typeof item.completion.label === 'string' ? item.completion.label : item.completion.label.name;
                    if (item.isResolved && _this._isDetailsVisible()) {
                        var _a = item.completion, documentation = _a.documentation, detail = _a.detail;
                        var docs = strings.format('{0}{1}', detail || '', documentation ? (typeof documentation === 'string' ? documentation : documentation.value) : '');
                        return nls.localize('ariaCurrenttSuggestionReadDetails', "{0}, docs: {1}", textLabel, docs);
                    }
                    else {
                        return textLabel;
                    }
                },
                getWidgetAriaLabel: function () { return nls.localize('suggest', "Suggest"); },
                getWidgetRole: function () { return 'listbox'; }
            }
        });
        this._status = instantiationService.createInstance(SuggestWidgetStatus, this.element.domNode);
        var applyStatusBarStyle = function () { return _this.element.domNode.classList.toggle('with-status-bar', _this.editor.getOption(101 /* suggest */).showStatusBar); };
        applyStatusBarStyle();
        this._disposables.add(attachListStyler(this._list, _themeService, {
            listInactiveFocusBackground: editorSuggestWidgetSelectedBackground,
            listInactiveFocusOutline: activeContrastBorder
        }));
        this._disposables.add(_themeService.onDidColorThemeChange(function (t) { return _this._onThemeChange(t); }));
        this._onThemeChange(_themeService.getColorTheme());
        this._disposables.add(this._list.onMouseDown(function (e) { return _this._onListMouseDownOrTap(e); }));
        this._disposables.add(this._list.onTap(function (e) { return _this._onListMouseDownOrTap(e); }));
        this._disposables.add(this._list.onDidChangeSelection(function (e) { return _this._onListSelection(e); }));
        this._disposables.add(this._list.onDidChangeFocus(function (e) { return _this._onListFocus(e); }));
        this._disposables.add(this.editor.onDidChangeCursorSelection(function () { return _this._onCursorSelectionChanged(); }));
        this._disposables.add(this.editor.onDidChangeConfiguration(function (e) {
            if (e.hasChanged(101 /* suggest */)) {
                applyStatusBarStyle();
                applyIconStyle();
            }
        }));
        this._ctxSuggestWidgetVisible = SuggestContext.Visible.bindTo(_contextKeyService);
        this._ctxSuggestWidgetDetailsVisible = SuggestContext.DetailsVisible.bindTo(_contextKeyService);
        this._ctxSuggestWidgetMultipleSuggestions = SuggestContext.MultipleSuggestions.bindTo(_contextKeyService);
        this._disposables.add(dom.addStandardDisposableListener(this._details.widget.domNode, 'keydown', function (e) {
            _this._onDetailsKeydown.fire(e);
        }));
        this._disposables.add(this.editor.onMouseDown(function (e) { return _this._onEditorMouseDown(e); }));
    }
    SuggestWidget.prototype.dispose = function () {
        var _a;
        this._details.widget.dispose();
        this._details.dispose();
        this._list.dispose();
        this._status.dispose();
        this._disposables.dispose();
        (_a = this._loadingTimeout) === null || _a === void 0 ? void 0 : _a.dispose();
        this._showTimeout.dispose();
        this._contentWidget.dispose();
        this.element.dispose();
    };
    SuggestWidget.prototype._onEditorMouseDown = function (mouseEvent) {
        if (this._details.widget.domNode.contains(mouseEvent.target.element)) {
            // Clicking inside details
            this._details.widget.domNode.focus();
        }
        else {
            // Clicking outside details and inside suggest
            if (this.element.domNode.contains(mouseEvent.target.element)) {
                this.editor.focus();
            }
        }
    };
    SuggestWidget.prototype._onCursorSelectionChanged = function () {
        if (this._state !== 0 /* Hidden */) {
            this._contentWidget.layout();
        }
    };
    SuggestWidget.prototype._onListMouseDownOrTap = function (e) {
        if (typeof e.element === 'undefined' || typeof e.index === 'undefined') {
            return;
        }
        // prevent stealing browser focus from the editor
        e.browserEvent.preventDefault();
        e.browserEvent.stopPropagation();
        this._select(e.element, e.index);
    };
    SuggestWidget.prototype._onListSelection = function (e) {
        if (e.elements.length) {
            this._select(e.elements[0], e.indexes[0]);
        }
    };
    SuggestWidget.prototype._select = function (item, index) {
        var completionModel = this._completionModel;
        if (completionModel) {
            this._onDidSelect.fire({ item: item, index: index, model: completionModel });
            this.editor.focus();
        }
    };
    SuggestWidget.prototype._onThemeChange = function (theme) {
        var backgroundColor = theme.getColor(editorSuggestWidgetBackground);
        if (backgroundColor) {
            this.element.domNode.style.backgroundColor = backgroundColor.toString();
            this._messageElement.style.backgroundColor = backgroundColor.toString();
            this._details.widget.domNode.style.backgroundColor = backgroundColor.toString();
        }
        var borderColor = theme.getColor(editorSuggestWidgetBorder);
        if (borderColor) {
            this.element.domNode.style.borderColor = borderColor.toString();
            this._messageElement.style.borderColor = borderColor.toString();
            this._status.element.style.borderTopColor = borderColor.toString();
            this._details.widget.domNode.style.borderColor = borderColor.toString();
            this._detailsBorderColor = borderColor.toString();
        }
        var focusBorderColor = theme.getColor(focusBorder);
        if (focusBorderColor) {
            this._detailsFocusBorderColor = focusBorderColor.toString();
        }
        this._details.widget.borderWidth = theme.type === 'hc' ? 2 : 1;
    };
    SuggestWidget.prototype._onListFocus = function (e) {
        var _this = this;
        var _a;
        if (this._ignoreFocusEvents) {
            return;
        }
        if (!e.elements.length) {
            if (this._currentSuggestionDetails) {
                this._currentSuggestionDetails.cancel();
                this._currentSuggestionDetails = undefined;
                this._focusedItem = undefined;
            }
            this.editor.setAriaOptions({ activeDescendant: undefined });
            return;
        }
        if (!this._completionModel) {
            return;
        }
        var item = e.elements[0];
        var index = e.indexes[0];
        if (item !== this._focusedItem) {
            (_a = this._currentSuggestionDetails) === null || _a === void 0 ? void 0 : _a.cancel();
            this._currentSuggestionDetails = undefined;
            this._focusedItem = item;
            this._list.reveal(index);
            this._currentSuggestionDetails = createCancelablePromise(function (token) { return __awaiter(_this, void 0, void 0, function () {
                var loading, result;
                var _this = this;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            loading = disposableTimeout(function () {
                                if (_this._isDetailsVisible()) {
                                    _this.showDetails(true);
                                }
                            }, 250);
                            token.onCancellationRequested(function () { return loading.dispose(); });
                            return [4 /*yield*/, item.resolve(token)];
                        case 1:
                            result = _a.sent();
                            loading.dispose();
                            return [2 /*return*/, result];
                    }
                });
            }); });
            this._currentSuggestionDetails.then(function () {
                if (index >= _this._list.length || item !== _this._list.element(index)) {
                    return;
                }
                // item can have extra information, so re-render
                _this._ignoreFocusEvents = true;
                _this._list.splice(index, 1, [item]);
                _this._list.setFocus([index]);
                _this._ignoreFocusEvents = false;
                if (_this._isDetailsVisible()) {
                    _this.showDetails(false);
                }
                else {
                    _this.element.domNode.classList.remove('docs-side');
                }
                _this.editor.setAriaOptions({ activeDescendant: getAriaId(index) });
            }).catch(onUnexpectedError);
        }
        // emit an event
        this._onDidFocus.fire({ item: item, index: index, model: this._completionModel });
    };
    SuggestWidget.prototype._setState = function (state) {
        if (this._state === state) {
            return;
        }
        this._state = state;
        this.element.domNode.classList.toggle('frozen', state === 4 /* Frozen */);
        this.element.domNode.classList.remove('message');
        switch (state) {
            case 0 /* Hidden */:
                dom.hide(this._messageElement, this._listElement, this._status.element);
                this._details.hide(true);
                this._status.hide();
                this._contentWidget.hide();
                this._ctxSuggestWidgetVisible.reset();
                this._ctxSuggestWidgetMultipleSuggestions.reset();
                this.element.domNode.classList.remove('visible');
                this._list.splice(0, this._list.length);
                this._focusedItem = undefined;
                this._cappedHeight = undefined;
                this._explainMode = false;
                break;
            case 1 /* Loading */:
                this.element.domNode.classList.add('message');
                this._messageElement.textContent = SuggestWidget.LOADING_MESSAGE;
                dom.hide(this._listElement, this._status.element);
                dom.show(this._messageElement);
                this._details.hide();
                this._show();
                this._focusedItem = undefined;
                break;
            case 2 /* Empty */:
                this.element.domNode.classList.add('message');
                this._messageElement.textContent = SuggestWidget.NO_SUGGESTIONS_MESSAGE;
                dom.hide(this._listElement, this._status.element);
                dom.show(this._messageElement);
                this._details.hide();
                this._show();
                this._focusedItem = undefined;
                break;
            case 3 /* Open */:
                dom.hide(this._messageElement);
                dom.show(this._listElement, this._status.element);
                this._show();
                break;
            case 4 /* Frozen */:
                dom.hide(this._messageElement);
                dom.show(this._listElement, this._status.element);
                this._show();
                break;
            case 5 /* Details */:
                dom.hide(this._messageElement);
                dom.show(this._listElement, this._status.element);
                this._details.show();
                this._show();
                break;
        }
    };
    SuggestWidget.prototype._show = function () {
        var _this = this;
        this._status.show();
        this._contentWidget.show();
        this._layout(this._persistedSize.restore());
        this._ctxSuggestWidgetVisible.set(true);
        this._showTimeout.cancelAndSet(function () {
            _this.element.domNode.classList.add('visible');
            _this._onDidShow.fire(_this);
        }, 100);
    };
    SuggestWidget.prototype.showTriggered = function (auto, delay) {
        var _this = this;
        if (this._state !== 0 /* Hidden */) {
            return;
        }
        this._contentWidget.setPosition(this.editor.getPosition());
        this._isAuto = !!auto;
        if (!this._isAuto) {
            this._loadingTimeout = disposableTimeout(function () { return _this._setState(1 /* Loading */); }, delay);
        }
    };
    SuggestWidget.prototype.showSuggestions = function (completionModel, selectionIndex, isFrozen, isAuto) {
        var _a, _b;
        this._contentWidget.setPosition(this.editor.getPosition());
        (_a = this._loadingTimeout) === null || _a === void 0 ? void 0 : _a.dispose();
        (_b = this._currentSuggestionDetails) === null || _b === void 0 ? void 0 : _b.cancel();
        this._currentSuggestionDetails = undefined;
        if (this._completionModel !== completionModel) {
            this._completionModel = completionModel;
        }
        if (isFrozen && this._state !== 2 /* Empty */ && this._state !== 0 /* Hidden */) {
            this._setState(4 /* Frozen */);
            return;
        }
        var visibleCount = this._completionModel.items.length;
        var isEmpty = visibleCount === 0;
        this._ctxSuggestWidgetMultipleSuggestions.set(visibleCount > 1);
        if (isEmpty) {
            this._setState(isAuto ? 0 /* Hidden */ : 2 /* Empty */);
            this._completionModel = undefined;
            return;
        }
        this._focusedItem = undefined;
        this._list.splice(0, this._list.length, this._completionModel.items);
        this._setState(isFrozen ? 4 /* Frozen */ : 3 /* Open */);
        this._list.reveal(selectionIndex, 0);
        this._list.setFocus([selectionIndex]);
        this._layout(this.element.size);
        // Reset focus border
        if (this._detailsBorderColor) {
            this._details.widget.domNode.style.borderColor = this._detailsBorderColor;
        }
    };
    SuggestWidget.prototype.selectNextPage = function () {
        switch (this._state) {
            case 0 /* Hidden */:
                return false;
            case 5 /* Details */:
                this._details.widget.pageDown();
                return true;
            case 1 /* Loading */:
                return !this._isAuto;
            default:
                this._list.focusNextPage();
                return true;
        }
    };
    SuggestWidget.prototype.selectNext = function () {
        switch (this._state) {
            case 0 /* Hidden */:
                return false;
            case 1 /* Loading */:
                return !this._isAuto;
            default:
                this._list.focusNext(1, true);
                return true;
        }
    };
    SuggestWidget.prototype.selectLast = function () {
        switch (this._state) {
            case 0 /* Hidden */:
                return false;
            case 5 /* Details */:
                this._details.widget.scrollBottom();
                return true;
            case 1 /* Loading */:
                return !this._isAuto;
            default:
                this._list.focusLast();
                return true;
        }
    };
    SuggestWidget.prototype.selectPreviousPage = function () {
        switch (this._state) {
            case 0 /* Hidden */:
                return false;
            case 5 /* Details */:
                this._details.widget.pageUp();
                return true;
            case 1 /* Loading */:
                return !this._isAuto;
            default:
                this._list.focusPreviousPage();
                return true;
        }
    };
    SuggestWidget.prototype.selectPrevious = function () {
        switch (this._state) {
            case 0 /* Hidden */:
                return false;
            case 1 /* Loading */:
                return !this._isAuto;
            default:
                this._list.focusPrevious(1, true);
                return false;
        }
    };
    SuggestWidget.prototype.selectFirst = function () {
        switch (this._state) {
            case 0 /* Hidden */:
                return false;
            case 5 /* Details */:
                this._details.widget.scrollTop();
                return true;
            case 1 /* Loading */:
                return !this._isAuto;
            default:
                this._list.focusFirst();
                return true;
        }
    };
    SuggestWidget.prototype.getFocusedItem = function () {
        if (this._state !== 0 /* Hidden */
            && this._state !== 2 /* Empty */
            && this._state !== 1 /* Loading */
            && this._completionModel) {
            return {
                item: this._list.getFocusedElements()[0],
                index: this._list.getFocus()[0],
                model: this._completionModel
            };
        }
        return undefined;
    };
    SuggestWidget.prototype.toggleDetailsFocus = function () {
        if (this._state === 5 /* Details */) {
            this._setState(3 /* Open */);
            if (this._detailsBorderColor) {
                this._details.widget.domNode.style.borderColor = this._detailsBorderColor;
            }
        }
        else if (this._state === 3 /* Open */ && this._isDetailsVisible()) {
            this._setState(5 /* Details */);
            if (this._detailsFocusBorderColor) {
                this._details.widget.domNode.style.borderColor = this._detailsFocusBorderColor;
            }
        }
    };
    SuggestWidget.prototype.toggleDetails = function () {
        if (this._isDetailsVisible()) {
            // hide details widget
            this._ctxSuggestWidgetDetailsVisible.set(false);
            this._setDetailsVisible(false);
            this._details.hide();
            this.element.domNode.classList.remove('shows-details');
        }
        else if (canExpandCompletionItem(this._list.getFocusedElements()[0]) && (this._state === 3 /* Open */ || this._state === 5 /* Details */ || this._state === 4 /* Frozen */)) {
            // show details widget (iff possible)
            this._ctxSuggestWidgetDetailsVisible.set(true);
            this._setDetailsVisible(true);
            this.showDetails(false);
        }
    };
    SuggestWidget.prototype.showDetails = function (loading) {
        this._details.show();
        if (loading) {
            this._details.widget.renderLoading();
        }
        else {
            this._details.widget.renderItem(this._list.getFocusedElements()[0], this._explainMode);
        }
        this._positionDetails();
        this.editor.focus();
        this.element.domNode.classList.add('shows-details');
    };
    SuggestWidget.prototype.toggleExplainMode = function () {
        if (this._list.getFocusedElements()[0] && this._isDetailsVisible()) {
            this._explainMode = !this._explainMode;
            this.showDetails(false);
        }
    };
    SuggestWidget.prototype.resetPersistedSize = function () {
        this._persistedSize.reset();
    };
    SuggestWidget.prototype.hideWidget = function () {
        var _a;
        (_a = this._loadingTimeout) === null || _a === void 0 ? void 0 : _a.dispose();
        this._setState(0 /* Hidden */);
        this._onDidHide.fire(this);
        // ensure that a reasonable widget height is persisted so that
        // accidential "resize-to-single-items" cases aren't happening
        var dim = this._persistedSize.restore();
        var minPersistedHeight = Math.ceil(this.getLayoutInfo().itemHeight * 4.3);
        if (dim && dim.height < minPersistedHeight) {
            this._persistedSize.store(dim.with(undefined, minPersistedHeight));
        }
    };
    SuggestWidget.prototype.isFrozen = function () {
        return this._state === 4 /* Frozen */;
    };
    SuggestWidget.prototype._afterRender = function (position) {
        if (position === null) {
            if (this._isDetailsVisible()) {
                this._details.hide(); //todo@jrieken soft-hide
            }
            return;
        }
        if (this._state === 2 /* Empty */ || this._state === 1 /* Loading */) {
            // no special positioning when widget isn't showing list
            return;
        }
        if (this._isDetailsVisible()) {
            this._details.show();
        }
        this._positionDetails();
    };
    SuggestWidget.prototype._layout = function (size) {
        var _a, _b, _c;
        if (!this.editor.hasModel()) {
            return;
        }
        if (!this.editor.getDomNode()) {
            // happens when running tests
            return;
        }
        var bodyBox = dom.getClientArea(document.body);
        var info = this.getLayoutInfo();
        if (!size) {
            size = info.defaultSize;
        }
        var height = size.height;
        var width = size.width;
        // status bar
        this._status.element.style.lineHeight = info.itemHeight + "px";
        if (this._state === 2 /* Empty */ || this._state === 1 /* Loading */) {
            // showing a message only
            height = info.itemHeight + info.borderHeight;
            width = info.defaultSize.width / 2;
            this.element.enableSashes(false, false, false, false);
            this.element.minSize = this.element.maxSize = new dom.Dimension(width, height);
            this._contentWidget.setPreference(2 /* BELOW */);
        }
        else {
            // showing items
            // width math
            var maxWidth = bodyBox.width - info.borderHeight - 2 * info.horizontalPadding;
            if (width > maxWidth) {
                width = maxWidth;
            }
            var preferredWidth = this._completionModel ? this._completionModel.stats.pLabelLen * info.typicalHalfwidthCharacterWidth : width;
            // height math
            var fullHeight = info.statusBarHeight + this._list.contentHeight + info.borderHeight;
            var minHeight = info.itemHeight + info.statusBarHeight;
            var editorBox = dom.getDomNodePagePosition(this.editor.getDomNode());
            var cursorBox = this.editor.getScrolledVisiblePosition(this.editor.getPosition());
            var cursorBottom = editorBox.top + cursorBox.top + cursorBox.height;
            var maxHeightBelow = Math.min(bodyBox.height - cursorBottom - info.verticalPadding, fullHeight);
            var maxHeightAbove = Math.min(editorBox.top + cursorBox.top - info.verticalPadding, fullHeight);
            var maxHeight = Math.min(Math.max(maxHeightAbove, maxHeightBelow) + info.borderHeight, fullHeight);
            if (height === ((_a = this._cappedHeight) === null || _a === void 0 ? void 0 : _a.capped)) {
                // Restore the old (wanted) height when the current
                // height is capped to fit
                height = this._cappedHeight.wanted;
            }
            if (height < minHeight) {
                height = minHeight;
            }
            if (height > maxHeight) {
                height = maxHeight;
            }
            if (height > maxHeightBelow) {
                this._contentWidget.setPreference(1 /* ABOVE */);
                this.element.enableSashes(true, true, false, false);
                maxHeight = maxHeightAbove;
            }
            else {
                this._contentWidget.setPreference(2 /* BELOW */);
                this.element.enableSashes(false, true, true, false);
                maxHeight = maxHeightBelow;
            }
            this.element.preferredSize = new dom.Dimension(preferredWidth, info.defaultSize.height);
            this.element.maxSize = new dom.Dimension(maxWidth, maxHeight);
            this.element.minSize = new dom.Dimension(220, minHeight);
            // Know when the height was capped to fit and remember
            // the wanted height for later. This is required when going
            // left to widen suggestions.
            this._cappedHeight = height === fullHeight
                ? { wanted: (_c = (_b = this._cappedHeight) === null || _b === void 0 ? void 0 : _b.wanted) !== null && _c !== void 0 ? _c : size.height, capped: height }
                : undefined;
        }
        this._resize(width, height);
    };
    SuggestWidget.prototype._resize = function (width, height) {
        var _a = this.element.maxSize, maxWidth = _a.width, maxHeight = _a.height;
        width = Math.min(maxWidth, width);
        height = Math.min(maxHeight, height);
        var statusBarHeight = this.getLayoutInfo().statusBarHeight;
        this._list.layout(height - statusBarHeight, width);
        this._listElement.style.height = height - statusBarHeight + "px";
        this.element.layout(height, width);
        this._contentWidget.layout();
        this._positionDetails();
    };
    SuggestWidget.prototype._positionDetails = function () {
        if (this._isDetailsVisible()) {
            this._details.placeAtAnchor(this.element.domNode);
        }
    };
    SuggestWidget.prototype.getLayoutInfo = function () {
        var fontInfo = this.editor.getOption(38 /* fontInfo */);
        var itemHeight = clamp(this.editor.getOption(103 /* suggestLineHeight */) || fontInfo.lineHeight, 8, 1000);
        var statusBarHeight = !this.editor.getOption(101 /* suggest */).showStatusBar || this._state === 2 /* Empty */ || this._state === 1 /* Loading */ ? 0 : itemHeight;
        var borderWidth = this._details.widget.borderWidth;
        var borderHeight = 2 * borderWidth;
        return {
            itemHeight: itemHeight,
            statusBarHeight: statusBarHeight,
            borderWidth: borderWidth,
            borderHeight: borderHeight,
            typicalHalfwidthCharacterWidth: fontInfo.typicalHalfwidthCharacterWidth,
            verticalPadding: 22,
            horizontalPadding: 14,
            defaultSize: new dom.Dimension(430, statusBarHeight + 12 * itemHeight + borderHeight)
        };
    };
    SuggestWidget.prototype._isDetailsVisible = function () {
        return this._storageService.getBoolean('expandSuggestionDocs', 0 /* GLOBAL */, false);
    };
    SuggestWidget.prototype._setDetailsVisible = function (value) {
        this._storageService.store('expandSuggestionDocs', value, 0 /* GLOBAL */, 0 /* USER */);
    };
    SuggestWidget.LOADING_MESSAGE = nls.localize('suggestWidget.loading', "Loading...");
    SuggestWidget.NO_SUGGESTIONS_MESSAGE = nls.localize('suggestWidget.noSuggestions', "No suggestions.");
    SuggestWidget = __decorate([
        __param(1, IStorageService),
        __param(2, IContextKeyService),
        __param(3, IThemeService),
        __param(4, IInstantiationService)
    ], SuggestWidget);
    return SuggestWidget;
}());
export { SuggestWidget };
var SuggestContentWidget = /** @class */ (function () {
    function SuggestContentWidget(_widget, _editor) {
        this._widget = _widget;
        this._editor = _editor;
        this.allowEditorOverflow = true;
        this.suppressMouseDown = false;
        this._preferenceLocked = false;
        this._added = false;
        this._hidden = false;
    }
    SuggestContentWidget.prototype.dispose = function () {
        if (this._added) {
            this._added = false;
            this._editor.removeContentWidget(this);
        }
    };
    SuggestContentWidget.prototype.getId = function () {
        return 'editor.widget.suggestWidget';
    };
    SuggestContentWidget.prototype.getDomNode = function () {
        return this._widget.element.domNode;
    };
    SuggestContentWidget.prototype.show = function () {
        this._hidden = false;
        if (!this._added) {
            this._added = true;
            this._editor.addContentWidget(this);
        }
    };
    SuggestContentWidget.prototype.hide = function () {
        if (!this._hidden) {
            this._hidden = true;
            this.layout();
        }
    };
    SuggestContentWidget.prototype.layout = function () {
        this._editor.layoutContentWidget(this);
    };
    SuggestContentWidget.prototype.getPosition = function () {
        if (this._hidden || !this._position || !this._preference) {
            return null;
        }
        return {
            position: this._position,
            preference: [this._preference]
        };
    };
    SuggestContentWidget.prototype.beforeRender = function () {
        var _a = this._widget.element.size, height = _a.height, width = _a.width;
        var _b = this._widget.getLayoutInfo(), borderWidth = _b.borderWidth, horizontalPadding = _b.horizontalPadding;
        return new dom.Dimension(width + 2 * borderWidth + horizontalPadding, height + 2 * borderWidth);
    };
    SuggestContentWidget.prototype.afterRender = function (position) {
        this._widget._afterRender(position);
    };
    SuggestContentWidget.prototype.setPreference = function (preference) {
        if (!this._preferenceLocked) {
            this._preference = preference;
        }
    };
    SuggestContentWidget.prototype.lockPreference = function () {
        this._preferenceLocked = true;
    };
    SuggestContentWidget.prototype.unlockPreference = function () {
        this._preferenceLocked = false;
    };
    SuggestContentWidget.prototype.setPosition = function (position) {
        this._position = position;
    };
    return SuggestContentWidget;
}());
export { SuggestContentWidget };
registerThemingParticipant(function (theme, collector) {
    var matchHighlight = theme.getColor(editorSuggestWidgetHighlightForeground);
    if (matchHighlight) {
        collector.addRule(".monaco-editor .suggest-widget .monaco-list .monaco-list-row .monaco-highlighted-label .highlight { color: " + matchHighlight + "; }");
    }
    var foreground = theme.getColor(editorSuggestWidgetForeground);
    if (foreground) {
        collector.addRule(".monaco-editor .suggest-widget, .monaco-editor .suggest-details { color: " + foreground + "; }");
    }
    var link = theme.getColor(textLinkForeground);
    if (link) {
        collector.addRule(".monaco-editor .suggest-details a { color: " + link + "; }");
    }
    var codeBackground = theme.getColor(textCodeBlockBackground);
    if (codeBackground) {
        collector.addRule(".monaco-editor .suggest-details code { background-color: " + codeBackground + "; }");
    }
});
