/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { RunOnceScheduler } from '../../../base/common/async';
import { onUnexpectedExternalError } from '../../../base/common/errors';
import { hash } from '../../../base/common/hash';
import { DisposableStore, toDisposable } from '../../../base/common/lifecycle';
import { registerEditorContribution } from '../../browser/editorExtensions';
import { ICodeEditorService } from '../../browser/services/codeEditorService';
import { InlineHintsProviderRegistry } from '../../common/modes';
import { flatten } from '../../../base/common/arrays';
import { editorInlineHintForeground, editorInlineHintBackground } from '../../../platform/theme/common/colorRegistry';
import { CancellationToken, CancellationTokenSource } from '../../../base/common/cancellation';
import { IThemeService } from '../../../platform/theme/common/themeService';
import { Range } from '../../common/core/range';
import { LanguageFeatureRequestDelays } from '../../common/modes/languageFeatureRegistry';
import { MarkdownString } from '../../../base/common/htmlContent';
import { CommandsRegistry } from '../../../platform/commands/common/commands';
import { URI } from '../../../base/common/uri';
import { assertType } from '../../../base/common/types';
import { ITextModelService } from '../../common/services/resolverService';
var MAX_DECORATORS = 500;
export function getInlineHints(model, ranges, token) {
    return __awaiter(this, void 0, void 0, function () {
        var datas, providers, promises;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    datas = [];
                    providers = InlineHintsProviderRegistry.ordered(model).reverse();
                    promises = flatten(providers.map(function (provider) { return ranges.map(function (range) { return Promise.resolve(provider.provideInlineHints(model, range, token)).then(function (result) {
                        if (result) {
                            datas.push({ list: result, provider: provider });
                        }
                    }, function (err) {
                        onUnexpectedExternalError(err);
                    }); }); }));
                    return [4 /*yield*/, Promise.all(promises)];
                case 1:
                    _a.sent();
                    return [2 /*return*/, datas];
            }
        });
    });
}
var InlineHintsController = /** @class */ (function () {
    function InlineHintsController(_editor, _codeEditorService, _themeService) {
        var _this = this;
        this._editor = _editor;
        this._codeEditorService = _codeEditorService;
        this._themeService = _themeService;
        // static get(editor: ICodeEditor): InlineHintsController {
        // 	return editor.getContribution<InlineHintsController>(this.ID);
        // }
        this._disposables = new DisposableStore();
        this._sessionDisposables = new DisposableStore();
        this._getInlineHintsDelays = new LanguageFeatureRequestDelays(InlineHintsProviderRegistry, 250, 2500);
        this._decorationsTypeIds = [];
        this._decorationIds = [];
        this._disposables.add(InlineHintsProviderRegistry.onDidChange(function () { return _this._update(); }));
        this._disposables.add(_themeService.onDidColorThemeChange(function () { return _this._update(); }));
        this._disposables.add(_editor.onDidChangeModel(function () { return _this._update(); }));
        this._disposables.add(_editor.onDidChangeModelLanguage(function () { return _this._update(); }));
        this._disposables.add(_editor.onDidChangeConfiguration(function (e) {
            if (e.hasChanged(120 /* inlineHints */)) {
                _this._update();
            }
        }));
        this._update();
    }
    InlineHintsController.prototype.dispose = function () {
        this._sessionDisposables.dispose();
        this._removeAllDecorations();
        this._disposables.dispose();
    };
    InlineHintsController.prototype._update = function () {
        var e_1, _a;
        var _this = this;
        this._sessionDisposables.clear();
        if (!this._editor.getOption(120 /* inlineHints */).enabled) {
            this._removeAllDecorations();
            return;
        }
        var model = this._editor.getModel();
        if (!model || !InlineHintsProviderRegistry.has(model)) {
            this._removeAllDecorations();
            return;
        }
        var scheduler = new RunOnceScheduler(function () { return __awaiter(_this, void 0, void 0, function () {
            var t1, cts, visibleRanges, result, newDelay;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        t1 = Date.now();
                        cts = new CancellationTokenSource();
                        this._sessionDisposables.add(toDisposable(function () { return cts.dispose(true); }));
                        visibleRanges = this._editor.getVisibleRangesPlusViewportAboveBelow();
                        return [4 /*yield*/, getInlineHints(model, visibleRanges, cts.token)];
                    case 1:
                        result = _a.sent();
                        newDelay = this._getInlineHintsDelays.update(model, Date.now() - t1);
                        scheduler.delay = newDelay;
                        // render hints
                        this._updateHintsDecorators(result);
                        return [2 /*return*/];
                }
            });
        }); }, this._getInlineHintsDelays.get(model));
        this._sessionDisposables.add(scheduler);
        // update inline hints when content or scroll position changes
        this._sessionDisposables.add(this._editor.onDidChangeModelContent(function () { return scheduler.schedule(); }));
        this._disposables.add(this._editor.onDidScrollChange(function () { return scheduler.schedule(); }));
        scheduler.schedule();
        // update inline hints when any any provider fires an event
        var providerListener = new DisposableStore();
        this._sessionDisposables.add(providerListener);
        try {
            for (var _b = __values(InlineHintsProviderRegistry.all(model)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var provider = _c.value;
                if (typeof provider.onDidChangeInlineHints === 'function') {
                    providerListener.add(provider.onDidChangeInlineHints(function () { return scheduler.schedule(); }));
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    InlineHintsController.prototype._updateHintsDecorators = function (hintsData) {
        var e_2, _a;
        var _b = this._getLayoutInfo(), fontSize = _b.fontSize, fontFamily = _b.fontFamily;
        var backgroundColor = this._themeService.getColorTheme().getColor(editorInlineHintBackground);
        var fontColor = this._themeService.getColorTheme().getColor(editorInlineHintForeground);
        var newDecorationsTypeIds = [];
        var newDecorationsData = [];
        try {
            for (var hintsData_1 = __values(hintsData), hintsData_1_1 = hintsData_1.next(); !hintsData_1_1.done; hintsData_1_1 = hintsData_1.next()) {
                var hints = hintsData_1_1.value.list;
                for (var j = 0; j < hints.length && newDecorationsData.length < MAX_DECORATORS; j++) {
                    var _c = hints[j], text = _c.text, range = _c.range, hoverMessage = _c.description, whitespaceBefore = _c.whitespaceBefore, whitespaceAfter = _c.whitespaceAfter;
                    var marginBefore = whitespaceBefore ? (fontSize / 3) | 0 : 0;
                    var marginAfter = whitespaceAfter ? (fontSize / 3) | 0 : 0;
                    var before = {
                        contentText: text,
                        backgroundColor: "" + backgroundColor,
                        color: "" + fontColor,
                        margin: "0px " + marginAfter + "px 0px " + marginBefore + "px",
                        fontSize: fontSize + "px",
                        fontFamily: fontFamily,
                        padding: "0px " + ((fontSize / 4) | 0) + "px",
                        borderRadius: ((fontSize / 4) | 0) + "px",
                    };
                    var key = 'inlineHints-' + hash(before).toString(16);
                    this._codeEditorService.registerDecorationType(key, { before: before }, undefined, this._editor);
                    // decoration types are ref-counted which means we only need to
                    // call register und remove equally often
                    newDecorationsTypeIds.push(key);
                    var options = this._codeEditorService.resolveDecorationOptions(key, true);
                    if (typeof hoverMessage === 'string') {
                        options.hoverMessage = new MarkdownString().appendText(hoverMessage);
                    }
                    else if (hoverMessage) {
                        options.hoverMessage = hoverMessage;
                    }
                    newDecorationsData.push({
                        range: range,
                        options: options
                    });
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (hintsData_1_1 && !hintsData_1_1.done && (_a = hintsData_1.return)) _a.call(hintsData_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        this._decorationsTypeIds.forEach(this._codeEditorService.removeDecorationType, this._codeEditorService);
        this._decorationsTypeIds = newDecorationsTypeIds;
        this._decorationIds = this._editor.deltaDecorations(this._decorationIds, newDecorationsData);
    };
    InlineHintsController.prototype._getLayoutInfo = function () {
        var options = this._editor.getOption(120 /* inlineHints */);
        var editorFontSize = this._editor.getOption(40 /* fontSize */);
        var fontSize = options.fontSize;
        if (!fontSize || fontSize < 5 || fontSize > editorFontSize) {
            fontSize = (editorFontSize * .9) | 0;
        }
        var fontFamily = options.fontFamily;
        return { fontSize: fontSize, fontFamily: fontFamily };
    };
    InlineHintsController.prototype._removeAllDecorations = function () {
        this._decorationIds = this._editor.deltaDecorations(this._decorationIds, []);
        this._decorationsTypeIds.forEach(this._codeEditorService.removeDecorationType, this._codeEditorService);
        this._decorationsTypeIds = [];
    };
    InlineHintsController.ID = 'editor.contrib.InlineHints';
    InlineHintsController = __decorate([
        __param(1, ICodeEditorService),
        __param(2, IThemeService)
    ], InlineHintsController);
    return InlineHintsController;
}());
export { InlineHintsController };
registerEditorContribution(InlineHintsController.ID, InlineHintsController);
CommandsRegistry.registerCommand('_executeInlineHintProvider', function (accessor) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    return __awaiter(void 0, void 0, void 0, function () {
        var _a, uri, range, ref, data;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _a = __read(args, 2), uri = _a[0], range = _a[1];
                    assertType(URI.isUri(uri));
                    assertType(Range.isIRange(range));
                    return [4 /*yield*/, accessor.get(ITextModelService).createModelReference(uri)];
                case 1:
                    ref = _b.sent();
                    _b.label = 2;
                case 2:
                    _b.trys.push([2, , 4, 5]);
                    return [4 /*yield*/, getInlineHints(ref.object.textEditorModel, [Range.lift(range)], CancellationToken.None)];
                case 3:
                    data = _b.sent();
                    return [2 /*return*/, flatten(data.map(function (item) { return item.list; })).sort(function (a, b) { return Range.compareRangesUsingStarts(a.range, b.range); })];
                case 4:
                    ref.dispose();
                    return [7 /*endfinally*/];
                case 5: return [2 /*return*/];
            }
        });
    });
});
