/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { Widget } from '../../../base/browser/ui/widget';
var GlyphHoverWidget = /** @class */ (function (_super) {
    __extends(GlyphHoverWidget, _super);
    function GlyphHoverWidget(id, editor) {
        var _this = _super.call(this) || this;
        _this._id = id;
        _this._editor = editor;
        _this._isVisible = false;
        _this._domNode = document.createElement('div');
        _this._domNode.className = 'monaco-hover hidden';
        _this._domNode.setAttribute('aria-hidden', 'true');
        _this._domNode.setAttribute('role', 'tooltip');
        _this._showAtLineNumber = -1;
        _this._register(_this._editor.onDidChangeConfiguration(function (e) {
            if (e.hasChanged(38 /* fontInfo */)) {
                _this.updateFont();
            }
        }));
        _this._editor.addOverlayWidget(_this);
        return _this;
    }
    Object.defineProperty(GlyphHoverWidget.prototype, "isVisible", {
        get: function () {
            return this._isVisible;
        },
        set: function (value) {
            this._isVisible = value;
            this._domNode.classList.toggle('hidden', !this._isVisible);
        },
        enumerable: false,
        configurable: true
    });
    GlyphHoverWidget.prototype.getId = function () {
        return this._id;
    };
    GlyphHoverWidget.prototype.getDomNode = function () {
        return this._domNode;
    };
    GlyphHoverWidget.prototype.showAt = function (lineNumber) {
        this._showAtLineNumber = lineNumber;
        if (!this.isVisible) {
            this.isVisible = true;
        }
        var editorLayout = this._editor.getLayoutInfo();
        var topForLineNumber = this._editor.getTopForLineNumber(this._showAtLineNumber);
        var editorScrollTop = this._editor.getScrollTop();
        var lineHeight = this._editor.getOption(53 /* lineHeight */);
        var nodeHeight = this._domNode.clientHeight;
        var top = topForLineNumber - editorScrollTop - ((nodeHeight - lineHeight) / 2);
        this._domNode.style.left = editorLayout.glyphMarginLeft + editorLayout.glyphMarginWidth + "px";
        this._domNode.style.top = Math.max(Math.round(top), 0) + "px";
    };
    GlyphHoverWidget.prototype.hide = function () {
        if (!this.isVisible) {
            return;
        }
        this.isVisible = false;
    };
    GlyphHoverWidget.prototype.getPosition = function () {
        return null;
    };
    GlyphHoverWidget.prototype.dispose = function () {
        this._editor.removeOverlayWidget(this);
        _super.prototype.dispose.call(this);
    };
    GlyphHoverWidget.prototype.updateFont = function () {
        var _this = this;
        var codeTags = Array.prototype.slice.call(this._domNode.getElementsByTagName('code'));
        var codeClasses = Array.prototype.slice.call(this._domNode.getElementsByClassName('code'));
        __spreadArray(__spreadArray([], __read(codeTags)), __read(codeClasses)).forEach(function (node) { return _this._editor.applyFontInfo(node); });
    };
    GlyphHoverWidget.prototype.updateContents = function (node) {
        this._domNode.textContent = '';
        this._domNode.appendChild(node);
        this.updateFont();
    };
    return GlyphHoverWidget;
}(Widget));
export { GlyphHoverWidget };
