/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import * as nls from '../../../nls';
import { DisposableStore } from '../../../base/common/lifecycle';
import { RawContextKey, IContextKeyService } from '../../../platform/contextkey/common/contextkey';
import { Position } from '../../common/core/position';
import { Range } from '../../common/core/range';
import { registerEditorAction, registerEditorContribution, EditorAction, EditorCommand, registerEditorCommand } from '../../browser/editorExtensions';
import { EditorContextKeys } from '../../common/editorContextKeys';
import { MarkerNavigationWidget } from './gotoErrorWidget';
import { ICodeEditorService } from '../../browser/services/codeEditorService';
import { MenuId } from '../../../platform/actions/common/actions';
import { Codicon } from '../../../base/common/codicons';
import { IInstantiationService } from '../../../platform/instantiation/common/instantiation';
import { IMarkerNavigationService } from './markerNavigationService';
import { registerIcon } from '../../../platform/theme/common/iconRegistry';
var MarkerController = /** @class */ (function () {
    function MarkerController(editor, _markerNavigationService, _contextKeyService, _editorService, _instantiationService) {
        this._markerNavigationService = _markerNavigationService;
        this._contextKeyService = _contextKeyService;
        this._editorService = _editorService;
        this._instantiationService = _instantiationService;
        this._sessionDispoables = new DisposableStore();
        this._editor = editor;
        this._widgetVisible = CONTEXT_MARKERS_NAVIGATION_VISIBLE.bindTo(this._contextKeyService);
    }
    MarkerController.get = function (editor) {
        return editor.getContribution(MarkerController.ID);
    };
    MarkerController.prototype.dispose = function () {
        this._cleanUp();
        this._sessionDispoables.dispose();
    };
    MarkerController.prototype._cleanUp = function () {
        this._widgetVisible.reset();
        this._sessionDispoables.clear();
        this._widget = undefined;
        this._model = undefined;
    };
    MarkerController.prototype._getOrCreateModel = function (uri) {
        var _this = this;
        if (this._model && this._model.matches(uri)) {
            return this._model;
        }
        var reusePosition = false;
        if (this._model) {
            reusePosition = true;
            this._cleanUp();
        }
        this._model = this._markerNavigationService.getMarkerList(uri);
        if (reusePosition) {
            this._model.move(true, this._editor.getModel(), this._editor.getPosition());
        }
        this._widget = this._instantiationService.createInstance(MarkerNavigationWidget, this._editor);
        this._widget.onDidClose(function () { return _this.close(); }, this, this._sessionDispoables);
        this._widgetVisible.set(true);
        this._sessionDispoables.add(this._model);
        this._sessionDispoables.add(this._widget);
        // follow cursor
        this._sessionDispoables.add(this._editor.onDidChangeCursorPosition(function (e) {
            var _a, _b, _c;
            if (!((_a = _this._model) === null || _a === void 0 ? void 0 : _a.selected) || !Range.containsPosition((_b = _this._model) === null || _b === void 0 ? void 0 : _b.selected.marker, e.position)) {
                (_c = _this._model) === null || _c === void 0 ? void 0 : _c.resetIndex();
            }
        }));
        // update markers
        this._sessionDispoables.add(this._model.onDidChange(function () {
            if (!_this._widget || !_this._widget.position || !_this._model) {
                return;
            }
            var info = _this._model.find(_this._editor.getModel().uri, _this._widget.position);
            if (info) {
                _this._widget.updateMarker(info.marker);
            }
            else {
                _this._widget.showStale();
            }
        }));
        // open related
        this._sessionDispoables.add(this._widget.onDidSelectRelatedInformation(function (related) {
            _this._editorService.openCodeEditor({
                resource: related.resource,
                options: { pinned: true, revealIfOpened: true, selection: Range.lift(related).collapseToStart() }
            }, _this._editor);
            _this.close(false);
        }));
        this._sessionDispoables.add(this._editor.onDidChangeModel(function () { return _this._cleanUp(); }));
        return this._model;
    };
    MarkerController.prototype.close = function (focusEditor) {
        if (focusEditor === void 0) { focusEditor = true; }
        this._cleanUp();
        if (focusEditor) {
            this._editor.focus();
        }
    };
    MarkerController.prototype.showAtMarker = function (marker) {
        if (this._editor.hasModel()) {
            var model = this._getOrCreateModel(this._editor.getModel().uri);
            model.resetIndex();
            model.move(true, this._editor.getModel(), new Position(marker.startLineNumber, marker.startColumn));
            if (model.selected) {
                this._widget.showAtMarker(model.selected.marker, model.selected.index, model.selected.total);
            }
        }
    };
    MarkerController.prototype.nagivate = function (next, multiFile) {
        return __awaiter(this, void 0, void 0, function () {
            var model, otherEditor;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this._editor.hasModel()) return [3 /*break*/, 3];
                        model = this._getOrCreateModel(multiFile ? undefined : this._editor.getModel().uri);
                        model.move(next, this._editor.getModel(), this._editor.getPosition());
                        if (!model.selected) {
                            return [2 /*return*/];
                        }
                        if (!(model.selected.marker.resource.toString() !== this._editor.getModel().uri.toString())) return [3 /*break*/, 2];
                        // show in different editor
                        this._cleanUp();
                        return [4 /*yield*/, this._editorService.openCodeEditor({
                                resource: model.selected.marker.resource,
                                options: { pinned: false, revealIfOpened: true, selectionRevealType: 2 /* NearTop */, selection: model.selected.marker }
                            }, this._editor)];
                    case 1:
                        otherEditor = _a.sent();
                        if (otherEditor) {
                            MarkerController.get(otherEditor).close();
                            MarkerController.get(otherEditor).nagivate(next, multiFile);
                        }
                        return [3 /*break*/, 3];
                    case 2:
                        // show in this editor
                        this._widget.showAtMarker(model.selected.marker, model.selected.index, model.selected.total);
                        _a.label = 3;
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    MarkerController.ID = 'editor.contrib.markerController';
    MarkerController = __decorate([
        __param(1, IMarkerNavigationService),
        __param(2, IContextKeyService),
        __param(3, ICodeEditorService),
        __param(4, IInstantiationService)
    ], MarkerController);
    return MarkerController;
}());
export { MarkerController };
var MarkerNavigationAction = /** @class */ (function (_super) {
    __extends(MarkerNavigationAction, _super);
    function MarkerNavigationAction(_next, _multiFile, opts) {
        var _this = _super.call(this, opts) || this;
        _this._next = _next;
        _this._multiFile = _multiFile;
        return _this;
    }
    MarkerNavigationAction.prototype.run = function (_accessor, editor) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (editor.hasModel()) {
                    MarkerController.get(editor).nagivate(this._next, this._multiFile);
                }
                return [2 /*return*/];
            });
        });
    };
    return MarkerNavigationAction;
}(EditorAction));
var NextMarkerAction = /** @class */ (function (_super) {
    __extends(NextMarkerAction, _super);
    function NextMarkerAction() {
        return _super.call(this, true, false, {
            id: NextMarkerAction.ID,
            label: NextMarkerAction.LABEL,
            alias: 'Go to Next Problem (Error, Warning, Info)',
            precondition: undefined,
            kbOpts: {
                kbExpr: EditorContextKeys.focus,
                primary: 512 /* Alt */ | 66 /* F8 */,
                weight: 100 /* EditorContrib */
            },
            menuOpts: {
                menuId: MarkerNavigationWidget.TitleMenu,
                title: NextMarkerAction.LABEL,
                icon: registerIcon('marker-navigation-next', Codicon.chevronDown, nls.localize('nextMarkerIcon', 'Icon for goto next marker.')),
                group: 'navigation',
                order: 1
            }
        }) || this;
    }
    NextMarkerAction.ID = 'editor.action.marker.next';
    NextMarkerAction.LABEL = nls.localize('markerAction.next.label', "Go to Next Problem (Error, Warning, Info)");
    return NextMarkerAction;
}(MarkerNavigationAction));
export { NextMarkerAction };
var PrevMarkerAction = /** @class */ (function (_super) {
    __extends(PrevMarkerAction, _super);
    function PrevMarkerAction() {
        return _super.call(this, false, false, {
            id: PrevMarkerAction.ID,
            label: PrevMarkerAction.LABEL,
            alias: 'Go to Previous Problem (Error, Warning, Info)',
            precondition: undefined,
            kbOpts: {
                kbExpr: EditorContextKeys.focus,
                primary: 1024 /* Shift */ | 512 /* Alt */ | 66 /* F8 */,
                weight: 100 /* EditorContrib */
            },
            menuOpts: {
                menuId: MarkerNavigationWidget.TitleMenu,
                title: NextMarkerAction.LABEL,
                icon: registerIcon('marker-navigation-previous', Codicon.chevronUp, nls.localize('previousMarkerIcon', 'Icon for goto previous marker.')),
                group: 'navigation',
                order: 2
            }
        }) || this;
    }
    PrevMarkerAction.ID = 'editor.action.marker.prev';
    PrevMarkerAction.LABEL = nls.localize('markerAction.previous.label', "Go to Previous Problem (Error, Warning, Info)");
    return PrevMarkerAction;
}(MarkerNavigationAction));
var NextMarkerInFilesAction = /** @class */ (function (_super) {
    __extends(NextMarkerInFilesAction, _super);
    function NextMarkerInFilesAction() {
        return _super.call(this, true, true, {
            id: 'editor.action.marker.nextInFiles',
            label: nls.localize('markerAction.nextInFiles.label', "Go to Next Problem in Files (Error, Warning, Info)"),
            alias: 'Go to Next Problem in Files (Error, Warning, Info)',
            precondition: undefined,
            kbOpts: {
                kbExpr: EditorContextKeys.focus,
                primary: 66 /* F8 */,
                weight: 100 /* EditorContrib */
            },
            menuOpts: {
                menuId: MenuId.MenubarGoMenu,
                title: nls.localize({ key: 'miGotoNextProblem', comment: ['&& denotes a mnemonic'] }, "Next &&Problem"),
                group: '6_problem_nav',
                order: 1
            }
        }) || this;
    }
    return NextMarkerInFilesAction;
}(MarkerNavigationAction));
var PrevMarkerInFilesAction = /** @class */ (function (_super) {
    __extends(PrevMarkerInFilesAction, _super);
    function PrevMarkerInFilesAction() {
        return _super.call(this, false, true, {
            id: 'editor.action.marker.prevInFiles',
            label: nls.localize('markerAction.previousInFiles.label', "Go to Previous Problem in Files (Error, Warning, Info)"),
            alias: 'Go to Previous Problem in Files (Error, Warning, Info)',
            precondition: undefined,
            kbOpts: {
                kbExpr: EditorContextKeys.focus,
                primary: 1024 /* Shift */ | 66 /* F8 */,
                weight: 100 /* EditorContrib */
            },
            menuOpts: {
                menuId: MenuId.MenubarGoMenu,
                title: nls.localize({ key: 'miGotoPreviousProblem', comment: ['&& denotes a mnemonic'] }, "Previous &&Problem"),
                group: '6_problem_nav',
                order: 2
            }
        }) || this;
    }
    return PrevMarkerInFilesAction;
}(MarkerNavigationAction));
registerEditorContribution(MarkerController.ID, MarkerController);
registerEditorAction(NextMarkerAction);
registerEditorAction(PrevMarkerAction);
registerEditorAction(NextMarkerInFilesAction);
registerEditorAction(PrevMarkerInFilesAction);
var CONTEXT_MARKERS_NAVIGATION_VISIBLE = new RawContextKey('markersNavigationVisible', false);
var MarkerCommand = EditorCommand.bindToContribution(MarkerController.get);
registerEditorCommand(new MarkerCommand({
    id: 'closeMarkersNavigation',
    precondition: CONTEXT_MARKERS_NAVIGATION_VISIBLE,
    handler: function (x) { return x.close(); },
    kbOpts: {
        weight: 100 /* EditorContrib */ + 50,
        kbExpr: EditorContextKeys.focus,
        primary: 9 /* Escape */,
        secondary: [1024 /* Shift */ | 9 /* Escape */]
    }
}));
