/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { equals, flatten, isNonEmptyArray, mergeSort, coalesce } from '../../../base/common/arrays';
import { CancellationToken } from '../../../base/common/cancellation';
import { illegalArgument, isPromiseCanceledError, onUnexpectedExternalError } from '../../../base/common/errors';
import { Disposable, DisposableStore } from '../../../base/common/lifecycle';
import { URI } from '../../../base/common/uri';
import { TextModelCancellationTokenSource } from '../../browser/core/editorState';
import { Range } from '../../common/core/range';
import { Selection } from '../../common/core/selection';
import * as modes from '../../common/modes';
import { IModelService } from '../../common/services/modelService';
import { CodeActionKind, filtersAction, mayIncludeActionsOfKind } from './types';
import { Progress } from '../../../platform/progress/common/progress';
import { CommandsRegistry } from '../../../platform/commands/common/commands';
export var codeActionCommandId = 'editor.action.codeAction';
export var refactorCommandId = 'editor.action.refactor';
export var sourceActionCommandId = 'editor.action.sourceAction';
export var organizeImportsCommandId = 'editor.action.organizeImports';
export var fixAllCommandId = 'editor.action.fixAll';
var CodeActionItem = /** @class */ (function () {
    function CodeActionItem(action, provider) {
        this.action = action;
        this.provider = provider;
    }
    CodeActionItem.prototype.resolve = function (token) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            var action, err_1;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!(((_a = this.provider) === null || _a === void 0 ? void 0 : _a.resolveCodeAction) && !this.action.edit)) return [3 /*break*/, 5];
                        action = void 0;
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, this.provider.resolveCodeAction(this.action, token)];
                    case 2:
                        action = _b.sent();
                        return [3 /*break*/, 4];
                    case 3:
                        err_1 = _b.sent();
                        onUnexpectedExternalError(err_1);
                        return [3 /*break*/, 4];
                    case 4:
                        if (action) {
                            this.action.edit = action.edit;
                        }
                        _b.label = 5;
                    case 5: return [2 /*return*/, this];
                }
            });
        });
    };
    return CodeActionItem;
}());
export { CodeActionItem };
var ManagedCodeActionSet = /** @class */ (function (_super) {
    __extends(ManagedCodeActionSet, _super);
    function ManagedCodeActionSet(actions, documentation, disposables) {
        var _this = _super.call(this) || this;
        _this.documentation = documentation;
        _this._register(disposables);
        _this.allActions = mergeSort(__spreadArray([], __read(actions)), ManagedCodeActionSet.codeActionsComparator);
        _this.validActions = _this.allActions.filter(function (_a) {
            var action = _a.action;
            return !action.disabled;
        });
        return _this;
    }
    ManagedCodeActionSet.codeActionsComparator = function (_a, _b) {
        var a = _a.action;
        var b = _b.action;
        if (a.isPreferred && !b.isPreferred) {
            return -1;
        }
        else if (!a.isPreferred && b.isPreferred) {
            return 1;
        }
        if (isNonEmptyArray(a.diagnostics)) {
            if (isNonEmptyArray(b.diagnostics)) {
                return a.diagnostics[0].message.localeCompare(b.diagnostics[0].message);
            }
            else {
                return -1;
            }
        }
        else if (isNonEmptyArray(b.diagnostics)) {
            return 1;
        }
        else {
            return 0; // both have no diagnostics
        }
    };
    Object.defineProperty(ManagedCodeActionSet.prototype, "hasAutoFix", {
        get: function () {
            return this.validActions.some(function (_a) {
                var fix = _a.action;
                return !!fix.kind && CodeActionKind.QuickFix.contains(new CodeActionKind(fix.kind)) && !!fix.isPreferred;
            });
        },
        enumerable: false,
        configurable: true
    });
    return ManagedCodeActionSet;
}(Disposable));
var emptyCodeActionsResponse = { actions: [], documentation: undefined };
export function getCodeActions(model, rangeOrSelection, trigger, progress, token) {
    var _this = this;
    var _a;
    var filter = trigger.filter || {};
    var codeActionContext = {
        only: (_a = filter.include) === null || _a === void 0 ? void 0 : _a.value,
        trigger: trigger.type,
    };
    var cts = new TextModelCancellationTokenSource(model, token);
    var providers = getCodeActionProviders(model, filter);
    var disposables = new DisposableStore();
    var promises = providers.map(function (provider) { return __awaiter(_this, void 0, void 0, function () {
        var providedCodeActions, filteredActions, documentation, err_2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 3]);
                    progress.report(provider);
                    return [4 /*yield*/, provider.provideCodeActions(model, rangeOrSelection, codeActionContext, cts.token)];
                case 1:
                    providedCodeActions = _a.sent();
                    if (providedCodeActions) {
                        disposables.add(providedCodeActions);
                    }
                    if (cts.token.isCancellationRequested) {
                        return [2 /*return*/, emptyCodeActionsResponse];
                    }
                    filteredActions = ((providedCodeActions === null || providedCodeActions === void 0 ? void 0 : providedCodeActions.actions) || []).filter(function (action) { return action && filtersAction(filter, action); });
                    documentation = getDocumentation(provider, filteredActions, filter.include);
                    return [2 /*return*/, {
                            actions: filteredActions.map(function (action) { return new CodeActionItem(action, provider); }),
                            documentation: documentation
                        }];
                case 2:
                    err_2 = _a.sent();
                    if (isPromiseCanceledError(err_2)) {
                        throw err_2;
                    }
                    onUnexpectedExternalError(err_2);
                    return [2 /*return*/, emptyCodeActionsResponse];
                case 3: return [2 /*return*/];
            }
        });
    }); });
    var listener = modes.CodeActionProviderRegistry.onDidChange(function () {
        var newProviders = modes.CodeActionProviderRegistry.all(model);
        if (!equals(newProviders, providers)) {
            cts.cancel();
        }
    });
    return Promise.all(promises).then(function (actions) {
        var allActions = flatten(actions.map(function (x) { return x.actions; }));
        var allDocumentation = coalesce(actions.map(function (x) { return x.documentation; }));
        return new ManagedCodeActionSet(allActions, allDocumentation, disposables);
    })
        .finally(function () {
        listener.dispose();
        cts.dispose();
    });
}
function getCodeActionProviders(model, filter) {
    return modes.CodeActionProviderRegistry.all(model)
        // Don't include providers that we know will not return code actions of interest
        .filter(function (provider) {
        if (!provider.providedCodeActionKinds) {
            // We don't know what type of actions this provider will return.
            return true;
        }
        return provider.providedCodeActionKinds.some(function (kind) { return mayIncludeActionsOfKind(filter, new CodeActionKind(kind)); });
    });
}
function getDocumentation(provider, providedCodeActions, only) {
    var e_1, _a, e_2, _b, e_3, _c;
    if (!provider.documentation) {
        return undefined;
    }
    var documentation = provider.documentation.map(function (entry) { return ({ kind: new CodeActionKind(entry.kind), command: entry.command }); });
    if (only) {
        var currentBest = void 0;
        try {
            for (var documentation_1 = __values(documentation), documentation_1_1 = documentation_1.next(); !documentation_1_1.done; documentation_1_1 = documentation_1.next()) {
                var entry = documentation_1_1.value;
                if (entry.kind.contains(only)) {
                    if (!currentBest) {
                        currentBest = entry;
                    }
                    else {
                        // Take best match
                        if (currentBest.kind.contains(entry.kind)) {
                            currentBest = entry;
                        }
                    }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (documentation_1_1 && !documentation_1_1.done && (_a = documentation_1.return)) _a.call(documentation_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (currentBest) {
            return currentBest === null || currentBest === void 0 ? void 0 : currentBest.command;
        }
    }
    try {
        // Otherwise, check to see if any of the provided actions match.
        for (var providedCodeActions_1 = __values(providedCodeActions), providedCodeActions_1_1 = providedCodeActions_1.next(); !providedCodeActions_1_1.done; providedCodeActions_1_1 = providedCodeActions_1.next()) {
            var action = providedCodeActions_1_1.value;
            if (!action.kind) {
                continue;
            }
            try {
                for (var documentation_2 = (e_3 = void 0, __values(documentation)), documentation_2_1 = documentation_2.next(); !documentation_2_1.done; documentation_2_1 = documentation_2.next()) {
                    var entry = documentation_2_1.value;
                    if (entry.kind.contains(new CodeActionKind(action.kind))) {
                        return entry.command;
                    }
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (documentation_2_1 && !documentation_2_1.done && (_c = documentation_2.return)) _c.call(documentation_2);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (providedCodeActions_1_1 && !providedCodeActions_1_1.done && (_b = providedCodeActions_1.return)) _b.call(providedCodeActions_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return undefined;
}
CommandsRegistry.registerCommand('_executeCodeActionProvider', function (accessor, resource, rangeOrSelection, kind, itemResolveCount) {
    return __awaiter(this, void 0, void 0, function () {
        var model, validatedRangeOrSelection, include, codeActionSet, resolving, resolveCount, i;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!(resource instanceof URI)) {
                        throw illegalArgument();
                    }
                    model = accessor.get(IModelService).getModel(resource);
                    if (!model) {
                        throw illegalArgument();
                    }
                    validatedRangeOrSelection = Selection.isISelection(rangeOrSelection)
                        ? Selection.liftSelection(rangeOrSelection)
                        : Range.isIRange(rangeOrSelection)
                            ? model.validateRange(rangeOrSelection)
                            : undefined;
                    if (!validatedRangeOrSelection) {
                        throw illegalArgument();
                    }
                    include = typeof kind === 'string' ? new CodeActionKind(kind) : undefined;
                    return [4 /*yield*/, getCodeActions(model, validatedRangeOrSelection, { type: 2 /* Manual */, filter: { includeSourceActions: true, include: include } }, Progress.None, CancellationToken.None)];
                case 1:
                    codeActionSet = _a.sent();
                    resolving = [];
                    resolveCount = Math.min(codeActionSet.validActions.length, typeof itemResolveCount === 'number' ? itemResolveCount : 0);
                    for (i = 0; i < resolveCount; i++) {
                        resolving.push(codeActionSet.validActions[i].resolve(CancellationToken.None));
                    }
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, , 4, 5]);
                    return [4 /*yield*/, Promise.all(resolving)];
                case 3:
                    _a.sent();
                    return [2 /*return*/, codeActionSet.validActions.map(function (item) { return item.action; })];
                case 4:
                    setTimeout(function () { return codeActionSet.dispose(); }, 100);
                    return [7 /*endfinally*/];
                case 5: return [2 /*return*/];
            }
        });
    });
});
