/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import * as dom from '../../../base/browser/dom';
import { CancellationToken } from '../../../base/common/cancellation';
import { LinkedList } from '../../../base/common/linkedList';
import { ResourceMap } from '../../../base/common/map';
import { parse } from '../../../base/common/marshalling';
import { Schemas } from '../../../base/common/network';
import { normalizePath } from '../../../base/common/resources';
import { URI } from '../../../base/common/uri';
import { ICodeEditorService } from './codeEditorService';
import { ICommandService } from '../../../platform/commands/common/commands';
import { EditorOpenContext } from '../../../platform/editor/common/editor';
import { matchesScheme } from '../../../platform/opener/common/opener';
var CommandOpener = /** @class */ (function () {
    function CommandOpener(_commandService) {
        this._commandService = _commandService;
    }
    CommandOpener.prototype.open = function (target) {
        return __awaiter(this, void 0, void 0, function () {
            var args;
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!matchesScheme(target, Schemas.command)) {
                            return [2 /*return*/, false];
                        }
                        // run command or bail out if command isn't known
                        if (typeof target === 'string') {
                            target = URI.parse(target);
                        }
                        args = [];
                        try {
                            args = parse(decodeURIComponent(target.query));
                        }
                        catch (_c) {
                            // ignore and retry
                            try {
                                args = parse(target.query);
                            }
                            catch (_d) {
                                // ignore error
                            }
                        }
                        if (!Array.isArray(args)) {
                            args = [args];
                        }
                        return [4 /*yield*/, (_a = this._commandService).executeCommand.apply(_a, __spreadArray([target.path], __read(args)))];
                    case 1:
                        _b.sent();
                        return [2 /*return*/, true];
                }
            });
        });
    };
    CommandOpener = __decorate([
        __param(0, ICommandService)
    ], CommandOpener);
    return CommandOpener;
}());
var EditorOpener = /** @class */ (function () {
    function EditorOpener(_editorService) {
        this._editorService = _editorService;
    }
    EditorOpener.prototype.open = function (target, options) {
        return __awaiter(this, void 0, void 0, function () {
            var selection, match;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (typeof target === 'string') {
                            target = URI.parse(target);
                        }
                        selection = undefined;
                        match = /^L?(\d+)(?:,(\d+))?/.exec(target.fragment);
                        if (match) {
                            // support file:///some/file.js#73,84
                            // support file:///some/file.js#L73
                            selection = {
                                startLineNumber: parseInt(match[1]),
                                startColumn: match[2] ? parseInt(match[2]) : 1
                            };
                            // remove fragment
                            target = target.with({ fragment: '' });
                        }
                        if (target.scheme === Schemas.file) {
                            target = normalizePath(target); // workaround for non-normalized paths (https://github.com/microsoft/vscode/issues/12954)
                        }
                        return [4 /*yield*/, this._editorService.openCodeEditor({
                                resource: target,
                                options: __assign({ selection: selection, context: (options === null || options === void 0 ? void 0 : options.fromUserGesture) ? EditorOpenContext.USER : EditorOpenContext.API }, options === null || options === void 0 ? void 0 : options.editorOptions)
                            }, this._editorService.getFocusedCodeEditor(), options === null || options === void 0 ? void 0 : options.openToSide)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, true];
                }
            });
        });
    };
    EditorOpener = __decorate([
        __param(0, ICodeEditorService)
    ], EditorOpener);
    return EditorOpener;
}());
var OpenerService = /** @class */ (function () {
    function OpenerService(editorService, commandService) {
        var _this = this;
        this._openers = new LinkedList();
        this._validators = new LinkedList();
        this._resolvers = new LinkedList();
        this._resolvedUriTargets = new ResourceMap(function (uri) { return uri.with({ path: null, fragment: null, query: null }).toString(); });
        this._externalOpeners = new LinkedList();
        // Default external opener is going through window.open()
        this._defaultExternalOpener = {
            openExternal: function (href) { return __awaiter(_this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    // ensure to open HTTP/HTTPS links into new windows
                    // to not trigger a navigation. Any other link is
                    // safe to be set as HREF to prevent a blank window
                    // from opening.
                    if (matchesScheme(href, Schemas.http) || matchesScheme(href, Schemas.https)) {
                        dom.windowOpenNoOpener(href);
                    }
                    else {
                        window.location.href = href;
                    }
                    return [2 /*return*/, true];
                });
            }); }
        };
        // Default opener: any external, maito, http(s), command, and catch-all-editors
        this._openers.push({
            open: function (target, options) { return __awaiter(_this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            if (!((options === null || options === void 0 ? void 0 : options.openExternal) || matchesScheme(target, Schemas.mailto) || matchesScheme(target, Schemas.http) || matchesScheme(target, Schemas.https))) return [3 /*break*/, 2];
                            // open externally
                            return [4 /*yield*/, this._doOpenExternal(target, options)];
                        case 1:
                            // open externally
                            _a.sent();
                            return [2 /*return*/, true];
                        case 2: return [2 /*return*/, false];
                    }
                });
            }); }
        });
        this._openers.push(new CommandOpener(commandService));
        this._openers.push(new EditorOpener(editorService));
    }
    OpenerService.prototype.registerOpener = function (opener) {
        var remove = this._openers.unshift(opener);
        return { dispose: remove };
    };
    OpenerService.prototype.registerValidator = function (validator) {
        var remove = this._validators.push(validator);
        return { dispose: remove };
    };
    OpenerService.prototype.registerExternalUriResolver = function (resolver) {
        var remove = this._resolvers.push(resolver);
        return { dispose: remove };
    };
    OpenerService.prototype.setDefaultExternalOpener = function (externalOpener) {
        this._defaultExternalOpener = externalOpener;
    };
    OpenerService.prototype.registerExternalOpener = function (opener) {
        var remove = this._externalOpeners.push(opener);
        return { dispose: remove };
    };
    OpenerService.prototype.open = function (target, options) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            var targetURI, validationTarget, _b, _c, validator, e_1_1, _d, _e, opener_1, handled, e_2_1;
            var e_1, _f, e_2, _g;
            return __generator(this, function (_h) {
                switch (_h.label) {
                    case 0:
                        targetURI = typeof target === 'string' ? URI.parse(target) : target;
                        validationTarget = (_a = this._resolvedUriTargets.get(targetURI)) !== null && _a !== void 0 ? _a : targetURI;
                        _h.label = 1;
                    case 1:
                        _h.trys.push([1, 6, 7, 8]);
                        _b = __values(this._validators), _c = _b.next();
                        _h.label = 2;
                    case 2:
                        if (!!_c.done) return [3 /*break*/, 5];
                        validator = _c.value;
                        return [4 /*yield*/, validator.shouldOpen(validationTarget)];
                    case 3:
                        if (!(_h.sent())) {
                            return [2 /*return*/, false];
                        }
                        _h.label = 4;
                    case 4:
                        _c = _b.next();
                        return [3 /*break*/, 2];
                    case 5: return [3 /*break*/, 8];
                    case 6:
                        e_1_1 = _h.sent();
                        e_1 = { error: e_1_1 };
                        return [3 /*break*/, 8];
                    case 7:
                        try {
                            if (_c && !_c.done && (_f = _b.return)) _f.call(_b);
                        }
                        finally { if (e_1) throw e_1.error; }
                        return [7 /*endfinally*/];
                    case 8:
                        _h.trys.push([8, 13, 14, 15]);
                        _d = __values(this._openers), _e = _d.next();
                        _h.label = 9;
                    case 9:
                        if (!!_e.done) return [3 /*break*/, 12];
                        opener_1 = _e.value;
                        return [4 /*yield*/, opener_1.open(target, options)];
                    case 10:
                        handled = _h.sent();
                        if (handled) {
                            return [2 /*return*/, true];
                        }
                        _h.label = 11;
                    case 11:
                        _e = _d.next();
                        return [3 /*break*/, 9];
                    case 12: return [3 /*break*/, 15];
                    case 13:
                        e_2_1 = _h.sent();
                        e_2 = { error: e_2_1 };
                        return [3 /*break*/, 15];
                    case 14:
                        try {
                            if (_e && !_e.done && (_g = _d.return)) _g.call(_d);
                        }
                        finally { if (e_2) throw e_2.error; }
                        return [7 /*endfinally*/];
                    case 15: return [2 /*return*/, false];
                }
            });
        });
    };
    OpenerService.prototype.resolveExternalUri = function (resource, options) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b, resolver, result, e_3_1;
            var e_3, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _d.trys.push([0, 5, 6, 7]);
                        _a = __values(this._resolvers), _b = _a.next();
                        _d.label = 1;
                    case 1:
                        if (!!_b.done) return [3 /*break*/, 4];
                        resolver = _b.value;
                        return [4 /*yield*/, resolver.resolveExternalUri(resource, options)];
                    case 2:
                        result = _d.sent();
                        if (result) {
                            if (!this._resolvedUriTargets.has(result.resolved)) {
                                this._resolvedUriTargets.set(result.resolved, resource);
                            }
                            return [2 /*return*/, result];
                        }
                        _d.label = 3;
                    case 3:
                        _b = _a.next();
                        return [3 /*break*/, 1];
                    case 4: return [3 /*break*/, 7];
                    case 5:
                        e_3_1 = _d.sent();
                        e_3 = { error: e_3_1 };
                        return [3 /*break*/, 7];
                    case 6:
                        try {
                            if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                        }
                        finally { if (e_3) throw e_3.error; }
                        return [7 /*endfinally*/];
                    case 7: return [2 /*return*/, { resolved: resource, dispose: function () { } }];
                }
            });
        });
    };
    OpenerService.prototype._doOpenExternal = function (resource, options) {
        return __awaiter(this, void 0, void 0, function () {
            var uri, resolved, href, preferredOpenerId, _a, _b, opener_2, didOpen, e_4_1;
            var e_4, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        uri = typeof resource === 'string' ? URI.parse(resource) : resource;
                        return [4 /*yield*/, this.resolveExternalUri(uri, options)];
                    case 1:
                        resolved = (_d.sent()).resolved;
                        if (typeof resource === 'string' && uri.toString() === resolved.toString()) {
                            // open the url-string AS IS
                            href = resource;
                        }
                        else {
                            // open URI using the toString(noEncode)+encodeURI-trick
                            href = encodeURI(resolved.toString(true));
                        }
                        if (!(options === null || options === void 0 ? void 0 : options.allowContributedOpeners)) return [3 /*break*/, 9];
                        preferredOpenerId = typeof (options === null || options === void 0 ? void 0 : options.allowContributedOpeners) === 'string' ? options === null || options === void 0 ? void 0 : options.allowContributedOpeners : undefined;
                        _d.label = 2;
                    case 2:
                        _d.trys.push([2, 7, 8, 9]);
                        _a = __values(this._externalOpeners), _b = _a.next();
                        _d.label = 3;
                    case 3:
                        if (!!_b.done) return [3 /*break*/, 6];
                        opener_2 = _b.value;
                        return [4 /*yield*/, opener_2.openExternal(href, {
                                sourceUri: uri,
                                preferredOpenerId: preferredOpenerId,
                            }, CancellationToken.None)];
                    case 4:
                        didOpen = _d.sent();
                        if (didOpen) {
                            return [2 /*return*/, true];
                        }
                        _d.label = 5;
                    case 5:
                        _b = _a.next();
                        return [3 /*break*/, 3];
                    case 6: return [3 /*break*/, 9];
                    case 7:
                        e_4_1 = _d.sent();
                        e_4 = { error: e_4_1 };
                        return [3 /*break*/, 9];
                    case 8:
                        try {
                            if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                        }
                        finally { if (e_4) throw e_4.error; }
                        return [7 /*endfinally*/];
                    case 9: return [2 /*return*/, this._defaultExternalOpener.openExternal(href, { sourceUri: uri }, CancellationToken.None)];
                }
            });
        });
    };
    OpenerService.prototype.dispose = function () {
        this._validators.clear();
    };
    OpenerService = __decorate([
        __param(0, ICodeEditorService),
        __param(1, ICommandService)
    ], OpenerService);
    return OpenerService;
}());
export { OpenerService };
