/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import './media/quickInput.css';
import { NO_KEY_MODS, ItemActivation } from '../common/quickInput';
import * as dom from '../../../browser/dom';
import { CancellationToken } from '../../../common/cancellation';
import { QuickInputList, QuickInputListFocus } from './quickInputList';
import { QuickInputBox } from './quickInputBox';
import { StandardKeyboardEvent } from '../../../browser/keyboardEvent';
import { localize } from '../../../../nls';
import { CountBadge } from '../../../browser/ui/countBadge/countBadge';
import { ProgressBar } from '../../../browser/ui/progressbar/progressbar';
import { Emitter, Event } from '../../../common/event';
import { Button } from '../../../browser/ui/button/button';
import { dispose, Disposable, DisposableStore } from '../../../common/lifecycle';
import Severity from '../../../common/severity';
import { ActionBar } from '../../../browser/ui/actionbar/actionbar';
import { Action } from '../../../common/actions';
import { equals } from '../../../common/arrays';
import { TimeoutTimer } from '../../../common/async';
import { getIconClass } from './quickInputUtils';
import { registerCodicon, Codicon } from '../../../common/codicons';
import { escape } from '../../../common/strings';
import { renderLabelWithIcons } from '../../../browser/ui/iconLabel/iconLabels';
var $ = dom.$;
var backButtonIcon = registerCodicon('quick-input-back', Codicon.arrowLeft);
var backButton = {
    iconClass: backButtonIcon.classNames,
    tooltip: localize('quickInput.back', "Back"),
    handle: -1 // TODO
};
var QuickInput = /** @class */ (function (_super) {
    __extends(QuickInput, _super);
    function QuickInput(ui) {
        var _this = _super.call(this) || this;
        _this.ui = ui;
        _this.visible = false;
        _this._enabled = true;
        _this._busy = false;
        _this._ignoreFocusOut = false;
        _this._buttons = [];
        _this.buttonsUpdated = false;
        _this.onDidTriggerButtonEmitter = _this._register(new Emitter());
        _this.onDidHideEmitter = _this._register(new Emitter());
        _this.onDisposeEmitter = _this._register(new Emitter());
        _this.visibleDisposables = _this._register(new DisposableStore());
        _this.onDidTriggerButton = _this.onDidTriggerButtonEmitter.event;
        _this.onDidHide = _this.onDidHideEmitter.event;
        _this.onDispose = _this.onDisposeEmitter.event;
        return _this;
    }
    Object.defineProperty(QuickInput.prototype, "title", {
        get: function () {
            return this._title;
        },
        set: function (title) {
            this._title = title;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInput.prototype, "description", {
        get: function () {
            return this._description;
        },
        set: function (description) {
            this._description = description;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInput.prototype, "step", {
        get: function () {
            return this._steps;
        },
        set: function (step) {
            this._steps = step;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInput.prototype, "totalSteps", {
        get: function () {
            return this._totalSteps;
        },
        set: function (totalSteps) {
            this._totalSteps = totalSteps;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInput.prototype, "enabled", {
        get: function () {
            return this._enabled;
        },
        set: function (enabled) {
            this._enabled = enabled;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInput.prototype, "contextKey", {
        get: function () {
            return this._contextKey;
        },
        set: function (contextKey) {
            this._contextKey = contextKey;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInput.prototype, "busy", {
        get: function () {
            return this._busy;
        },
        set: function (busy) {
            this._busy = busy;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInput.prototype, "ignoreFocusOut", {
        get: function () {
            return this._ignoreFocusOut;
        },
        set: function (ignoreFocusOut) {
            this._ignoreFocusOut = ignoreFocusOut;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInput.prototype, "buttons", {
        get: function () {
            return this._buttons;
        },
        set: function (buttons) {
            this._buttons = buttons;
            this.buttonsUpdated = true;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    QuickInput.prototype.show = function () {
        var _this = this;
        if (this.visible) {
            return;
        }
        this.visibleDisposables.add(this.ui.onDidTriggerButton(function (button) {
            if (_this.buttons.indexOf(button) !== -1) {
                _this.onDidTriggerButtonEmitter.fire(button);
            }
        }));
        this.ui.show(this);
        this.visible = true;
        this.update();
    };
    QuickInput.prototype.hide = function () {
        if (!this.visible) {
            return;
        }
        this.ui.hide();
    };
    QuickInput.prototype.didHide = function () {
        this.visible = false;
        this.visibleDisposables.clear();
        this.onDidHideEmitter.fire();
    };
    QuickInput.prototype.update = function () {
        var _this = this;
        if (!this.visible) {
            return;
        }
        var title = this.getTitle();
        if (title && this.ui.title.textContent !== title) {
            this.ui.title.textContent = title;
        }
        else if (!title && this.ui.title.innerHTML !== '&nbsp;') {
            this.ui.title.innerText = '\u00a0;';
        }
        var description = this.getDescription();
        if (this.ui.description1.textContent !== description) {
            this.ui.description1.textContent = description;
        }
        if (this.ui.description2.textContent !== description) {
            this.ui.description2.textContent = description;
        }
        if (this.busy && !this.busyDelay) {
            this.busyDelay = new TimeoutTimer();
            this.busyDelay.setIfNotSet(function () {
                if (_this.visible) {
                    _this.ui.progressBar.infinite();
                }
            }, 800);
        }
        if (!this.busy && this.busyDelay) {
            this.ui.progressBar.stop();
            this.busyDelay.cancel();
            this.busyDelay = undefined;
        }
        if (this.buttonsUpdated) {
            this.buttonsUpdated = false;
            this.ui.leftActionBar.clear();
            var leftButtons = this.buttons.filter(function (button) { return button === backButton; });
            this.ui.leftActionBar.push(leftButtons.map(function (button, index) {
                var action = new Action("id-" + index, '', button.iconClass || getIconClass(button.iconPath), true, function () { return __awaiter(_this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        this.onDidTriggerButtonEmitter.fire(button);
                        return [2 /*return*/];
                    });
                }); });
                action.tooltip = button.tooltip || '';
                return action;
            }), { icon: true, label: false });
            this.ui.rightActionBar.clear();
            var rightButtons = this.buttons.filter(function (button) { return button !== backButton; });
            this.ui.rightActionBar.push(rightButtons.map(function (button, index) {
                var action = new Action("id-" + index, '', button.iconClass || getIconClass(button.iconPath), true, function () { return __awaiter(_this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        this.onDidTriggerButtonEmitter.fire(button);
                        return [2 /*return*/];
                    });
                }); });
                action.tooltip = button.tooltip || '';
                return action;
            }), { icon: true, label: false });
        }
        this.ui.ignoreFocusOut = this.ignoreFocusOut;
        this.ui.setEnabled(this.enabled);
        this.ui.setContextKey(this.contextKey);
    };
    QuickInput.prototype.getTitle = function () {
        if (this.title && this.step) {
            return this.title + " (" + this.getSteps() + ")";
        }
        if (this.title) {
            return this.title;
        }
        if (this.step) {
            return this.getSteps();
        }
        return '';
    };
    QuickInput.prototype.getDescription = function () {
        return this.description || '';
    };
    QuickInput.prototype.getSteps = function () {
        if (this.step && this.totalSteps) {
            return localize('quickInput.steps', "{0}/{1}", this.step, this.totalSteps);
        }
        if (this.step) {
            return String(this.step);
        }
        return '';
    };
    QuickInput.prototype.showMessageDecoration = function (severity) {
        this.ui.inputBox.showDecoration(severity);
        if (severity === Severity.Error) {
            var styles = this.ui.inputBox.stylesForType(severity);
            this.ui.message.style.color = styles.foreground ? "" + styles.foreground : '';
            this.ui.message.style.backgroundColor = styles.background ? "" + styles.background : '';
            this.ui.message.style.border = styles.border ? "1px solid " + styles.border : '';
            this.ui.message.style.paddingBottom = '4px';
        }
        else {
            this.ui.message.style.color = '';
            this.ui.message.style.backgroundColor = '';
            this.ui.message.style.border = '';
            this.ui.message.style.paddingBottom = '';
        }
    };
    QuickInput.prototype.dispose = function () {
        this.hide();
        this.onDisposeEmitter.fire();
        _super.prototype.dispose.call(this);
    };
    return QuickInput;
}(Disposable));
var QuickPick = /** @class */ (function (_super) {
    __extends(QuickPick, _super);
    function QuickPick() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._value = '';
        _this.onDidChangeValueEmitter = _this._register(new Emitter());
        _this.onDidAcceptEmitter = _this._register(new Emitter());
        _this.onDidCustomEmitter = _this._register(new Emitter());
        _this._items = [];
        _this.itemsUpdated = false;
        _this._canSelectMany = false;
        _this._canAcceptInBackground = false;
        _this._matchOnDescription = false;
        _this._matchOnDetail = false;
        _this._matchOnLabel = true;
        _this._sortByLabel = true;
        _this._autoFocusOnList = true;
        _this._itemActivation = _this.ui.isScreenReaderOptimized() ? ItemActivation.NONE /* https://github.com/microsoft/vscode/issues/57501 */ : ItemActivation.FIRST;
        _this._activeItems = [];
        _this.activeItemsUpdated = false;
        _this.activeItemsToConfirm = [];
        _this.onDidChangeActiveEmitter = _this._register(new Emitter());
        _this._selectedItems = [];
        _this.selectedItemsUpdated = false;
        _this.selectedItemsToConfirm = [];
        _this.onDidChangeSelectionEmitter = _this._register(new Emitter());
        _this.onDidTriggerItemButtonEmitter = _this._register(new Emitter());
        _this.valueSelectionUpdated = true;
        _this._ok = 'default';
        _this._customButton = false;
        _this.filterValue = function (value) { return value; };
        _this.onDidChangeValue = _this.onDidChangeValueEmitter.event;
        _this.onDidAccept = _this.onDidAcceptEmitter.event;
        _this.onDidCustom = _this.onDidCustomEmitter.event;
        _this.onDidChangeActive = _this.onDidChangeActiveEmitter.event;
        _this.onDidChangeSelection = _this.onDidChangeSelectionEmitter.event;
        _this.onDidTriggerItemButton = _this.onDidTriggerItemButtonEmitter.event;
        return _this;
    }
    Object.defineProperty(QuickPick.prototype, "quickNavigate", {
        get: function () {
            return this._quickNavigate;
        },
        set: function (quickNavigate) {
            this._quickNavigate = quickNavigate;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "value", {
        get: function () {
            return this._value;
        },
        set: function (value) {
            this._value = value || '';
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "ariaLabel", {
        get: function () {
            return this._ariaLabel;
        },
        set: function (ariaLabel) {
            this._ariaLabel = ariaLabel;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "placeholder", {
        get: function () {
            return this._placeholder;
        },
        set: function (placeholder) {
            this._placeholder = placeholder;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "items", {
        get: function () {
            return this._items;
        },
        set: function (items) {
            this._items = items;
            this.itemsUpdated = true;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "canSelectMany", {
        get: function () {
            return this._canSelectMany;
        },
        set: function (canSelectMany) {
            this._canSelectMany = canSelectMany;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "canAcceptInBackground", {
        get: function () {
            return this._canAcceptInBackground;
        },
        set: function (canAcceptInBackground) {
            this._canAcceptInBackground = canAcceptInBackground;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "matchOnDescription", {
        get: function () {
            return this._matchOnDescription;
        },
        set: function (matchOnDescription) {
            this._matchOnDescription = matchOnDescription;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "matchOnDetail", {
        get: function () {
            return this._matchOnDetail;
        },
        set: function (matchOnDetail) {
            this._matchOnDetail = matchOnDetail;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "matchOnLabel", {
        get: function () {
            return this._matchOnLabel;
        },
        set: function (matchOnLabel) {
            this._matchOnLabel = matchOnLabel;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "sortByLabel", {
        get: function () {
            return this._sortByLabel;
        },
        set: function (sortByLabel) {
            this._sortByLabel = sortByLabel;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "autoFocusOnList", {
        get: function () {
            return this._autoFocusOnList;
        },
        set: function (autoFocusOnList) {
            this._autoFocusOnList = autoFocusOnList;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "itemActivation", {
        get: function () {
            return this._itemActivation;
        },
        set: function (itemActivation) {
            this._itemActivation = itemActivation;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "activeItems", {
        get: function () {
            return this._activeItems;
        },
        set: function (activeItems) {
            this._activeItems = activeItems;
            this.activeItemsUpdated = true;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "selectedItems", {
        get: function () {
            return this._selectedItems;
        },
        set: function (selectedItems) {
            this._selectedItems = selectedItems;
            this.selectedItemsUpdated = true;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "keyMods", {
        get: function () {
            if (this._quickNavigate) {
                // Disable keyMods when quick navigate is enabled
                // because in this model the interaction is purely
                // keyboard driven and Ctrl/Alt are typically
                // pressed and hold during this interaction.
                return NO_KEY_MODS;
            }
            return this.ui.keyMods;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "valueSelection", {
        set: function (valueSelection) {
            this._valueSelection = valueSelection;
            this.valueSelectionUpdated = true;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "validationMessage", {
        get: function () {
            return this._validationMessage;
        },
        set: function (validationMessage) {
            this._validationMessage = validationMessage;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "customButton", {
        get: function () {
            return this._customButton;
        },
        set: function (showCustomButton) {
            this._customButton = showCustomButton;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "customLabel", {
        get: function () {
            return this._customButtonLabel;
        },
        set: function (label) {
            this._customButtonLabel = label;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "customHover", {
        get: function () {
            return this._customButtonHover;
        },
        set: function (hover) {
            this._customButtonHover = hover;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "ok", {
        get: function () {
            return this._ok;
        },
        set: function (showOkButton) {
            this._ok = showOkButton;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    QuickPick.prototype.inputHasFocus = function () {
        return this.visible ? this.ui.inputBox.hasFocus() : false;
    };
    QuickPick.prototype.focusOnInput = function () {
        this.ui.inputBox.setFocus();
    };
    Object.defineProperty(QuickPick.prototype, "hideInput", {
        get: function () {
            return !!this._hideInput;
        },
        set: function (hideInput) {
            this._hideInput = hideInput;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickPick.prototype, "hideCheckAll", {
        get: function () {
            return !!this._hideCheckAll;
        },
        set: function (hideCheckAll) {
            this._hideCheckAll = hideCheckAll;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    QuickPick.prototype.trySelectFirst = function () {
        if (this.autoFocusOnList) {
            if (!this.canSelectMany) {
                this.ui.list.focus(QuickInputListFocus.First);
            }
        }
    };
    QuickPick.prototype.show = function () {
        var _this = this;
        if (!this.visible) {
            this.visibleDisposables.add(this.ui.inputBox.onDidChange(function (value) {
                if (value === _this.value) {
                    return;
                }
                _this._value = value;
                var didFilter = _this.ui.list.filter(_this.filterValue(_this.ui.inputBox.value));
                if (didFilter) {
                    _this.trySelectFirst();
                }
                _this.onDidChangeValueEmitter.fire(value);
            }));
            this.visibleDisposables.add(this.ui.inputBox.onMouseDown(function (event) {
                if (!_this.autoFocusOnList) {
                    _this.ui.list.clearFocus();
                }
            }));
            this.visibleDisposables.add((this._hideInput ? this.ui.list : this.ui.inputBox).onKeyDown(function (event) {
                switch (event.keyCode) {
                    case 18 /* DownArrow */:
                        _this.ui.list.focus(QuickInputListFocus.Next);
                        if (_this.canSelectMany) {
                            _this.ui.list.domFocus();
                        }
                        dom.EventHelper.stop(event, true);
                        break;
                    case 16 /* UpArrow */:
                        if (_this.ui.list.getFocusedElements().length) {
                            _this.ui.list.focus(QuickInputListFocus.Previous);
                        }
                        else {
                            _this.ui.list.focus(QuickInputListFocus.Last);
                        }
                        if (_this.canSelectMany) {
                            _this.ui.list.domFocus();
                        }
                        dom.EventHelper.stop(event, true);
                        break;
                    case 12 /* PageDown */:
                        _this.ui.list.focus(QuickInputListFocus.NextPage);
                        if (_this.canSelectMany) {
                            _this.ui.list.domFocus();
                        }
                        dom.EventHelper.stop(event, true);
                        break;
                    case 11 /* PageUp */:
                        _this.ui.list.focus(QuickInputListFocus.PreviousPage);
                        if (_this.canSelectMany) {
                            _this.ui.list.domFocus();
                        }
                        dom.EventHelper.stop(event, true);
                        break;
                    case 17 /* RightArrow */:
                        if (!_this._canAcceptInBackground) {
                            return; // needs to be enabled
                        }
                        if (!_this.ui.inputBox.isSelectionAtEnd()) {
                            return; // ensure input box selection at end
                        }
                        if (_this.activeItems[0]) {
                            _this._selectedItems = [_this.activeItems[0]];
                            _this.onDidChangeSelectionEmitter.fire(_this.selectedItems);
                            _this.onDidAcceptEmitter.fire({ inBackground: true });
                        }
                        break;
                    case 14 /* Home */:
                        if ((event.ctrlKey || event.metaKey) && !event.shiftKey && !event.altKey) {
                            _this.ui.list.focus(QuickInputListFocus.First);
                            dom.EventHelper.stop(event, true);
                        }
                        break;
                    case 13 /* End */:
                        if ((event.ctrlKey || event.metaKey) && !event.shiftKey && !event.altKey) {
                            _this.ui.list.focus(QuickInputListFocus.Last);
                            dom.EventHelper.stop(event, true);
                        }
                        break;
                }
            }));
            this.visibleDisposables.add(this.ui.onDidAccept(function () {
                if (!_this.canSelectMany && _this.activeItems[0]) {
                    _this._selectedItems = [_this.activeItems[0]];
                    _this.onDidChangeSelectionEmitter.fire(_this.selectedItems);
                }
                _this.onDidAcceptEmitter.fire({ inBackground: false });
            }));
            this.visibleDisposables.add(this.ui.onDidCustom(function () {
                _this.onDidCustomEmitter.fire();
            }));
            this.visibleDisposables.add(this.ui.list.onDidChangeFocus(function (focusedItems) {
                if (_this.activeItemsUpdated) {
                    return; // Expect another event.
                }
                if (_this.activeItemsToConfirm !== _this._activeItems && equals(focusedItems, _this._activeItems, function (a, b) { return a === b; })) {
                    return;
                }
                _this._activeItems = focusedItems;
                _this.onDidChangeActiveEmitter.fire(focusedItems);
            }));
            this.visibleDisposables.add(this.ui.list.onDidChangeSelection(function (_a) {
                var selectedItems = _a.items, event = _a.event;
                if (_this.canSelectMany) {
                    if (selectedItems.length) {
                        _this.ui.list.setSelectedElements([]);
                    }
                    return;
                }
                if (_this.selectedItemsToConfirm !== _this._selectedItems && equals(selectedItems, _this._selectedItems, function (a, b) { return a === b; })) {
                    return;
                }
                _this._selectedItems = selectedItems;
                _this.onDidChangeSelectionEmitter.fire(selectedItems);
                if (selectedItems.length) {
                    _this.onDidAcceptEmitter.fire({ inBackground: event instanceof MouseEvent && event.button === 1 /* mouse middle click */ });
                }
            }));
            this.visibleDisposables.add(this.ui.list.onChangedCheckedElements(function (checkedItems) {
                if (!_this.canSelectMany) {
                    return;
                }
                if (_this.selectedItemsToConfirm !== _this._selectedItems && equals(checkedItems, _this._selectedItems, function (a, b) { return a === b; })) {
                    return;
                }
                _this._selectedItems = checkedItems;
                _this.onDidChangeSelectionEmitter.fire(checkedItems);
            }));
            this.visibleDisposables.add(this.ui.list.onButtonTriggered(function (event) { return _this.onDidTriggerItemButtonEmitter.fire(event); }));
            this.visibleDisposables.add(this.registerQuickNavigation());
            this.valueSelectionUpdated = true;
        }
        _super.prototype.show.call(this); // TODO: Why have show() bubble up while update() trickles down? (Could move setComboboxAccessibility() here.)
    };
    QuickPick.prototype.registerQuickNavigation = function () {
        var _this = this;
        return dom.addDisposableListener(this.ui.container, dom.EventType.KEY_UP, function (e) {
            if (_this.canSelectMany || !_this._quickNavigate) {
                return;
            }
            var keyboardEvent = new StandardKeyboardEvent(e);
            var keyCode = keyboardEvent.keyCode;
            // Select element when keys are pressed that signal it
            var quickNavKeys = _this._quickNavigate.keybindings;
            var wasTriggerKeyPressed = quickNavKeys.some(function (k) {
                var _a = __read(k.getParts(), 2), firstPart = _a[0], chordPart = _a[1];
                if (chordPart) {
                    return false;
                }
                if (firstPart.shiftKey && keyCode === 4 /* Shift */) {
                    if (keyboardEvent.ctrlKey || keyboardEvent.altKey || keyboardEvent.metaKey) {
                        return false; // this is an optimistic check for the shift key being used to navigate back in quick input
                    }
                    return true;
                }
                if (firstPart.altKey && keyCode === 6 /* Alt */) {
                    return true;
                }
                if (firstPart.ctrlKey && keyCode === 5 /* Ctrl */) {
                    return true;
                }
                if (firstPart.metaKey && keyCode === 57 /* Meta */) {
                    return true;
                }
                return false;
            });
            if (wasTriggerKeyPressed) {
                if (_this.activeItems[0]) {
                    _this._selectedItems = [_this.activeItems[0]];
                    _this.onDidChangeSelectionEmitter.fire(_this.selectedItems);
                    _this.onDidAcceptEmitter.fire({ inBackground: false });
                }
                // Unset quick navigate after press. It is only valid once
                // and should not result in any behaviour change afterwards
                // if the picker remains open because there was no active item
                _this._quickNavigate = undefined;
            }
        });
    };
    QuickPick.prototype.update = function () {
        if (!this.visible) {
            return;
        }
        var hideInput = false;
        var inputShownJustForScreenReader = false;
        if (!!this._hideInput && this._items.length > 0) {
            if (this.ui.isScreenReaderOptimized()) {
                // Always show input if screen reader attached https://github.com/microsoft/vscode/issues/94360
                inputShownJustForScreenReader = true;
            }
            else {
                hideInput = true;
            }
        }
        this.ui.container.classList.toggle('hidden-input', hideInput && !this.description);
        var visibilities = {
            title: !!this.title || !!this.step || !!this.buttons.length,
            description: !!this.description,
            checkAll: this.canSelectMany && !this._hideCheckAll,
            checkBox: this.canSelectMany,
            inputBox: !hideInput,
            progressBar: !hideInput,
            visibleCount: true,
            count: this.canSelectMany,
            ok: this.ok === 'default' ? this.canSelectMany : this.ok,
            list: true,
            message: !!this.validationMessage,
            customButton: this.customButton
        };
        this.ui.setVisibilities(visibilities);
        _super.prototype.update.call(this);
        if (this.ui.inputBox.value !== this.value) {
            this.ui.inputBox.value = this.value;
        }
        if (this.valueSelectionUpdated) {
            this.valueSelectionUpdated = false;
            this.ui.inputBox.select(this._valueSelection && { start: this._valueSelection[0], end: this._valueSelection[1] });
        }
        if (this.ui.inputBox.placeholder !== (this.placeholder || '')) {
            this.ui.inputBox.placeholder = (this.placeholder || '');
        }
        if (inputShownJustForScreenReader) {
            this.ui.inputBox.ariaLabel = '';
        }
        else {
            var ariaLabel = this.ariaLabel || this.placeholder || QuickPick.DEFAULT_ARIA_LABEL;
            if (this.ui.inputBox.ariaLabel !== ariaLabel) {
                this.ui.inputBox.ariaLabel = ariaLabel;
            }
        }
        this.ui.list.matchOnDescription = this.matchOnDescription;
        this.ui.list.matchOnDetail = this.matchOnDetail;
        this.ui.list.matchOnLabel = this.matchOnLabel;
        this.ui.list.sortByLabel = this.sortByLabel;
        if (this.itemsUpdated) {
            this.itemsUpdated = false;
            this.ui.list.setElements(this.items);
            this.ui.list.filter(this.filterValue(this.ui.inputBox.value));
            this.ui.checkAll.checked = this.ui.list.getAllVisibleChecked();
            this.ui.visibleCount.setCount(this.ui.list.getVisibleCount());
            this.ui.count.setCount(this.ui.list.getCheckedCount());
            switch (this._itemActivation) {
                case ItemActivation.NONE:
                    this._itemActivation = ItemActivation.FIRST; // only valid once, then unset
                    break;
                case ItemActivation.SECOND:
                    this.ui.list.focus(QuickInputListFocus.Second);
                    this._itemActivation = ItemActivation.FIRST; // only valid once, then unset
                    break;
                case ItemActivation.LAST:
                    this.ui.list.focus(QuickInputListFocus.Last);
                    this._itemActivation = ItemActivation.FIRST; // only valid once, then unset
                    break;
                default:
                    this.trySelectFirst();
                    break;
            }
        }
        if (this.ui.container.classList.contains('show-checkboxes') !== !!this.canSelectMany) {
            if (this.canSelectMany) {
                this.ui.list.clearFocus();
            }
            else {
                this.trySelectFirst();
            }
        }
        if (this.activeItemsUpdated) {
            this.activeItemsUpdated = false;
            this.activeItemsToConfirm = this._activeItems;
            this.ui.list.setFocusedElements(this.activeItems);
            if (this.activeItemsToConfirm === this._activeItems) {
                this.activeItemsToConfirm = null;
            }
        }
        if (this.selectedItemsUpdated) {
            this.selectedItemsUpdated = false;
            this.selectedItemsToConfirm = this._selectedItems;
            if (this.canSelectMany) {
                this.ui.list.setCheckedElements(this.selectedItems);
            }
            else {
                this.ui.list.setSelectedElements(this.selectedItems);
            }
            if (this.selectedItemsToConfirm === this._selectedItems) {
                this.selectedItemsToConfirm = null;
            }
        }
        var validationMessage = this.validationMessage || '';
        if (this._lastValidationMessage !== validationMessage) {
            this._lastValidationMessage = validationMessage;
            dom.reset.apply(dom, __spreadArray([this.ui.message], __read(renderLabelWithIcons(escape(validationMessage)))));
            this.showMessageDecoration(this.validationMessage ? Severity.Error : Severity.Ignore);
        }
        this.ui.customButton.label = this.customLabel || '';
        this.ui.customButton.element.title = this.customHover || '';
        this.ui.setComboboxAccessibility(true);
        if (!visibilities.inputBox) {
            // we need to move focus into the tree to detect keybindings
            // properly when the input box is not visible (quick nav)
            this.ui.list.domFocus();
            // Focus the first element in the list if multiselect is enabled
            if (this.canSelectMany) {
                this.ui.list.focus(QuickInputListFocus.First);
            }
        }
    };
    QuickPick.DEFAULT_ARIA_LABEL = localize('quickInputBox.ariaLabel', "Type to narrow down results.");
    return QuickPick;
}(QuickInput));
var InputBox = /** @class */ (function (_super) {
    __extends(InputBox, _super);
    function InputBox() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._value = '';
        _this.valueSelectionUpdated = true;
        _this._password = false;
        _this.noValidationMessage = InputBox.noPromptMessage;
        _this.onDidValueChangeEmitter = _this._register(new Emitter());
        _this.onDidAcceptEmitter = _this._register(new Emitter());
        _this.onDidChangeValue = _this.onDidValueChangeEmitter.event;
        _this.onDidAccept = _this.onDidAcceptEmitter.event;
        return _this;
    }
    Object.defineProperty(InputBox.prototype, "value", {
        get: function () {
            return this._value;
        },
        set: function (value) {
            this._value = value || '';
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(InputBox.prototype, "valueSelection", {
        set: function (valueSelection) {
            this._valueSelection = valueSelection;
            this.valueSelectionUpdated = true;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(InputBox.prototype, "placeholder", {
        get: function () {
            return this._placeholder;
        },
        set: function (placeholder) {
            this._placeholder = placeholder;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(InputBox.prototype, "password", {
        get: function () {
            return this._password;
        },
        set: function (password) {
            this._password = password;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(InputBox.prototype, "prompt", {
        get: function () {
            return this._prompt;
        },
        set: function (prompt) {
            this._prompt = prompt;
            this.noValidationMessage = prompt
                ? localize('inputModeEntryDescription', "{0} (Press 'Enter' to confirm or 'Escape' to cancel)", prompt)
                : InputBox.noPromptMessage;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(InputBox.prototype, "validationMessage", {
        get: function () {
            return this._validationMessage;
        },
        set: function (validationMessage) {
            this._validationMessage = validationMessage;
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    InputBox.prototype.show = function () {
        var _this = this;
        if (!this.visible) {
            this.visibleDisposables.add(this.ui.inputBox.onDidChange(function (value) {
                if (value === _this.value) {
                    return;
                }
                _this._value = value;
                _this.onDidValueChangeEmitter.fire(value);
            }));
            this.visibleDisposables.add(this.ui.onDidAccept(function () { return _this.onDidAcceptEmitter.fire(); }));
            this.valueSelectionUpdated = true;
        }
        _super.prototype.show.call(this);
    };
    InputBox.prototype.update = function () {
        if (!this.visible) {
            return;
        }
        var visibilities = {
            title: !!this.title || !!this.step || !!this.buttons.length,
            description: !!this.description || !!this.step,
            inputBox: true, message: true
        };
        this.ui.setVisibilities(visibilities);
        _super.prototype.update.call(this);
        if (this.ui.inputBox.value !== this.value) {
            this.ui.inputBox.value = this.value;
        }
        if (this.valueSelectionUpdated) {
            this.valueSelectionUpdated = false;
            this.ui.inputBox.select(this._valueSelection && { start: this._valueSelection[0], end: this._valueSelection[1] });
        }
        if (this.ui.inputBox.placeholder !== (this.placeholder || '')) {
            this.ui.inputBox.placeholder = (this.placeholder || '');
        }
        if (this.ui.inputBox.password !== this.password) {
            this.ui.inputBox.password = this.password;
        }
        var validationMessage = this.validationMessage || this.noValidationMessage;
        if (this._lastValidationMessage !== validationMessage) {
            this._lastValidationMessage = validationMessage;
            dom.reset.apply(dom, __spreadArray([this.ui.message], __read(renderLabelWithIcons(validationMessage))));
            this.showMessageDecoration(this.validationMessage ? Severity.Error : Severity.Ignore);
        }
    };
    InputBox.noPromptMessage = localize('inputModeEntry', "Press 'Enter' to confirm your input or 'Escape' to cancel");
    return InputBox;
}(QuickInput));
var QuickInputController = /** @class */ (function (_super) {
    __extends(QuickInputController, _super);
    function QuickInputController(options) {
        var _this = _super.call(this) || this;
        _this.options = options;
        _this.comboboxAccessibility = false;
        _this.enabled = true;
        _this.onDidAcceptEmitter = _this._register(new Emitter());
        _this.onDidCustomEmitter = _this._register(new Emitter());
        _this.onDidTriggerButtonEmitter = _this._register(new Emitter());
        _this.keyMods = { ctrlCmd: false, alt: false };
        _this.controller = null;
        _this.onShowEmitter = _this._register(new Emitter());
        _this.onShow = _this.onShowEmitter.event;
        _this.onHideEmitter = _this._register(new Emitter());
        _this.onHide = _this.onHideEmitter.event;
        _this.backButton = backButton;
        _this.idPrefix = options.idPrefix;
        _this.parentElement = options.container;
        _this.styles = options.styles;
        _this.registerKeyModsListeners();
        return _this;
    }
    QuickInputController.prototype.registerKeyModsListeners = function () {
        var _this = this;
        var listener = function (e) {
            _this.keyMods.ctrlCmd = e.ctrlKey || e.metaKey;
            _this.keyMods.alt = e.altKey;
        };
        this._register(dom.addDisposableListener(window, dom.EventType.KEY_DOWN, listener, true));
        this._register(dom.addDisposableListener(window, dom.EventType.KEY_UP, listener, true));
        this._register(dom.addDisposableListener(window, dom.EventType.MOUSE_DOWN, listener, true));
    };
    QuickInputController.prototype.getUI = function () {
        var _this = this;
        if (this.ui) {
            return this.ui;
        }
        var container = dom.append(this.parentElement, $('.quick-input-widget.show-file-icons'));
        container.tabIndex = -1;
        container.style.display = 'none';
        var styleSheet = dom.createStyleSheet(container);
        var titleBar = dom.append(container, $('.quick-input-titlebar'));
        var leftActionBar = this._register(new ActionBar(titleBar));
        leftActionBar.domNode.classList.add('quick-input-left-action-bar');
        var title = dom.append(titleBar, $('.quick-input-title'));
        var rightActionBar = this._register(new ActionBar(titleBar));
        rightActionBar.domNode.classList.add('quick-input-right-action-bar');
        var description1 = dom.append(container, $('.quick-input-description'));
        var headerContainer = dom.append(container, $('.quick-input-header'));
        var checkAll = dom.append(headerContainer, $('input.quick-input-check-all'));
        checkAll.type = 'checkbox';
        this._register(dom.addStandardDisposableListener(checkAll, dom.EventType.CHANGE, function (e) {
            var checked = checkAll.checked;
            list.setAllVisibleChecked(checked);
        }));
        this._register(dom.addDisposableListener(checkAll, dom.EventType.CLICK, function (e) {
            if (e.x || e.y) { // Avoid 'click' triggered by 'space'...
                inputBox.setFocus();
            }
        }));
        var description2 = dom.append(headerContainer, $('.quick-input-description'));
        var extraContainer = dom.append(headerContainer, $('.quick-input-and-message'));
        var filterContainer = dom.append(extraContainer, $('.quick-input-filter'));
        var inputBox = this._register(new QuickInputBox(filterContainer));
        inputBox.setAttribute('aria-describedby', this.idPrefix + "message");
        var visibleCountContainer = dom.append(filterContainer, $('.quick-input-visible-count'));
        visibleCountContainer.setAttribute('aria-live', 'polite');
        visibleCountContainer.setAttribute('aria-atomic', 'true');
        var visibleCount = new CountBadge(visibleCountContainer, { countFormat: localize({ key: 'quickInput.visibleCount', comment: ['This tells the user how many items are shown in a list of items to select from. The items can be anything. Currently not visible, but read by screen readers.'] }, "{0} Results") });
        var countContainer = dom.append(filterContainer, $('.quick-input-count'));
        countContainer.setAttribute('aria-live', 'polite');
        var count = new CountBadge(countContainer, { countFormat: localize({ key: 'quickInput.countSelected', comment: ['This tells the user how many items are selected in a list of items to select from. The items can be anything.'] }, "{0} Selected") });
        var okContainer = dom.append(headerContainer, $('.quick-input-action'));
        var ok = new Button(okContainer);
        ok.label = localize('ok', "OK");
        this._register(ok.onDidClick(function (e) {
            _this.onDidAcceptEmitter.fire();
        }));
        var customButtonContainer = dom.append(headerContainer, $('.quick-input-action'));
        var customButton = new Button(customButtonContainer);
        customButton.label = localize('custom', "Custom");
        this._register(customButton.onDidClick(function (e) {
            _this.onDidCustomEmitter.fire();
        }));
        var message = dom.append(extraContainer, $("#" + this.idPrefix + "message.quick-input-message"));
        var progressBar = new ProgressBar(container);
        progressBar.getContainer().classList.add('quick-input-progress');
        var list = this._register(new QuickInputList(container, this.idPrefix + 'list', this.options));
        this._register(list.onChangedAllVisibleChecked(function (checked) {
            checkAll.checked = checked;
        }));
        this._register(list.onChangedVisibleCount(function (c) {
            visibleCount.setCount(c);
        }));
        this._register(list.onChangedCheckedCount(function (c) {
            count.setCount(c);
        }));
        this._register(list.onLeave(function () {
            // Defer to avoid the input field reacting to the triggering key.
            setTimeout(function () {
                inputBox.setFocus();
                if (_this.controller instanceof QuickPick && _this.controller.canSelectMany) {
                    list.clearFocus();
                }
            }, 0);
        }));
        this._register(list.onDidChangeFocus(function () {
            if (_this.comboboxAccessibility) {
                _this.getUI().inputBox.setAttribute('aria-activedescendant', _this.getUI().list.getActiveDescendant() || '');
            }
        }));
        var focusTracker = dom.trackFocus(container);
        this._register(focusTracker);
        this._register(dom.addDisposableListener(container, dom.EventType.FOCUS, function (e) {
            _this.previousFocusElement = e.relatedTarget instanceof HTMLElement ? e.relatedTarget : undefined;
        }, true));
        this._register(focusTracker.onDidBlur(function () {
            if (!_this.getUI().ignoreFocusOut && !_this.options.ignoreFocusOut()) {
                _this.hide();
            }
            _this.previousFocusElement = undefined;
        }));
        this._register(dom.addDisposableListener(container, dom.EventType.FOCUS, function (e) {
            inputBox.setFocus();
        }));
        this._register(dom.addDisposableListener(container, dom.EventType.KEY_DOWN, function (e) {
            var event = new StandardKeyboardEvent(e);
            switch (event.keyCode) {
                case 3 /* Enter */:
                    dom.EventHelper.stop(e, true);
                    _this.onDidAcceptEmitter.fire();
                    break;
                case 9 /* Escape */:
                    dom.EventHelper.stop(e, true);
                    _this.hide();
                    break;
                case 2 /* Tab */:
                    if (!event.altKey && !event.ctrlKey && !event.metaKey) {
                        var selectors = ['.action-label.codicon'];
                        if (container.classList.contains('show-checkboxes')) {
                            selectors.push('input');
                        }
                        else {
                            selectors.push('input[type=text]');
                        }
                        if (_this.getUI().list.isDisplayed()) {
                            selectors.push('.monaco-list');
                        }
                        var stops = container.querySelectorAll(selectors.join(', '));
                        if (event.shiftKey && event.target === stops[0]) {
                            dom.EventHelper.stop(e, true);
                            stops[stops.length - 1].focus();
                        }
                        else if (!event.shiftKey && event.target === stops[stops.length - 1]) {
                            dom.EventHelper.stop(e, true);
                            stops[0].focus();
                        }
                    }
                    break;
            }
        }));
        this.ui = {
            container: container,
            styleSheet: styleSheet,
            leftActionBar: leftActionBar,
            titleBar: titleBar,
            title: title,
            description1: description1,
            description2: description2,
            rightActionBar: rightActionBar,
            checkAll: checkAll,
            filterContainer: filterContainer,
            inputBox: inputBox,
            visibleCountContainer: visibleCountContainer,
            visibleCount: visibleCount,
            countContainer: countContainer,
            count: count,
            okContainer: okContainer,
            ok: ok,
            message: message,
            customButtonContainer: customButtonContainer,
            customButton: customButton,
            progressBar: progressBar,
            list: list,
            onDidAccept: this.onDidAcceptEmitter.event,
            onDidCustom: this.onDidCustomEmitter.event,
            onDidTriggerButton: this.onDidTriggerButtonEmitter.event,
            ignoreFocusOut: false,
            keyMods: this.keyMods,
            isScreenReaderOptimized: function () { return _this.options.isScreenReaderOptimized(); },
            show: function (controller) { return _this.show(controller); },
            hide: function () { return _this.hide(); },
            setVisibilities: function (visibilities) { return _this.setVisibilities(visibilities); },
            setComboboxAccessibility: function (enabled) { return _this.setComboboxAccessibility(enabled); },
            setEnabled: function (enabled) { return _this.setEnabled(enabled); },
            setContextKey: function (contextKey) { return _this.options.setContextKey(contextKey); },
        };
        this.updateStyles();
        return this.ui;
    };
    QuickInputController.prototype.pick = function (picks, options, token) {
        var _this = this;
        if (options === void 0) { options = {}; }
        if (token === void 0) { token = CancellationToken.None; }
        return new Promise(function (doResolve, reject) {
            var resolve = function (result) {
                resolve = doResolve;
                if (options.onKeyMods) {
                    options.onKeyMods(input.keyMods);
                }
                doResolve(result);
            };
            if (token.isCancellationRequested) {
                resolve(undefined);
                return;
            }
            var input = _this.createQuickPick();
            var activeItem;
            var disposables = [
                input,
                input.onDidAccept(function () {
                    if (input.canSelectMany) {
                        resolve(input.selectedItems.slice());
                        input.hide();
                    }
                    else {
                        var result = input.activeItems[0];
                        if (result) {
                            resolve(result);
                            input.hide();
                        }
                    }
                }),
                input.onDidChangeActive(function (items) {
                    var focused = items[0];
                    if (focused && options.onDidFocus) {
                        options.onDidFocus(focused);
                    }
                }),
                input.onDidChangeSelection(function (items) {
                    if (!input.canSelectMany) {
                        var result = items[0];
                        if (result) {
                            resolve(result);
                            input.hide();
                        }
                    }
                }),
                input.onDidTriggerItemButton(function (event) { return options.onDidTriggerItemButton && options.onDidTriggerItemButton(__assign(__assign({}, event), { removeItem: function () {
                        var index = input.items.indexOf(event.item);
                        if (index !== -1) {
                            var items = input.items.slice();
                            items.splice(index, 1);
                            input.items = items;
                        }
                    } })); }),
                input.onDidChangeValue(function (value) {
                    if (activeItem && !value && (input.activeItems.length !== 1 || input.activeItems[0] !== activeItem)) {
                        input.activeItems = [activeItem];
                    }
                }),
                token.onCancellationRequested(function () {
                    input.hide();
                }),
                input.onDidHide(function () {
                    dispose(disposables);
                    resolve(undefined);
                }),
            ];
            input.canSelectMany = !!options.canPickMany;
            input.placeholder = options.placeHolder;
            input.ignoreFocusOut = !!options.ignoreFocusLost;
            input.matchOnDescription = !!options.matchOnDescription;
            input.matchOnDetail = !!options.matchOnDetail;
            input.matchOnLabel = (options.matchOnLabel === undefined) || options.matchOnLabel; // default to true
            input.autoFocusOnList = (options.autoFocusOnList === undefined) || options.autoFocusOnList; // default to true
            input.quickNavigate = options.quickNavigate;
            input.contextKey = options.contextKey;
            input.busy = true;
            Promise.all([picks, options.activeItem])
                .then(function (_a) {
                var _b = __read(_a, 2), items = _b[0], _activeItem = _b[1];
                activeItem = _activeItem;
                input.busy = false;
                input.items = items;
                if (input.canSelectMany) {
                    input.selectedItems = items.filter(function (item) { return item.type !== 'separator' && item.picked; });
                }
                if (activeItem) {
                    input.activeItems = [activeItem];
                }
            });
            input.show();
            Promise.resolve(picks).then(undefined, function (err) {
                reject(err);
                input.hide();
            });
        });
    };
    QuickInputController.prototype.input = function (options, token) {
        var _this = this;
        if (options === void 0) { options = {}; }
        if (token === void 0) { token = CancellationToken.None; }
        return new Promise(function (resolve) {
            if (token.isCancellationRequested) {
                resolve(undefined);
                return;
            }
            var input = _this.createInputBox();
            var validateInput = options.validateInput || (function () { return Promise.resolve(undefined); });
            var onDidValueChange = Event.debounce(input.onDidChangeValue, function (last, cur) { return cur; }, 100);
            var validationValue = options.value || '';
            var validation = Promise.resolve(validateInput(validationValue));
            var disposables = [
                input,
                onDidValueChange(function (value) {
                    if (value !== validationValue) {
                        validation = Promise.resolve(validateInput(value));
                        validationValue = value;
                    }
                    validation.then(function (result) {
                        if (value === validationValue) {
                            input.validationMessage = result || undefined;
                        }
                    });
                }),
                input.onDidAccept(function () {
                    var value = input.value;
                    if (value !== validationValue) {
                        validation = Promise.resolve(validateInput(value));
                        validationValue = value;
                    }
                    validation.then(function (result) {
                        if (!result) {
                            resolve(value);
                            input.hide();
                        }
                        else if (value === validationValue) {
                            input.validationMessage = result;
                        }
                    });
                }),
                token.onCancellationRequested(function () {
                    input.hide();
                }),
                input.onDidHide(function () {
                    dispose(disposables);
                    resolve(undefined);
                }),
            ];
            input.value = options.value || '';
            input.valueSelection = options.valueSelection;
            input.prompt = options.prompt;
            input.placeholder = options.placeHolder;
            input.password = !!options.password;
            input.ignoreFocusOut = !!options.ignoreFocusLost;
            input.show();
        });
    };
    QuickInputController.prototype.createQuickPick = function () {
        var ui = this.getUI();
        return new QuickPick(ui);
    };
    QuickInputController.prototype.createInputBox = function () {
        var ui = this.getUI();
        return new InputBox(ui);
    };
    QuickInputController.prototype.show = function (controller) {
        var ui = this.getUI();
        this.onShowEmitter.fire();
        var oldController = this.controller;
        this.controller = controller;
        if (oldController) {
            oldController.didHide();
        }
        this.setEnabled(true);
        ui.leftActionBar.clear();
        ui.title.textContent = '';
        ui.description1.textContent = '';
        ui.description2.textContent = '';
        ui.rightActionBar.clear();
        ui.checkAll.checked = false;
        // ui.inputBox.value = ''; Avoid triggering an event.
        ui.inputBox.placeholder = '';
        ui.inputBox.password = false;
        ui.inputBox.showDecoration(Severity.Ignore);
        ui.visibleCount.setCount(0);
        ui.count.setCount(0);
        dom.reset(ui.message);
        ui.progressBar.stop();
        ui.list.setElements([]);
        ui.list.matchOnDescription = false;
        ui.list.matchOnDetail = false;
        ui.list.matchOnLabel = true;
        ui.list.sortByLabel = true;
        ui.ignoreFocusOut = false;
        this.setComboboxAccessibility(false);
        ui.inputBox.ariaLabel = '';
        var backKeybindingLabel = this.options.backKeybindingLabel();
        backButton.tooltip = backKeybindingLabel ? localize('quickInput.backWithKeybinding', "Back ({0})", backKeybindingLabel) : localize('quickInput.back', "Back");
        ui.container.style.display = '';
        this.updateLayout();
        ui.inputBox.setFocus();
    };
    QuickInputController.prototype.setVisibilities = function (visibilities) {
        var ui = this.getUI();
        ui.title.style.display = visibilities.title ? '' : 'none';
        ui.description1.style.display = visibilities.description && (visibilities.inputBox || visibilities.checkAll) ? '' : 'none';
        ui.description2.style.display = visibilities.description && !(visibilities.inputBox || visibilities.checkAll) ? '' : 'none';
        ui.checkAll.style.display = visibilities.checkAll ? '' : 'none';
        ui.filterContainer.style.display = visibilities.inputBox ? '' : 'none';
        ui.visibleCountContainer.style.display = visibilities.visibleCount ? '' : 'none';
        ui.countContainer.style.display = visibilities.count ? '' : 'none';
        ui.okContainer.style.display = visibilities.ok ? '' : 'none';
        ui.customButtonContainer.style.display = visibilities.customButton ? '' : 'none';
        ui.message.style.display = visibilities.message ? '' : 'none';
        ui.progressBar.getContainer().style.display = visibilities.progressBar ? '' : 'none';
        ui.list.display(!!visibilities.list);
        ui.container.classList[visibilities.checkBox ? 'add' : 'remove']('show-checkboxes');
        this.updateLayout(); // TODO
    };
    QuickInputController.prototype.setComboboxAccessibility = function (enabled) {
        if (enabled !== this.comboboxAccessibility) {
            var ui = this.getUI();
            this.comboboxAccessibility = enabled;
            if (this.comboboxAccessibility) {
                ui.inputBox.setAttribute('role', 'combobox');
                ui.inputBox.setAttribute('aria-haspopup', 'true');
                ui.inputBox.setAttribute('aria-autocomplete', 'list');
                ui.inputBox.setAttribute('aria-activedescendant', ui.list.getActiveDescendant() || '');
            }
            else {
                ui.inputBox.removeAttribute('role');
                ui.inputBox.removeAttribute('aria-haspopup');
                ui.inputBox.removeAttribute('aria-autocomplete');
                ui.inputBox.removeAttribute('aria-activedescendant');
            }
        }
    };
    QuickInputController.prototype.setEnabled = function (enabled) {
        var e_1, _a, e_2, _b;
        if (enabled !== this.enabled) {
            this.enabled = enabled;
            try {
                for (var _c = __values(this.getUI().leftActionBar.viewItems), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var item = _d.value;
                    item.getAction().enabled = enabled;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_1) throw e_1.error; }
            }
            try {
                for (var _e = __values(this.getUI().rightActionBar.viewItems), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var item = _f.value;
                    item.getAction().enabled = enabled;
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                }
                finally { if (e_2) throw e_2.error; }
            }
            this.getUI().checkAll.disabled = !enabled;
            // this.getUI().inputBox.enabled = enabled; Avoid loosing focus.
            this.getUI().ok.enabled = enabled;
            this.getUI().list.enabled = enabled;
        }
    };
    QuickInputController.prototype.hide = function () {
        var _a;
        var controller = this.controller;
        if (controller) {
            var focusChanged = !((_a = this.ui) === null || _a === void 0 ? void 0 : _a.container.contains(document.activeElement));
            this.controller = null;
            this.onHideEmitter.fire();
            this.getUI().container.style.display = 'none';
            if (!focusChanged) {
                if (this.previousFocusElement && this.previousFocusElement.offsetParent) {
                    this.previousFocusElement.focus();
                    this.previousFocusElement = undefined;
                }
                else {
                    this.options.returnFocus();
                }
            }
            controller.didHide();
        }
    };
    QuickInputController.prototype.focus = function () {
        if (this.isDisplayed()) {
            this.getUI().inputBox.setFocus();
        }
    };
    QuickInputController.prototype.toggle = function () {
        if (this.isDisplayed() && this.controller instanceof QuickPick && this.controller.canSelectMany) {
            this.getUI().list.toggleCheckbox();
        }
    };
    QuickInputController.prototype.navigate = function (next, quickNavigate) {
        if (this.isDisplayed() && this.getUI().list.isDisplayed()) {
            this.getUI().list.focus(next ? QuickInputListFocus.Next : QuickInputListFocus.Previous);
            if (quickNavigate && this.controller instanceof QuickPick) {
                this.controller.quickNavigate = quickNavigate;
            }
        }
    };
    QuickInputController.prototype.accept = function (keyMods) {
        if (keyMods === void 0) { keyMods = { alt: false, ctrlCmd: false }; }
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                // When accepting the item programmatically, it is important that
                // we update `keyMods` either from the provided set or unset it
                // because the accept did not happen from mouse or keyboard
                // interaction on the list itself
                this.keyMods.alt = keyMods.alt;
                this.keyMods.ctrlCmd = keyMods.ctrlCmd;
                this.onDidAcceptEmitter.fire();
                return [2 /*return*/];
            });
        });
    };
    QuickInputController.prototype.back = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.onDidTriggerButtonEmitter.fire(this.backButton);
                return [2 /*return*/];
            });
        });
    };
    QuickInputController.prototype.cancel = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.hide();
                return [2 /*return*/];
            });
        });
    };
    QuickInputController.prototype.layout = function (dimension, titleBarOffset) {
        this.dimension = dimension;
        this.titleBarOffset = titleBarOffset;
        this.updateLayout();
    };
    QuickInputController.prototype.updateLayout = function () {
        if (this.ui) {
            this.ui.container.style.top = this.titleBarOffset + "px";
            var style = this.ui.container.style;
            var width = Math.min(this.dimension.width * 0.62 /* golden cut */, QuickInputController.MAX_WIDTH);
            style.width = width + 'px';
            style.marginLeft = '-' + (width / 2) + 'px';
            this.ui.inputBox.layout();
            this.ui.list.layout(this.dimension && this.dimension.height * 0.4);
        }
    };
    QuickInputController.prototype.applyStyles = function (styles) {
        this.styles = styles;
        this.updateStyles();
    };
    QuickInputController.prototype.updateStyles = function () {
        if (this.ui) {
            var _a = this.styles.widget, quickInputTitleBackground = _a.quickInputTitleBackground, quickInputBackground = _a.quickInputBackground, quickInputForeground = _a.quickInputForeground, contrastBorder = _a.contrastBorder, widgetShadow = _a.widgetShadow;
            this.ui.titleBar.style.backgroundColor = quickInputTitleBackground ? quickInputTitleBackground.toString() : '';
            this.ui.container.style.backgroundColor = quickInputBackground ? quickInputBackground.toString() : '';
            this.ui.container.style.color = quickInputForeground ? quickInputForeground.toString() : '';
            this.ui.container.style.border = contrastBorder ? "1px solid " + contrastBorder : '';
            this.ui.container.style.boxShadow = widgetShadow ? "0 0 8px 2px " + widgetShadow : '';
            this.ui.inputBox.style(this.styles.inputBox);
            this.ui.count.style(this.styles.countBadge);
            this.ui.ok.style(this.styles.button);
            this.ui.customButton.style(this.styles.button);
            this.ui.progressBar.style(this.styles.progressBar);
            this.ui.list.style(this.styles.list);
            var content = [];
            if (this.styles.list.pickerGroupBorder) {
                content.push(".quick-input-list .quick-input-list-entry { border-top-color:  " + this.styles.list.pickerGroupBorder + "; }");
            }
            if (this.styles.list.pickerGroupForeground) {
                content.push(".quick-input-list .quick-input-list-separator { color:  " + this.styles.list.pickerGroupForeground + "; }");
            }
            var newStyles = content.join('\n');
            if (newStyles !== this.ui.styleSheet.textContent) {
                this.ui.styleSheet.textContent = newStyles;
            }
        }
    };
    QuickInputController.prototype.isDisplayed = function () {
        return this.ui && this.ui.container.style.display !== 'none';
    };
    QuickInputController.MAX_WIDTH = 600; // Max total width of quick input widget
    return QuickInputController;
}(Disposable));
export { QuickInputController };
