/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { Disposable } from '../common/lifecycle';
import { addDisposableListener } from './dom';
/**
 * A helper that will execute a provided function when the provided HTMLElement receives
 *  dragover event for 800ms. If the drag is aborted before, the callback will not be triggered.
 */
var DelayedDragHandler = /** @class */ (function (_super) {
    __extends(DelayedDragHandler, _super);
    function DelayedDragHandler(container, callback) {
        var _this = _super.call(this) || this;
        _this._register(addDisposableListener(container, 'dragover', function (e) {
            e.preventDefault(); // needed so that the drop event fires (https://stackoverflow.com/questions/21339924/drop-event-not-firing-in-chrome)
            if (!_this.timeout) {
                _this.timeout = setTimeout(function () {
                    callback();
                    _this.timeout = null;
                }, 800);
            }
        }));
        ['dragleave', 'drop', 'dragend'].forEach(function (type) {
            _this._register(addDisposableListener(container, type, function () {
                _this.clearDragTimeout();
            }));
        });
        return _this;
    }
    DelayedDragHandler.prototype.clearDragTimeout = function () {
        if (this.timeout) {
            clearTimeout(this.timeout);
            this.timeout = null;
        }
    };
    DelayedDragHandler.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this.clearDragTimeout();
    };
    return DelayedDragHandler;
}(Disposable));
export { DelayedDragHandler };
// Common data transfers
export var DataTransfers = {
    /**
     * Application specific resource transfer type
     */
    RESOURCES: 'ResourceURLs',
    /**
     * Browser specific transfer type to download
     */
    DOWNLOAD_URL: 'DownloadURL',
    /**
     * Browser specific transfer type for files
     */
    FILES: 'Files',
    /**
     * Typically transfer type for copy/paste transfers.
     */
    TEXT: 'text/plain'
};
export function applyDragImage(event, label, clazz) {
    var dragImage = document.createElement('div');
    dragImage.className = clazz;
    dragImage.textContent = label;
    if (event.dataTransfer) {
        document.body.appendChild(dragImage);
        event.dataTransfer.setDragImage(dragImage, -10, -10);
        // Removes the element when the DND operation is done
        setTimeout(function () { return document.body.removeChild(dragImage); }, 0);
    }
}
var DragAndDropData = /** @class */ (function () {
    function DragAndDropData(data) {
        this.data = data;
    }
    DragAndDropData.prototype.update = function () {
        // noop
    };
    DragAndDropData.prototype.getData = function () {
        return this.data;
    };
    return DragAndDropData;
}());
export { DragAndDropData };
export var StaticDND = {
    CurrentDragAndDropData: undefined
};
