"use strict";
/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.TestWebSocketChannel = void 0;
const ws = require("ws");
const web_socket_channel_1 = require("../../../common/messaging/web-socket-channel");
const disposable_1 = require("../../../common/disposable");
class TestWebSocketChannel extends web_socket_channel_1.WebSocketChannel {
    constructor({ server, path }) {
        super(0, content => socket.send(content));
        const socket = new ws(`ws://localhost:${server.address().port}${web_socket_channel_1.WebSocketChannel.wsPath}`);
        socket.on('error', error => this.fireError(error));
        socket.on('close', (code, reason) => this.fireClose(code, reason));
        socket.on('message', data => {
            this.handleMessage(JSON.parse(data.toString()));
        });
        socket.on('open', () => this.open(path));
        this.toDispose.push(disposable_1.Disposable.create(() => socket.close()));
    }
}
exports.TestWebSocketChannel = TestWebSocketChannel;
//# sourceMappingURL=test-web-socket-channel.js.map