"use strict";
/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTreeContainer = void 0;
const inversify_1 = require("inversify");
const tree_widget_1 = require("./tree-widget");
const tree_model_1 = require("./tree-model");
const tree_1 = require("./tree");
const tree_selection_1 = require("./tree-selection");
const tree_selection_impl_1 = require("./tree-selection-impl");
const tree_expansion_1 = require("./tree-expansion");
const tree_navigation_1 = require("./tree-navigation");
const tree_decorator_1 = require("./tree-decorator");
const tree_search_1 = require("./tree-search");
const fuzzy_search_1 = require("./fuzzy-search");
const search_box_1 = require("./search-box");
const search_box_debounce_1 = require("./search-box-debounce");
const tree_view_welcome_widget_1 = require("./tree-view-welcome-widget");
function createTreeContainer(parent, props) {
    const child = new inversify_1.Container({ defaultScope: 'Singleton' });
    child.parent = parent;
    child.bind(tree_1.TreeImpl).toSelf();
    child.bind(tree_1.Tree).toService(tree_1.TreeImpl);
    child.bind(tree_selection_impl_1.TreeSelectionServiceImpl).toSelf();
    child.bind(tree_selection_1.TreeSelectionService).toService(tree_selection_impl_1.TreeSelectionServiceImpl);
    child.bind(tree_expansion_1.TreeExpansionServiceImpl).toSelf();
    child.bind(tree_expansion_1.TreeExpansionService).toService(tree_expansion_1.TreeExpansionServiceImpl);
    child.bind(tree_navigation_1.TreeNavigationService).toSelf();
    child.bind(tree_model_1.TreeModelImpl).toSelf();
    child.bind(tree_model_1.TreeModel).toService(tree_model_1.TreeModelImpl);
    child.bind(tree_widget_1.TreeWidget).toSelf();
    child.bind(tree_widget_1.TreeProps).toConstantValue(Object.assign(Object.assign({}, tree_widget_1.defaultTreeProps), props));
    child.bind(tree_view_welcome_widget_1.TreeViewWelcomeWidget).toSelf();
    child.bind(tree_search_1.TreeSearch).toSelf().inSingletonScope();
    child.bind(fuzzy_search_1.FuzzySearch).toSelf().inSingletonScope();
    child.bind(search_box_1.SearchBoxFactory).toFactory(context => (options) => {
        const debounce = new search_box_debounce_1.SearchBoxDebounce(options);
        return new search_box_1.SearchBox(options, debounce);
    });
    child.bind(tree_decorator_1.TreeDecoratorService).to(tree_decorator_1.NoopTreeDecoratorService).inSingletonScope();
    return child;
}
exports.createTreeContainer = createTreeContainer;
//# sourceMappingURL=tree-container.js.map