"use strict";
/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var ColorApplicationContribution_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ColorApplicationContribution = exports.ColorContribution = void 0;
const inversify_1 = require("inversify");
const color_registry_1 = require("./color-registry");
const event_1 = require("../common/event");
const theming_1 = require("./theming");
const contribution_provider_1 = require("../common/contribution-provider");
const disposable_1 = require("../common/disposable");
exports.ColorContribution = Symbol('ColorContribution');
let ColorApplicationContribution = ColorApplicationContribution_1 = class ColorApplicationContribution {
    constructor() {
        this.onDidChangeEmitter = new event_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
        this.toUpdate = new disposable_1.DisposableCollection();
    }
    onStart() {
        for (const contribution of this.colorContributions.getContributions()) {
            contribution.registerColors(this.colors);
        }
        this.updateThemeBackground();
        theming_1.ThemeService.get().onDidColorThemeChange(() => this.updateThemeBackground());
        this.update();
        theming_1.ThemeService.get().onDidColorThemeChange(() => this.update());
        this.colors.onDidChange(() => this.update());
    }
    update() {
        if (!document) {
            return;
        }
        this.toUpdate.dispose();
        const theme = 'theia-' + theming_1.ThemeService.get().getCurrentTheme().type;
        document.body.classList.add(theme);
        this.toUpdate.push(disposable_1.Disposable.create(() => document.body.classList.remove(theme)));
        const documentElement = document.documentElement;
        if (documentElement) {
            for (const id of this.colors.getColors()) {
                const variable = this.colors.getCurrentCssVariable(id);
                if (variable) {
                    const { name, value } = variable;
                    documentElement.style.setProperty(name, value);
                    this.toUpdate.push(disposable_1.Disposable.create(() => documentElement.style.removeProperty(name)));
                }
            }
        }
        this.onDidChangeEmitter.fire(undefined);
    }
    updateThemeBackground() {
        const color = this.colors.getCurrentColor('editor.background');
        if (color) {
            window.localStorage.setItem(ColorApplicationContribution_1.themeBackgroundId, color);
        }
        else {
            window.localStorage.removeItem(ColorApplicationContribution_1.themeBackgroundId);
        }
    }
    static initBackground() {
        const value = window.localStorage.getItem(this.themeBackgroundId) || '#1d1d1d';
        const documentElement = document.documentElement;
        documentElement.style.setProperty('--theia-editor-background', value);
    }
};
ColorApplicationContribution.themeBackgroundId = 'theme.background';
__decorate([
    inversify_1.inject(color_registry_1.ColorRegistry),
    __metadata("design:type", color_registry_1.ColorRegistry)
], ColorApplicationContribution.prototype, "colors", void 0);
__decorate([
    inversify_1.inject(contribution_provider_1.ContributionProvider),
    inversify_1.named(exports.ColorContribution),
    __metadata("design:type", Object)
], ColorApplicationContribution.prototype, "colorContributions", void 0);
ColorApplicationContribution = ColorApplicationContribution_1 = __decorate([
    inversify_1.injectable()
], ColorApplicationContribution);
exports.ColorApplicationContribution = ColorApplicationContribution;
//# sourceMappingURL=color-application-contribution.js.map