/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.semantictokens;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public enum TokenModifier {
    PUBLIC("public"),
    PRIVATE("private"),
    PROTECTED("protected"),
    ABSTRACT("abstract"),
    STATIC("static"),
    FINAL("readonly"),
    NATIVE("native"),
    DEPRECATED("deprecated"),
    GENERIC("generic"),
    TYPE_ARGUMENT("typeArgument"),
    DECLARATION("declaration"),
    IMPORT_DECLARATION("importDeclaration");

    private final String genericName;
    public final int bitmask = 1 << this.ordinal();

    private TokenModifier(String genericName) {
        this.genericName = genericName;
    }

    public String toString() {
        return this.genericName;
    }

    public static int getApplicableModifiers(IBinding binding) {
        if (binding == null) {
            return 0;
        }
        int modifiers = 0;
        int bindingModifiers = binding.getModifiers();
        if (Modifier.isPublic((int)bindingModifiers)) {
            modifiers |= TokenModifier.PUBLIC.bitmask;
        }
        if (Modifier.isPrivate((int)bindingModifiers)) {
            modifiers |= TokenModifier.PRIVATE.bitmask;
        }
        if (Modifier.isProtected((int)bindingModifiers)) {
            modifiers |= TokenModifier.PROTECTED.bitmask;
        }
        if (Modifier.isAbstract((int)bindingModifiers)) {
            modifiers |= TokenModifier.ABSTRACT.bitmask;
        }
        if (Modifier.isStatic((int)bindingModifiers)) {
            modifiers |= TokenModifier.STATIC.bitmask;
        }
        if (Modifier.isFinal((int)bindingModifiers)) {
            modifiers |= TokenModifier.FINAL.bitmask;
        }
        if (Modifier.isNative((int)bindingModifiers)) {
            modifiers |= TokenModifier.NATIVE.bitmask;
        }
        if (binding.isDeprecated()) {
            modifiers |= TokenModifier.DEPRECATED.bitmask;
        }
        return modifiers;
    }

    public static boolean isGeneric(IBinding binding) {
        if (binding == null) {
            return false;
        }
        switch (binding.getKind()) {
            case 2: {
                return TokenModifier.isGeneric((ITypeBinding)binding);
            }
            case 4: {
                return TokenModifier.isGeneric((IMethodBinding)binding);
            }
        }
        return false;
    }

    public static boolean isGeneric(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return false;
        }
        return typeBinding.isGenericType() || typeBinding.isParameterizedType();
    }

    public static boolean isGeneric(IMethodBinding methodBinding) {
        if (methodBinding == null) {
            return false;
        }
        return methodBinding.isGenericMethod() || methodBinding.isParameterizedMethod();
    }

    public static boolean isDeclaration(SimpleName simpleName) {
        StructuralPropertyDescriptor d = simpleName.getLocationInParent();
        if (d == null) {
            return false;
        }
        ASTNode parent = simpleName.getParent();
        if (parent instanceof TypeDeclaration) {
            return d == TypeDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof MethodDeclaration) {
            return d == MethodDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof SingleVariableDeclaration) {
            return d == SingleVariableDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof VariableDeclarationFragment) {
            return d == VariableDeclarationFragment.NAME_PROPERTY;
        }
        if (parent instanceof EnumDeclaration) {
            return d == EnumDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof EnumConstantDeclaration) {
            return d == EnumConstantDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof TypeParameter) {
            return d == TypeParameter.NAME_PROPERTY;
        }
        if (parent instanceof AnnotationTypeDeclaration) {
            return d == AnnotationTypeDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof AnnotationTypeMemberDeclaration) {
            return d == AnnotationTypeMemberDeclaration.NAME_PROPERTY;
        }
        return false;
    }
}

