/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.ActionableNotification;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.FormatterManager;
import org.eclipse.jdt.ls.core.internal.managers.GradleBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.managers.UpdateClasspathJob;
import org.eclipse.jdt.ls.core.internal.preferences.IPreferencesChangeListener;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.DidChangeWatchedFilesRegistrationOptions;
import org.eclipse.lsp4j.FileSystemWatcher;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextDocumentIdentifier;

public class StandardProjectsManager
extends ProjectsManager {
    protected static final String BUILD_SUPPORT_EXTENSION_POINT_ID = "buildSupport";
    private static final Set<String> watchers = new LinkedHashSet<String>();
    private PreferenceManager preferenceManager;
    private static final List<String> basicWatchers = Arrays.asList("**/*.java", "**/.project", "**/.classpath", "**/.settings/*.prefs", "**/src/**");
    private Job registerWatcherJob = new Job("Register Watchers"){

        protected IStatus run(IProgressMonitor monitor) {
            JobHelpers.waitForJobsToComplete();
            StandardProjectsManager.this.registerWatchers();
            return Status.OK_STATUS;
        }
    };
    private IPreferencesChangeListener preferenceChangeListener = null;

    public StandardProjectsManager(PreferenceManager preferenceManager) {
        super(preferenceManager);
        this.preferenceManager = preferenceManager;
    }

    @Override
    public void cleanInvalidProjects(Collection<IPath> rootPaths, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        this.deleteInvalidProjects(rootPaths, (IProgressMonitor)subMonitor.split(10));
        GradleBuildSupport.cleanGradleModels((IProgressMonitor)subMonitor.split(10));
    }

    private void deleteInvalidProjects(Collection<IPath> rootPaths, IProgressMonitor monitor) {
        List workspaceProjects = rootPaths.stream().map(rootPath -> ProjectUtils.getWorkspaceInvisibleProjectName(rootPath)).collect(Collectors.toList());
        ArrayList<IProject> validGradleProjects = new ArrayList<IProject>();
        ArrayList<IProject> suspiciousGradleProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = ProjectUtils.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                IProject project2 = iProjectArray[n2];
                if (!project2.equals((Object)StandardProjectsManager.getDefaultProject())) {
                    if (project2.exists() && (ResourceUtils.isContainedIn(project2.getLocation(), rootPaths) || ProjectUtils.isGradleProject(project2) || workspaceProjects.contains(project2.getName()))) {
                        try {
                            project2.getDescription();
                            if (!ProjectUtils.isGradleProject(project2)) break block11;
                            if (ResourceUtils.isContainedIn(project2.getLocation(), rootPaths)) {
                                validGradleProjects.add(project2);
                                break block11;
                            }
                            suspiciousGradleProjects.add(project2);
                        }
                        catch (CoreException e) {
                            try {
                                project2.delete(true, monitor);
                            }
                            catch (CoreException e1) {
                                JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
                            }
                        }
                    } else {
                        try {
                            project2.delete(false, true, monitor);
                        }
                        catch (CoreException e1) {
                            JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
                        }
                    }
                }
            }
            ++n2;
        }
        List<IProject> unrelatedProjects = this.findUnrelatedGradleProjects(suspiciousGradleProjects, validGradleProjects);
        unrelatedProjects.forEach(project -> {
            try {
                project.delete(false, true, monitor);
            }
            catch (CoreException e1) {
                JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
            }
        });
    }

    private List<IProject> findUnrelatedGradleProjects(List<IProject> suspiciousProjects, List<IProject> validProjects) {
        suspiciousProjects.sort((p1, p2) -> p1.getLocation().toOSString().length() - p2.getLocation().toOSString().length());
        ArrayList<IProject> unrelatedCandidates = new ArrayList<IProject>();
        ArrayList validSubPaths = new ArrayList();
        for (IProject suspiciousProject : suspiciousProjects) {
            if (validSubPaths.contains(suspiciousProject.getFullPath().makeRelative())) continue;
            boolean isParentProject = false;
            Collection subpaths = null;
            PersistentModel model = CorePlugin.modelPersistence().loadModel(suspiciousProject);
            if (model.isPresent() && !(subpaths = model.getSubprojectPaths()).isEmpty()) {
                for (IProject validProject : validProjects) {
                    if (!subpaths.contains(validProject.getFullPath().makeRelative())) continue;
                    isParentProject = true;
                    break;
                }
            }
            if (isParentProject) {
                validSubPaths.addAll(subpaths);
                continue;
            }
            unrelatedCandidates.add(suspiciousProject);
        }
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (IProject candidate : unrelatedCandidates) {
            if (validSubPaths.contains(candidate.getFullPath().makeRelative())) continue;
            result.add(candidate);
        }
        return result;
    }

    @Override
    public void fileChanged(String uriString, ProjectsManager.CHANGE_TYPE changeType) {
        block15: {
            if (uriString == null) {
                return;
            }
            IResource resource = JDTUtils.getFileOrFolder(uriString);
            if (resource == null) {
                return;
            }
            String formatterUrl = this.preferenceManager.getPreferences().getFormatterUrl();
            if (formatterUrl != null) {
                try {
                    URL url = this.getUrl(formatterUrl);
                    if (url != null) {
                        URI formatterUri = url.toURI();
                        URI uri = JDTUtils.toURI(uriString);
                        if (uri != null && uri.equals(formatterUri) && JavaLanguageServerPlugin.getInstance().getProtocol() != null) {
                            if (changeType == ProjectsManager.CHANGE_TYPE.DELETED || changeType == ProjectsManager.CHANGE_TYPE.CREATED) {
                                this.registerWatchers();
                            }
                            FormatterManager.configureFormatter(this.preferenceManager, this);
                        }
                    }
                }
                catch (URISyntaxException url) {
                    // empty catch block
                }
            }
            try {
                IBuildSupport buildSupport;
                boolean requireConfigurationUpdate;
                Optional<IBuildSupport> bs = this.getBuildSupport(resource.getProject());
                if (!bs.isPresent() || !(requireConfigurationUpdate = (buildSupport = bs.get()).fileChanged(resource, changeType, (IProgressMonitor)new NullProgressMonitor()))) break block15;
                Preferences.FeatureStatus status = this.preferenceManager.getPreferences().getUpdateBuildConfigurationStatus();
                switch (status) {
                    case automatic: {
                        this.updateProject(resource.getProject(), false);
                        break;
                    }
                    case disabled: {
                        break;
                    }
                    default: {
                        if (this.client != null) {
                            String cmd = "java.projectConfiguration.status";
                            TextDocumentIdentifier uri = new TextDocumentIdentifier(uriString);
                            ActionableNotification updateProjectConfigurationNotification = new ActionableNotification().withSeverity(MessageType.Info).withMessage("A build file was modified. Do you want to synchronize the Java classpath/configuration?").withCommands(Arrays.asList(new Command("Never", cmd, Arrays.asList(new Object[]{uri, Preferences.FeatureStatus.disabled})), new Command("Now", cmd, Arrays.asList(new Object[]{uri, Preferences.FeatureStatus.interactive})), new Command("Always", cmd, Arrays.asList(new Object[]{uri, Preferences.FeatureStatus.automatic}))));
                            this.client.sendActionableNotification(updateProjectConfigurationNotification);
                        }
                        break;
                    }
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem refreshing workspace", e);
            }
        }
    }

    @Override
    public boolean isBuildFile(IResource resource) {
        return this.buildSupports().filter(bs -> bs.isBuildFile(resource)).findAny().isPresent();
    }

    @Override
    public Optional<IBuildSupport> getBuildSupport(IProject project) {
        return this.buildSupports().filter(bs -> bs.applies(project)).findFirst();
    }

    protected Stream<IBuildSupport> buildSupports() {
        IConfigurationElement[] configs;
        TreeMap<Integer, IBuildSupport> supporters = new TreeMap<Integer, IBuildSupport>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.ls.core", BUILD_SUPPORT_EXTENSION_POINT_ID);
        IConfigurationElement[] iConfigurationElementArray = configs = extensionPoint.getConfigurationElements();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                Integer order = Integer.valueOf(config.getAttribute("order"));
                supporters.put(order, (IBuildSupport)config.createExecutableExtension("class"));
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logError(String.valueOf(config.getAttribute("class")) + " implementation was skipped \n" + e.getStatus());
            }
            ++n2;
        }
        return supporters.values().stream();
    }

    @Override
    public boolean isBuildLikeFileName(String fileName) {
        return this.buildSupports().filter(bs -> bs.isBuildLikeFileName(fileName)).findAny().isPresent();
    }

    @Override
    public void prepareToSave(ISaveContext context) throws CoreException {
        if (context.getKind() == 1) {
            GradleBuildSupport.saveModels();
        }
    }

    @Override
    public void registerWatchers(boolean runInJob) {
        if (runInJob) {
            this.registerWatcherJob.schedule();
        } else {
            this.registerWatchers();
        }
    }

    @Override
    public List<FileSystemWatcher> registerWatchers() {
        JavaLanguageServerPlugin.logInfo(">> registerWatchers'");
        if (this.preferenceManager.getClientPreferences().isWorkspaceChangeWatchedFilesDynamicRegistered()) {
            LinkedHashSet<String> patterns = new LinkedHashSet<String>(basicWatchers);
            this.buildSupports().forEach(e -> e.getWatchPatterns().forEach(patterns::add));
            HashSet<IPath> sources = new HashSet<IPath>();
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            try {
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject javaProject;
                    IProject project = iProjectArray[n2];
                    if (!"jdt.ls-java-project".equals(project.getName()) && (javaProject = JavaCore.create((IProject)project)) != null && javaProject.exists()) {
                        IClasspathEntry[] classpath = javaProject.getRawClasspath();
                        IClasspathEntry[] iClasspathEntryArray = classpath;
                        int n3 = classpath.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IPath location;
                            IFolder folder;
                            IPath path;
                            IClasspathEntry entry = iClasspathEntryArray[n4];
                            if (!(entry.getEntryKind() != 3 || (path = entry.getPath()) == null || path.toString().contains("/src/") || path.toString().endsWith("/src") || !(folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path)).exists() || folder.isDerived() || (location = folder.getLocation()) == null || ResourceUtils.isContainedIn(location, sources))) {
                                sources.add(location);
                            }
                            if (entry.getEntryKind() == 1) {
                                path = entry.getPath();
                                IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                                if (resource != null && !resource.isDerived() && (location = resource.getLocation()) != null && !ResourceUtils.isContainedIn(location, sources)) {
                                    sources.add(location);
                                }
                            }
                            ++n4;
                        }
                        if (!ProjectUtils.isVisibleProject(project)) {
                            IPath projectFolder = ProjectUtils.getProjectRealFolder(project);
                            Set<String> libraries = this.preferenceManager.getPreferences().getReferencedLibraries().getInclude();
                            for (String pattern : libraries) {
                                patterns.add(ProjectUtils.resolveGlobPath(projectFolder, pattern).toPortableString());
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e2) {
                JavaLanguageServerPlugin.logException(e2.getMessage(), e2);
            }
            ArrayList<FileSystemWatcher> fileWatchers = new ArrayList<FileSystemWatcher>();
            String formatterUrl = this.preferenceManager.getPreferences().getFormatterUrl();
            if (formatterUrl != null) {
                Path formatterPath;
                File file = new File(formatterUrl);
                if (!file.isFile()) {
                    file = this.findFile(formatterUrl);
                }
                if (file != null && file.isFile() && !ResourceUtils.isContainedIn((IPath)(formatterPath = new Path(file.getAbsolutePath())), sources)) {
                    sources.add((IPath)formatterPath);
                }
            }
            patterns.addAll(sources.stream().map(ResourceUtils::toGlobPattern).collect(Collectors.toList()));
            for (String pattern : patterns) {
                FileSystemWatcher watcher = new FileSystemWatcher(pattern);
                fileWatchers.add(watcher);
            }
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n5 = 0;
            while (n5 < n) {
                IProject project = iProjectArray[n5];
                if (ProjectUtils.isVisibleProject(project) && project.exists()) {
                    FileSystemWatcher watcher = new FileSystemWatcher(ResourceUtils.toGlobPattern(project.getLocation(), false), Integer.valueOf(4));
                    fileWatchers.add(watcher);
                }
                ++n5;
            }
            if (!patterns.equals(watchers)) {
                JavaLanguageServerPlugin.logInfo(">> registerFeature 'workspace/didChangeWatchedFiles'");
                DidChangeWatchedFilesRegistrationOptions didChangeWatchedFilesRegistrationOptions = new DidChangeWatchedFilesRegistrationOptions(fileWatchers);
                JavaLanguageServerPlugin.getInstance().unregisterCapability(Preferences.WORKSPACE_WATCHED_FILES_ID, "workspace/didChangeWatchedFiles");
                JavaLanguageServerPlugin.getInstance().registerCapability(Preferences.WORKSPACE_WATCHED_FILES_ID, "workspace/didChangeWatchedFiles", didChangeWatchedFilesRegistrationOptions);
                watchers.clear();
                watchers.addAll(patterns);
            }
            return fileWatchers;
        }
        return Collections.emptyList();
    }

    @Override
    public void registerListeners() {
        if (this.preferenceChangeListener == null) {
            this.preferenceChangeListener = new IPreferencesChangeListener(){

                @Override
                public void preferencesChange(Preferences oldPreferences, Preferences newPreferences) {
                    if (!oldPreferences.getReferencedLibraries().equals(newPreferences.getReferencedLibraries())) {
                        StandardProjectsManager.this.registerWatcherJob.schedule(1000L);
                        UpdateClasspathJob.getInstance().updateClasspath();
                    }
                    if (!Objects.equals(oldPreferences.getResourceFilters(), newPreferences.getResourceFilters())) {
                        try {
                            StandardProjectsManager.this.configureFilters((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            JavaLanguageServerPlugin.logException(e.getMessage(), e);
                        }
                    }
                }
            };
            this.preferenceManager.addPreferencesChangeListener(this.preferenceChangeListener);
        }
        this.buildSupports().forEach(p -> {
            try {
                p.registerPreferencesChangeListener(this.preferenceManager);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        });
    }
}

