/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ls.core.internal.AbstractProjectImporter;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.managers.UpdateClasspathJob;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public class InvisibleProjectImporter
extends AbstractProjectImporter {
    public static final String[][] SRC_PREFIXES = new String[][]{{"src"}};

    @Override
    public boolean applies(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        IPath rootPath;
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (workspaceLocation.equals((Object)(rootPath = ResourceUtils.filePathFromURI(this.rootFolder.toPath().toUri().toString())))) {
            return false;
        }
        return ProjectUtils.getVisibleProjects(rootPath).isEmpty();
    }

    @Override
    public void importToWorkspace(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager == null || preferencesManager.getPreferences() == null) {
            return;
        }
        Collection<IPath> triggerFiles = preferencesManager.getPreferences().getTriggerFiles();
        if (triggerFiles == null || triggerFiles.isEmpty()) {
            return;
        }
        IPath rootPath = ResourceUtils.filePathFromURI(this.rootFolder.toPath().toUri().toString());
        Optional<IPath> triggerJavaFile = triggerFiles.stream().filter(triggerFile -> rootPath.isPrefixOf(triggerFile)).findFirst();
        if (!triggerJavaFile.isPresent()) {
            return;
        }
        InvisibleProjectImporter.loadInvisibleProject(triggerJavaFile.get(), rootPath, true);
    }

    @Override
    public void reset() {
    }

    public static boolean loadInvisibleProject(IPath javaFile, IPath rootPath, boolean forceUpdateLibPath) {
        PreferenceManager preferencesManager;
        IPath sourcePath;
        if (!ProjectUtils.getVisibleProjects(rootPath).isEmpty()) {
            return false;
        }
        String packageName = InvisibleProjectImporter.getPackageName(javaFile, rootPath);
        IPath sourceDirectory = InvisibleProjectImporter.inferSourceDirectory(javaFile.toFile().toPath(), packageName);
        if (sourceDirectory == null || !rootPath.isPrefixOf(sourceDirectory) || InvisibleProjectImporter.isPartOfMatureProject(sourceDirectory)) {
            return false;
        }
        String invisibleProjectName = ProjectUtils.getWorkspaceInvisibleProjectName(rootPath);
        IProject invisibleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(invisibleProjectName);
        Path libFolder = new Path("lib");
        IFolder workspaceLinkFolder = invisibleProject.getFolder("_");
        IPath relativeSourcePath = sourceDirectory.makeRelativeTo(rootPath);
        IPath iPath = sourcePath = relativeSourcePath.isEmpty() ? workspaceLinkFolder.getFullPath() : workspaceLinkFolder.getFolder(relativeSourcePath).getFullPath();
        if (!invisibleProject.exists()) {
            try {
                JavaLanguageServerPlugin.logInfo("Try to create an invisible project for the workspace " + rootPath);
                invisibleProject = ProjectUtils.createInvisibleProjectIfNotExist(rootPath);
                List<IProject> subProjects = ProjectUtils.getVisibleProjects(rootPath);
                List<IPath> subProjectPaths = subProjects.stream().map(project -> {
                    IPath relativePath = project.getLocation().makeRelativeTo(rootPath);
                    return workspaceLinkFolder.getFolder(relativePath).getFullPath();
                }).collect(Collectors.toList());
                subProjectPaths.add((IPath)libFolder);
                IJavaProject javaProject = JavaCore.create((IProject)invisibleProject);
                ProjectUtils.addSourcePath(sourcePath, subProjectPaths.toArray(new IPath[0]), javaProject);
                JavaLanguageServerPlugin.logInfo("Successfully created a workspace invisible project " + invisibleProjectName);
                forceUpdateLibPath = true;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Failed to create the invisible project.", e);
                return false;
            }
        }
        if (forceUpdateLibPath && (preferencesManager = JavaLanguageServerPlugin.getPreferencesManager()) != null && preferencesManager.getPreferences() != null) {
            IJavaProject javaProject = JavaCore.create((IProject)invisibleProject);
            UpdateClasspathJob.getInstance().updateClasspath(javaProject, preferencesManager.getPreferences().getReferencedLibraries());
        }
        return true;
    }

    private static boolean isPartOfMatureProject(IPath sourcePath) {
        List<String> segments = Arrays.asList((sourcePath = sourcePath.removeTrailingSeparator()).segments());
        int index = segments.lastIndexOf("src");
        if (index <= 0) {
            return false;
        }
        IPath srcPath = sourcePath.removeLastSegments(segments.size() - 1 - index);
        IPath container = srcPath.removeLastSegments(1);
        return container.append("pom.xml").toFile().exists() || container.append("build.gradle").toFile().exists();
    }

    private static String getPackageName(IPath javaFile, IPath workspaceRoot) {
        return InvisibleProjectImporter.getPackageName(javaFile, workspaceRoot, SRC_PREFIXES);
    }

    private static String getPackageName(IPath javaFile, IPath workspaceRoot, String[][] srcPrefixes) {
        JavaLanguageServerPlugin.getProjectsManager();
        IProject project = ProjectsManager.getDefaultProject();
        if (project == null || !project.isAccessible()) {
            return "";
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return InvisibleProjectImporter.getPackageName(javaFile, workspaceRoot, javaProject, srcPrefixes);
    }

    public static String getPackageName(IPath javaFile, IPath workspaceRoot, IJavaProject javaProject) {
        return InvisibleProjectImporter.getPackageName(javaFile, workspaceRoot, javaProject, SRC_PREFIXES);
    }

    public static String getPackageName(IPath javaFile, IPath workspaceRoot, IJavaProject javaProject, String[][] srcPrefixes) {
        File nioFile = javaFile.toFile();
        try {
            String content = com.google.common.io.Files.toString((File)nioFile, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isBlank((CharSequence)content)) {
                File found = InvisibleProjectImporter.findNearbyNonEmptyFile(nioFile);
                if (found == null) {
                    return InvisibleProjectImporter.inferPackageNameFromPath(javaFile, workspaceRoot, srcPrefixes);
                }
                nioFile = found;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return JDTUtils.getPackageName(javaProject, nioFile.toURI());
    }

    private static File findNearbyNonEmptyFile(File nioFile) throws IOException {
        java.nio.file.Path directory = nioFile.getParentFile().toPath();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<java.nio.file.Path> walk = Files.walk(directory, 1, new FileVisitOption[0]);){
                Optional<java.nio.file.Path> found = walk.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(file2 -> {
                    try {
                        return file2.toString().endsWith(".java") && !Objects.equals(nioFile.getName(), file2.toFile().getName()) && Files.size(file2) > 0L;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }).findFirst();
                if (found.isPresent()) {
                    return found.get().toFile();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String inferPackageNameFromPath(IPath javaFile, IPath workspaceRoot, String[][] srcPrefixes) {
        IPath parentPath = javaFile.removeTrailingSeparator().removeLastSegments(1);
        IPath relativePath = parentPath.makeRelativeTo(workspaceRoot);
        List<String> segments = Arrays.asList(relativePath.segments());
        int i = 0;
        while (i < srcPrefixes.length) {
            int index = Collections.indexOfSubList(segments, Arrays.asList(srcPrefixes[i]));
            if (index > -1) {
                return String.join((CharSequence)".", segments.subList(index + srcPrefixes[i].length, segments.size()));
            }
            ++i;
        }
        return String.join((CharSequence)".", segments);
    }

    private static IPath inferSourceDirectory(java.nio.file.Path filePath, String packageName) {
        String packagePath = packageName.replace(".", "/");
        java.nio.file.Path sourcePath = filePath.getParent();
        if (StringUtils.isBlank((CharSequence)packagePath)) {
            return ResourceUtils.filePathFromURI(sourcePath.toUri().toString());
        }
        if (sourcePath.endsWith(Paths.get(packagePath, new String[0]))) {
            int packageCount = packageName.split("\\.").length;
            while (packageCount > 0) {
                sourcePath = sourcePath.getParent();
                --packageCount;
            }
            return ResourceUtils.filePathFromURI(sourcePath.toUri().toString());
        }
        return null;
    }

    public static IPath tryResolveSourceDirectory(IPath javaFile, IPath rootPath, String[][] potentialSrcPrefixes) {
        String packageName = InvisibleProjectImporter.getPackageName(javaFile, rootPath, potentialSrcPrefixes);
        return InvisibleProjectImporter.inferSourceDirectory(javaFile.toFile().toPath(), packageName);
    }
}

