/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.SynchronizationResult;
import org.eclipse.buildship.core.WrapperGradleDistribution;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.AbstractProjectImporter;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.BasicFileDetector;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jdt.ls.internal.gradle.checksums.ValidationResult;
import org.eclipse.jdt.ls.internal.gradle.checksums.WrapperValidator;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;

public class GradleProjectImporter
extends AbstractProjectImporter {
    public static final String GRADLE_HOME = "GRADLE_HOME";
    public static final String GRADLE_USER_HOME = "GRADLE_USER_HOME";
    public static final String BUILD_GRADLE_DESCRIPTOR = "build.gradle";
    public static final String SETTINGS_GRADLE_DESCRIPTOR = "settings.gradle";
    public static final GradleDistribution DEFAULT_DISTRIBUTION = GradleDistribution.forVersion((String)GradleVersion.current().getVersion());
    public static final String IMPORTING_GRADLE_PROJECTS = "Importing Gradle project(s)";
    public static final String GRADLE_WRAPPER_CHEKSUM_WARNING_TEMPLATE = "Security Warning! The gradle wrapper '@wrapper@' could be malicious. If you trust it, please add \n`{\"sha256\": \"@checksum@\",\n\"allowed\": true}`\n to the `java.import.gradle.wrapper.checksums` preference." + "".replaceAll("\n", System.lineSeparator());

    @Override
    public boolean applies(IProgressMonitor monitor) throws CoreException {
        if (this.rootFolder == null) {
            return false;
        }
        Preferences preferences = GradleProjectImporter.getPreferences();
        if (!preferences.isImportGradleEnabled()) {
            return false;
        }
        if (this.directories == null) {
            BasicFileDetector gradleDetector = new BasicFileDetector(this.rootFolder.toPath(), BUILD_GRADLE_DESCRIPTOR, SETTINGS_GRADLE_DESCRIPTOR).includeNested(false).addExclusions("**/build").addExclusions("**/bin");
            IProject[] iProjectArray = ProjectUtils.getAllProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (!ProjectUtils.isGradleProject(project)) {
                    String path = project.getLocation().toOSString();
                    gradleDetector.addExclusions(path);
                }
                ++n2;
            }
            this.directories = gradleDetector.scan(monitor);
        }
        return !this.directories.isEmpty();
    }

    @Override
    public void importToWorkspace(IProgressMonitor monitor) throws CoreException {
        if (!this.applies(monitor)) {
            return;
        }
        int projectSize = this.directories.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(projectSize + 1));
        subMonitor.setTaskName(IMPORTING_GRADLE_PROJECTS);
        JavaLanguageServerPlugin.logInfo(IMPORTING_GRADLE_PROJECTS);
        subMonitor.worked(1);
        this.directories.forEach(d -> this.importDir((Path)d, (IProgressMonitor)subMonitor.newChild(1)));
        ProjectUtils.getGradleProjects().forEach(project -> {
            File buildFile = project.getFile(BUILD_GRADLE_DESCRIPTOR).getLocation().toFile();
            File settingsFile = project.getFile(SETTINGS_GRADLE_DESCRIPTOR).getLocation().toFile();
            try {
                if (buildFile.exists()) {
                    JavaLanguageServerPlugin.getDigestStore().updateDigest(buildFile.toPath());
                }
                if (settingsFile.exists()) {
                    JavaLanguageServerPlugin.getDigestStore().updateDigest(settingsFile.toPath());
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Failed to update digest for gradle build file", e);
            }
        });
        subMonitor.done();
    }

    private void importDir(Path projectFolder, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        this.startSynchronization(projectFolder, monitor);
    }

    public static GradleDistribution getGradleDistribution(Path rootFolder) {
        File gradleHomeFile;
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        Preferences preferences = GradleProjectImporter.getPreferences();
        if (preferencesManager != null && preferences.isGradleWrapperEnabled() && Files.exists(rootFolder.resolve("gradlew"), new LinkOption[0])) {
            WrapperValidator validator = new WrapperValidator();
            try {
                ProjectsManager pm;
                ValidationResult result = validator.checkWrapper(rootFolder.toFile().getAbsolutePath());
                if (result.isValid()) {
                    WrapperGradleDistribution gradleDistribution = GradleDistribution.fromBuild();
                    return gradleDistribution;
                }
                if (!WrapperValidator.contains(result.getChecksum()) && (pm = JavaLanguageServerPlugin.getProjectsManager()) != null && pm.getConnection() != null) {
                    if (preferencesManager.getClientPreferences().isGradleChecksumWrapperPromptSupport()) {
                        String id = "gradle/checksum/prompt";
                        ExecuteCommandParams params = new ExecuteCommandParams(id, Arrays.asList(result.getWrapperJar(), result.getChecksum()));
                        pm.getConnection().sendNotification(params);
                    } else {
                        String message = GRADLE_WRAPPER_CHEKSUM_WARNING_TEMPLATE.replaceAll("@wrapper@", result.getWrapperJar()).replaceAll("@checksum@", result.getChecksum());
                        pm.getConnection().showMessage(new MessageParams(MessageType.Error, message));
                    }
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)preferences.getGradleVersion())) {
            List versions = CorePlugin.publishedGradleVersions().getVersions();
            GradleVersion gradleVersion = null;
            String versionString = preferences.getGradleVersion();
            GradleVersion requiredVersion = GradleVersion.version((String)versionString);
            for (GradleVersion version : versions) {
                if (version.compareTo(requiredVersion) != 0) continue;
                gradleVersion = version;
            }
            if (gradleVersion != null) {
                return GradleDistribution.forVersion((String)gradleVersion.getVersion());
            }
            JavaLanguageServerPlugin.logInfo("Invalid gradle version" + versionString);
        }
        if ((gradleHomeFile = GradleProjectImporter.getGradleHomeFile()) != null) {
            return GradleDistribution.forLocalInstallation((File)gradleHomeFile);
        }
        return DEFAULT_DISTRIBUTION;
    }

    public static File getGradleHomeFile() {
        Map<String, String> env = System.getenv();
        Properties sysprops = System.getProperties();
        return GradleProjectImporter.getGradleHomeFile(env, sysprops);
    }

    public static File getGradleHomeFile(Map<String, String> env, Properties sysprops) {
        File gradleHomeFile;
        Preferences preferences = GradleProjectImporter.getPreferences();
        if (StringUtils.isNotBlank((CharSequence)preferences.getGradleHome())) {
            return new File(preferences.getGradleHome());
        }
        String gradleHome = env.get(GRADLE_HOME);
        if (gradleHome == null || !new File(gradleHome).isDirectory()) {
            gradleHome = sysprops.getProperty(GRADLE_HOME);
        }
        if (gradleHome != null && (gradleHomeFile = new File(gradleHome)).isDirectory()) {
            return gradleHomeFile;
        }
        return null;
    }

    public static File getGradleUserHomeFile() {
        Preferences preferences = GradleProjectImporter.getPreferences();
        if (StringUtils.isNotBlank((CharSequence)preferences.getGradleUserHome())) {
            return new File(preferences.getGradleUserHome());
        }
        String gradleUserHome = System.getenv().get(GRADLE_USER_HOME);
        if (gradleUserHome == null) {
            gradleUserHome = System.getProperties().getProperty(GRADLE_USER_HOME);
        }
        return gradleUserHome == null || gradleUserHome.isEmpty() ? null : new File(gradleUserHome);
    }

    public static File getGradleJavaHomeFile() {
        File file;
        Preferences preferences = GradleProjectImporter.getPreferences();
        if (StringUtils.isNotBlank((CharSequence)preferences.getGradleJavaHome()) && (file = new File(preferences.getGradleJavaHome())).isDirectory()) {
            return file;
        }
        return null;
    }

    protected void startSynchronization(Path projectFolder, IProgressMonitor monitor) {
        File location = projectFolder.toFile();
        boolean shouldSynchronize = GradleProjectImporter.shouldSynchronize(location);
        if (shouldSynchronize) {
            BuildConfiguration build = GradleProjectImporter.getBuildConfiguration(projectFolder);
            SynchronizationResult result = GradleCore.getWorkspace().createBuild(build).synchronize(monitor);
            if (!result.getStatus().isOK()) {
                JavaLanguageServerPlugin.log(result.getStatus());
            }
        }
    }

    public static BuildConfiguration getBuildConfiguration(Path rootFolder) {
        GradleDistribution distribution = GradleProjectImporter.getGradleDistribution(rootFolder);
        File javaHome = GradleProjectImporter.getGradleJavaHomeFile();
        Preferences preferences = GradleProjectImporter.getPreferences();
        if (javaHome == null) {
            String javaHomeStr;
            IVMInstall javaDefaultRuntime = JavaRuntime.getDefaultVMInstall();
            javaHome = javaDefaultRuntime != null && javaDefaultRuntime.getVMRunner("run") != null ? javaDefaultRuntime.getInstallLocation() : ((javaHomeStr = preferences.getJavaHome()) == null ? null : new File(javaHomeStr));
        }
        File gradleUserHome = GradleProjectImporter.getGradleUserHomeFile();
        List<String> gradleArguments = preferences.getGradleArguments();
        List<String> gradleJvmArguments = preferences.getGradleJvmArguments();
        boolean offlineMode = preferences.isImportGradleOfflineEnabled();
        boolean overrideWorkspaceConfiguration = !(distribution instanceof WrapperGradleDistribution) || offlineMode || gradleArguments != null && !gradleArguments.isEmpty() || gradleJvmArguments != null && !gradleJvmArguments.isEmpty() || gradleUserHome != null || javaHome != null;
        BuildConfiguration build = BuildConfiguration.forRootProjectDirectory((File)rootFolder.toFile()).overrideWorkspaceConfiguration(overrideWorkspaceConfiguration).gradleDistribution(distribution).javaHome(javaHome).arguments(gradleArguments).gradleUserHome(gradleUserHome).jvmArguments(gradleJvmArguments).offlineMode(offlineMode).build();
        return build;
    }

    public static boolean shouldSynchronize(File location) {
        for (IProject project : ProjectUtils.getGradleProjects()) {
            File projectDir;
            File file = projectDir = project.getLocation() == null ? null : project.getLocation().toFile();
            if (!location.equals(projectDir)) continue;
            boolean shouldSynchronize = GradleProjectImporter.checkGradlePersistence(project, projectDir);
            if (shouldSynchronize) {
                JavaLanguageServerPlugin.logInfo(String.valueOf(project.getName()) + " was modified since last time the workspace was opened, must be synchronized");
            }
            return shouldSynchronize;
        }
        JavaLanguageServerPlugin.logInfo("No previous Gradle project at " + location + ", it must be synchronized");
        return true;
    }

    private static boolean checkGradlePersistence(IProject project, File projectDir) {
        File persistentFile;
        if (ProjectUtils.isJavaProject(project) && !project.getFile(".classpath").exists()) {
            return true;
        }
        boolean shouldSynchronize = true;
        PersistentModel model = CorePlugin.modelPersistence().loadModel(project);
        if (model.isPresent() && (persistentFile = CorePlugin.getInstance().getStateLocation().append("project-preferences").append(project.getName()).toFile()).exists()) {
            final long modified = persistentFile.lastModified();
            if (projectDir.exists()) {
                File[] files = projectDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        if (name != null && name.endsWith(".gradle")) {
                            return new File(dir, name).lastModified() > modified;
                        }
                        return false;
                    }
                });
                shouldSynchronize = files != null && files.length > 0;
            }
        }
        return shouldSynchronize;
    }

    @Override
    public void reset() {
    }
}

