/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.lsp4j.Location;

public class JavaElementLinks {
    private static final char LINK_BRACKET_REPLACEMENT = '\u2603';
    public static final String JAVADOC_SCHEME = "eclipse-javadoc";
    private static final char LINK_SEPARATOR = '\u2602';

    private JavaElementLinks() {
    }

    public static String createURI(String scheme, IJavaElement element) throws URISyntaxException {
        return JavaElementLinks.createURI(scheme, element, null, null, null, -1);
    }

    public static String createURI(String scheme, IJavaElement element, String refTypeName, String refMemberName, String[] refParameterTypes, int startPosition) throws URISyntaxException {
        URI javadocURI;
        IJavaElement linkTarget;
        StringBuffer ssp = new StringBuffer(60);
        ssp.append('\u2602');
        ssp.append(element.getHandleIdentifier().toString().replace('[', '\u2603'));
        if (refTypeName != null) {
            ssp.append('\u2602');
            ssp.append(refTypeName);
            if (refMemberName != null) {
                ssp.append('\u2602');
                ssp.append(refMemberName);
                if (refParameterTypes != null) {
                    ssp.append('\u2602');
                    int i = 0;
                    while (i < refParameterTypes.length) {
                        ssp.append(refParameterTypes[i]);
                        if (i != refParameterTypes.length - 1) {
                            ssp.append('\u2602');
                        }
                        ++i;
                    }
                }
            }
        }
        if ((linkTarget = JavaElementLinks.parseURI(javadocURI = new URI(JAVADOC_SCHEME, ssp.toString(), null))) == null) {
            return "";
        }
        try {
            Location locationToElement = JDTUtils.toLocation(linkTarget);
            if (locationToElement != null) {
                return String.valueOf(locationToElement.getUri()) + "#" + (locationToElement.getRange().getStart().getLine() + 1);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return "";
    }

    public static IJavaElement parseURI(URI uri) {
        String ssp = uri.getSchemeSpecificPart();
        String[] segments = ssp.split(String.valueOf('\u2602'), -1);
        IJavaElement element = JavaCore.create((String)segments[1].replace('\u2603', '['));
        if (segments.length > 2) {
            String refTypeName = segments[2];
            if (refTypeName.indexOf(46) == -1) {
                try {
                    ITypeParameter resolvedTypeVariable = JavaElementLinks.resolveTypeVariable(element, refTypeName);
                    if (resolvedTypeVariable != null) {
                        return resolvedTypeVariable;
                    }
                }
                catch (JavaModelException resolvedTypeVariable) {
                    // empty catch block
                }
            }
            if (element instanceof IAnnotation) {
                element = element.getParent();
            }
            if (element instanceof ILocalVariable) {
                element = ((ILocalVariable)element).getDeclaringMember();
            } else if (element instanceof ITypeParameter) {
                element = ((ITypeParameter)element).getDeclaringMember();
            }
            if (element instanceof IMember && !(element instanceof IType)) {
                element = ((IMember)element).getDeclaringType();
            }
            if (element instanceof IPackageFragment) {
                try {
                    IPackageFragment root = (IPackageFragment)element;
                    element = JavaElementLinks.resolvePackageInfoType(root, refTypeName);
                    if (element == null) {
                        IJavaProject javaProject = root.getJavaProject();
                        return JavaModelUtil.findTypeContainer((IJavaProject)javaProject, (String)refTypeName);
                    }
                }
                catch (JavaModelException root) {
                    // empty catch block
                }
            }
            if (element instanceof IType) {
                try {
                    IPackageFragment pack;
                    IType type = (IType)element;
                    if (refTypeName.length() > 0 && (type = JavaElementLinks.resolveType(type, refTypeName)) == null && (pack = JavaModelUtil.getPackageFragmentRoot((IJavaElement)element).getPackageFragment(refTypeName)).exists()) {
                        return pack;
                    }
                    if (type != null) {
                        element = type;
                        if (segments.length > 3) {
                            String refMemberName = segments[3];
                            if (segments.length > 4) {
                                String[] paramSignatures = new String[segments[4].length() == 0 ? 0 : segments.length - 4];
                                int i = 0;
                                while (i < paramSignatures.length) {
                                    paramSignatures[i] = Signature.createTypeSignature((String)segments[i + 4], (boolean)false);
                                    ++i;
                                }
                                IMethod method = type.getMethod(refMemberName, paramSignatures);
                                IMethod[] methods = type.findMethods(method);
                                if (methods != null) {
                                    return methods[0];
                                }
                                methods = type.getMethods();
                                int i2 = 0;
                                while (i2 < methods.length) {
                                    method = methods[i2];
                                    if (method.getElementName().equals(refMemberName) && method.getNumberOfParameters() == paramSignatures.length) {
                                        return method;
                                    }
                                    ++i2;
                                }
                                ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)type);
                                method = JavaModelUtil.findMethodInHierarchy((ITypeHierarchy)hierarchy, (IType)type, (String)refMemberName, (String[])paramSignatures, (boolean)false);
                                if (method != null) {
                                    return method;
                                }
                            } else {
                                IField field = type.getField(refMemberName);
                                if (field.exists()) {
                                    return field;
                                }
                                IMethod[] methods = type.getMethods();
                                int i = 0;
                                while (i < methods.length) {
                                    IMethod method = methods[i];
                                    if (method.getElementName().equals(refMemberName)) {
                                        return method;
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                    return type;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
        return element;
    }

    private static IType resolvePackageInfoType(IPackageFragment pack, String refTypeName) throws JavaModelException {
        IJavaProject javaProject = pack.getJavaProject();
        return javaProject.findType(refTypeName, null);
    }

    private static ITypeParameter resolveTypeVariable(IJavaElement baseElement, String typeVariableName) throws JavaModelException {
        while (baseElement != null) {
            switch (baseElement.getElementType()) {
                case 9: {
                    IMethod method = (IMethod)baseElement;
                    ITypeParameter[] typeParameters = method.getTypeParameters();
                    int i = 0;
                    while (i < typeParameters.length) {
                        ITypeParameter typeParameter = typeParameters[i];
                        if (typeParameter.getElementName().equals(typeVariableName)) {
                            return typeParameter;
                        }
                        ++i;
                    }
                    break;
                }
                case 7: {
                    IType type = (IType)baseElement;
                    ITypeParameter[] typeParameters = type.getTypeParameters();
                    int i = 0;
                    while (i < typeParameters.length) {
                        ITypeParameter typeParameter = typeParameters[i];
                        if (typeParameter.getElementName().equals(typeVariableName)) {
                            return typeParameter;
                        }
                        ++i;
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: 
                case 12: 
                case 13: {
                    return null;
                }
            }
            baseElement = baseElement.getParent();
        }
        return null;
    }

    private static IType resolveType(IType baseType, String refTypeName) throws JavaModelException {
        if (refTypeName.length() == 0) {
            return baseType;
        }
        String[][] resolvedNames = baseType.resolveType(refTypeName);
        if (resolvedNames != null && resolvedNames.length > 0) {
            return baseType.getJavaProject().findType(resolvedNames[0][0], resolvedNames[0][1].replace('$', '.'), null);
        }
        if (baseType.isBinary()) {
            IType type = baseType.getJavaProject().findType(refTypeName, null);
            if (type == null) {
                type = baseType.getJavaProject().findType(String.valueOf(baseType.getPackageFragment().getElementName()) + '.' + refTypeName, null);
            }
            return type;
        }
        return null;
    }

    public static String createLink(String uri, String label) {
        return "<a href='" + uri + "'>" + label + "</a>";
    }

    public static String createHeaderLink(String uri, String label) {
        return JavaElementLinks.createHeaderLink(uri, label, "");
    }

    public static String createHeaderLink(String uri, String label, String title) {
        if (title.length() > 0) {
            title = " title='" + title + "'";
        }
        return "<a class='header' href='" + uri + "'" + title + ">" + label + "</a>";
    }

    public static interface ILinkHandler {
        public void handleInlineJavadocLink(IJavaElement var1);

        public void handleJavadocViewLink(IJavaElement var1);

        public void handleDeclarationLink(IJavaElement var1);

        public void handleTextSet();
    }
}

