/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.internal.resources.CheckMissingNaturesListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.DiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.ClientPreferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.m2e.core.internal.Messages;

public final class WorkspaceDiagnosticsHandler
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public static final String PROJECT_CONFIGURATION_IS_NOT_UP_TO_DATE_WITH_POM_XML = "Project configuration is not up-to-date with pom.xml, requires an update.";
    private final JavaClientConnection connection;
    private final ProjectsManager projectsManager;
    private final boolean isDiagnosticTagSupported;

    @Deprecated
    public WorkspaceDiagnosticsHandler(JavaClientConnection connection, ProjectsManager projectsManager) {
        this(connection, projectsManager, null);
    }

    public WorkspaceDiagnosticsHandler(JavaClientConnection connection, ProjectsManager projectsManager, ClientPreferences prefs) {
        this.connection = connection;
        this.projectsManager = projectsManager;
        this.isDiagnosticTagSupported = prefs != null ? prefs.isDiagnosticTagSupported() : false;
    }

    public void addResourceChangeListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void removeResourceChangeListener() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            delta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("failed to send diagnostics", e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if (resource.getType() == 2 || resource.getType() == 8) {
            return true;
        }
        if (!resource.isAccessible()) {
            if (this.isSupportedDiagnosticsResource(resource)) {
                this.cleanUpDiagnostics(resource);
                return resource.getType() == 4;
            }
            if (this.projectsManager.isBuildLikeFileName(resource.getName())) {
                this.cleanUpDiagnostics(resource);
                if (!resource.getParent().isAccessible()) {
                    this.cleanUpDiagnostics((IResource)resource.getParent(), "win32".equals(Platform.getOS()));
                }
            }
            return false;
        }
        if (resource.getType() == 4) {
            JavaLanguageServerPlugin.getProjectsManager();
            if (ProjectsManager.getDefaultProject().equals((Object)resource.getProject())) {
                return false;
            }
            IProject project = (IProject)resource;
            IMarker[] markers = project.findMarkers(null, true, 0);
            this.publishMarkers(project, markers);
            return true;
        }
        if ((delta.getFlags() & 0x20000) == 0) {
            return false;
        }
        IFile file = (IFile)resource;
        IDocument document = null;
        IMarker[] markers = null;
        if (JavaCore.isJavaLikeFileName((String)file.getName())) {
            ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IFile)file);
            IJavaProject javaProject = cu.getJavaProject();
            if (javaProject == null || !javaProject.isOnClasspath((IJavaElement)cu)) {
                String uri = JDTUtils.getFileURI(resource);
                this.connection.publishDiagnostics(new PublishDiagnosticsParams(ResourceUtils.toClientUri(uri), Collections.emptyList()));
                return false;
            }
            IMarker[] javaMarkers = resource.findMarkers("org.eclipse.jdt.core.problem", false, 1);
            IMarker[] taskMarkers = resource.findMarkers("org.eclipse.jdt.core.task", false, 1);
            markers = Arrays.copyOf(javaMarkers, javaMarkers.length + taskMarkers.length);
            System.arraycopy(taskMarkers, 0, markers, javaMarkers.length, taskMarkers.length);
            document = JsonRpcHelpers.toDocument(cu.getBuffer());
        } else if (this.projectsManager.isBuildFile((IResource)file)) {
            markers = file.findMarkers(null, true, 1);
            document = JsonRpcHelpers.toDocument(file);
        }
        if (document != null) {
            String uri = JDTUtils.getFileURI(resource);
            this.connection.publishDiagnostics(new PublishDiagnosticsParams(ResourceUtils.toClientUri(uri), WorkspaceDiagnosticsHandler.toDiagnosticsArray(document, markers, this.isDiagnosticTagSupported)));
        }
        return false;
    }

    private void publishMarkers(IProject project, IMarker[] markers) throws CoreException {
        Range range = new Range(new Position(0, 0), new Position(0, 0));
        ArrayList<IMarker> projectMarkers = new ArrayList<IMarker>(markers.length);
        String uri = JDTUtils.getFileURI((IResource)project);
        IFile pom = project.getFile("pom.xml");
        ArrayList<IMarker> pomMarkers = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.exists() && !CheckMissingNaturesListener.MARKER_TYPE.equals(marker.getType())) {
                if ("org.eclipse.m2e.core.maven2Problem.configuration".equals(marker.getType())) {
                    pomMarkers.add(marker);
                } else {
                    projectMarkers.add(marker);
                }
            }
            ++n2;
        }
        List<Diagnostic> diagnostics = WorkspaceDiagnosticsHandler.toDiagnosticArray(range, projectMarkers, this.isDiagnosticTagSupported);
        String clientUri = ResourceUtils.toClientUri(uri);
        this.connection.publishDiagnostics(new PublishDiagnosticsParams(clientUri, diagnostics));
        if (pom.exists()) {
            IDocument document = JsonRpcHelpers.toDocument(pom);
            diagnostics = WorkspaceDiagnosticsHandler.toDiagnosticsArray(document, pom.findMarkers(null, true, 0), this.isDiagnosticTagSupported);
            List<Diagnostic> diagnosicts2 = WorkspaceDiagnosticsHandler.toDiagnosticArray(range, pomMarkers, this.isDiagnosticTagSupported);
            diagnostics.addAll(diagnosicts2);
            String pomSuffix = clientUri.endsWith("/") ? "pom.xml" : "/pom.xml";
            this.connection.publishDiagnostics(new PublishDiagnosticsParams(ResourceUtils.toClientUri(String.valueOf(clientUri) + pomSuffix), diagnostics));
        }
    }

    public List<IMarker> publishDiagnostics(IProgressMonitor monitor) throws CoreException {
        List<IMarker> problemMarkers = this.getProblemMarkers(monitor);
        this.publishDiagnostics(problemMarkers);
        return problemMarkers;
    }

    private List<IMarker> getProblemMarkers(IProgressMonitor monitor) throws CoreException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            JavaLanguageServerPlugin.getProjectsManager();
            if (!ProjectsManager.getDefaultProject().equals((Object)project)) {
                IMarker[] allMarkers;
                IMarker[] iMarkerArray = allMarkers = project.findMarkers(null, true, 2);
                int n3 = allMarkers.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMarker marker = iMarkerArray[n4];
                    if (marker.exists() && !CheckMissingNaturesListener.MARKER_TYPE.equals(marker.getType())) {
                        if ("org.eclipse.jdt.core.problem".equals(marker.getType()) || "org.eclipse.jdt.core.task".equals(marker.getType())) {
                            markers.add(marker);
                        } else {
                            IResource resource = marker.getResource();
                            if (project.equals((Object)resource) || this.projectsManager.isBuildFile(resource)) {
                                markers.add(marker);
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return markers;
    }

    private void publishDiagnostics(List<IMarker> markers) {
        Map<IResource, List<IMarker>> map = markers.stream().collect(Collectors.groupingBy(IMarker::getResource));
        for (Map.Entry<IResource, List<IMarker>> entry : map.entrySet()) {
            IResource resource = entry.getKey();
            if (resource instanceof IProject) {
                try {
                    IProject project = (IProject)resource;
                    this.publishMarkers(project, entry.getValue().toArray(new IMarker[0]));
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
                continue;
            }
            IFile file = (IFile)resource.getAdapter(IFile.class);
            if (file == null) continue;
            IDocument document = null;
            String uri = JDTUtils.getFileURI((IResource)file);
            if (JavaCore.isJavaLikeFileName((String)file.getName())) {
                ICompilationUnit cu = JDTUtils.resolveCompilationUnit(uri);
                if (cu != null && !cu.isWorkingCopy()) {
                    try {
                        document = JsonRpcHelpers.toDocument(cu.getBuffer());
                    }
                    catch (JavaModelException e) {
                        JavaLanguageServerPlugin.logException("Failed to publish diagnostics for " + uri, e);
                    }
                }
            } else if (this.projectsManager.isBuildFile((IResource)file)) {
                document = JsonRpcHelpers.toDocument(file);
            }
            if (document == null) continue;
            List<Diagnostic> diagnostics = WorkspaceDiagnosticsHandler.toDiagnosticsArray(document, entry.getValue().toArray(new IMarker[0]), this.isDiagnosticTagSupported);
            this.connection.publishDiagnostics(new PublishDiagnosticsParams(ResourceUtils.toClientUri(uri), diagnostics));
        }
    }

    @Deprecated
    public static List<Diagnostic> toDiagnosticArray(Range range, Collection<IMarker> markers) {
        return WorkspaceDiagnosticsHandler.toDiagnosticArray(range, markers, false);
    }

    public static List<Diagnostic> toDiagnosticArray(Range range, Collection<IMarker> markers, boolean isDiagnosticTagSupported) {
        List<Diagnostic> diagnostics = markers.stream().map(m -> WorkspaceDiagnosticsHandler.toDiagnostic(range, m, isDiagnosticTagSupported)).filter(d -> d != null).collect(Collectors.toList());
        return diagnostics;
    }

    private static Diagnostic toDiagnostic(Range range, IMarker marker, boolean isDiagnosticTagSupported) {
        if (marker == null || !marker.exists()) {
            return null;
        }
        Diagnostic d = new Diagnostic();
        d.setSource("Java");
        String message = marker.getAttribute("message", "");
        if (Messages.ProjectConfigurationUpdateRequired.equals(message)) {
            message = PROJECT_CONFIGURATION_IS_NOT_UP_TO_DATE_WITH_POM_XML;
        }
        d.setMessage(message);
        d.setSeverity(WorkspaceDiagnosticsHandler.convertSeverity(marker.getAttribute("severity", -1)));
        int problemId = marker.getAttribute("id", 0);
        d.setCode(String.valueOf(problemId));
        if (isDiagnosticTagSupported) {
            d.setTags(DiagnosticsHandler.getDiagnosticTag(problemId));
        }
        d.setRange(range);
        return d;
    }

    @Deprecated
    public static List<Diagnostic> toDiagnosticsArray(IDocument document, IMarker[] markers) {
        return WorkspaceDiagnosticsHandler.toDiagnosticsArray(document, markers, false);
    }

    public static List<Diagnostic> toDiagnosticsArray(IDocument document, IMarker[] markers, boolean isDiagnosticTagSupported) {
        List<Diagnostic> diagnostics = Stream.of(markers).map(m -> WorkspaceDiagnosticsHandler.toDiagnostic(document, m, isDiagnosticTagSupported)).filter(d -> d != null).collect(Collectors.toList());
        return diagnostics;
    }

    private static Diagnostic toDiagnostic(IDocument document, IMarker marker, boolean isDiagnosticTagSupported) {
        if (marker == null || !marker.exists()) {
            return null;
        }
        Diagnostic d = new Diagnostic();
        d.setSource("Java");
        d.setMessage(marker.getAttribute("message", ""));
        int problemId = marker.getAttribute("id", 0);
        d.setCode(String.valueOf(problemId));
        d.setSeverity(WorkspaceDiagnosticsHandler.convertSeverity(marker.getAttribute("severity", -1)));
        d.setRange(WorkspaceDiagnosticsHandler.convertRange(document, marker));
        if (isDiagnosticTagSupported) {
            d.setTags(DiagnosticsHandler.getDiagnosticTag(problemId));
        }
        return d;
    }

    private static Range convertRange(IDocument document, IMarker marker) {
        int cEnd;
        int cStart;
        int line;
        block7: {
            line = marker.getAttribute("lineNumber", -1) - 1;
            if (line < 0) {
                int end = marker.getAttribute("charEnd", -1);
                int start = marker.getAttribute("charStart", -1);
                if (start >= 0 && end >= start) {
                    int[] startPos = JsonRpcHelpers.toLine(document, start);
                    int[] endPos = JsonRpcHelpers.toLine(document, end);
                    return new Range(new Position(startPos[0], startPos[1]), new Position(endPos[0], endPos[1]));
                }
                return new Range(new Position(0, 0), new Position(0, 0));
            }
            cStart = 0;
            cEnd = 0;
            try {
                if (marker.isSubtypeOf("org.eclipse.m2e.core.maven2Problem")) {
                    cStart = marker.getAttribute("columnStart", -1);
                    cEnd = marker.getAttribute("columnEnd", -1);
                    break block7;
                }
                int lineOffset = 0;
                try {
                    lineOffset = document.getLineOffset(line);
                }
                catch (BadLocationException unlikelyException) {
                    JavaLanguageServerPlugin.logException(unlikelyException.getMessage(), unlikelyException);
                    return new Range(new Position(line, 0), new Position(line, 0));
                }
                cEnd = marker.getAttribute("charEnd", -1) - lineOffset;
                cStart = marker.getAttribute("charStart", -1) - lineOffset;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        cStart = Math.max(0, cStart);
        cEnd = Math.max(0, cEnd);
        return new Range(new Position(line, cStart), new Position(line, cEnd));
    }

    private static DiagnosticSeverity convertSeverity(int severity) {
        if (severity == 2) {
            return DiagnosticSeverity.Error;
        }
        if (severity == 1) {
            return DiagnosticSeverity.Warning;
        }
        return DiagnosticSeverity.Information;
    }

    private void cleanUpDiagnostics(IResource resource) {
        this.cleanUpDiagnostics(resource, false);
    }

    private void cleanUpDiagnostics(IResource resource, boolean addTrailingSlash) {
        String uri = JDTUtils.getFileURI(resource);
        if (uri != null) {
            if (addTrailingSlash && !uri.endsWith("/")) {
                uri = String.valueOf(uri) + "/";
            }
            this.connection.publishDiagnostics(new PublishDiagnosticsParams(ResourceUtils.toClientUri(uri), Collections.emptyList()));
        }
    }

    private boolean isSupportedDiagnosticsResource(IResource resource) {
        if (resource.getType() == 4) {
            return true;
        }
        IFile file = (IFile)resource;
        return JavaCore.isJavaLikeFileName((String)file.getName()) || this.projectsManager.isBuildFile((IResource)file);
    }
}

