/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.SignatureHelpRequestor;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SignatureInformation;

public class SignatureHelpHandler {
    private static final int SEARCH_BOUND = 2000;
    private PreferenceManager preferenceManager;

    public static SignatureHelpOptions createOptions() {
        return new SignatureHelpOptions(Arrays.asList("(", ","));
    }

    public SignatureHelpHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public SignatureHelp signatureHelp(SignatureHelpParams position, IProgressMonitor monitor) {
        SignatureHelp help = new SignatureHelp();
        if (!this.preferenceManager.getPreferences(null).isSignatureHelpEnabled()) {
            return help;
        }
        try {
            ICompilationUnit unit = JDTUtils.resolveCompilationUnit(position.getTextDocument().getUri());
            int offset = JsonRpcHelpers.toOffset(unit.getBuffer(), position.getPosition().getLine(), position.getPosition().getCharacter());
            int[] contextInfomation = this.getContextInfomation(unit.getBuffer(), offset);
            ASTNode node = this.getNode(unit, contextInfomation, monitor);
            if (node == null) {
                return help;
            }
            SignatureHelpRequestor collector = new SignatureHelpRequestor(unit, contextInfomation[0] + 1);
            if (offset > -1 && !monitor.isCanceled()) {
                unit.codeComplete(contextInfomation[0] + 1, (CompletionRequestor)collector, monitor);
                help = collector.getSignatureHelp(monitor);
                IMethod method = this.getMethod(node);
                if (help.getSignatures().isEmpty()) {
                    int pos = offset;
                    if (method != null) {
                        int start = node.getStartPosition();
                        pos = start + method.getElementName().length();
                    }
                    unit.codeComplete(pos, (CompletionRequestor)collector, monitor);
                    help = collector.getSignatureHelp(monitor);
                }
                if (!monitor.isCanceled() && help != null) {
                    int activeParameter;
                    SignatureHelp help2 = null;
                    SignatureHelpRequestor collector2 = null;
                    if (contextInfomation[0] + 1 != offset) {
                        collector2 = new SignatureHelpRequestor(unit, offset);
                        unit.codeComplete(offset, (CompletionRequestor)collector2, monitor);
                        help2 = collector2.getSignatureHelp(monitor);
                    }
                    int currentParameter = contextInfomation[1];
                    int size = currentParameter + 1;
                    List infos = help.getSignatures();
                    int n = activeParameter = currentParameter < 0 ? 0 : currentParameter;
                    if (node != null) {
                        CompletionProposal proposal;
                        IMethod m;
                        int i;
                        IJavaProject javaProject = unit.getJavaProject();
                        if (help2 != null) {
                            if (method != null) {
                                i = 0;
                                while (i < infos.size()) {
                                    if (((SignatureInformation)infos.get(i)).getParameters().size() >= size && this.isSameParameters(m = JDTUtils.resolveMethod(proposal = collector.getInfoProposals().get(infos.get(i)), javaProject), method)) {
                                        help.setActiveSignature(Integer.valueOf(i));
                                        help.setActiveParameter(Integer.valueOf(activeParameter));
                                        return help;
                                    }
                                    ++i;
                                }
                            }
                            if (!monitor.isCanceled() && help.getActiveSignature() == null) {
                                i = 0;
                                while (i < infos.size()) {
                                    if (((SignatureInformation)infos.get(i)).getParameters().size() >= size && this.isSameParameters(m = JDTUtils.resolveMethod(proposal = collector.getInfoProposals().get(infos.get(i)), javaProject), help2, collector2, javaProject)) {
                                        help.setActiveSignature(Integer.valueOf(i));
                                        help.setActiveParameter(Integer.valueOf(activeParameter));
                                        return help;
                                    }
                                    ++i;
                                }
                            }
                        }
                        if (!monitor.isCanceled() && help.getActiveSignature() == null && method != null) {
                            i = 0;
                            while (i < infos.size()) {
                                if (((SignatureInformation)infos.get(i)).getParameters().size() >= size && this.isSameParameters(method, m = JDTUtils.resolveMethod(proposal = collector.getInfoProposals().get(infos.get(i)), javaProject))) {
                                    help.setActiveSignature(Integer.valueOf(i));
                                    help.setActiveParameter(Integer.valueOf(activeParameter));
                                    return help;
                                }
                                ++i;
                            }
                        }
                        if (!monitor.isCanceled() && help.getActiveSignature() == null) {
                            i = 0;
                            while (i < infos.size()) {
                                proposal = collector.getInfoProposals().get(infos.get(i));
                                if (Flags.isVarargs((int)proposal.getFlags())) {
                                    help.setActiveSignature(Integer.valueOf(i));
                                    char[][] infoTypes = Signature.getParameterTypes((char[])SignatureUtil.fix83600((char[])proposal.getSignature()));
                                    if (infoTypes.length <= activeParameter) {
                                        help.setActiveParameter(Integer.valueOf(infoTypes.length - 1));
                                    } else {
                                        help.setActiveParameter(Integer.valueOf(activeParameter));
                                    }
                                    return help;
                                }
                                ++i;
                            }
                        }
                        if (!monitor.isCanceled() && help.getActiveSignature() == null && node instanceof Block) {
                            i = 0;
                            while (i < infos.size()) {
                                if (((SignatureInformation)infos.get(i)).getParameters().size() >= activeParameter) {
                                    help.setActiveSignature(Integer.valueOf(i));
                                    help.setActiveParameter(Integer.valueOf(activeParameter));
                                    return help;
                                }
                                ++i;
                            }
                        }
                    }
                }
            }
        }
        catch (CoreException ex) {
            JavaLanguageServerPlugin.logException("Find signatureHelp failure ", ex);
        }
        return help;
    }

    private boolean isSameParameters(IMethod m, SignatureHelp help, SignatureHelpRequestor collector, IJavaProject javaProject) throws JavaModelException {
        if (m == null || help == null || javaProject == null) {
            return false;
        }
        List infos = help.getSignatures();
        int i = 0;
        while (i < infos.size()) {
            CompletionProposal proposal = collector.getInfoProposals().get(infos.get(i));
            IMethod method = JDTUtils.resolveMethod(proposal, javaProject);
            if (this.isSameParameters(method, m)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isSameParameters(IMethod method1, IMethod method2) {
        if (method1 == null || method2 == null) {
            return false;
        }
        String[] params1 = method1.getParameterTypes();
        String[] params2 = method2.getParameterTypes();
        if (params2.length == params1.length) {
            int i = 0;
            while (i < params2.length) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)params2[i]));
                if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)params1[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private IMethod getMethod(ASTNode node) throws JavaModelException {
        IJavaElement javaElement;
        Object binding = node instanceof MethodInvocation ? ((MethodInvocation)node).resolveMethodBinding() : (node instanceof MethodRef ? ((MethodRef)node).resolveBinding() : (node instanceof ClassInstanceCreation ? ((ClassInstanceCreation)node).resolveConstructorBinding() : null));
        if (binding != null && (javaElement = binding.getJavaElement()) instanceof IMethod) {
            IMethod method = (IMethod)javaElement;
            return method;
        }
        return null;
    }

    private ASTNode getNode(ICompilationUnit unit, int[] contextInfomation, IProgressMonitor monitor) {
        if (contextInfomation[0] != -1) {
            CompilationUnit ast = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
            ASTNode node = NodeFinder.perform((ASTNode)ast, (int)contextInfomation[0], (int)1);
            if (node instanceof MethodInvocation || node instanceof ClassInstanceCreation || node instanceof MethodRef) {
                return node;
            }
            if (node instanceof Block) {
                try {
                    int pos = contextInfomation[0];
                    IBuffer buffer = unit.getBuffer();
                    while (pos >= 0) {
                        char ch = buffer.getChar(pos);
                        if (ch != '(' && !Character.isWhitespace(ch)) break;
                        --pos;
                    }
                    int end = pos + 1;
                    while (pos >= 0) {
                        char ch = buffer.getChar(pos);
                        if (!Character.isJavaIdentifierPart(ch)) break;
                        --pos;
                    }
                    int start = pos + 1;
                    String name = unit.getSource().substring(start, end);
                    IStatus status = JavaConventionsUtil.validateMethodName((String)name, (IJavaElement)unit);
                    if (status.isOK()) {
                        return node;
                    }
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
            if (node instanceof Expression && ((node = node.getParent()) instanceof MethodInvocation || node instanceof ClassInstanceCreation || node instanceof MethodRef)) {
                return node;
            }
        }
        return null;
    }

    private int[] getContextInfomation(IBuffer buffer, int offset) {
        int[] result = new int[2];
        result[1] = -1;
        result[0] = -1;
        int depth = 1;
        int i = offset - 1;
        while (i >= 0 && offset - i < 2000) {
            char c = buffer.getChar(i);
            if (c == '{' || c == '}') {
                result[1] = -1;
                result[0] = -1;
                return result;
            }
            if (c == ')') {
                ++depth;
            }
            if (c == '(') {
                --depth;
            }
            if (c == ',' && depth == 1) {
                result[1] = result[1] + 1;
            }
            if (depth == 0) {
                result[0] = i;
                break;
            }
            --i;
        }
        if (result[0] + 1 != offset) {
            i = 1;
            while (result[0] + i < offset) {
                if (!Character.isWhitespace(buffer.getChar(result[0] + i))) {
                    result[1] = result[1] + 1;
                    break;
                }
                ++i;
            }
        }
        return result;
    }
}

