/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;

public class JdtSourceLookUpProvider {
    public String getSourceFileURI(String fullyQualifiedName, String sourcePath, List<String> projectNames) {
        if (sourcePath == null) {
            return null;
        }
        Object sourceElement = this.findSourceElement(sourcePath, this.getSourceContainers(projectNames));
        if (sourceElement instanceof IResource) {
            return JDTUtils.getFileURI((IResource)sourceElement);
        }
        if (sourceElement instanceof IClassFile) {
            return JDTUtils.toUri((IClassFile)sourceElement);
        }
        return null;
    }

    private Object findSourceElement(String sourcePath, ISourceContainer[] containers) {
        if (containers == null) {
            return null;
        }
        ISourceContainer[] iSourceContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainer container = iSourceContainerArray[n2];
            try {
                Object[] objects = container.findSourceElements(sourcePath);
                if (objects.length > 0 && (objects[0] instanceof IResource || objects[0] instanceof IClassFile)) {
                    return objects[0];
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Failed to find the source elements", e);
            }
            ++n2;
        }
        return null;
    }

    private ISourceContainer[] getSourceContainers(List<String> projectNames) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        if (projectNames == null || projectNames.size() == 0) {
            projects.addAll(Arrays.asList(ProjectUtils.getAllProjects()));
        } else {
            for (String projectName : projectNames) {
                projects.add(ProjectUtils.getProject(projectName));
            }
        }
        LinkedHashSet containers = new LinkedHashSet();
        LinkedHashSet calculated = new LinkedHashSet();
        projects.stream().map(project -> ProjectUtils.getJavaProject(project)).filter(javaProject -> javaProject != null && javaProject.exists()).forEach(javaProject -> {
            containers.addAll(Arrays.asList(this.getSourceContainers((IJavaProject)javaProject, calculated)));
            containers.add(new JavaProjectSourceContainer(javaProject));
        });
        return containers.toArray(new ISourceContainer[0]);
    }

    private ISourceContainer[] getSourceContainers(IJavaProject project, Set<IRuntimeClasspathEntry> calculated) {
        if (project == null || !project.exists()) {
            return new ISourceContainer[0];
        }
        try {
            IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)project);
            ArrayList<IRuntimeClasspathEntry> resolved = new ArrayList<IRuntimeClasspathEntry>();
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = unresolved;
            int n = unresolved.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray2 = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entry, (IJavaProject)project);
                int n3 = iRuntimeClasspathEntryArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IRuntimeClasspathEntry resolvedEntry = iRuntimeClasspathEntryArray2[n4];
                    if (!calculated.contains(resolvedEntry)) {
                        calculated.add(resolvedEntry);
                        resolved.add(resolvedEntry);
                    }
                    ++n4;
                }
                ++n2;
            }
            LinkedHashSet<ISourceContainer> containers = new LinkedHashSet<ISourceContainer>();
            containers.addAll(Arrays.asList(JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved.toArray(new IRuntimeClasspathEntry[0]))));
            return containers.toArray(new ISourceContainer[0]);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Failed to find the source elements for project: " + project.getElementName(), e);
            return new ISourceContainer[0];
        }
    }
}

