/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.IntroduceParameterRefactoring;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.InnovationContext;
import org.eclipse.jdt.ls.core.internal.corrections.InvertBooleanUtility;
import org.eclipse.jdt.ls.core.internal.corrections.RefactorProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.RefactoringCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.FormatterHandler;
import org.eclipse.jdt.ls.core.internal.handlers.InferSelectionHandler;
import org.eclipse.jdt.ls.core.internal.text.correction.RefactorProposalUtility;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.ltk.core.refactoring.Change;

public class GetRefactorEditHandler {
    public static final String RENAME_COMMAND = "java.action.rename";
    private static final String DEFAULT_POSITION_KEY = "name";

    public static RefactorWorkspaceEdit getEditsForRefactor(GetRefactorEditParams params) {
        LinkedCorrectionProposal proposal;
        String positionKey;
        ICompilationUnit unit;
        block29: {
            String initializeIn;
            InferSelectionHandler.SelectionInfo info;
            unit = JDTUtils.resolveCompilationUnit(params.context.getTextDocument().getUri());
            if (unit == null) {
                return null;
            }
            int start = DiagnosticsHelper.getStartOffset(unit, params.context.getRange());
            int end = DiagnosticsHelper.getEndOffset(unit, params.context.getRange());
            InnovationContext context = new InnovationContext(unit, start, end - start);
            context.setASTRoot(CodeActionHandler.getASTRoot(unit));
            IProblemLocationCore[] locations = CodeActionHandler.getProblemLocationCores(unit, params.context.getContext().getDiagnostics());
            boolean problemsAtLocation = locations.length != 0;
            positionKey = DEFAULT_POSITION_KEY;
            Map<String, String> formatterOptions = params.options == null ? null : FormatterHandler.getOptions(params.options, unit);
            proposal = null;
            if ("extractVariable".equals(params.command) || "extractVariableAllOccurrence".equals(params.command) || "extractConstant".equals(params.command)) {
                InferSelectionHandler.SelectionInfo selectionInfo = info = params.commandArguments != null && !params.commandArguments.isEmpty() ? JSONUtility.toModel(params.commandArguments.get(0), InferSelectionHandler.SelectionInfo.class) : null;
                if (info != null) {
                    context = new InnovationContext(unit, info.offset, info.length);
                }
                proposal = (LinkedCorrectionProposal)GetRefactorEditHandler.getExtractVariableProposal(params.context, context, problemsAtLocation, params.command, formatterOptions);
            } else if ("assignVariable".equals(params.command)) {
                proposal = (LinkedCorrectionProposal)GetRefactorEditHandler.getAssignVariableProposal(params, context, problemsAtLocation, params.command, formatterOptions, locations);
            } else if ("assignField".equals(params.command)) {
                proposal = (LinkedCorrectionProposal)RefactorProposalUtility.getAssignFieldProposal(params.context, context, problemsAtLocation, formatterOptions, false, locations);
            } else if ("extractMethod".equals(params.command)) {
                InferSelectionHandler.SelectionInfo selectionInfo = info = params.commandArguments != null && !params.commandArguments.isEmpty() ? JSONUtility.toModel(params.commandArguments.get(0), InferSelectionHandler.SelectionInfo.class) : null;
                if (info != null) {
                    context = new InnovationContext(unit, info.offset, info.length);
                }
                proposal = (LinkedCorrectionProposal)GetRefactorEditHandler.getExtractMethodProposal(params.context, context, context.getCoveringNode(), problemsAtLocation, formatterOptions);
            } else if ("convertVariableToField".equals(params.command)) {
                initializeIn = params.commandArguments != null && !params.commandArguments.isEmpty() ? JSONUtility.toModel(params.commandArguments.get(0), String.class) : null;
                proposal = (LinkedCorrectionProposal)RefactorProposalUtility.getConvertVariableToFieldProposal(params.context, context, problemsAtLocation, formatterOptions, initializeIn, false);
            } else if ("extractField".equals(params.command)) {
                InferSelectionHandler.SelectionInfo info2;
                initializeIn = params.commandArguments != null && !params.commandArguments.isEmpty() ? JSONUtility.toModel(params.commandArguments.get(0), String.class) : null;
                InferSelectionHandler.SelectionInfo selectionInfo = info2 = params.commandArguments != null && params.commandArguments.size() > 1 ? JSONUtility.toModel(params.commandArguments.get(1), InferSelectionHandler.SelectionInfo.class) : null;
                if (info2 != null) {
                    context = new InnovationContext(unit, info2.offset, info2.length);
                }
                proposal = (LinkedCorrectionProposal)RefactorProposalUtility.getExtractFieldProposal(params.context, context, problemsAtLocation, formatterOptions, initializeIn, false);
            } else if ("invertVariable".equals(params.command)) {
                proposal = (LinkedCorrectionProposal)InvertBooleanUtility.getInvertVariableProposal(params.context, context, context.getCoveringNode(), false);
            } else if ("convertAnonymousClassToNestedCommand".equals(params.command)) {
                proposal = RefactorProcessor.getConvertAnonymousToNestedProposal(params.context, context, context.getCoveringNode(), false);
                positionKey = "type_name";
            } else if ("introduceParameter".equals(params.command)) {
                RefactoringCorrectionProposal rcp;
                IntroduceParameterRefactoring refactoring;
                ParameterInfo parameterInfo;
                proposal = (LinkedCorrectionProposal)RefactorProposalUtility.getIntroduceParameterRefactoringProposals(params.context, context, context.getCoveringNode(), false, locations);
                positionKey = null;
                if (proposal instanceof RefactoringCorrectionProposal && (parameterInfo = (refactoring = (IntroduceParameterRefactoring)(rcp = (RefactoringCorrectionProposal)proposal).getRefactoring()).getAddedParameterInfo()) != null) {
                    positionKey = parameterInfo.getNewName();
                }
            }
            if (proposal != null) break block29;
            return null;
        }
        try {
            Change change = proposal.getChange();
            WorkspaceEdit edit = ChangeUtil.convertToWorkspaceEdit(change);
            LinkedProposalModelCore linkedProposalModel = proposal.getLinkedProposalModel();
            Command additionalCommand = null;
            if (linkedProposalModel != null) {
                LinkedProposalPositionGroupCore.PositionInformation highlightPosition;
                LinkedProposalPositionGroupCore linkedPositionGroup = linkedProposalModel.getPositionGroup(positionKey, false);
                if (linkedPositionGroup == null) {
                    Iterator iter = linkedProposalModel.getPositionGroupCoreIterator();
                    while (iter.hasNext()) {
                        LinkedProposalPositionGroupCore lppgc = (LinkedProposalPositionGroupCore)iter.next();
                        if (!lppgc.getGroupId().startsWith(positionKey)) continue;
                        linkedPositionGroup = lppgc;
                        break;
                    }
                }
                if ((highlightPosition = GetRefactorEditHandler.getFirstTrackedNodePositionBySequenceRank(linkedPositionGroup)) != null) {
                    int offset = highlightPosition.getOffset();
                    int length = highlightPosition.getLength();
                    RenamePosition renamePosition = new RenamePosition(JDTUtils.toURI(unit), offset, length);
                    additionalCommand = new Command("Rename", RENAME_COMMAND, Arrays.asList(renamePosition));
                }
            }
            return new RefactorWorkspaceEdit(edit, additionalCommand);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static LinkedProposalPositionGroupCore.PositionInformation getFirstTrackedNodePositionBySequenceRank(LinkedProposalPositionGroupCore positionGroup) {
        if (positionGroup == null) {
            return null;
        }
        LinkedProposalPositionGroupCore.PositionInformation[] positions = positionGroup.getPositions();
        if (positions == null || positions.length == 0) {
            return null;
        }
        LinkedProposalPositionGroupCore.PositionInformation targetPosition = positions[0];
        int i = 1;
        while (i < positions.length) {
            if (positions[i].getSequenceRank() < targetPosition.getSequenceRank()) {
                targetPosition = positions[i];
            }
            ++i;
        }
        return targetPosition;
    }

    private static CUCorrectionProposal getExtractVariableProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, String refactorType, Map formatterOptions) throws CoreException {
        if ("extractVariableAllOccurrence".equals(refactorType)) {
            return RefactorProposalUtility.getExtractVariableAllOccurrenceProposal(params, context, problemsAtLocation, formatterOptions, false);
        }
        if ("extractVariable".equals(refactorType)) {
            return RefactorProposalUtility.getExtractVariableProposal(params, context, problemsAtLocation, formatterOptions, false);
        }
        if ("extractConstant".equals(refactorType)) {
            return RefactorProposalUtility.getExtractConstantProposal(params, context, problemsAtLocation, formatterOptions, false);
        }
        return null;
    }

    private static CUCorrectionProposal getAssignVariableProposal(GetRefactorEditParams params, IInvocationContext context, boolean problemsAtLocation, String refactorType, Map formatterOptions, IProblemLocationCore[] locations) throws CoreException {
        if ("assignVariable".equals(refactorType)) {
            return RefactorProposalUtility.getAssignVariableProposal(params.context, context, problemsAtLocation, formatterOptions, false, locations);
        }
        if ("assignField".equals(refactorType)) {
            return RefactorProposalUtility.getAssignFieldProposal(params.context, context, problemsAtLocation, formatterOptions, false, locations);
        }
        return null;
    }

    private static CUCorrectionProposal getExtractMethodProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Map formatterOptions) throws CoreException {
        return RefactorProposalUtility.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, formatterOptions, false);
    }

    public static class GetRefactorEditParams {
        public String command;
        public List<Object> commandArguments;
        public CodeActionParams context;
        public FormattingOptions options;

        public GetRefactorEditParams(String command, CodeActionParams context) {
            this(command, null, context);
        }

        public GetRefactorEditParams(String command, List<Object> commandArguments, CodeActionParams context) {
            this(command, commandArguments, context, null);
        }

        public GetRefactorEditParams(String command, List<Object> commandArguments, CodeActionParams context, FormattingOptions options) {
            this.command = command;
            this.commandArguments = commandArguments;
            this.context = context;
            this.options = options;
        }
    }

    public static class RefactorWorkspaceEdit {
        public WorkspaceEdit edit;
        public Command command;
        public String errorMessage;

        public RefactorWorkspaceEdit(WorkspaceEdit edit) {
            this.edit = edit;
        }

        public RefactorWorkspaceEdit(WorkspaceEdit edit, Command command) {
            this.edit = edit;
            this.command = command;
        }

        public RefactorWorkspaceEdit(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    public static class RenamePosition {
        public String uri;
        public int offset;
        public int length;

        public RenamePosition(String uri, int offset, int length) {
            this.uri = uri;
            this.offset = offset;
            this.length = length;
        }
    }
}

