/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.codemanipulation.GenerateGetterSetterOperation;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.text.edits.TextEdit;

public class GenerateAccessorsHandler {
    public static GenerateGetterSetterOperation.AccessorField[] getUnimplementedAccessors(CodeActionParams params) {
        IType type = SourceAssistProcessor.getSelectionType(params);
        return GenerateAccessorsHandler.getUnimplementedAccessors(type);
    }

    public static GenerateGetterSetterOperation.AccessorField[] getUnimplementedAccessors(IType type) {
        try {
            return GenerateGetterSetterOperation.getUnimplementedAccessors(type);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Failed to resolve the unimplemented accessors.", e);
            return new GenerateGetterSetterOperation.AccessorField[0];
        }
    }

    public static WorkspaceEdit generateAccessors(GenerateAccessorsParams params) {
        IType type = SourceAssistProcessor.getSelectionType(params.context);
        if (type == null || type.getCompilationUnit() == null) {
            return null;
        }
        Preferences preferences = JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
        TextEdit edit = GenerateAccessorsHandler.generateAccessors(type, params.accessors, preferences.isCodeGenerationTemplateGenerateComments());
        return edit == null ? null : SourceAssistProcessor.convertToWorkspaceEdit(type.getCompilationUnit(), edit);
    }

    public static TextEdit generateAccessors(IType type, GenerateGetterSetterOperation.AccessorField[] accessors, boolean generateComments) {
        if (type == null || type.getCompilationUnit() == null) {
            return null;
        }
        try {
            GenerateGetterSetterOperation operation = new GenerateGetterSetterOperation(type, null, generateComments);
            return operation.createTextEdit(null, accessors);
        }
        catch (CoreException | OperationCanceledException e) {
            JavaLanguageServerPlugin.logException("Failed to generate the accessors.", e);
            return null;
        }
    }

    public static class GenerateAccessorsParams {
        CodeActionParams context;
        GenerateGetterSetterOperation.AccessorField[] accessors;
    }
}

