/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ls.core.internal.EventNotification;
import org.eclipse.jdt.ls.core.internal.EventType;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;

public class ClasspathUpdateHandler
implements IElementChangedListener {
    private final JavaClientConnection connection;

    public ClasspathUpdateHandler(JavaClientConnection client) {
        this.connection = client;
    }

    public void elementChanged(ElementChangedEvent event) {
        Set<String> uris = this.processDelta(event.getDelta(), null);
        if (this.connection != null && uris != null && !uris.isEmpty()) {
            for (String uri : uris) {
                EventNotification notification = new EventNotification().withType(EventType.ClasspathUpdated).withData(uri);
                this.connection.sendEventNotification(notification);
            }
        }
    }

    public void addElementChangeListener() {
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void removeElementChangeListener() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    private Set<String> processDeltaChildren(IJavaElementDelta delta, Set<String> uris) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta c = iJavaElementDeltaArray[n2];
            uris = this.processDelta(c, uris);
            ++n2;
        }
        return uris;
    }

    private Set<String> processDelta(IJavaElementDelta delta, Set<String> uris) {
        IJavaElement element = delta.getElement();
        switch (element.getElementType()) {
            case 1: {
                uris = this.processDeltaChildren(delta, uris);
                break;
            }
            case 2: {
                if (!this.isClasspathChanged(delta.getFlags())) break;
                if (uris == null) {
                    uris = new HashSet<String>();
                }
                IJavaProject javaProject = (IJavaProject)element;
                uris.add(ProjectUtils.getProjectRealFolder(javaProject.getProject()).toFile().toURI().toString());
                break;
            }
        }
        return uris;
    }

    private boolean isClasspathChanged(int flags) {
        return (flags & 0x220600) != 0;
    }
}

