/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.LinkedCorrectionProposal;

public class ConstructorFromSuperclassProposal
extends LinkedCorrectionProposal {
    private TypeDeclaration fTypeNode;
    private IMethodBinding fSuperConstructor;

    public ConstructorFromSuperclassProposal(ICompilationUnit cu, TypeDeclaration typeNode, IMethodBinding superConstructor, int relevance) {
        super("", "quickfix", cu, (ASTRewrite)null, relevance);
        this.fTypeNode = typeNode;
        this.fSuperConstructor = superConstructor;
    }

    public String getName() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.fTypeNode.getName().getIdentifier());
        buf.append('(');
        if (this.fSuperConstructor != null) {
            ITypeBinding[] paramTypes = this.fSuperConstructor.getParameterTypes();
            int i = 0;
            while (i < paramTypes.length) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(paramTypes[i].getName());
                ++i;
            }
        }
        buf.append(')');
        return Messages.format((String)CorrectionMessages.ConstructorFromSuperclassProposal_description, (Object)BasicElementLabels.getJavaElementName((String)buf.toString()));
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.fTypeNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        this.createImportRewrite((CompilationUnit)this.fTypeNode.getRoot());
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)this.getCompilationUnit().getJavaProject());
        if (!settings.createComments) {
            settings = null;
        }
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)this.fTypeNode, this.getImportRewrite());
        MethodDeclaration newMethodDecl = this.createNewMethodDeclaration(ast, this.fSuperConstructor, rewrite, (ImportRewrite.ImportRewriteContext)importRewriteContext, settings);
        rewrite.getListRewrite((ASTNode)this.fTypeNode, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst((ASTNode)newMethodDecl, null);
        this.addLinkedRanges(rewrite, newMethodDecl);
        return rewrite;
    }

    private void addLinkedRanges(ASTRewrite rewrite, MethodDeclaration newStub) {
        List parameters = newStub.parameters();
        int i = 0;
        while (i < parameters.size()) {
            SingleVariableDeclaration curr = (SingleVariableDeclaration)parameters.get(i);
            String name = curr.getName().getIdentifier();
            this.addLinkedPosition(rewrite.track((ASTNode)curr.getType()), false, "arg_type_" + name);
            this.addLinkedPosition(rewrite.track((ASTNode)curr.getName()), false, "arg_name_" + name);
            ++i;
        }
    }

    private MethodDeclaration createNewMethodDeclaration(AST ast, IMethodBinding binding, ASTRewrite rewrite, ImportRewrite.ImportRewriteContext importRewriteContext, CodeGenerationSettings commentSettings) throws CoreException {
        String string;
        String name = this.fTypeNode.getName().getIdentifier();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.setConstructor(true);
        decl.setName(ast.newSimpleName(name));
        Block body = ast.newBlock();
        decl.setBody(body);
        SuperConstructorInvocation invocation = null;
        List parameters = decl.parameters();
        String[] paramNames = this.getArgumentNames(binding);
        ITypeBinding enclosingInstance = this.getEnclosingInstance();
        if (enclosingInstance != null) {
            invocation = this.addEnclosingInstanceAccess(rewrite, importRewriteContext, parameters, paramNames, enclosingInstance);
        }
        if (binding == null) {
            decl.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        } else {
            decl.modifiers().addAll(ASTNodeFactory.newModifiers((AST)ast, (int)binding.getModifiers()));
            ITypeBinding[] params = binding.getParameterTypes();
            int i = 0;
            while (i < params.length) {
                SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
                var.setType(this.getImportRewrite().addImport(params[i], ast, importRewriteContext, ImportRewrite.TypeLocation.LOCAL_VARIABLE));
                var.setName(ast.newSimpleName(paramNames[i]));
                parameters.add(var);
                ++i;
            }
            List thrownExceptions = decl.thrownExceptionTypes();
            ITypeBinding[] excTypes = binding.getExceptionTypes();
            int i2 = 0;
            while (i2 < excTypes.length) {
                Type excType = this.getImportRewrite().addImport(excTypes[i2], ast, importRewriteContext, ImportRewrite.TypeLocation.EXCEPTION);
                thrownExceptions.add(excType);
                ++i2;
            }
            if (invocation == null) {
                invocation = ast.newSuperConstructorInvocation();
            }
            List arguments = invocation.arguments();
            int i3 = 0;
            while (i3 < paramNames.length) {
                SimpleName argument = ast.newSimpleName(paramNames[i3]);
                arguments.add(argument);
                this.addLinkedPosition(rewrite.track((ASTNode)argument), false, "arg_name_" + paramNames[i3]);
                ++i3;
            }
        }
        String bodyStatement = invocation == null ? "" : ASTNodes.asFormattedString((ASTNode)invocation, (int)0, (String)String.valueOf('\n'), (Map)this.getCompilationUnit().getJavaProject().getOptions(true));
        String placeHolder = CodeGeneration.getMethodBodyContent((ICompilationUnit)this.getCompilationUnit(), (String)name, (String)name, (boolean)true, (String)bodyStatement, (String)String.valueOf('\n'));
        if (placeHolder != null) {
            ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 41);
            body.statements().add(todoNode);
        }
        if (commentSettings != null && (string = CodeGeneration.getMethodComment((ICompilationUnit)this.getCompilationUnit(), (String)name, (MethodDeclaration)decl, null, (String)String.valueOf('\n'))) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    private SuperConstructorInvocation addEnclosingInstanceAccess(ASTRewrite rewrite, ImportRewrite.ImportRewriteContext importRewriteContext, List<SingleVariableDeclaration> parameters, String[] paramNames, ITypeBinding enclosingInstance) {
        AST ast = rewrite.getAST();
        SuperConstructorInvocation invocation = ast.newSuperConstructorInvocation();
        SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
        var.setType(this.getImportRewrite().addImport(enclosingInstance, ast, importRewriteContext, ImportRewrite.TypeLocation.PARAMETER));
        String[] enclosingArgNames = StubUtility.getArgumentNameSuggestions((IJavaProject)this.getCompilationUnit().getJavaProject(), (String)enclosingInstance.getTypeDeclaration().getName(), (int)0, (String[])paramNames);
        String firstName = enclosingArgNames[0];
        var.setName(ast.newSimpleName(firstName));
        parameters.add(var);
        SimpleName enclosing = ast.newSimpleName(firstName);
        invocation.setExpression((Expression)enclosing);
        String key = "arg_name_" + firstName;
        this.addLinkedPosition(rewrite.track((ASTNode)enclosing), false, key);
        int i = 0;
        while (i < enclosingArgNames.length) {
            this.addLinkedPositionProposal(key, enclosingArgNames[i]);
            ++i;
        }
        return invocation;
    }

    private ITypeBinding getEnclosingInstance() {
        ITypeBinding currBinding = this.fTypeNode.resolveBinding();
        if (currBinding == null || Modifier.isStatic((int)currBinding.getModifiers())) {
            return null;
        }
        ITypeBinding superBinding = currBinding.getSuperclass();
        if (superBinding == null || superBinding.getDeclaringClass() == null || Modifier.isStatic((int)superBinding.getModifiers())) {
            return null;
        }
        ITypeBinding enclosing = superBinding.getDeclaringClass();
        while (currBinding != null) {
            if (Bindings.isSuperType((ITypeBinding)enclosing, (ITypeBinding)currBinding)) {
                return null;
            }
            if (Modifier.isStatic((int)currBinding.getModifiers())) {
                return null;
            }
            currBinding = currBinding.getDeclaringClass();
        }
        return enclosing;
    }

    private String[] getArgumentNames(IMethodBinding binding) {
        if (binding == null) {
            return new String[0];
        }
        return StubUtility.suggestArgumentNames((IJavaProject)this.getCompilationUnit().getJavaProject(), (IMethodBinding)binding);
    }
}

