/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringCoreMessages;

public class JavaElementUtil {
    private JavaElementUtil() {
    }

    public static String createMethodSignature(IMethod method) {
        try {
            return BasicElementLabels.getJavaElementName((String)Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)false, (!method.isConstructor() ? 1 : 0) != 0));
        }
        catch (JavaModelException e) {
            return BasicElementLabels.getJavaElementName((String)method.getElementName());
        }
    }

    public static String createFieldSignature(IField field) {
        return BasicElementLabels.getJavaElementName((String)(String.valueOf(field.getDeclaringType().getFullyQualifiedName('.')) + "." + field.getElementName()));
    }

    public static String createSignature(IMember member) {
        switch (member.getElementType()) {
            case 8: {
                return JavaElementUtil.createFieldSignature((IField)member);
            }
            case 7: {
                return BasicElementLabels.getJavaElementName((String)((IType)member).getFullyQualifiedName('.'));
            }
            case 10: {
                return RefactoringCoreMessages.JavaElementUtil_initializer;
            }
            case 9: {
                return JavaElementUtil.createMethodSignature((IMethod)member);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static IJavaElement[] getElementsOfType(IJavaElement[] elements, int type) {
        HashSet<IJavaElement> result = new HashSet<IJavaElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            if (element.getElementType() == type) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    public static IType getMainType(ICompilationUnit cu) throws JavaModelException {
        IType[] types = cu.getTypes();
        int i = 0;
        while (i < types.length) {
            if (JavaElementUtil.isMainType(types[i])) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isMainType(IType type) throws JavaModelException {
        if (!type.exists()) {
            return false;
        }
        if (type.isBinary()) {
            return false;
        }
        if (type.getCompilationUnit() == null) {
            return false;
        }
        if (type.getDeclaringType() != null) {
            return false;
        }
        return JavaElementUtil.isPrimaryType(type) || JavaElementUtil.isCuOnlyType(type);
    }

    private static boolean isPrimaryType(IType type) {
        return type.equals(type.getCompilationUnit().findPrimaryType());
    }

    private static boolean isCuOnlyType(IType type) throws JavaModelException {
        return type.getCompilationUnit().getTypes().length == 1;
    }

    public static boolean isAncestorOf(IJavaElement ancestor, IJavaElement child) {
        IJavaElement parent = child.getParent();
        while (parent != null && !parent.equals(ancestor)) {
            parent = parent.getParent();
        }
        return parent != null;
    }

    public static IMethod[] getAllConstructors(IType type) throws JavaModelException {
        if (JavaModelUtil.isInterfaceOrAnnotation((IType)type)) {
            return new IMethod[0];
        }
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            IMethod iMethod = methods[i];
            if (iMethod.isConstructor()) {
                result.add(iMethod);
            }
            ++i;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IJavaProject[] getReferencingProjects(IPackageFragmentRoot root) throws JavaModelException {
        IClasspathEntry cpe = root.getRawClasspathEntry();
        if (cpe.getEntryKind() == 1) {
            cpe = root.getResolvedClasspathEntry();
        }
        IJavaProject[] allJavaProjects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        ArrayList<IJavaProject> result = new ArrayList<IJavaProject>(allJavaProjects.length);
        int i = 0;
        while (i < allJavaProjects.length) {
            IJavaProject project = allJavaProjects[i];
            IPackageFragmentRoot[] roots = project.findPackageFragmentRoots(cpe);
            if (roots.length > 0) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray(new IJavaProject[result.size()]);
    }

    public static IMember[] merge(IMember[] a1, IMember[] a2) {
        IMember member;
        ArrayList<IMember> result = new ArrayList<IMember>(a1.length + a2.length);
        int i = 0;
        while (i < a1.length) {
            member = a1[i];
            if (!result.contains(member)) {
                result.add(member);
            }
            ++i;
        }
        i = 0;
        while (i < a2.length) {
            member = a2[i];
            if (!result.contains(member)) {
                result.add(member);
            }
            ++i;
        }
        return result.toArray(new IMember[result.size()]);
    }

    public static boolean isDefaultPackage(Object element) {
        return element instanceof IPackageFragment && ((IPackageFragment)element).isDefaultPackage();
    }

    public static IPackageFragment[] getPackageAndSubpackages(IPackageFragment pack) throws JavaModelException {
        if (pack.isDefaultPackage()) {
            return new IPackageFragment[]{pack};
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)pack.getParent();
        IJavaElement[] allPackages = root.getChildren();
        ArrayList<IPackageFragment> subpackages = new ArrayList<IPackageFragment>();
        subpackages.add(pack);
        String prefix = String.valueOf(pack.getElementName()) + '.';
        int i = 0;
        while (i < allPackages.length) {
            IPackageFragment currentPackage = (IPackageFragment)allPackages[i];
            if (currentPackage.getElementName().startsWith(prefix)) {
                subpackages.add(currentPackage);
            }
            ++i;
        }
        return subpackages.toArray(new IPackageFragment[subpackages.size()]);
    }

    public static IPackageFragment getParentSubpackage(IPackageFragment pack) {
        String newPackageName;
        if (pack.isDefaultPackage()) {
            return null;
        }
        int index = pack.getElementName().lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)pack.getParent();
        IPackageFragment parent = root.getPackageFragment(newPackageName = pack.getElementName().substring(0, index));
        if (parent.exists()) {
            return parent;
        }
        return null;
    }

    public static IMember[] sortByOffset(IMember[] members) {
        Comparator<IMember> comparator = new Comparator<IMember>(){

            @Override
            public int compare(IMember o1, IMember o2) {
                try {
                    return o1.getNameRange().getOffset() - o2.getNameRange().getOffset();
                }
                catch (JavaModelException e) {
                    return 0;
                }
            }
        };
        Arrays.sort(members, comparator);
        return members;
    }

    public static boolean isSourceAvailable(ISourceReference sourceReference) {
        try {
            return SourceRange.isAvailable((ISourceRange)sourceReference.getSourceRange());
        }
        catch (JavaModelException e) {
            return false;
        }
    }
}

