/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnFieldType;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnKeyword2;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.core.manipulation.CodeTemplateContext;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.SnippetUtils;
import org.eclipse.jdt.ls.core.internal.contentassist.SortTextHelper;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.ls.core.internal.corext.template.java.JavaContextType;
import org.eclipse.jdt.ls.core.internal.preferences.CodeGenerationTemplate;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;

public class SnippetCompletionProposal {
    private static final String CLASS_SNIPPET_LABEL = "class";
    private static final String INTERFACE_SNIPPET_LABEL = "interface";
    private static final String RECORD_SNIPPET_LABEL = "record";
    private static final String CLASS_KEYWORD = "class";
    private static final String INTERFACE_KEYWORD = "interface";
    private static final String RECORD_KEYWORD = "record";
    private static String PACKAGEHEADER = "package_header";
    private static String CURSOR = "cursor";

    public static List<CompletionItem> getSnippets(ICompilationUnit cu, CompletionContext completionContext, IProgressMonitor monitor) throws JavaModelException {
        if (cu == null) {
            throw new IllegalArgumentException("Compilation unit must not be null");
        }
        ArrayList<CompletionItem> res = new ArrayList<CompletionItem>();
        SnippetCompletionContext scc = new SnippetCompletionContext(cu, completionContext);
        res.addAll(SnippetCompletionProposal.getGenericSnippets(scc));
        res.addAll(SnippetCompletionProposal.getTypeDefinitionSnippets(scc, monitor));
        return res;
    }

    private static List<CompletionItem> getGenericSnippets(SnippetCompletionContext scc) throws JavaModelException {
        ArrayList<CompletionItem> res = new ArrayList<CompletionItem>();
        CompletionContext completionContext = scc.getCompletionContext();
        char[] completionToken = completionContext.getToken();
        if (completionToken == null) {
            return Collections.emptyList();
        }
        int tokenLocation = completionContext.getTokenLocation();
        JavaContextType contextType = (JavaContextType)JavaLanguageServerPlugin.getInstance().getTemplateContextRegistry().getContextType("java-statements");
        if (contextType == null) {
            return Collections.emptyList();
        }
        ICompilationUnit cu = scc.getCompilationUnit();
        Document document = new Document(cu.getSource());
        DocumentTemplateContext javaContext = contextType.createContext((IDocument)document, completionContext.getOffset(), completionToken.length, cu);
        Template[] templates = null;
        if ((tokenLocation & 2) != 0) {
            templates = JavaLanguageServerPlugin.getInstance().getTemplateStore().getTemplates("java-statements");
        }
        if (templates == null || templates.length == 0) {
            return Collections.emptyList();
        }
        Template[] templateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                Template template = templateArray[n2];
                if (javaContext.canEvaluate(template)) {
                    String content;
                    TemplateBuffer buffer = null;
                    try {
                        buffer = javaContext.evaluate(template);
                    }
                    catch (BadLocationException | TemplateException e) {
                        JavaLanguageServerPlugin.logException(e.getMessage(), e);
                        break block9;
                    }
                    if (buffer != null && !Strings.containsOnlyWhitespaces((String)(content = buffer.getString()))) {
                        CompletionItem item = new CompletionItem();
                        item.setLabel(template.getName());
                        item.setInsertText(content);
                        item.setDetail(template.getDescription());
                        SnippetCompletionProposal.setFields(item, cu);
                        res.add(item);
                    }
                }
            }
            ++n2;
        }
        return res;
    }

    private static List<CompletionItem> getTypeDefinitionSnippets(SnippetCompletionContext scc, IProgressMonitor monitor) throws JavaModelException {
        CompletionItem recordSnippet;
        CompletionItem interfaceSnippet;
        CompletionItem classSnippet;
        char[] completionToken = scc.getCompletionContext().getToken();
        boolean isInterfacePrefix = true;
        boolean isClassPrefix = true;
        boolean isRecordPrefix = true;
        if (completionToken != null && completionToken.length > 0) {
            String prefix = new String(completionToken);
            isInterfacePrefix = "interface".startsWith(prefix);
            isClassPrefix = "class".startsWith(prefix);
            isRecordPrefix = "record".startsWith(prefix);
        }
        if (!(isInterfacePrefix || isClassPrefix || isRecordPrefix)) {
            return Collections.emptyList();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ArrayList<CompletionItem> res = new ArrayList<CompletionItem>(3);
        if (isClassPrefix && (classSnippet = SnippetCompletionProposal.getClassSnippet(scc, monitor)) != null) {
            res.add(classSnippet);
        }
        if (isInterfacePrefix && (interfaceSnippet = SnippetCompletionProposal.getInterfaceSnippet(scc, monitor)) != null) {
            res.add(interfaceSnippet);
        }
        if (isRecordPrefix && (recordSnippet = SnippetCompletionProposal.getRecordSnippet(scc, monitor)) != null) {
            res.add(recordSnippet);
        }
        return res;
    }

    private static boolean accept(ICompilationUnit cu, CompletionContext completionContext, boolean acceptClass) {
        if (completionContext != null && completionContext.isExtended()) {
            if (completionContext.isInJavadoc()) {
                return false;
            }
            if (completionContext instanceof InternalCompletionContext) {
                InternalCompletionContext internalCompletionContext = (InternalCompletionContext)completionContext;
                org.eclipse.jdt.internal.compiler.ast.ASTNode node = internalCompletionContext.getCompletionNode();
                if (node instanceof CompletionOnKeyword2) {
                    return true;
                }
                if (node instanceof CompletionOnFieldType) {
                    return true;
                }
                if (acceptClass && node instanceof CompletionOnSingleNameReference) {
                    if (completionContext.getEnclosingElement() instanceof IMethod) {
                        CompilationUnit ast = CoreASTProvider.getInstance().getAST((ITypeRoot)cu, CoreASTProvider.WAIT_YES, null);
                        ASTNode astNode = ASTNodeSearchUtil.getAstNode(ast, completionContext.getTokenStart(), completionContext.getTokenEnd() - completionContext.getTokenStart() + 1);
                        return astNode == null || astNode.getParent() instanceof ExpressionStatement;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static CompletionItem getClassSnippet(SnippetCompletionContext scc, IProgressMonitor monitor) {
        ICompilationUnit cu = scc.getCompilationUnit();
        if (!SnippetCompletionProposal.accept(cu, scc.getCompletionContext(), true)) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        CompletionItem classSnippetItem = new CompletionItem();
        classSnippetItem.setLabel("class");
        classSnippetItem.setFilterText("class");
        classSnippetItem.setSortText(SortTextHelper.convertRelevance(1));
        try {
            CodeGenerationTemplate template = scc.needsPublic(monitor) ? CodeGenerationTemplate.CLASSSNIPPET_PUBLIC : CodeGenerationTemplate.CLASSSNIPPET_DEFAULT;
            classSnippetItem.setInsertText(SnippetCompletionProposal.getSnippetContent(scc, template, true));
            SnippetCompletionProposal.setFields(classSnippetItem, cu);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e.getStatus());
            return null;
        }
        return classSnippetItem;
    }

    private static CompletionItem getInterfaceSnippet(SnippetCompletionContext scc, IProgressMonitor monitor) {
        ICompilationUnit cu = scc.getCompilationUnit();
        if (!SnippetCompletionProposal.accept(cu, scc.completionContext, false)) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        CompletionItem interfaceSnippetItem = new CompletionItem();
        interfaceSnippetItem.setFilterText("interface");
        interfaceSnippetItem.setLabel("interface");
        interfaceSnippetItem.setSortText(SortTextHelper.convertRelevance(0));
        try {
            CodeGenerationTemplate template = scc.needsPublic(monitor) ? CodeGenerationTemplate.INTERFACESNIPPET_PUBLIC : CodeGenerationTemplate.INTERFACESNIPPET_DEFAULT;
            interfaceSnippetItem.setInsertText(SnippetCompletionProposal.getSnippetContent(scc, template, true));
            SnippetCompletionProposal.setFields(interfaceSnippetItem, cu);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e.getStatus());
            return null;
        }
        return interfaceSnippetItem;
    }

    private static CompletionItem getRecordSnippet(SnippetCompletionContext scc, IProgressMonitor monitor) {
        ICompilationUnit cu = scc.getCompilationUnit();
        IJavaProject javaProject = cu.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        String version = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        if (JavaModelUtil.isVersionLessThan((String)version, (String)"14")) {
            return null;
        }
        if (!SnippetCompletionProposal.accept(cu, scc.getCompletionContext(), false)) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        CompletionItem recordSnippet = new CompletionItem();
        recordSnippet.setFilterText("record");
        recordSnippet.setLabel("record");
        recordSnippet.setSortText(SortTextHelper.convertRelevance(0));
        try {
            CodeGenerationTemplate template = scc.needsPublic(monitor) ? CodeGenerationTemplate.RECORDSNIPPET_PUBLIC : CodeGenerationTemplate.RECORDSNIPPET_DEFAULT;
            recordSnippet.setInsertText(SnippetCompletionProposal.getSnippetContent(scc, template, true));
            SnippetCompletionProposal.setFields(recordSnippet, cu);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e.getStatus());
            return null;
        }
        return recordSnippet;
    }

    private static void setFields(CompletionItem ci, ICompilationUnit cu) {
        ci.setKind(CompletionItemKind.Snippet);
        ci.setInsertTextFormat(InsertTextFormat.Snippet);
        ci.setDocumentation(SnippetUtils.beautifyDocument(ci.getInsertText()));
        HashMap<String, String> data = new HashMap<String, String>(3);
        data.put("uri", JDTUtils.toURI(cu));
        data.put("rid", "0");
        data.put("pid", "0");
        ci.setData(data);
    }

    private static String getSnippetContent(SnippetCompletionContext scc, CodeGenerationTemplate templateSetting, boolean snippetStringSupport) throws CoreException {
        TemplateBuffer buffer;
        ICompilationUnit cu = scc.getCompilationUnit();
        Template template = templateSetting.createTemplate();
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), scc.getRecommendedLineSeprator());
        context.setVariable(PACKAGEHEADER, scc.getPackageHeader());
        String typeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
        List<IType> types = Arrays.asList(cu.getAllTypes());
        int postfix = 0;
        while (!types.isEmpty() && types.stream().filter(SnippetCompletionProposal.isTypeExists(typeName)).findFirst().isPresent()) {
            typeName = "Inner" + JavaCore.removeJavaLikeExtension((String)cu.getElementName()) + (postfix == 0 ? "" : "_" + postfix);
            ++postfix;
        }
        if (postfix > 0 && snippetStringSupport) {
            context.setVariable("type_name", "${1:" + typeName + "}");
        } else {
            context.setVariable("type_name", typeName);
        }
        context.setVariable(CURSOR, snippetStringSupport ? "${0}" : "");
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces((String)str)) {
            return null;
        }
        return str;
    }

    private static Predicate<IType> isTypeExists(String typeName) {
        return type -> type.getElementName().equals(typeName);
    }

    private static class SnippetCompletionContext {
        private ICompilationUnit cu;
        private Boolean needsPublic;
        private CompletionContext completionContext;
        private String packageHeader;
        private String recommendedLineSeprator;

        SnippetCompletionContext(ICompilationUnit cu, CompletionContext completionContext) {
            this.cu = cu;
            this.completionContext = completionContext;
        }

        ICompilationUnit getCompilationUnit() {
            return this.cu;
        }

        boolean needsPublic(IProgressMonitor monitor) {
            if (this.needsPublic == null) {
                this.needsPublic = SnippetCompletionContext.needsPublic(this.cu, this.getCompletionContext(), monitor);
            }
            return this.needsPublic;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static boolean needsPublic(ICompilationUnit cu, CompletionContext completionContext, IProgressMonitor monitor) {
            block15: {
                block14: {
                    block13: {
                        if (completionContext == null || !completionContext.isExtended()) break block14;
                        if (completionContext.isInJavadoc()) {
                            return false;
                        }
                        if (!(completionContext instanceof InternalCompletionContext) || !((node = (internalCompletionContext = (InternalCompletionContext)completionContext).getCompletionNode()) instanceof CompletionOnKeyword2) && !(node instanceof CompletionOnFieldType) && !(node instanceof CompletionOnSingleNameReference)) break block14;
                        if (completionContext.getEnclosingElement() instanceof IMethod) {
                            return false;
                        }
                        try {
                            scanner = new TokenScanner((ITypeRoot)cu);
                            previous = curr = scanner.readNext(0, true);
                            while (scanner.getCurrentEndOffset() < completionContext.getTokenStart()) {
                                previous = curr;
                                if (monitor.isCanceled()) {
                                    return false;
                                }
                                if (curr == 158) break;
                                try {
                                    curr = scanner.readNext(true);
                                }
                                catch (CoreException var8_10) {
                                    // empty catch block
                                }
                            }
                            if (TokenScanner.isModifier((int)previous)) {
                                return false;
                            }
                        }
                        catch (CoreException e) {
                            if (e.getStatus().getCode() == 20001) break block13;
                            JavaLanguageServerPlugin.logException(e.getMessage(), e);
                        }
                    }
                    if (!(node instanceof CompletionOnSingleNameReference)) break block15;
                    ast = CoreASTProvider.getInstance().getAST((ITypeRoot)cu, CoreASTProvider.WAIT_YES, null);
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    astNode = ASTNodeSearchUtil.getAstNode(ast, completionContext.getOffset(), 1);
                    if (astNode == null) {
                        return false;
                    }
                    ** GOTO lbl41
                }
                return false;
lbl-1000:
                // 1 sources

                {
                    if (astNode instanceof Initializer) {
                        return false;
                    }
                    astNode = astNode.getParent();
lbl41:
                    // 2 sources

                    ** while (astNode != null)
                }
            }
            return true;
        }

        CompletionContext getCompletionContext() {
            return this.completionContext;
        }

        String getPackageHeader() throws JavaModelException {
            if (this.packageHeader == null) {
                IPackageDeclaration[] packageDeclarations = this.cu.getPackageDeclarations();
                String packageName = this.cu.getParent().getElementName();
                this.packageHeader = packageName != null && !packageName.isEmpty() && (packageDeclarations == null || packageDeclarations.length == 0) ? "package " + packageName + ";\n\n" : "";
            }
            return this.packageHeader;
        }

        String getRecommendedLineSeprator() throws JavaModelException {
            if (this.recommendedLineSeprator == null) {
                this.recommendedLineSeprator = this.cu.findRecommendedLineSeparator();
            }
            return this.recommendedLineSeprator;
        }
    }
}

