/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalDescriptionProvider;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalReplacementProvider;
import org.eclipse.jdt.ls.core.internal.contentassist.GetterSetterCompletionProposal;
import org.eclipse.jdt.ls.core.internal.contentassist.SortTextHelper;
import org.eclipse.jdt.ls.core.internal.contentassist.TypeFilter;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponse;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponses;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;

public final class CompletionProposalRequestor
extends CompletionRequestor {
    private List<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
    private final ICompilationUnit unit;
    private CompletionProposalDescriptionProvider descriptionProvider;
    private CompletionResponse response;
    private boolean fIsTestCodeExcluded;
    private CompletionContext context;
    private boolean isComplete = true;
    private PreferenceManager preferenceManager;
    private CompletionProposalReplacementProvider proposalProvider;
    public static final Set<CompletionItemKind> SUPPORTED_KINDS = ImmutableSet.of((Object)CompletionItemKind.Constructor, (Object)CompletionItemKind.Class, (Object)CompletionItemKind.Constant, (Object)CompletionItemKind.Interface, (Object)CompletionItemKind.Enum, (Object)CompletionItemKind.EnumMember, (Object[])new CompletionItemKind[]{CompletionItemKind.Module, CompletionItemKind.Field, CompletionItemKind.Keyword, CompletionItemKind.Reference, CompletionItemKind.Variable, CompletionItemKind.Method, CompletionItemKind.Text});

    public boolean isComplete() {
        return this.isComplete;
    }

    @Deprecated
    public CompletionProposalRequestor(ICompilationUnit aUnit, int offset) {
        this(aUnit, offset, JavaLanguageServerPlugin.getPreferencesManager());
    }

    public CompletionProposalRequestor(ICompilationUnit aUnit, int offset, PreferenceManager preferenceManager) {
        this.unit = aUnit;
        this.preferenceManager = preferenceManager;
        this.response = new CompletionResponse();
        this.response.setOffset(offset);
        this.fIsTestCodeExcluded = !this.isTestSource(this.unit.getJavaProject(), this.unit);
        this.setRequireExtendedContext(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTestSource(IJavaProject project, ICompilationUnit cu) {
        if (project == null) {
            return true;
        }
        try {
            IClasspathEntry[] resolvedClasspath = project.getResolvedClasspath(true);
            IPath resourcePath = cu.getResource().getFullPath();
            IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
            int n = resolvedClasspath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.getEntryKind() == 3 && e.isTest() && e.getPath().isPrefixOf(resourcePath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    public void accept(CompletionProposal proposal) {
        if (this.isFiltered(proposal)) {
            return;
        }
        if (!this.isIgnored(proposal.getKind())) {
            if (proposal.getKind() == 11) {
                this.acceptPotentialMethodDeclaration(proposal);
            } else {
                if (proposal.getKind() == 8 && this.unit.getParent() != null && String.valueOf(proposal.getCompletion()).equals(this.unit.getParent().getElementName())) {
                    proposal.setRelevance(proposal.getRelevance() + 1);
                }
                this.proposals.add(proposal);
            }
        }
    }

    public List<CompletionItem> getCompletionItems() {
        this.proposals.sort(new ProposalComparator(this.proposals.size()));
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>(this.proposals.size());
        int maxCompletions = this.preferenceManager.getPreferences().getMaxCompletionResults();
        int limit = Math.min(this.proposals.size(), maxCompletions);
        if (this.proposals.size() > maxCompletions) {
            this.isComplete = false;
            this.response.setProposals(this.proposals.subList(0, limit));
        } else {
            this.response.setProposals(this.proposals);
        }
        CompletionResponses.store(this.response);
        int i = 0;
        while (i < limit) {
            CompletionProposal proposal = this.proposals.get(i);
            try {
                CompletionItem item = this.toCompletionItem(proposal, i);
                completionItems.add(item);
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            ++i;
        }
        return completionItems;
    }

    public CompletionItem toCompletionItem(CompletionProposal proposal, int index) {
        String label;
        ISourceRange nameRange;
        ITypeRoot typeRoot;
        Region nameRegion;
        CompletionItem $ = new CompletionItem();
        $.setKind(this.mapKind(proposal));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("uri", JDTUtils.toURI(this.unit));
        data.put("rid", String.valueOf(this.response.getId()));
        data.put("pid", String.valueOf(index));
        $.setData(data);
        this.descriptionProvider.updateDescription(proposal, $);
        $.setSortText(SortTextHelper.computeSortText(proposal));
        if (proposal.getKind() == 2) {
            try {
                IField field = JDTUtils.resolveField(proposal, this.unit.getJavaProject());
                nameRegion = null;
                if (field != null) {
                    String constantValue;
                    typeRoot = field.getTypeRoot();
                    nameRange = field.getNameRange();
                    if (SourceRange.isAvailable((ISourceRange)nameRange)) {
                        nameRegion = new Region(nameRange.getOffset(), nameRange.getLength());
                    }
                    if ((constantValue = JDTUtils.getConstantValue(field, typeRoot, nameRegion)) != null) {
                        label = $.getLabel();
                        $.setLabel(String.valueOf(label) + " = " + constantValue);
                        data.put("constant_value", constantValue);
                    }
                }
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.log((CoreException)((Object)e));
            }
        }
        if (proposal.getKind() == 6 || proposal.getKind() == 13) {
            try {
                IMethod method = JDTUtils.resolveMethod(proposal, this.unit.getJavaProject());
                nameRegion = null;
                if (method != null) {
                    String defaultValue;
                    typeRoot = method.getTypeRoot();
                    nameRange = method.getNameRange();
                    if (SourceRange.isAvailable((ISourceRange)nameRange)) {
                        nameRegion = new Region(nameRange.getOffset(), nameRange.getLength());
                    }
                    if ((defaultValue = JDTUtils.getAnnotationMemberDefaultValue(method, typeRoot, (IRegion)nameRegion)) != null) {
                        label = $.getLabel();
                        $.setLabel(String.valueOf(label) + " (Default: " + defaultValue + ")");
                        data.put("default_value", defaultValue);
                    }
                }
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.log((CoreException)((Object)e));
            }
        }
        this.proposalProvider.updateReplacement(proposal, $, '\u0000');
        if (proposal.getKind() == 9 && $.getTextEdit() != null && $.getTextEdit().getRange() != null && $.getTextEdit().getNewText() != null) {
            $.setFilterText($.getTextEdit().getNewText());
        }
        return $;
    }

    public void acceptContext(CompletionContext context) {
        super.acceptContext(context);
        this.context = context;
        this.response.setContext(context);
        this.descriptionProvider = new CompletionProposalDescriptionProvider(context);
        this.proposalProvider = new CompletionProposalReplacementProvider(this.unit, context, this.response.getOffset(), this.preferenceManager.getPreferences(), this.preferenceManager.getClientPreferences());
    }

    private CompletionItemKind mapKind(CompletionProposal proposal) {
        int kind = proposal.getKind();
        int flags = proposal.getFlags();
        switch (kind) {
            case 26: 
            case 27: {
                return CompletionItemKind.Constructor;
            }
            case 1: 
            case 9: {
                if (Flags.isInterface((int)flags)) {
                    return CompletionItemKind.Interface;
                }
                if (Flags.isEnum((int)flags)) {
                    return CompletionItemKind.Enum;
                }
                return CompletionItemKind.Class;
            }
            case 8: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: {
                return CompletionItemKind.Module;
            }
            case 2: {
                if (Flags.isEnum((int)flags)) {
                    return CompletionItemKind.EnumMember;
                }
                if (Flags.isStatic((int)flags) && Flags.isFinal((int)flags)) {
                    return CompletionItemKind.Constant;
                }
                return CompletionItemKind.Field;
            }
            case 25: {
                return CompletionItemKind.Field;
            }
            case 3: {
                return CompletionItemKind.Keyword;
            }
            case 4: {
                return CompletionItemKind.Reference;
            }
            case 5: 
            case 10: {
                return CompletionItemKind.Variable;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 24: {
                return CompletionItemKind.Method;
            }
        }
        return CompletionItemKind.Text;
    }

    public void setIgnored(int completionProposalKind, boolean ignore) {
        super.setIgnored(completionProposalKind, ignore);
        if (completionProposalKind == 7 && !ignore) {
            this.setRequireExtendedContext(true);
        }
    }

    private void acceptPotentialMethodDeclaration(CompletionProposal proposal) {
        try {
            IJavaElement enclosingElement = null;
            if (this.response.getContext().isExtended()) {
                enclosingElement = this.response.getContext().getEnclosingElement();
            } else if (this.unit != null) {
                enclosingElement = this.unit.getElementAt(proposal.getCompletionLocation() + 1);
            }
            if (enclosingElement == null) {
                return;
            }
            IType type = (IType)enclosingElement.getAncestor(7);
            if (type != null) {
                String prefix = String.valueOf(proposal.getName());
                int completionStart = proposal.getReplaceStart();
                int completionEnd = proposal.getReplaceEnd();
                int relevance = proposal.getRelevance() + 6;
                GetterSetterCompletionProposal.evaluateProposals(type, prefix, completionStart, completionEnd - completionStart, relevance, this.proposals);
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Accept potential method declaration failed for completion ", e);
        }
    }

    public boolean isTestCodeExcluded() {
        return this.fIsTestCodeExcluded;
    }

    public CompletionContext getContext() {
        return this.context;
    }

    public List<CompletionProposal> getProposals() {
        return this.proposals;
    }

    protected boolean isFiltered(CompletionProposal proposal) {
        if (this.isIgnored(proposal.getKind())) {
            return true;
        }
        switch (proposal.getKind()) {
            case 9: 
            case 16: 
            case 26: 
            case 27: {
                char[] declaringType = this.getDeclaringType(proposal);
                return declaringType != null && TypeFilter.isFiltered(declaringType);
            }
        }
        return false;
    }

    protected final char[] getDeclaringType(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                char[] declaration = proposal.getDeclarationSignature();
                if (declaration == null) {
                    return "java.lang.Object".toCharArray();
                }
                return Signature.toCharArray((char[])declaration);
            }
            case 8: 
            case 28: 
            case 29: {
                return proposal.getDeclarationSignature();
            }
            case 9: 
            case 16: {
                return Signature.toCharArray((char[])proposal.getSignature());
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 18: 
            case 19: 
            case 20: {
                return null;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    static class ProposalComparator
    implements Comparator<CompletionProposal> {
        private Map<CompletionProposal, char[]> completionCache;

        ProposalComparator(int cacheSize) {
            this.completionCache = new HashMap<CompletionProposal, char[]>(cacheSize + 1, 1.0f);
        }

        @Override
        public int compare(CompletionProposal p1, CompletionProposal p2) {
            int res = p2.getRelevance() - p1.getRelevance();
            if (res == 0) {
                res = p1.getKind() - p2.getKind();
            }
            if (res == 0) {
                char[] completion1 = this.getCompletion(p1);
                char[] completion2 = this.getCompletion(p2);
                int p1Length = completion1.length;
                int p2Length = completion2.length;
                int i = 0;
                while (i < p1Length) {
                    if (i >= p2Length) {
                        return -1;
                    }
                    res = Character.compare(completion1[i], completion2[i]);
                    if (res != 0) {
                        return res;
                    }
                    ++i;
                }
                res = p2Length - p1Length;
            }
            return res;
        }

        private char[] getCompletion(CompletionProposal cp) {
            return this.completionCache.computeIfAbsent(cp, p -> p.getCompletion());
        }
    }
}

