/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public class LanguageServer
implements IApplication {
    private volatile boolean shutdown;
    private long parentProcessId;
    private final Object waitLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object start(IApplicationContext context) throws Exception {
        JavaLanguageServerPlugin.startLanguageServer(this);
        Object object = this.waitLock;
        synchronized (object) {
            while (true) {
                if (this.shutdown) {
                    return IApplication.EXIT_OK;
                }
                try {
                    context.applicationRunning();
                    JavaLanguageServerPlugin.logInfo("Main thread is waiting");
                    this.waitLock.wait();
                }
                catch (InterruptedException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        this.shutdown = true;
        JavaLanguageServerPlugin.logInfo("Shutdown received... waking up main thread");
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.notifyAll();
        }
    }

    public void setParentProcessId(long pid) {
        this.parentProcessId = pid;
    }

    long getParentProcessId() {
        return this.parentProcessId;
    }
}

