/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.commands.BuildPathCommand;
import org.eclipse.jdt.ls.core.internal.commands.DiagnosticsCommand;
import org.eclipse.jdt.ls.core.internal.commands.OrganizeImportsCommand;
import org.eclipse.jdt.ls.core.internal.commands.ProjectCommand;
import org.eclipse.jdt.ls.core.internal.commands.SemanticTokensCommand;
import org.eclipse.jdt.ls.core.internal.commands.SourceAttachmentCommand;
import org.eclipse.jdt.ls.core.internal.handlers.ResolveSourceMappingHandler;
import org.eclipse.jdt.ls.core.internal.semantictokens.SemanticTokensLegend;
import org.eclipse.lsp4j.WorkspaceEdit;

public class JDTDelegateCommandHandler
implements IDelegateCommandHandler {
    @Override
    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor monitor) throws Exception {
        block51: {
            if (StringUtils.isBlank((CharSequence)commandId)) break block51;
            switch (commandId) {
                case "java.edit.organizeImports": {
                    OrganizeImportsCommand c = new OrganizeImportsCommand();
                    Object result = c.organizeImports(arguments);
                    boolean applyNow = JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isWorkspaceApplyEditSupported();
                    if (applyNow) {
                        JavaLanguageServerPlugin.getInstance().getClientConnection().applyWorkspaceEdit((WorkspaceEdit)result);
                        return new Object();
                    }
                    return result;
                }
                case "java.project.resolveSourceAttachment": {
                    return SourceAttachmentCommand.resolveSourceAttachment(arguments, monitor);
                }
                case "java.project.updateSourceAttachment": {
                    return SourceAttachmentCommand.updateSourceAttachment(arguments, monitor);
                }
                case "java.project.addToSourcePath": {
                    String sourceFolder = (String)arguments.get(0);
                    return BuildPathCommand.addToSourcePath(sourceFolder);
                }
                case "java.project.removeFromSourcePath": {
                    String sourceFolder1 = (String)arguments.get(0);
                    return BuildPathCommand.removeFromSourcePath(sourceFolder1);
                }
                case "java.project.listSourcePaths": {
                    return BuildPathCommand.listSourcePaths();
                }
                case "java.project.getSettings": {
                    return ProjectCommand.getProjectSettings((String)arguments.get(0), (ArrayList)arguments.get(1));
                }
                case "java.project.getClasspaths": {
                    return ProjectCommand.getClasspaths((String)arguments.get(0), JSONUtility.toModel(arguments.get(1), ProjectCommand.ClasspathOptions.class));
                }
                case "java.project.isTestFile": {
                    return ProjectCommand.isTestFile((String)arguments.get(0));
                }
                case "java.project.getAll": {
                    return ProjectCommand.getAllJavaProjects();
                }
                case "java.project.refreshDiagnostics": {
                    return DiagnosticsCommand.refreshDiagnostics((String)arguments.get(0), (String)arguments.get(1), (Boolean)arguments.get(2));
                }
                case "java.project.provideSemanticTokens": {
                    return SemanticTokensCommand.provide((String)arguments.get(0));
                }
                case "java.project.getSemanticTokensLegend": {
                    return new SemanticTokensLegend();
                }
                case "java.project.import": {
                    ProjectCommand.importProject(monitor);
                    return null;
                }
                case "java.project.resolveStackTraceLocation": {
                    ArrayList projectNames = null;
                    if (arguments.size() > 1) {
                        projectNames = (ArrayList)arguments.get(1);
                    }
                    return ResolveSourceMappingHandler.resolveStackTraceLocation((String)arguments.get(0), projectNames);
                }
            }
        }
        throw new UnsupportedOperationException(String.format("Java language server doesn't support the command '%s'.", commandId));
    }
}

