/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdtls.ext.core;

import com.microsoft.jdtls.ext.core.ExtUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.ls.core.internal.IContentProvider;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public class JarFileContentProvider
implements IContentProvider {
    public String getContent(URI uri, IProgressMonitor monitor) throws CoreException {
        return this.getContent(uri.getQuery(), uri.getPath().toString(), monitor);
    }

    private String getContent(String rootId, String path, IProgressMonitor pm) {
        try {
            JarEntryFile fileEntry;
            IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)JavaCore.create((String)rootId);
            if (packageRoot == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdtls.ext.core", String.format("No package root found for %s", rootId)));
            }
            if (packageRoot instanceof JarPackageFragmentRoot && (fileEntry = ExtUtils.findJarEntryFile(packageRoot, path)) != null) {
                return JarFileContentProvider.readFileContent(fileEntry);
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException((String)"Problem get JarEntryFile content ", (Throwable)e);
        }
        return null;
    }

    private static String readFileContent(JarEntryFile file) throws CoreException {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream stream = file.getContents();){
                return JarFileContentProvider.convertStreamToString(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdtls.ext.core", "Can't read file content: " + file.getFullPath()));
        }
    }

    private static String convertStreamToString(InputStream inputStream) throws IOException {
        return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }
}

