/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdtls.ext.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarEntryDirectory;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public final class ExtUtils {
    public static final String JDT_SCHEME = "jdt";
    private static final String CONTENTS_AUTHORITY = "jarentry";

    public static String toUri(IJarEntryResource jarEntryFile) {
        IPackageFragmentRoot fragmentRoot = jarEntryFile.getPackageFragmentRoot();
        try {
            return new URI(JDT_SCHEME, CONTENTS_AUTHORITY, jarEntryFile.getFullPath().toPortableString(), fragmentRoot.getHandleIdentifier(), null).toASCIIString();
        }
        catch (URISyntaxException e) {
            JavaLanguageServerPlugin.logException((String)"Error generating URI for jarentryfile ", (Throwable)e);
            return null;
        }
    }

    public static boolean isJarResourceUri(URI uri) {
        return uri != null && JDT_SCHEME.equals(uri.getScheme()) && CONTENTS_AUTHORITY.equals(uri.getAuthority());
    }

    public static JarEntryFile findJarEntryFile(IPackageFragmentRoot packageRoot, String path) throws JavaModelException {
        Object[] resources;
        int n;
        int n2;
        Object[] objectArray;
        String[] segments = StringUtils.split((String)path, (String)"/");
        String packageName = StringUtils.join(Arrays.asList(segments).subList(0, segments.length - 1), (char)'.');
        IPackageFragment packageFragment = packageRoot.getPackageFragment(packageName);
        if (packageFragment != null && packageFragment.exists()) {
            Object[] objs = packageFragment.getNonJavaResources();
            objectArray = objs;
            n2 = objs.length;
            n = 0;
            while (n < n2) {
                IJarEntryResource child;
                Object obj = objectArray[n];
                if (obj instanceof IJarEntryResource && (child = (IJarEntryResource)obj) instanceof JarEntryFile && child.getFullPath().toPortableString().equals(path)) {
                    return (JarEntryFile)child;
                }
                ++n;
            }
        }
        objectArray = resources = packageRoot.getNonJavaResources();
        n2 = resources.length;
        n = 0;
        while (n < n2) {
            JarEntryDirectory directory;
            JarEntryFile file;
            JarEntryFile file2;
            Object resource = objectArray[n];
            if (resource instanceof JarEntryFile && (file2 = (JarEntryFile)resource).getFullPath().toPortableString().equals(path)) {
                return file2;
            }
            if (resource instanceof JarEntryDirectory && (file = ExtUtils.findFileInJar(directory = (JarEntryDirectory)resource, path)) != null) {
                return file;
            }
            ++n;
        }
        return null;
    }

    public static IJarEntryResource getJarEntryResource(URI uri) throws CoreException {
        if (uri == null) {
            throw new NullPointerException("Cannot get jar resource from null URI.");
        }
        String handleId = uri.getQuery();
        if (handleId == null) {
            throw new NullPointerException("Invalid uri for a jar entry.");
        }
        IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)JavaCore.create((String)handleId);
        if (packageRoot == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdtls.ext.core", String.format("No package root found for %s", handleId)));
        }
        return ExtUtils.findJarEntryFile(packageRoot, uri.getPath());
    }

    public static IPath removeProjectSegment(String projectElementName, IPath path) {
        if (projectElementName.equals(path.segment(0))) {
            return path.removeFirstSegments(1).makeRelative();
        }
        return path;
    }

    public static URI getContainerURI(IJavaProject javaProject, IClasspathContainer container) throws CoreException {
        switch (container.getKind()) {
            case 2: 
            case 3: {
                return JavaRuntime.getVMInstall((IJavaProject)javaProject).getInstallLocation().toURI();
            }
            case 1: {
                return null;
            }
        }
        return container.getPath().toFile().toURI();
    }

    private static JarEntryFile findFileInJar(JarEntryDirectory directory, String path) {
        IJarEntryResource[] iJarEntryResourceArray = directory.getChildren();
        int n = iJarEntryResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            JarEntryFile file;
            IJarEntryResource child = iJarEntryResourceArray[n2];
            if (child instanceof JarEntryFile && child.getFullPath().toPortableString().equals(path)) {
                return (JarEntryFile)child;
            }
            if (child instanceof JarEntryDirectory && (file = ExtUtils.findFileInJar((JarEntryDirectory)child, path)) != null) {
                return file;
            }
            ++n2;
        }
        return null;
    }
}

