/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.IAnnotationModelFactory;
import org.eclipse.core.filebuffers.IDocumentFactory;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IDocumentSetupParticipantExtension;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ISynchronizationContext;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.filebuffers.AbstractFileBuffer;
import org.eclipse.core.internal.filebuffers.ExtensionsRegistry;
import org.eclipse.core.internal.filebuffers.FileBuffersMessages;
import org.eclipse.core.internal.filebuffers.FileStoreFileBuffer;
import org.eclipse.core.internal.filebuffers.FileStoreTextFileBuffer;
import org.eclipse.core.internal.filebuffers.NLSUtility;
import org.eclipse.core.internal.filebuffers.ResourceTextFileBufferManager;
import org.eclipse.core.internal.filebuffers.SynchronizableDocument;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.source.IAnnotationModel;

public class TextFileBufferManager
implements ITextFileBufferManager {
    protected static final IContentType TEXT_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
    private Map<IPath, AbstractFileBuffer> fFilesBuffers = new HashMap<IPath, AbstractFileBuffer>();
    private Map<IFileStore, FileStoreFileBuffer> fFileStoreFileBuffers = new HashMap<IFileStore, FileStoreFileBuffer>();
    private List<IFileBufferListener> fFileBufferListeners = new ArrayList<IFileBufferListener>();
    protected ExtensionsRegistry fRegistry = new ExtensionsRegistry();
    private ISynchronizationContext fSynchronizationContext;

    @Override
    @Deprecated
    public void connect(IPath location, IProgressMonitor monitor) throws CoreException {
        this.connect(location, LocationKind.NORMALIZE, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(IPath location, LocationKind locationKind, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)location);
        if (locationKind == LocationKind.NORMALIZE) {
            location = this.normalizeLocation(location);
        }
        AbstractFileBuffer fileBuffer = null;
        Map<IPath, AbstractFileBuffer> map = this.fFilesBuffers;
        synchronized (map) {
            fileBuffer = this.internalGetFileBuffer(location);
            if (fileBuffer != null) {
                fileBuffer.connect();
                return;
            }
        }
        fileBuffer = this.createFileBuffer(location, locationKind);
        if (fileBuffer == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 2, FileBuffersMessages.FileBufferManager_error_canNotCreateFilebuffer, null));
        }
        fileBuffer.create(location, monitor);
        map = this.fFilesBuffers;
        synchronized (map) {
            AbstractFileBuffer oldFileBuffer = this.internalGetFileBuffer(location);
            if (oldFileBuffer != null) {
                fileBuffer.disconnect();
                fileBuffer.dispose();
                oldFileBuffer.connect();
                return;
            }
            fileBuffer.connect();
            this.fFilesBuffers.put(location, fileBuffer);
        }
        this.fireBufferCreated(fileBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectFileStore(IFileStore fileStore, IProgressMonitor monitor) throws CoreException {
        Assert.isLegal((fileStore != null ? 1 : 0) != 0);
        FileStoreFileBuffer fileBuffer = null;
        Map<IFileStore, FileStoreFileBuffer> map = this.fFileStoreFileBuffers;
        synchronized (map) {
            fileBuffer = this.internalGetFileBuffer(fileStore);
            if (fileBuffer != null) {
                fileBuffer.connect();
                return;
            }
        }
        fileBuffer = this.createFileBuffer(fileStore);
        if (fileBuffer == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 2, FileBuffersMessages.FileBufferManager_error_canNotCreateFilebuffer, null));
        }
        fileBuffer.create(fileStore, monitor);
        map = this.fFileStoreFileBuffers;
        synchronized (map) {
            FileStoreFileBuffer oldFileBuffer = this.internalGetFileBuffer(fileStore);
            if (oldFileBuffer != null) {
                fileBuffer.disconnect();
                fileBuffer.dispose();
                ((AbstractFileBuffer)oldFileBuffer).connect();
                return;
            }
            fileBuffer.connect();
            this.fFileStoreFileBuffers.put(fileStore, fileBuffer);
        }
        this.fireBufferCreated(fileBuffer);
    }

    @Override
    @Deprecated
    public void disconnect(IPath location, IProgressMonitor monitor) throws CoreException {
        this.disconnect(location, LocationKind.NORMALIZE, monitor);
    }

    protected IPath normalizeLocation(IPath location) {
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(IPath location, LocationKind locationKind, IProgressMonitor monitor) throws CoreException {
        AbstractFileBuffer fileBuffer;
        Assert.isNotNull((Object)location);
        if (locationKind == LocationKind.NORMALIZE) {
            location = this.normalizeLocation(location);
        }
        Map<IPath, AbstractFileBuffer> map = this.fFilesBuffers;
        synchronized (map) {
            fileBuffer = this.internalGetFileBuffer(location);
            if (fileBuffer == null) {
                return;
            }
            fileBuffer.disconnect();
            if (!fileBuffer.isDisconnected()) {
                return;
            }
            this.fFilesBuffers.remove(location);
        }
        this.fireBufferDisposed(fileBuffer);
        fileBuffer.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectFileStore(IFileStore fileStore, IProgressMonitor monitor) throws CoreException {
        FileStoreFileBuffer fileBuffer;
        Assert.isLegal((fileStore != null ? 1 : 0) != 0);
        Map<IFileStore, FileStoreFileBuffer> map = this.fFileStoreFileBuffers;
        synchronized (map) {
            fileBuffer = this.internalGetFileBuffer(fileStore);
            if (fileBuffer == null) {
                return;
            }
            ((AbstractFileBuffer)fileBuffer).disconnect();
            if (!((AbstractFileBuffer)fileBuffer).isDisconnected()) {
                return;
            }
            this.fFileStoreFileBuffers.remove(fileStore);
        }
        this.fireBufferDisposed(fileBuffer);
        fileBuffer.dispose();
    }

    @Override
    @Deprecated
    public boolean isTextFileLocation(IPath location) {
        return this.isTextFileLocation(location, false);
    }

    protected boolean isTextFileLocation(IFileStore fileStore, boolean strict) {
        if (fileStore == null) {
            return false;
        }
        IContentTypeManager manager = Platform.getContentTypeManager();
        IFileInfo fileInfo = fileStore.fetchInfo();
        if (fileInfo.exists()) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream is = fileStore.openInputStream(0, null);){
                    IContentType type;
                    IContentDescription description = manager.getDescriptionFor(is, fileStore.getName(), IContentDescription.ALL);
                    if (description != null && (type = description.getContentType()) != null) {
                        return type.isKindOf(TEXT_CONTENT_TYPE);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException throwable) {}
            return !strict;
        }
        IContentType[] contentTypes = manager.findContentTypesFor(fileStore.getName());
        if (contentTypes != null && contentTypes.length > 0) {
            IContentType[] iContentTypeArray = contentTypes;
            int n = contentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType contentType = iContentTypeArray[n2];
                if (contentType.isKindOf(TEXT_CONTENT_TYPE)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return !strict;
    }

    @Override
    public boolean isTextFileLocation(IPath location, boolean strict) {
        Assert.isNotNull((Object)location);
        location = this.normalizeLocation(location);
        try {
            return this.isTextFileLocation(EFS.getStore((URI)URIUtil.toURI((IPath)location)), strict);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    @Deprecated
    public IFileBuffer getFileBuffer(IPath location) {
        return this.getFileBuffer(location, LocationKind.NORMALIZE);
    }

    @Override
    public IFileBuffer getFileBuffer(IPath location, LocationKind locationKind) {
        if (locationKind == LocationKind.NORMALIZE) {
            location = this.normalizeLocation(location);
        }
        return this.internalGetFileBuffer(location);
    }

    @Override
    public IFileBuffer getFileStoreFileBuffer(IFileStore fileStore) {
        Assert.isLegal((fileStore != null ? 1 : 0) != 0);
        return this.internalGetFileBuffer(fileStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractFileBuffer internalGetFileBuffer(IPath location) {
        Map<IPath, AbstractFileBuffer> map = this.fFilesBuffers;
        synchronized (map) {
            return this.fFilesBuffers.get(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileStoreFileBuffer internalGetFileBuffer(IFileStore fileStore) {
        Map<IFileStore, FileStoreFileBuffer> map = this.fFileStoreFileBuffers;
        synchronized (map) {
            return this.fFileStoreFileBuffers.get(fileStore);
        }
    }

    @Override
    @Deprecated
    public ITextFileBuffer getTextFileBuffer(IPath location) {
        return this.getTextFileBuffer(location, LocationKind.NORMALIZE);
    }

    @Override
    public ITextFileBuffer getTextFileBuffer(IPath location, LocationKind locationKind) {
        return (ITextFileBuffer)this.getFileBuffer(location, locationKind);
    }

    @Override
    public ITextFileBuffer getFileStoreTextFileBuffer(IFileStore fileStore) {
        Assert.isLegal((fileStore != null ? 1 : 0) != 0);
        return (ITextFileBuffer)this.getFileStoreFileBuffer(fileStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ITextFileBuffer getTextFileBuffer(IDocument document) {
        Assert.isLegal((boolean)(document != null));
        var3_2 = this.fFilesBuffers;
        synchronized (var3_2) {
            iter = new ArrayList<AbstractFileBuffer>(this.fFilesBuffers.values()).iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var3_2
            if (true) ** GOTO lbl16
        }
        do {
            if (!((buffer = iter.next()) instanceof ITextFileBuffer) || (textFileBuffer = (ITextFileBuffer)buffer).getDocument() != document) continue;
            if (!((AbstractFileBuffer)textFileBuffer).isDisconnected()) {
                return textFileBuffer;
            }
            return null;
lbl16:
            // 2 sources

        } while (iter.hasNext());
        buffer = this.fFileStoreFileBuffers;
        synchronized (buffer) {
            iter = new ArrayList<FileStoreFileBuffer>(this.fFileStoreFileBuffers.values()).iterator();
            // MONITOREXIT @DISABLED, blocks:[1, 3] lbl22 : MonitorExitStatement: MONITOREXIT : buffer
            if (true) ** GOTO lbl28
        }
        do {
            if (!((buffer = iter.next()) instanceof ITextFileBuffer) || (textFileBuffer = (ITextFileBuffer)buffer).getDocument() != document || ((AbstractFileBuffer)textFileBuffer).isDisconnected()) continue;
            return textFileBuffer;
lbl28:
            // 2 sources

        } while (iter.hasNext());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFileBuffer[] getFileBuffers() {
        Map<IPath, AbstractFileBuffer> map = this.fFilesBuffers;
        synchronized (map) {
            Collection<AbstractFileBuffer> values = this.fFilesBuffers.values();
            return values.toArray(new IFileBuffer[values.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFileBuffer[] getFileStoreFileBuffers() {
        Map<IFileStore, FileStoreFileBuffer> map = this.fFileStoreFileBuffers;
        synchronized (map) {
            Collection<FileStoreFileBuffer> values = this.fFileStoreFileBuffers.values();
            return values.toArray(new IFileBuffer[values.size()]);
        }
    }

    @Override
    public String getDefaultEncoding() {
        return System.getProperty("file.encoding");
    }

    @Override
    @Deprecated
    public IDocument createEmptyDocument(IPath location) {
        return this.createEmptyDocument(location, LocationKind.NORMALIZE);
    }

    @Override
    public IDocument createEmptyDocument(IPath location, LocationKind locationKind) {
        IDocumentSetupParticipant[] participants;
        String initalLineDelimiter;
        IDocument documentFromFactory = this.createDocumentFromFactory(location, locationKind);
        Object document = documentFromFactory != null ? documentFromFactory : new SynchronizableDocument();
        if (location == null) {
            return document;
        }
        if (document instanceof IDocumentExtension4 && (initalLineDelimiter = this.getLineDelimiterPreference(location, locationKind)) != null) {
            ((IDocumentExtension4)document).setInitialLineDelimiter(initalLineDelimiter);
        }
        if ((participants = this.fRegistry.getDocumentSetupParticipants(location, locationKind)) != null) {
            IDocumentSetupParticipant[] iDocumentSetupParticipantArray = participants;
            int n = participants.length;
            int n2 = 0;
            while (n2 < n) {
                final IDocumentSetupParticipant participant = iDocumentSetupParticipantArray[n2];
                ISafeRunnable runnable = new ISafeRunnable((IDocument)document, location, locationKind){
                    private final /* synthetic */ IDocument val$document;
                    private final /* synthetic */ IPath val$location;
                    private final /* synthetic */ LocationKind val$locationKind;
                    {
                        this.val$document = iDocument;
                        this.val$location = iPath;
                        this.val$locationKind = locationKind;
                    }

                    public void run() throws Exception {
                        if (participant instanceof IDocumentSetupParticipantExtension) {
                            ((IDocumentSetupParticipantExtension)((Object)participant)).setup(this.val$document, this.val$location, this.val$locationKind);
                        } else {
                            participant.setup(this.val$document);
                        }
                        if (this.val$document.getDocumentPartitioner() != null) {
                            String message = NLSUtility.format(FileBuffersMessages.TextFileBufferManager_warning_documentSetupInstallsDefaultPartitioner, participant.getClass());
                            Status status = new Status(2, "org.eclipse.core.filebuffers", 0, message, null);
                            Platform.getLog(ResourceTextFileBufferManager.class).log((IStatus)status);
                        }
                    }

                    public void handleException(Throwable t) {
                        Status status = new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.TextFileBufferManager_error_documentSetupFailed, t);
                        Platform.getLog(ResourceTextFileBufferManager.class).log((IStatus)status);
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
                ++n2;
            }
        }
        return document;
    }

    @Deprecated
    private IDocument createDocumentFromFactory(IPath location, LocationKind locationKind) {
        IDocumentFactory factory;
        final IDocument[] runnableResult = new IDocument[1];
        if (location != null && (factory = this.fRegistry.getDocumentFactory(location, locationKind)) != null) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    runnableResult[0] = factory.createDocument();
                }

                public void handleException(Throwable t) {
                    Status status = new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.TextFileBufferManager_error_documentFactoryFailed, t);
                    Platform.getLog(ResourceTextFileBufferManager.class).log((IStatus)status);
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
        return runnableResult[0];
    }

    @Override
    @Deprecated
    public IAnnotationModel createAnnotationModel(IPath location) {
        return this.createAnnotationModel(location, LocationKind.NORMALIZE);
    }

    @Override
    public IAnnotationModel createAnnotationModel(IPath location, LocationKind locationKind) {
        Assert.isNotNull((Object)location);
        IAnnotationModelFactory factory = this.fRegistry.getAnnotationModelFactory(location, locationKind);
        if (factory != null) {
            return factory.createAnnotationModel(location);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFileBufferListener(IFileBufferListener listener) {
        Assert.isNotNull((Object)listener);
        List<IFileBufferListener> list = this.fFileBufferListeners;
        synchronized (list) {
            if (!this.fFileBufferListeners.contains(listener)) {
                this.fFileBufferListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFileBufferListener(IFileBufferListener listener) {
        Assert.isNotNull((Object)listener);
        List<IFileBufferListener> list = this.fFileBufferListeners;
        synchronized (list) {
            this.fFileBufferListeners.remove(listener);
        }
    }

    @Override
    public void setSynchronizationContext(ISynchronizationContext context) {
        this.fSynchronizationContext = context;
    }

    @Override
    @Deprecated
    public void requestSynchronizationContext(IPath location) {
        Assert.isNotNull((Object)location);
        location = this.normalizeLocation(location);
        AbstractFileBuffer fileBuffer = this.internalGetFileBuffer(location);
        if (fileBuffer != null) {
            fileBuffer.requestSynchronizationContext();
        }
    }

    @Override
    @Deprecated
    public void releaseSynchronizationContext(IPath location) {
        Assert.isNotNull((Object)location);
        location = this.normalizeLocation(location);
        AbstractFileBuffer fileBuffer = this.internalGetFileBuffer(location);
        if (fileBuffer != null) {
            fileBuffer.releaseSynchronizationContext();
        }
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.fSynchronizationContext != null) {
            this.fSynchronizationContext.run(runnable);
        } else {
            runnable.run();
        }
    }

    private AbstractFileBuffer createFileBuffer(IPath location, LocationKind locationKind) {
        return this.createTextFileBuffer(location, locationKind);
    }

    protected AbstractFileBuffer createTextFileBuffer(IPath location, LocationKind locationKind) {
        Assert.isLegal((locationKind != LocationKind.IFILE ? 1 : 0) != 0);
        return new FileStoreTextFileBuffer(this);
    }

    private FileStoreFileBuffer createFileBuffer(IFileStore location) {
        return this.createTextFileBuffer(location);
    }

    protected FileStoreFileBuffer createTextFileBuffer(IFileStore location) {
        return new FileStoreTextFileBuffer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<IFileBufferListener> getFileBufferListenerIterator() {
        List<IFileBufferListener> list = this.fFileBufferListeners;
        synchronized (list) {
            return new ArrayList<IFileBufferListener>(this.fFileBufferListeners).iterator();
        }
    }

    protected void fireDirtyStateChanged(final IFileBuffer buffer, final boolean isDirty) {
        Iterator<IFileBufferListener> e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.dirtyStateChanged(buffer, isDirty);
                }
            });
        }
    }

    protected void fireBufferContentAboutToBeReplaced(final IFileBuffer buffer) {
        Iterator<IFileBufferListener> e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.bufferContentAboutToBeReplaced(buffer);
                }
            });
        }
    }

    protected void fireBufferContentReplaced(final IFileBuffer buffer) {
        Iterator<IFileBufferListener> e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.bufferContentReplaced(buffer);
                }
            });
        }
    }

    protected void fireUnderlyingFileMoved(final IFileBuffer buffer, final IPath target) {
        Iterator<IFileBufferListener> e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.underlyingFileMoved(buffer, target);
                }
            });
        }
    }

    protected void fireUnderlyingFileDeleted(final IFileBuffer buffer) {
        Iterator<IFileBufferListener> e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.underlyingFileDeleted(buffer);
                }
            });
        }
    }

    protected void fireStateValidationChanged(final IFileBuffer buffer, final boolean isStateValidated) {
        Iterator<IFileBufferListener> e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.stateValidationChanged(buffer, isStateValidated);
                }
            });
        }
    }

    protected void fireStateChanging(final IFileBuffer buffer) {
        Iterator<IFileBufferListener> e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.stateChanging(buffer);
                }
            });
        }
    }

    protected void fireStateChangeFailed(final IFileBuffer buffer) {
        Iterator<IFileBufferListener> e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.stateChangeFailed(buffer);
                }
            });
        }
    }

    protected void fireBufferCreated(final IFileBuffer buffer) {
        Iterator<IFileBufferListener> e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.bufferCreated(buffer);
                }
            });
        }
    }

    protected void fireBufferDisposed(final IFileBuffer buffer) {
        Iterator<IFileBufferListener> e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.bufferDisposed(buffer);
                }
            });
        }
    }

    @Override
    public void validateState(IFileBuffer[] fileBuffers, IProgressMonitor monitor, Object computationContext) throws CoreException {
    }

    protected String getLineDelimiterPreference(IPath location, LocationKind locationKind) {
        return System.lineSeparator();
    }

    private static abstract class SafeNotifier
    implements ISafeRunnable {
        private SafeNotifier() {
        }

        public void handleException(Throwable ex) {
        }
    }
}

