"use strict";
/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginTheiaDirectoryHandler = void 0;
const plugin_protocol_1 = require("../../../common/plugin-protocol");
const inversify_1 = require("@theia/core/shared/inversify");
const fs = require("@theia/core/shared/fs-extra");
const path = require("path");
let PluginTheiaDirectoryHandler = class PluginTheiaDirectoryHandler {
    accept(resolvedPlugin) {
        console.log('PluginTheiaDirectoryHandler: accepting plugin with path', resolvedPlugin.path());
        // handle only directories
        if (resolvedPlugin.isFile()) {
            return false;
        }
        // is there a package.json ?
        const packageJsonPath = path.resolve(resolvedPlugin.path(), 'package.json');
        const existsPackageJson = fs.existsSync(packageJsonPath);
        if (!existsPackageJson) {
            return false;
        }
        let packageJson = resolvedPlugin.getValue('package.json');
        if (!packageJson) {
            packageJson = fs.readJSONSync(packageJsonPath);
            resolvedPlugin.storeValue('package.json', packageJson);
        }
        if (!packageJson.engines) {
            return false;
        }
        if (packageJson.engines && packageJson.engines.theiaPlugin) {
            return true;
        }
        return false;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    handle(context) {
        const types = [];
        const packageJson = context.pluginEntry().getValue('package.json');
        if (packageJson.theiaPlugin && packageJson.theiaPlugin.backend) {
            types.push(plugin_protocol_1.PluginDeployerEntryType.BACKEND);
        }
        if (packageJson.theiaPlugin && packageJson.theiaPlugin.frontend) {
            types.push(plugin_protocol_1.PluginDeployerEntryType.FRONTEND);
        }
        context.pluginEntry().accept(...types);
        return Promise.resolve(true);
    }
};
PluginTheiaDirectoryHandler = __decorate([
    inversify_1.injectable()
], PluginTheiaDirectoryHandler);
exports.PluginTheiaDirectoryHandler = PluginTheiaDirectoryHandler;
//# sourceMappingURL=plugin-theia-directory-handler.js.map