/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { $ } from '../../../base/browser/dom';
import { isEmptyMarkdownString } from '../../../base/common/htmlContent';
import { DisposableStore } from '../../../base/common/lifecycle';
import { HoverOperation } from './hoverOperation';
import { GlyphHoverWidget } from './hoverWidgets';
import { MarkdownRenderer } from '../../browser/core/markdownRenderer';
import { NullOpenerService } from '../../../platform/opener/common/opener';
import { asArray } from '../../../base/common/arrays';
var MarginComputer = /** @class */ (function () {
    function MarginComputer(editor) {
        this._editor = editor;
        this._lineNumber = -1;
        this._result = [];
    }
    MarginComputer.prototype.setLineNumber = function (lineNumber) {
        this._lineNumber = lineNumber;
        this._result = [];
    };
    MarginComputer.prototype.clearResult = function () {
        this._result = [];
    };
    MarginComputer.prototype.computeSync = function () {
        var e_1, _a;
        var toHoverMessage = function (contents) {
            return {
                value: contents
            };
        };
        var lineDecorations = this._editor.getLineDecorations(this._lineNumber);
        var result = [];
        if (!lineDecorations) {
            return result;
        }
        try {
            for (var lineDecorations_1 = __values(lineDecorations), lineDecorations_1_1 = lineDecorations_1.next(); !lineDecorations_1_1.done; lineDecorations_1_1 = lineDecorations_1.next()) {
                var d = lineDecorations_1_1.value;
                if (!d.options.glyphMarginClassName) {
                    continue;
                }
                var hoverMessage = d.options.glyphMarginHoverMessage;
                if (!hoverMessage || isEmptyMarkdownString(hoverMessage)) {
                    continue;
                }
                result.push.apply(result, __spreadArray([], __read(asArray(hoverMessage).map(toHoverMessage))));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (lineDecorations_1_1 && !lineDecorations_1_1.done && (_a = lineDecorations_1.return)) _a.call(lineDecorations_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return result;
    };
    MarginComputer.prototype.onResult = function (result, isFromSynchronousComputation) {
        this._result = this._result.concat(result);
    };
    MarginComputer.prototype.getResult = function () {
        return this._result;
    };
    MarginComputer.prototype.getResultWithLoadingMessage = function () {
        return this.getResult();
    };
    return MarginComputer;
}());
var ModesGlyphHoverWidget = /** @class */ (function (_super) {
    __extends(ModesGlyphHoverWidget, _super);
    function ModesGlyphHoverWidget(editor, modeService, openerService) {
        if (openerService === void 0) { openerService = NullOpenerService; }
        var _this = _super.call(this, ModesGlyphHoverWidget.ID, editor) || this;
        _this._renderDisposeables = _this._register(new DisposableStore());
        _this._messages = [];
        _this._lastLineNumber = -1;
        _this._markdownRenderer = _this._register(new MarkdownRenderer({ editor: _this._editor }, modeService, openerService));
        _this._computer = new MarginComputer(_this._editor);
        _this._hoverOperation = new HoverOperation(_this._computer, function (result) { return _this._withResult(result); }, undefined, function (result) { return _this._withResult(result); }, 300);
        return _this;
    }
    ModesGlyphHoverWidget.prototype.dispose = function () {
        this._hoverOperation.cancel();
        _super.prototype.dispose.call(this);
    };
    ModesGlyphHoverWidget.prototype.onModelDecorationsChanged = function () {
        if (this.isVisible) {
            // The decorations have changed and the hover is visible,
            // we need to recompute the displayed text
            this._hoverOperation.cancel();
            this._computer.clearResult();
            this._hoverOperation.start(0 /* Delayed */);
        }
    };
    ModesGlyphHoverWidget.prototype.startShowingAt = function (lineNumber) {
        if (this._lastLineNumber === lineNumber) {
            // We have to show the widget at the exact same line number as before, so no work is needed
            return;
        }
        this._hoverOperation.cancel();
        this.hide();
        this._lastLineNumber = lineNumber;
        this._computer.setLineNumber(lineNumber);
        this._hoverOperation.start(0 /* Delayed */);
    };
    ModesGlyphHoverWidget.prototype.hide = function () {
        this._lastLineNumber = -1;
        this._hoverOperation.cancel();
        _super.prototype.hide.call(this);
    };
    ModesGlyphHoverWidget.prototype._withResult = function (result) {
        this._messages = result;
        if (this._messages.length > 0) {
            this._renderMessages(this._lastLineNumber, this._messages);
        }
        else {
            this.hide();
        }
    };
    ModesGlyphHoverWidget.prototype._renderMessages = function (lineNumber, messages) {
        var e_2, _a;
        this._renderDisposeables.clear();
        var fragment = document.createDocumentFragment();
        try {
            for (var messages_1 = __values(messages), messages_1_1 = messages_1.next(); !messages_1_1.done; messages_1_1 = messages_1.next()) {
                var msg = messages_1_1.value;
                var renderedContents = this._markdownRenderer.render(msg.value);
                this._renderDisposeables.add(renderedContents);
                fragment.appendChild($('div.hover-row', undefined, renderedContents.element));
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (messages_1_1 && !messages_1_1.done && (_a = messages_1.return)) _a.call(messages_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        this.updateContents(fragment);
        this.showAt(lineNumber);
    };
    ModesGlyphHoverWidget.ID = 'editor.contrib.modesGlyphHoverWidget';
    return ModesGlyphHoverWidget;
}(GlyphHoverWidget));
export { ModesGlyphHoverWidget };
