/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import * as nls from '../../../nls';
import * as dom from '../../../base/browser/dom';
import { MarkdownString, isEmptyMarkdownString, markedStringsEquals } from '../../../base/common/htmlContent';
import { DisposableStore } from '../../../base/common/lifecycle';
import { Range } from '../../common/core/range';
import { MarkdownRenderer } from '../../browser/core/markdownRenderer';
import { asArray } from '../../../base/common/arrays';
import { IOpenerService } from '../../../platform/opener/common/opener';
import { IModeService } from '../../common/services/modeService';
import { HoverProviderRegistry } from '../../common/modes';
import { getHover } from './getHover';
import { Position } from '../../common/core/position';
var $ = dom.$;
var MarkdownHover = /** @class */ (function () {
    function MarkdownHover(range, contents) {
        this.range = range;
        this.contents = contents;
    }
    MarkdownHover.prototype.equals = function (other) {
        if (other instanceof MarkdownHover) {
            return markedStringsEquals(this.contents, other.contents);
        }
        return false;
    };
    return MarkdownHover;
}());
export { MarkdownHover };
var MarkdownHoverParticipant = /** @class */ (function () {
    function MarkdownHoverParticipant(_editor, _hover, _modeService, _openerService) {
        this._editor = _editor;
        this._hover = _hover;
        this._modeService = _modeService;
        this._openerService = _openerService;
    }
    MarkdownHoverParticipant.prototype.createLoadingMessage = function (range) {
        return new MarkdownHover(range, [new MarkdownString().appendText(nls.localize('modesContentHover.loading', "Loading..."))]);
    };
    MarkdownHoverParticipant.prototype.computeSync = function (hoverRange, lineDecorations) {
        var e_1, _a;
        if (!this._editor.hasModel()) {
            return [];
        }
        var model = this._editor.getModel();
        var lineNumber = hoverRange.startLineNumber;
        var maxColumn = model.getLineMaxColumn(lineNumber);
        var result = [];
        try {
            for (var lineDecorations_1 = __values(lineDecorations), lineDecorations_1_1 = lineDecorations_1.next(); !lineDecorations_1_1.done; lineDecorations_1_1 = lineDecorations_1.next()) {
                var d = lineDecorations_1_1.value;
                var startColumn = (d.range.startLineNumber === lineNumber) ? d.range.startColumn : 1;
                var endColumn = (d.range.endLineNumber === lineNumber) ? d.range.endColumn : maxColumn;
                var hoverMessage = d.options.hoverMessage;
                if (!hoverMessage || isEmptyMarkdownString(hoverMessage)) {
                    continue;
                }
                var range = new Range(hoverRange.startLineNumber, startColumn, hoverRange.startLineNumber, endColumn);
                result.push(new MarkdownHover(range, asArray(hoverMessage)));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (lineDecorations_1_1 && !lineDecorations_1_1.done && (_a = lineDecorations_1.return)) _a.call(lineDecorations_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return result;
    };
    MarkdownHoverParticipant.prototype.computeAsync = function (range, token) {
        return __awaiter(this, void 0, void 0, function () {
            var model, hovers, result, hovers_1, hovers_1_1, hover, rng;
            var e_2, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!this._editor.hasModel() || !range) {
                            return [2 /*return*/, Promise.resolve([])];
                        }
                        model = this._editor.getModel();
                        if (!HoverProviderRegistry.has(model)) {
                            return [2 /*return*/, Promise.resolve([])];
                        }
                        return [4 /*yield*/, getHover(model, new Position(range.startLineNumber, range.startColumn), token)];
                    case 1:
                        hovers = _b.sent();
                        result = [];
                        try {
                            for (hovers_1 = __values(hovers), hovers_1_1 = hovers_1.next(); !hovers_1_1.done; hovers_1_1 = hovers_1.next()) {
                                hover = hovers_1_1.value;
                                if (isEmptyMarkdownString(hover.contents)) {
                                    continue;
                                }
                                rng = hover.range ? Range.lift(hover.range) : range;
                                result.push(new MarkdownHover(rng, hover.contents));
                            }
                        }
                        catch (e_2_1) { e_2 = { error: e_2_1 }; }
                        finally {
                            try {
                                if (hovers_1_1 && !hovers_1_1.done && (_a = hovers_1.return)) _a.call(hovers_1);
                            }
                            finally { if (e_2) throw e_2.error; }
                        }
                        return [2 /*return*/, result];
                }
            });
        });
    };
    MarkdownHoverParticipant.prototype.renderHoverParts = function (hoverParts, fragment) {
        var e_3, _a, e_4, _b;
        var _this = this;
        var disposables = new DisposableStore();
        try {
            for (var hoverParts_1 = __values(hoverParts), hoverParts_1_1 = hoverParts_1.next(); !hoverParts_1_1.done; hoverParts_1_1 = hoverParts_1.next()) {
                var hoverPart = hoverParts_1_1.value;
                var _loop_1 = function (contents) {
                    if (isEmptyMarkdownString(contents)) {
                        return "continue";
                    }
                    var markdownHoverElement = $('div.hover-row.markdown-hover');
                    var hoverContentsElement = dom.append(markdownHoverElement, $('div.hover-contents'));
                    var renderer = disposables.add(new MarkdownRenderer({ editor: this_1._editor }, this_1._modeService, this_1._openerService));
                    disposables.add(renderer.onDidRenderAsync(function () {
                        hoverContentsElement.className = 'hover-contents code-hover-contents';
                        _this._hover.onContentsChanged();
                    }));
                    var renderedContents = disposables.add(renderer.render(contents));
                    hoverContentsElement.appendChild(renderedContents.element);
                    fragment.appendChild(markdownHoverElement);
                };
                var this_1 = this;
                try {
                    for (var _c = (e_4 = void 0, __values(hoverPart.contents)), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var contents = _d.value;
                        _loop_1(contents);
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (hoverParts_1_1 && !hoverParts_1_1.done && (_a = hoverParts_1.return)) _a.call(hoverParts_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return disposables;
    };
    MarkdownHoverParticipant = __decorate([
        __param(2, IModeService),
        __param(3, IOpenerService)
    ], MarkdownHoverParticipant);
    return MarkdownHoverParticipant;
}());
export { MarkdownHoverParticipant };
