/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.searcher;

import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.searcher.BaseFrameworkSearcher;
import com.microsoft.java.test.plugin.util.TestFrameworkUtils;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.Modifier;

public class JUnit4TestSearcher
extends BaseFrameworkSearcher {
    public static final String RUN_WITH = "org.junit.runner.RunWith";

    public JUnit4TestSearcher() {
        this.testMethodAnnotations = new String[]{"org.junit.Test", "org.junit.experimental.theories.Theory"};
        this.testClassAnnotations = new String[]{RUN_WITH};
    }

    @Override
    public TestKind getTestKind() {
        return TestKind.JUnit;
    }

    @Override
    public String getJdtTestKind() {
        return "org.eclipse.jdt.junit.loader.junit4";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isTestMethod(IMethod method) {
        try {
            int flags = method.getFlags();
            if (Flags.isAbstract((int)flags) || Flags.isStatic((int)flags) || !Flags.isPublic((int)flags)) {
                return false;
            }
            if (method.isConstructor() || !"V".equals(method.getReturnType())) {
                return false;
            }
            String[] stringArray = this.testMethodAnnotations;
            int n = this.testMethodAnnotations.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String annotation = stringArray[n2];
                if (TestFrameworkUtils.hasAnnotation((IMember)method, annotation, false)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    @Override
    public boolean isTestMethod(IMethodBinding methodBinding) {
        int modifiers = methodBinding.getModifiers();
        if (Modifier.isAbstract((int)modifiers) || Modifier.isStatic((int)modifiers) || !Modifier.isPublic((int)modifiers)) {
            return false;
        }
        if (methodBinding.isConstructor() || !"void".equals(methodBinding.getReturnType().getName())) {
            return false;
        }
        return this.findAnnotation(methodBinding.getAnnotations(), this.getTestMethodAnnotations());
    }
}

