'use strict';
/** @module route/nodes */


/**
 * Create a node for use with the parser, giving it a constructor that takes
 * props, children, and returns an object with props, children, and a
 * displayName.
 * @param  {String} displayName The display name for the node
 * @return {{displayName: string, props: Object, children: Array}}
 */
function createNode(displayName) {
  return function(props, children) {
    return {
      displayName: displayName,
      props: props,
      children: children || []
    };
  };
}

module.exports = {
  Root: createNode('Root'),
  Concat: createNode('Concat'),
  Literal: createNode('Literal'),
  Splat: createNode('Splat'),
  Param: createNode('Param'),
  Optional: createNode('Optional')
};
