"use strict";
/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const inversify_1 = require("@theia/core/shared/inversify");
const vsx_extension_resolver_1 = require("./vsx-extension-resolver");
const plugin_protocol_1 = require("@theia/plugin-ext/lib/common/plugin-protocol");
const plugin_vscode_types_1 = require("@theia/plugin-ext-vscode/lib/common/plugin-vscode-types");
const ovsx_client_1 = require("@theia/ovsx-client/lib/ovsx-client");
exports.default = new inversify_1.ContainerModule(bind => {
    bind(ovsx_client_1.OVSXClient).toConstantValue(new ovsx_client_1.OVSXClient({
        apiVersion: process.env['VSCODE_API_VERSION'] || plugin_vscode_types_1.VSCODE_DEFAULT_API_VERSION,
        apiUrl: resolveRegistryUrl()
    }));
    bind(vsx_extension_resolver_1.VSXExtensionResolver).toSelf().inSingletonScope();
    bind(plugin_protocol_1.PluginDeployerResolver).toService(vsx_extension_resolver_1.VSXExtensionResolver);
});
function resolveRegistryUrl() {
    return process.env['VSX_REGISTRY_URL'] || plugin_vscode_types_1.VSX_REGISTRY_URL_DEFAULT;
}
//# sourceMappingURL=vsx-registry-backend-module.js.map