/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var _a;
import './media/diffEditor.css';
import * as nls from '../../../nls';
import * as dom from '../../../base/browser/dom';
import { createFastDomNode } from '../../../base/browser/fastDomNode';
import { Sash } from '../../../base/browser/ui/sash/sash';
import { RunOnceScheduler } from '../../../base/common/async';
import { Emitter } from '../../../base/common/event';
import { Disposable } from '../../../base/common/lifecycle';
import { Configuration } from '../config/configuration';
import { StableEditorScrollState } from '../core/editorState';
import { ICodeEditorService } from '../services/codeEditorService';
import { CodeEditorWidget } from './codeEditorWidget';
import { DiffReview } from './diffReview';
import { EditorOptions, EditorFontLigatures, stringSet as validateStringSetOption, boolean as validateBooleanOption } from '../../common/config/editorOptions';
import { Range } from '../../common/core/range';
import { createStringBuilder } from '../../common/core/stringBuilder';
import * as editorCommon from '../../common/editorCommon';
import { ModelDecorationOptions } from '../../common/model/textModel';
import { IEditorWorkerService } from '../../common/services/editorWorkerService';
import { OverviewRulerZone } from '../../common/view/overviewZoneManager';
import { LineDecoration } from '../../common/viewLayout/lineDecorations';
import { RenderLineInput, renderViewLine } from '../../common/viewLayout/viewLineRenderer';
import { InlineDecoration, ViewLineRenderingData } from '../../common/viewModel/viewModel';
import { IContextKeyService } from '../../../platform/contextkey/common/contextkey';
import { IInstantiationService } from '../../../platform/instantiation/common/instantiation';
import { ServiceCollection } from '../../../platform/instantiation/common/serviceCollection';
import { INotificationService } from '../../../platform/notification/common/notification';
import { defaultInsertColor, defaultRemoveColor, diffBorder, diffInserted, diffInsertedOutline, diffRemoved, diffRemovedOutline, scrollbarShadow, scrollbarSliderBackground, scrollbarSliderHoverBackground, scrollbarSliderActiveBackground, diffDiagonalFill } from '../../../platform/theme/common/colorRegistry';
import { IThemeService, getThemeTypeSelector, registerThemingParticipant, ThemeIcon } from '../../../platform/theme/common/themeService';
import { IContextMenuService } from '../../../platform/contextview/browser/contextView';
import { InlineDiffMargin } from './inlineDiffMargin';
import { IClipboardService } from '../../../platform/clipboard/common/clipboardService';
import { EditorExtensionsRegistry } from '../editorExtensions';
import { onUnexpectedError } from '../../../base/common/errors';
import { IEditorProgressService } from '../../../platform/progress/common/progress';
import { ElementSizeObserver } from '../config/elementSizeObserver';
import { Codicon } from '../../../base/common/codicons';
import { MOUSE_CURSOR_TEXT_CSS_CLASS_NAME } from '../../../base/browser/ui/mouseCursor/mouseCursor';
import { registerIcon } from '../../../platform/theme/common/iconRegistry';
var VisualEditorState = /** @class */ (function () {
    function VisualEditorState(_contextMenuService, _clipboardService) {
        this._contextMenuService = _contextMenuService;
        this._clipboardService = _clipboardService;
        this._zones = [];
        this._inlineDiffMargins = [];
        this._zonesMap = {};
        this._decorations = [];
    }
    VisualEditorState.prototype.getForeignViewZones = function (allViewZones) {
        var _this = this;
        return allViewZones.filter(function (z) { return !_this._zonesMap[String(z.id)]; });
    };
    VisualEditorState.prototype.clean = function (editor) {
        var _this = this;
        // (1) View zones
        if (this._zones.length > 0) {
            editor.changeViewZones(function (viewChangeAccessor) {
                var e_1, _a;
                try {
                    for (var _b = __values(_this._zones), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var zoneId = _c.value;
                        viewChangeAccessor.removeZone(zoneId);
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            });
        }
        this._zones = [];
        this._zonesMap = {};
        // (2) Model decorations
        this._decorations = editor.deltaDecorations(this._decorations, []);
    };
    VisualEditorState.prototype.apply = function (editor, overviewRuler, newDecorations, restoreScrollState) {
        var _this = this;
        var scrollState = restoreScrollState ? StableEditorScrollState.capture(editor) : null;
        // view zones
        editor.changeViewZones(function (viewChangeAccessor) {
            var e_2, _a, e_3, _b;
            try {
                for (var _c = __values(_this._zones), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var zoneId = _d.value;
                    viewChangeAccessor.removeZone(zoneId);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_2) throw e_2.error; }
            }
            try {
                for (var _e = __values(_this._inlineDiffMargins), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var inlineDiffMargin = _f.value;
                    inlineDiffMargin.dispose();
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                }
                finally { if (e_3) throw e_3.error; }
            }
            _this._zones = [];
            _this._zonesMap = {};
            _this._inlineDiffMargins = [];
            for (var i = 0, length_1 = newDecorations.zones.length; i < length_1; i++) {
                var viewZone = newDecorations.zones[i];
                viewZone.suppressMouseDown = true;
                var zoneId = viewChangeAccessor.addZone(viewZone);
                _this._zones.push(zoneId);
                _this._zonesMap[String(zoneId)] = true;
                if (newDecorations.zones[i].diff && viewZone.marginDomNode) {
                    viewZone.suppressMouseDown = false;
                    _this._inlineDiffMargins.push(new InlineDiffMargin(zoneId, viewZone.marginDomNode, editor, newDecorations.zones[i].diff, _this._contextMenuService, _this._clipboardService));
                }
            }
        });
        if (scrollState) {
            scrollState.restore(editor);
        }
        // decorations
        this._decorations = editor.deltaDecorations(this._decorations, newDecorations.decorations);
        // overview ruler
        if (overviewRuler) {
            overviewRuler.setZones(newDecorations.overviewZones);
        }
    };
    return VisualEditorState;
}());
var DIFF_EDITOR_ID = 0;
var diffInsertIcon = registerIcon('diff-insert', Codicon.add, nls.localize('diffInsertIcon', 'Line decoration for inserts in the diff editor.'));
var diffRemoveIcon = registerIcon('diff-remove', Codicon.remove, nls.localize('diffRemoveIcon', 'Line decoration for removals in the diff editor.'));
var ttPolicy = (_a = window.trustedTypes) === null || _a === void 0 ? void 0 : _a.createPolicy('diffEditorWidget', { createHTML: function (value) { return value; } });
var DiffEditorWidget = /** @class */ (function (_super) {
    __extends(DiffEditorWidget, _super);
    function DiffEditorWidget(domElement, options, codeEditorWidgetOptions, clipboardService, editorWorkerService, contextKeyService, instantiationService, codeEditorService, themeService, notificationService, contextMenuService, _editorProgressService) {
        var e_4, _a;
        var _this = _super.call(this) || this;
        _this._editorProgressService = _editorProgressService;
        _this._onDidDispose = _this._register(new Emitter());
        _this.onDidDispose = _this._onDidDispose.event;
        _this._onDidUpdateDiff = _this._register(new Emitter());
        _this.onDidUpdateDiff = _this._onDidUpdateDiff.event;
        _this._onDidContentSizeChange = _this._register(new Emitter());
        _this.onDidContentSizeChange = _this._onDidContentSizeChange.event;
        _this._lastOriginalWarning = null;
        _this._lastModifiedWarning = null;
        _this._editorWorkerService = editorWorkerService;
        _this._codeEditorService = codeEditorService;
        _this._contextKeyService = _this._register(contextKeyService.createScoped(domElement));
        _this._instantiationService = instantiationService.createChild(new ServiceCollection([IContextKeyService, _this._contextKeyService]));
        _this._contextKeyService.createKey('isInDiffEditor', true);
        _this._themeService = themeService;
        _this._notificationService = notificationService;
        _this._id = (++DIFF_EDITOR_ID);
        _this._state = 0 /* Idle */;
        _this._updatingDiffProgress = null;
        _this._domElement = domElement;
        options = options || {};
        // renderSideBySide
        _this._renderSideBySide = true;
        if (typeof options.renderSideBySide !== 'undefined') {
            _this._renderSideBySide = options.renderSideBySide;
        }
        // maxComputationTime
        _this._maxComputationTime = 5000;
        if (typeof options.maxComputationTime !== 'undefined') {
            _this._maxComputationTime = options.maxComputationTime;
        }
        // ignoreTrimWhitespace
        _this._ignoreTrimWhitespace = true;
        if (typeof options.ignoreTrimWhitespace !== 'undefined') {
            _this._ignoreTrimWhitespace = options.ignoreTrimWhitespace;
        }
        // renderIndicators
        _this._renderIndicators = true;
        if (typeof options.renderIndicators !== 'undefined') {
            _this._renderIndicators = options.renderIndicators;
        }
        _this._originalIsEditable = validateBooleanOption(options.originalEditable, false);
        _this._diffCodeLens = validateBooleanOption(options.diffCodeLens, false);
        _this._diffWordWrap = validateDiffWordWrap(options.diffWordWrap, 'inherit');
        if (typeof options.isInEmbeddedEditor !== 'undefined') {
            _this._contextKeyService.createKey('isInEmbeddedDiffEditor', options.isInEmbeddedEditor);
        }
        else {
            _this._contextKeyService.createKey('isInEmbeddedDiffEditor', false);
        }
        _this._renderOverviewRuler = true;
        if (typeof options.renderOverviewRuler !== 'undefined') {
            _this._renderOverviewRuler = Boolean(options.renderOverviewRuler);
        }
        _this._updateDecorationsRunner = _this._register(new RunOnceScheduler(function () { return _this._updateDecorations(); }, 0));
        _this._containerDomElement = document.createElement('div');
        _this._containerDomElement.className = DiffEditorWidget._getClassName(_this._themeService.getColorTheme(), _this._renderSideBySide);
        _this._containerDomElement.style.position = 'relative';
        _this._containerDomElement.style.height = '100%';
        _this._domElement.appendChild(_this._containerDomElement);
        _this._overviewViewportDomElement = createFastDomNode(document.createElement('div'));
        _this._overviewViewportDomElement.setClassName('diffViewport');
        _this._overviewViewportDomElement.setPosition('absolute');
        _this._overviewDomElement = document.createElement('div');
        _this._overviewDomElement.className = 'diffOverview';
        _this._overviewDomElement.style.position = 'absolute';
        _this._overviewDomElement.appendChild(_this._overviewViewportDomElement.domNode);
        _this._register(dom.addStandardDisposableListener(_this._overviewDomElement, 'mousedown', function (e) {
            _this._modifiedEditor.delegateVerticalScrollbarMouseDown(e);
        }));
        if (_this._renderOverviewRuler) {
            _this._containerDomElement.appendChild(_this._overviewDomElement);
        }
        // Create left side
        _this._originalDomNode = document.createElement('div');
        _this._originalDomNode.className = 'editor original';
        _this._originalDomNode.style.position = 'absolute';
        _this._originalDomNode.style.height = '100%';
        _this._containerDomElement.appendChild(_this._originalDomNode);
        // Create right side
        _this._modifiedDomNode = document.createElement('div');
        _this._modifiedDomNode.className = 'editor modified';
        _this._modifiedDomNode.style.position = 'absolute';
        _this._modifiedDomNode.style.height = '100%';
        _this._containerDomElement.appendChild(_this._modifiedDomNode);
        _this._beginUpdateDecorationsTimeout = -1;
        _this._currentlyChangingViewZones = false;
        _this._diffComputationToken = 0;
        _this._originalEditorState = new VisualEditorState(contextMenuService, clipboardService);
        _this._modifiedEditorState = new VisualEditorState(contextMenuService, clipboardService);
        _this._isVisible = true;
        _this._isHandlingScrollEvent = false;
        _this._elementSizeObserver = _this._register(new ElementSizeObserver(_this._containerDomElement, options.dimension, function () { return _this._onDidContainerSizeChanged(); }));
        if (options.automaticLayout) {
            _this._elementSizeObserver.startObserving();
        }
        _this._diffComputationResult = null;
        _this._originalEditor = _this._createLeftHandSideEditor(options, codeEditorWidgetOptions.originalEditor || {});
        _this._modifiedEditor = _this._createRightHandSideEditor(options, codeEditorWidgetOptions.modifiedEditor || {});
        _this._originalOverviewRuler = null;
        _this._modifiedOverviewRuler = null;
        _this._reviewPane = new DiffReview(_this);
        _this._containerDomElement.appendChild(_this._reviewPane.domNode.domNode);
        _this._containerDomElement.appendChild(_this._reviewPane.shadow.domNode);
        _this._containerDomElement.appendChild(_this._reviewPane.actionBarContainer.domNode);
        // enableSplitViewResizing
        _this._enableSplitViewResizing = true;
        if (typeof options.enableSplitViewResizing !== 'undefined') {
            _this._enableSplitViewResizing = options.enableSplitViewResizing;
        }
        if (_this._renderSideBySide) {
            _this._setStrategy(new DiffEditorWidgetSideBySide(_this._createDataSource(), _this._enableSplitViewResizing));
        }
        else {
            _this._setStrategy(new DiffEditorWidgetInline(_this._createDataSource(), _this._enableSplitViewResizing));
        }
        _this._register(themeService.onDidColorThemeChange(function (t) {
            if (_this._strategy && _this._strategy.applyColors(t)) {
                _this._updateDecorationsRunner.schedule();
            }
            _this._containerDomElement.className = DiffEditorWidget._getClassName(_this._themeService.getColorTheme(), _this._renderSideBySide);
        }));
        var contributions = EditorExtensionsRegistry.getDiffEditorContributions();
        try {
            for (var contributions_1 = __values(contributions), contributions_1_1 = contributions_1.next(); !contributions_1_1.done; contributions_1_1 = contributions_1.next()) {
                var desc = contributions_1_1.value;
                try {
                    _this._register(instantiationService.createInstance(desc.ctor, _this));
                }
                catch (err) {
                    onUnexpectedError(err);
                }
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (contributions_1_1 && !contributions_1_1.done && (_a = contributions_1.return)) _a.call(contributions_1);
            }
            finally { if (e_4) throw e_4.error; }
        }
        _this._codeEditorService.addDiffEditor(_this);
        return _this;
    }
    Object.defineProperty(DiffEditorWidget.prototype, "ignoreTrimWhitespace", {
        get: function () {
            return this._ignoreTrimWhitespace;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DiffEditorWidget.prototype, "renderSideBySide", {
        get: function () {
            return this._renderSideBySide;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DiffEditorWidget.prototype, "maxComputationTime", {
        get: function () {
            return this._maxComputationTime;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DiffEditorWidget.prototype, "renderIndicators", {
        get: function () {
            return this._renderIndicators;
        },
        enumerable: false,
        configurable: true
    });
    DiffEditorWidget.prototype.getContentHeight = function () {
        return this._modifiedEditor.getContentHeight();
    };
    DiffEditorWidget.prototype.getViewWidth = function () {
        return this._elementSizeObserver.getWidth();
    };
    DiffEditorWidget.prototype._setState = function (newState) {
        if (this._state === newState) {
            return;
        }
        this._state = newState;
        if (this._updatingDiffProgress) {
            this._updatingDiffProgress.done();
            this._updatingDiffProgress = null;
        }
        if (this._state === 1 /* ComputingDiff */) {
            this._updatingDiffProgress = this._editorProgressService.show(true, 1000);
        }
    };
    DiffEditorWidget.prototype.hasWidgetFocus = function () {
        return dom.isAncestor(document.activeElement, this._domElement);
    };
    DiffEditorWidget.prototype.diffReviewNext = function () {
        this._reviewPane.next();
    };
    DiffEditorWidget.prototype.diffReviewPrev = function () {
        this._reviewPane.prev();
    };
    DiffEditorWidget._getClassName = function (theme, renderSideBySide) {
        var result = 'monaco-diff-editor monaco-editor-background ';
        if (renderSideBySide) {
            result += 'side-by-side ';
        }
        result += getThemeTypeSelector(theme.type);
        return result;
    };
    DiffEditorWidget.prototype._recreateOverviewRulers = function () {
        if (!this._renderOverviewRuler) {
            return;
        }
        if (this._originalOverviewRuler) {
            this._overviewDomElement.removeChild(this._originalOverviewRuler.getDomNode());
            this._originalOverviewRuler.dispose();
        }
        if (this._originalEditor.hasModel()) {
            this._originalOverviewRuler = this._originalEditor.createOverviewRuler('original diffOverviewRuler');
            this._overviewDomElement.appendChild(this._originalOverviewRuler.getDomNode());
        }
        if (this._modifiedOverviewRuler) {
            this._overviewDomElement.removeChild(this._modifiedOverviewRuler.getDomNode());
            this._modifiedOverviewRuler.dispose();
        }
        if (this._modifiedEditor.hasModel()) {
            this._modifiedOverviewRuler = this._modifiedEditor.createOverviewRuler('modified diffOverviewRuler');
            this._overviewDomElement.appendChild(this._modifiedOverviewRuler.getDomNode());
        }
        this._layoutOverviewRulers();
    };
    DiffEditorWidget.prototype._createLeftHandSideEditor = function (options, codeEditorWidgetOptions) {
        var _this = this;
        var editor = this._createInnerEditor(this._instantiationService, this._originalDomNode, this._adjustOptionsForLeftHandSide(options), codeEditorWidgetOptions);
        this._register(editor.onDidScrollChange(function (e) {
            if (_this._isHandlingScrollEvent) {
                return;
            }
            if (!e.scrollTopChanged && !e.scrollLeftChanged && !e.scrollHeightChanged) {
                return;
            }
            _this._isHandlingScrollEvent = true;
            _this._modifiedEditor.setScrollPosition({
                scrollLeft: e.scrollLeft,
                scrollTop: e.scrollTop
            });
            _this._isHandlingScrollEvent = false;
            _this._layoutOverviewViewport();
        }));
        this._register(editor.onDidChangeViewZones(function () {
            _this._onViewZonesChanged();
        }));
        this._register(editor.onDidChangeConfiguration(function (e) {
            if (!editor.getModel()) {
                return;
            }
            if (e.hasChanged(38 /* fontInfo */)) {
                _this._updateDecorationsRunner.schedule();
            }
            if (e.hasChanged(125 /* wrappingInfo */)) {
                _this._updateDecorationsRunner.cancel();
                _this._updateDecorations();
            }
        }));
        this._register(editor.onDidChangeModelContent(function () {
            if (_this._isVisible) {
                _this._beginUpdateDecorationsSoon();
            }
        }));
        var isInDiffLeftEditorKey = this._contextKeyService.createKey('isInDiffLeftEditor', editor.hasWidgetFocus());
        this._register(editor.onDidFocusEditorWidget(function () { return isInDiffLeftEditorKey.set(true); }));
        this._register(editor.onDidBlurEditorWidget(function () { return isInDiffLeftEditorKey.set(false); }));
        this._register(editor.onDidContentSizeChange(function (e) {
            var width = _this._originalEditor.getContentWidth() + _this._modifiedEditor.getContentWidth() + DiffEditorWidget.ONE_OVERVIEW_WIDTH;
            var height = Math.max(_this._modifiedEditor.getContentHeight(), _this._originalEditor.getContentHeight());
            _this._onDidContentSizeChange.fire({
                contentHeight: height,
                contentWidth: width,
                contentHeightChanged: e.contentHeightChanged,
                contentWidthChanged: e.contentWidthChanged
            });
        }));
        return editor;
    };
    DiffEditorWidget.prototype._createRightHandSideEditor = function (options, codeEditorWidgetOptions) {
        var _this = this;
        var editor = this._createInnerEditor(this._instantiationService, this._modifiedDomNode, this._adjustOptionsForRightHandSide(options), codeEditorWidgetOptions);
        this._register(editor.onDidScrollChange(function (e) {
            if (_this._isHandlingScrollEvent) {
                return;
            }
            if (!e.scrollTopChanged && !e.scrollLeftChanged && !e.scrollHeightChanged) {
                return;
            }
            _this._isHandlingScrollEvent = true;
            _this._originalEditor.setScrollPosition({
                scrollLeft: e.scrollLeft,
                scrollTop: e.scrollTop
            });
            _this._isHandlingScrollEvent = false;
            _this._layoutOverviewViewport();
        }));
        this._register(editor.onDidChangeViewZones(function () {
            _this._onViewZonesChanged();
        }));
        this._register(editor.onDidChangeConfiguration(function (e) {
            if (!editor.getModel()) {
                return;
            }
            if (e.hasChanged(38 /* fontInfo */)) {
                _this._updateDecorationsRunner.schedule();
            }
            if (e.hasChanged(125 /* wrappingInfo */)) {
                _this._updateDecorationsRunner.cancel();
                _this._updateDecorations();
            }
        }));
        this._register(editor.onDidChangeModelContent(function () {
            if (_this._isVisible) {
                _this._beginUpdateDecorationsSoon();
            }
        }));
        this._register(editor.onDidChangeModelOptions(function (e) {
            if (e.tabSize) {
                _this._updateDecorationsRunner.schedule();
            }
        }));
        var isInDiffRightEditorKey = this._contextKeyService.createKey('isInDiffRightEditor', editor.hasWidgetFocus());
        this._register(editor.onDidFocusEditorWidget(function () { return isInDiffRightEditorKey.set(true); }));
        this._register(editor.onDidBlurEditorWidget(function () { return isInDiffRightEditorKey.set(false); }));
        this._register(editor.onDidContentSizeChange(function (e) {
            var width = _this._originalEditor.getContentWidth() + _this._modifiedEditor.getContentWidth() + DiffEditorWidget.ONE_OVERVIEW_WIDTH;
            var height = Math.max(_this._modifiedEditor.getContentHeight(), _this._originalEditor.getContentHeight());
            _this._onDidContentSizeChange.fire({
                contentHeight: height,
                contentWidth: width,
                contentHeightChanged: e.contentHeightChanged,
                contentWidthChanged: e.contentWidthChanged
            });
        }));
        return editor;
    };
    DiffEditorWidget.prototype._createInnerEditor = function (instantiationService, container, options, editorWidgetOptions) {
        return instantiationService.createInstance(CodeEditorWidget, container, options, editorWidgetOptions);
    };
    DiffEditorWidget.prototype.dispose = function () {
        this._codeEditorService.removeDiffEditor(this);
        if (this._beginUpdateDecorationsTimeout !== -1) {
            window.clearTimeout(this._beginUpdateDecorationsTimeout);
            this._beginUpdateDecorationsTimeout = -1;
        }
        this._cleanViewZonesAndDecorations();
        if (this._originalOverviewRuler) {
            this._overviewDomElement.removeChild(this._originalOverviewRuler.getDomNode());
            this._originalOverviewRuler.dispose();
        }
        if (this._modifiedOverviewRuler) {
            this._overviewDomElement.removeChild(this._modifiedOverviewRuler.getDomNode());
            this._modifiedOverviewRuler.dispose();
        }
        this._overviewDomElement.removeChild(this._overviewViewportDomElement.domNode);
        if (this._renderOverviewRuler) {
            this._containerDomElement.removeChild(this._overviewDomElement);
        }
        this._containerDomElement.removeChild(this._originalDomNode);
        this._originalEditor.dispose();
        this._containerDomElement.removeChild(this._modifiedDomNode);
        this._modifiedEditor.dispose();
        this._strategy.dispose();
        this._containerDomElement.removeChild(this._reviewPane.domNode.domNode);
        this._containerDomElement.removeChild(this._reviewPane.shadow.domNode);
        this._containerDomElement.removeChild(this._reviewPane.actionBarContainer.domNode);
        this._reviewPane.dispose();
        this._domElement.removeChild(this._containerDomElement);
        this._onDidDispose.fire();
        _super.prototype.dispose.call(this);
    };
    //------------ begin IDiffEditor methods
    DiffEditorWidget.prototype.getId = function () {
        return this.getEditorType() + ':' + this._id;
    };
    DiffEditorWidget.prototype.getEditorType = function () {
        return editorCommon.EditorType.IDiffEditor;
    };
    DiffEditorWidget.prototype.getLineChanges = function () {
        if (!this._diffComputationResult) {
            return null;
        }
        return this._diffComputationResult.changes;
    };
    DiffEditorWidget.prototype.getDiffComputationResult = function () {
        return this._diffComputationResult;
    };
    DiffEditorWidget.prototype.getOriginalEditor = function () {
        return this._originalEditor;
    };
    DiffEditorWidget.prototype.getModifiedEditor = function () {
        return this._modifiedEditor;
    };
    DiffEditorWidget.prototype.updateOptions = function (newOptions) {
        // Handle side by side
        var renderSideBySideChanged = false;
        if (typeof newOptions.renderSideBySide !== 'undefined') {
            if (this._renderSideBySide !== newOptions.renderSideBySide) {
                this._renderSideBySide = newOptions.renderSideBySide;
                renderSideBySideChanged = true;
            }
        }
        if (typeof newOptions.maxComputationTime !== 'undefined') {
            this._maxComputationTime = newOptions.maxComputationTime;
            if (this._isVisible) {
                this._beginUpdateDecorationsSoon();
            }
        }
        var beginUpdateDecorations = false;
        if (typeof newOptions.ignoreTrimWhitespace !== 'undefined') {
            if (this._ignoreTrimWhitespace !== newOptions.ignoreTrimWhitespace) {
                this._ignoreTrimWhitespace = newOptions.ignoreTrimWhitespace;
                // Begin comparing
                beginUpdateDecorations = true;
            }
        }
        if (typeof newOptions.renderIndicators !== 'undefined') {
            if (this._renderIndicators !== newOptions.renderIndicators) {
                this._renderIndicators = newOptions.renderIndicators;
                beginUpdateDecorations = true;
            }
        }
        if (beginUpdateDecorations) {
            this._beginUpdateDecorations();
        }
        this._originalIsEditable = validateBooleanOption(newOptions.originalEditable, this._originalIsEditable);
        this._diffCodeLens = validateBooleanOption(newOptions.diffCodeLens, this._diffCodeLens);
        this._diffWordWrap = validateDiffWordWrap(newOptions.diffWordWrap, this._diffWordWrap);
        this._modifiedEditor.updateOptions(this._adjustOptionsForRightHandSide(newOptions));
        this._originalEditor.updateOptions(this._adjustOptionsForLeftHandSide(newOptions));
        // enableSplitViewResizing
        if (typeof newOptions.enableSplitViewResizing !== 'undefined') {
            this._enableSplitViewResizing = newOptions.enableSplitViewResizing;
        }
        this._strategy.setEnableSplitViewResizing(this._enableSplitViewResizing);
        // renderSideBySide
        if (renderSideBySideChanged) {
            if (this._renderSideBySide) {
                this._setStrategy(new DiffEditorWidgetSideBySide(this._createDataSource(), this._enableSplitViewResizing));
            }
            else {
                this._setStrategy(new DiffEditorWidgetInline(this._createDataSource(), this._enableSplitViewResizing));
            }
            // Update class name
            this._containerDomElement.className = DiffEditorWidget._getClassName(this._themeService.getColorTheme(), this._renderSideBySide);
        }
        // renderOverviewRuler
        if (typeof newOptions.renderOverviewRuler !== 'undefined' && this._renderOverviewRuler !== newOptions.renderOverviewRuler) {
            this._renderOverviewRuler = newOptions.renderOverviewRuler;
            if (this._renderOverviewRuler) {
                this._containerDomElement.appendChild(this._overviewDomElement);
            }
            else {
                this._containerDomElement.removeChild(this._overviewDomElement);
            }
        }
    };
    DiffEditorWidget.prototype.getModel = function () {
        return {
            original: this._originalEditor.getModel(),
            modified: this._modifiedEditor.getModel()
        };
    };
    DiffEditorWidget.prototype.setModel = function (model) {
        // Guard us against partial null model
        if (model && (!model.original || !model.modified)) {
            throw new Error(!model.original ? 'DiffEditorWidget.setModel: Original model is null' : 'DiffEditorWidget.setModel: Modified model is null');
        }
        // Remove all view zones & decorations
        this._cleanViewZonesAndDecorations();
        // Update code editor models
        this._originalEditor.setModel(model ? model.original : null);
        this._modifiedEditor.setModel(model ? model.modified : null);
        this._updateDecorationsRunner.cancel();
        // this.originalEditor.onDidChangeModelOptions
        if (model) {
            this._originalEditor.setScrollTop(0);
            this._modifiedEditor.setScrollTop(0);
        }
        // Disable any diff computations that will come in
        this._diffComputationResult = null;
        this._diffComputationToken++;
        this._setState(0 /* Idle */);
        if (model) {
            this._recreateOverviewRulers();
            // Begin comparing
            this._beginUpdateDecorations();
        }
        this._layoutOverviewViewport();
    };
    DiffEditorWidget.prototype.getDomNode = function () {
        return this._domElement;
    };
    DiffEditorWidget.prototype.getVisibleColumnFromPosition = function (position) {
        return this._modifiedEditor.getVisibleColumnFromPosition(position);
    };
    DiffEditorWidget.prototype.getStatusbarColumn = function (position) {
        return this._modifiedEditor.getStatusbarColumn(position);
    };
    DiffEditorWidget.prototype.getPosition = function () {
        return this._modifiedEditor.getPosition();
    };
    DiffEditorWidget.prototype.setPosition = function (position) {
        this._modifiedEditor.setPosition(position);
    };
    DiffEditorWidget.prototype.revealLine = function (lineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealLine(lineNumber, scrollType);
    };
    DiffEditorWidget.prototype.revealLineInCenter = function (lineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealLineInCenter(lineNumber, scrollType);
    };
    DiffEditorWidget.prototype.revealLineInCenterIfOutsideViewport = function (lineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealLineInCenterIfOutsideViewport(lineNumber, scrollType);
    };
    DiffEditorWidget.prototype.revealLineNearTop = function (lineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealLineNearTop(lineNumber, scrollType);
    };
    DiffEditorWidget.prototype.revealPosition = function (position, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealPosition(position, scrollType);
    };
    DiffEditorWidget.prototype.revealPositionInCenter = function (position, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealPositionInCenter(position, scrollType);
    };
    DiffEditorWidget.prototype.revealPositionInCenterIfOutsideViewport = function (position, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealPositionInCenterIfOutsideViewport(position, scrollType);
    };
    DiffEditorWidget.prototype.revealPositionNearTop = function (position, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealPositionNearTop(position, scrollType);
    };
    DiffEditorWidget.prototype.getSelection = function () {
        return this._modifiedEditor.getSelection();
    };
    DiffEditorWidget.prototype.getSelections = function () {
        return this._modifiedEditor.getSelections();
    };
    DiffEditorWidget.prototype.setSelection = function (something) {
        this._modifiedEditor.setSelection(something);
    };
    DiffEditorWidget.prototype.setSelections = function (ranges) {
        this._modifiedEditor.setSelections(ranges);
    };
    DiffEditorWidget.prototype.revealLines = function (startLineNumber, endLineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealLines(startLineNumber, endLineNumber, scrollType);
    };
    DiffEditorWidget.prototype.revealLinesInCenter = function (startLineNumber, endLineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealLinesInCenter(startLineNumber, endLineNumber, scrollType);
    };
    DiffEditorWidget.prototype.revealLinesInCenterIfOutsideViewport = function (startLineNumber, endLineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealLinesInCenterIfOutsideViewport(startLineNumber, endLineNumber, scrollType);
    };
    DiffEditorWidget.prototype.revealLinesNearTop = function (startLineNumber, endLineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealLinesNearTop(startLineNumber, endLineNumber, scrollType);
    };
    DiffEditorWidget.prototype.revealRange = function (range, scrollType, revealVerticalInCenter, revealHorizontal) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        if (revealVerticalInCenter === void 0) { revealVerticalInCenter = false; }
        if (revealHorizontal === void 0) { revealHorizontal = true; }
        this._modifiedEditor.revealRange(range, scrollType, revealVerticalInCenter, revealHorizontal);
    };
    DiffEditorWidget.prototype.revealRangeInCenter = function (range, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealRangeInCenter(range, scrollType);
    };
    DiffEditorWidget.prototype.revealRangeInCenterIfOutsideViewport = function (range, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealRangeInCenterIfOutsideViewport(range, scrollType);
    };
    DiffEditorWidget.prototype.revealRangeNearTop = function (range, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealRangeNearTop(range, scrollType);
    };
    DiffEditorWidget.prototype.revealRangeNearTopIfOutsideViewport = function (range, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealRangeNearTopIfOutsideViewport(range, scrollType);
    };
    DiffEditorWidget.prototype.revealRangeAtTop = function (range, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._modifiedEditor.revealRangeAtTop(range, scrollType);
    };
    DiffEditorWidget.prototype.getSupportedActions = function () {
        return this._modifiedEditor.getSupportedActions();
    };
    DiffEditorWidget.prototype.saveViewState = function () {
        var originalViewState = this._originalEditor.saveViewState();
        var modifiedViewState = this._modifiedEditor.saveViewState();
        return {
            original: originalViewState,
            modified: modifiedViewState
        };
    };
    DiffEditorWidget.prototype.restoreViewState = function (s) {
        if (s && s.original && s.modified) {
            var diffEditorState = s;
            this._originalEditor.restoreViewState(diffEditorState.original);
            this._modifiedEditor.restoreViewState(diffEditorState.modified);
        }
    };
    DiffEditorWidget.prototype.layout = function (dimension) {
        this._elementSizeObserver.observe(dimension);
    };
    DiffEditorWidget.prototype.focus = function () {
        this._modifiedEditor.focus();
    };
    DiffEditorWidget.prototype.hasTextFocus = function () {
        return this._originalEditor.hasTextFocus() || this._modifiedEditor.hasTextFocus();
    };
    DiffEditorWidget.prototype.onVisible = function () {
        this._isVisible = true;
        this._originalEditor.onVisible();
        this._modifiedEditor.onVisible();
        // Begin comparing
        this._beginUpdateDecorations();
    };
    DiffEditorWidget.prototype.onHide = function () {
        this._isVisible = false;
        this._originalEditor.onHide();
        this._modifiedEditor.onHide();
        // Remove all view zones & decorations
        this._cleanViewZonesAndDecorations();
    };
    DiffEditorWidget.prototype.trigger = function (source, handlerId, payload) {
        this._modifiedEditor.trigger(source, handlerId, payload);
    };
    DiffEditorWidget.prototype.changeDecorations = function (callback) {
        return this._modifiedEditor.changeDecorations(callback);
    };
    //------------ end IDiffEditor methods
    //------------ begin layouting methods
    DiffEditorWidget.prototype._onDidContainerSizeChanged = function () {
        this._doLayout();
    };
    DiffEditorWidget.prototype._getReviewHeight = function () {
        return this._reviewPane.isVisible() ? this._elementSizeObserver.getHeight() : 0;
    };
    DiffEditorWidget.prototype._layoutOverviewRulers = function () {
        if (!this._renderOverviewRuler) {
            return;
        }
        if (!this._originalOverviewRuler || !this._modifiedOverviewRuler) {
            return;
        }
        var height = this._elementSizeObserver.getHeight();
        var reviewHeight = this._getReviewHeight();
        var freeSpace = DiffEditorWidget.ENTIRE_DIFF_OVERVIEW_WIDTH - 2 * DiffEditorWidget.ONE_OVERVIEW_WIDTH;
        var layoutInfo = this._modifiedEditor.getLayoutInfo();
        if (layoutInfo) {
            this._originalOverviewRuler.setLayout({
                top: 0,
                width: DiffEditorWidget.ONE_OVERVIEW_WIDTH,
                right: freeSpace + DiffEditorWidget.ONE_OVERVIEW_WIDTH,
                height: (height - reviewHeight)
            });
            this._modifiedOverviewRuler.setLayout({
                top: 0,
                right: 0,
                width: DiffEditorWidget.ONE_OVERVIEW_WIDTH,
                height: (height - reviewHeight)
            });
        }
    };
    //------------ end layouting methods
    DiffEditorWidget.prototype._onViewZonesChanged = function () {
        if (this._currentlyChangingViewZones) {
            return;
        }
        this._updateDecorationsRunner.schedule();
    };
    DiffEditorWidget.prototype._beginUpdateDecorationsSoon = function () {
        var _this = this;
        // Clear previous timeout if necessary
        if (this._beginUpdateDecorationsTimeout !== -1) {
            window.clearTimeout(this._beginUpdateDecorationsTimeout);
            this._beginUpdateDecorationsTimeout = -1;
        }
        this._beginUpdateDecorationsTimeout = window.setTimeout(function () { return _this._beginUpdateDecorations(); }, DiffEditorWidget.UPDATE_DIFF_DECORATIONS_DELAY);
    };
    DiffEditorWidget._equals = function (a, b) {
        if (!a && !b) {
            return true;
        }
        if (!a || !b) {
            return false;
        }
        return (a.toString() === b.toString());
    };
    DiffEditorWidget.prototype._beginUpdateDecorations = function () {
        var _this = this;
        this._beginUpdateDecorationsTimeout = -1;
        var currentOriginalModel = this._originalEditor.getModel();
        var currentModifiedModel = this._modifiedEditor.getModel();
        if (!currentOriginalModel || !currentModifiedModel) {
            return;
        }
        // Prevent old diff requests to come if a new request has been initiated
        // The best method would be to call cancel on the Promise, but this is not
        // yet supported, so using tokens for now.
        this._diffComputationToken++;
        var currentToken = this._diffComputationToken;
        this._setState(1 /* ComputingDiff */);
        if (!this._editorWorkerService.canComputeDiff(currentOriginalModel.uri, currentModifiedModel.uri)) {
            if (!DiffEditorWidget._equals(currentOriginalModel.uri, this._lastOriginalWarning)
                || !DiffEditorWidget._equals(currentModifiedModel.uri, this._lastModifiedWarning)) {
                this._lastOriginalWarning = currentOriginalModel.uri;
                this._lastModifiedWarning = currentModifiedModel.uri;
                this._notificationService.warn(nls.localize("diff.tooLarge", "Cannot compare files because one file is too large."));
            }
            return;
        }
        this._editorWorkerService.computeDiff(currentOriginalModel.uri, currentModifiedModel.uri, this._ignoreTrimWhitespace, this._maxComputationTime).then(function (result) {
            if (currentToken === _this._diffComputationToken
                && currentOriginalModel === _this._originalEditor.getModel()
                && currentModifiedModel === _this._modifiedEditor.getModel()) {
                _this._setState(2 /* DiffComputed */);
                _this._diffComputationResult = result;
                _this._updateDecorationsRunner.schedule();
                _this._onDidUpdateDiff.fire();
            }
        }, function (error) {
            if (currentToken === _this._diffComputationToken
                && currentOriginalModel === _this._originalEditor.getModel()
                && currentModifiedModel === _this._modifiedEditor.getModel()) {
                _this._setState(2 /* DiffComputed */);
                _this._diffComputationResult = null;
                _this._updateDecorationsRunner.schedule();
            }
        });
    };
    DiffEditorWidget.prototype._cleanViewZonesAndDecorations = function () {
        this._originalEditorState.clean(this._originalEditor);
        this._modifiedEditorState.clean(this._modifiedEditor);
    };
    DiffEditorWidget.prototype._updateDecorations = function () {
        if (!this._originalEditor.getModel() || !this._modifiedEditor.getModel()) {
            return;
        }
        var lineChanges = (this._diffComputationResult ? this._diffComputationResult.changes : []);
        var foreignOriginal = this._originalEditorState.getForeignViewZones(this._originalEditor.getWhitespaces());
        var foreignModified = this._modifiedEditorState.getForeignViewZones(this._modifiedEditor.getWhitespaces());
        var diffDecorations = this._strategy.getEditorsDiffDecorations(lineChanges, this._ignoreTrimWhitespace, this._renderIndicators, foreignOriginal, foreignModified);
        try {
            this._currentlyChangingViewZones = true;
            this._originalEditorState.apply(this._originalEditor, this._originalOverviewRuler, diffDecorations.original, false);
            this._modifiedEditorState.apply(this._modifiedEditor, this._modifiedOverviewRuler, diffDecorations.modified, true);
        }
        finally {
            this._currentlyChangingViewZones = false;
        }
    };
    DiffEditorWidget.prototype._adjustOptionsForSubEditor = function (options) {
        var clonedOptions = __assign({}, options);
        clonedOptions.inDiffEditor = true;
        clonedOptions.automaticLayout = false;
        // Clone scrollbar options before changing them
        clonedOptions.scrollbar = __assign({}, (clonedOptions.scrollbar || {}));
        clonedOptions.scrollbar.vertical = 'visible';
        clonedOptions.folding = false;
        clonedOptions.codeLens = this._diffCodeLens;
        clonedOptions.fixedOverflowWidgets = true;
        // clonedOptions.lineDecorationsWidth = '2ch';
        // Clone minimap options before changing them
        clonedOptions.minimap = __assign({}, (clonedOptions.minimap || {}));
        clonedOptions.minimap.enabled = false;
        return clonedOptions;
    };
    DiffEditorWidget.prototype._adjustOptionsForLeftHandSide = function (options) {
        var result = this._adjustOptionsForSubEditor(options);
        if (!this._renderSideBySide) {
            // never wrap hidden editor
            result.wordWrapOverride1 = 'off';
        }
        else {
            result.wordWrapOverride1 = this._diffWordWrap;
        }
        if (options.originalAriaLabel) {
            result.ariaLabel = options.originalAriaLabel;
        }
        result.readOnly = !this._originalIsEditable;
        result.extraEditorClassName = 'original-in-monaco-diff-editor';
        return __assign(__assign({}, result), { dimension: {
                height: 0,
                width: 0
            } });
    };
    DiffEditorWidget.prototype._adjustOptionsForRightHandSide = function (options) {
        var result = this._adjustOptionsForSubEditor(options);
        if (options.modifiedAriaLabel) {
            result.ariaLabel = options.modifiedAriaLabel;
        }
        result.wordWrapOverride1 = this._diffWordWrap;
        result.revealHorizontalRightPadding = EditorOptions.revealHorizontalRightPadding.defaultValue + DiffEditorWidget.ENTIRE_DIFF_OVERVIEW_WIDTH;
        result.scrollbar.verticalHasArrows = false;
        result.extraEditorClassName = 'modified-in-monaco-diff-editor';
        return __assign(__assign({}, result), { dimension: {
                height: 0,
                width: 0
            } });
    };
    DiffEditorWidget.prototype.doLayout = function () {
        this._elementSizeObserver.observe();
        this._doLayout();
    };
    DiffEditorWidget.prototype._doLayout = function () {
        var width = this._elementSizeObserver.getWidth();
        var height = this._elementSizeObserver.getHeight();
        var reviewHeight = this._getReviewHeight();
        var splitPoint = this._strategy.layout();
        this._originalDomNode.style.width = splitPoint + 'px';
        this._originalDomNode.style.left = '0px';
        this._modifiedDomNode.style.width = (width - splitPoint) + 'px';
        this._modifiedDomNode.style.left = splitPoint + 'px';
        this._overviewDomElement.style.top = '0px';
        this._overviewDomElement.style.height = (height - reviewHeight) + 'px';
        this._overviewDomElement.style.width = DiffEditorWidget.ENTIRE_DIFF_OVERVIEW_WIDTH + 'px';
        this._overviewDomElement.style.left = (width - DiffEditorWidget.ENTIRE_DIFF_OVERVIEW_WIDTH) + 'px';
        this._overviewViewportDomElement.setWidth(DiffEditorWidget.ENTIRE_DIFF_OVERVIEW_WIDTH);
        this._overviewViewportDomElement.setHeight(30);
        this._originalEditor.layout({ width: splitPoint, height: (height - reviewHeight) });
        this._modifiedEditor.layout({ width: width - splitPoint - (this._renderOverviewRuler ? DiffEditorWidget.ENTIRE_DIFF_OVERVIEW_WIDTH : 0), height: (height - reviewHeight) });
        if (this._originalOverviewRuler || this._modifiedOverviewRuler) {
            this._layoutOverviewRulers();
        }
        this._reviewPane.layout(height - reviewHeight, width, reviewHeight);
        this._layoutOverviewViewport();
    };
    DiffEditorWidget.prototype._layoutOverviewViewport = function () {
        var layout = this._computeOverviewViewport();
        if (!layout) {
            this._overviewViewportDomElement.setTop(0);
            this._overviewViewportDomElement.setHeight(0);
        }
        else {
            this._overviewViewportDomElement.setTop(layout.top);
            this._overviewViewportDomElement.setHeight(layout.height);
        }
    };
    DiffEditorWidget.prototype._computeOverviewViewport = function () {
        var layoutInfo = this._modifiedEditor.getLayoutInfo();
        if (!layoutInfo) {
            return null;
        }
        var scrollTop = this._modifiedEditor.getScrollTop();
        var scrollHeight = this._modifiedEditor.getScrollHeight();
        var computedAvailableSize = Math.max(0, layoutInfo.height);
        var computedRepresentableSize = Math.max(0, computedAvailableSize - 2 * 0);
        var computedRatio = scrollHeight > 0 ? (computedRepresentableSize / scrollHeight) : 0;
        var computedSliderSize = Math.max(0, Math.floor(layoutInfo.height * computedRatio));
        var computedSliderPosition = Math.floor(scrollTop * computedRatio);
        return {
            height: computedSliderSize,
            top: computedSliderPosition
        };
    };
    DiffEditorWidget.prototype._createDataSource = function () {
        var _this = this;
        return {
            getWidth: function () {
                return _this._elementSizeObserver.getWidth();
            },
            getHeight: function () {
                return (_this._elementSizeObserver.getHeight() - _this._getReviewHeight());
            },
            getOptions: function () {
                return {
                    renderOverviewRuler: _this._renderOverviewRuler
                };
            },
            getContainerDomNode: function () {
                return _this._containerDomElement;
            },
            relayoutEditors: function () {
                _this._doLayout();
            },
            getOriginalEditor: function () {
                return _this._originalEditor;
            },
            getModifiedEditor: function () {
                return _this._modifiedEditor;
            }
        };
    };
    DiffEditorWidget.prototype._setStrategy = function (newStrategy) {
        if (this._strategy) {
            this._strategy.dispose();
        }
        this._strategy = newStrategy;
        newStrategy.applyColors(this._themeService.getColorTheme());
        if (this._diffComputationResult) {
            this._updateDecorations();
        }
        // Just do a layout, the strategy might need it
        this._doLayout();
    };
    DiffEditorWidget.prototype._getLineChangeAtOrBeforeLineNumber = function (lineNumber, startLineNumberExtractor) {
        var lineChanges = (this._diffComputationResult ? this._diffComputationResult.changes : []);
        if (lineChanges.length === 0 || lineNumber < startLineNumberExtractor(lineChanges[0])) {
            // There are no changes or `lineNumber` is before the first change
            return null;
        }
        var min = 0;
        var max = lineChanges.length - 1;
        while (min < max) {
            var mid = Math.floor((min + max) / 2);
            var midStart = startLineNumberExtractor(lineChanges[mid]);
            var midEnd = (mid + 1 <= max ? startLineNumberExtractor(lineChanges[mid + 1]) : 1073741824 /* MAX_SAFE_SMALL_INTEGER */);
            if (lineNumber < midStart) {
                max = mid - 1;
            }
            else if (lineNumber >= midEnd) {
                min = mid + 1;
            }
            else {
                // HIT!
                min = mid;
                max = mid;
            }
        }
        return lineChanges[min];
    };
    DiffEditorWidget.prototype._getEquivalentLineForOriginalLineNumber = function (lineNumber) {
        var lineChange = this._getLineChangeAtOrBeforeLineNumber(lineNumber, function (lineChange) { return lineChange.originalStartLineNumber; });
        if (!lineChange) {
            return lineNumber;
        }
        var originalEquivalentLineNumber = lineChange.originalStartLineNumber + (lineChange.originalEndLineNumber > 0 ? -1 : 0);
        var modifiedEquivalentLineNumber = lineChange.modifiedStartLineNumber + (lineChange.modifiedEndLineNumber > 0 ? -1 : 0);
        var lineChangeOriginalLength = (lineChange.originalEndLineNumber > 0 ? (lineChange.originalEndLineNumber - lineChange.originalStartLineNumber + 1) : 0);
        var lineChangeModifiedLength = (lineChange.modifiedEndLineNumber > 0 ? (lineChange.modifiedEndLineNumber - lineChange.modifiedStartLineNumber + 1) : 0);
        var delta = lineNumber - originalEquivalentLineNumber;
        if (delta <= lineChangeOriginalLength) {
            return modifiedEquivalentLineNumber + Math.min(delta, lineChangeModifiedLength);
        }
        return modifiedEquivalentLineNumber + lineChangeModifiedLength - lineChangeOriginalLength + delta;
    };
    DiffEditorWidget.prototype._getEquivalentLineForModifiedLineNumber = function (lineNumber) {
        var lineChange = this._getLineChangeAtOrBeforeLineNumber(lineNumber, function (lineChange) { return lineChange.modifiedStartLineNumber; });
        if (!lineChange) {
            return lineNumber;
        }
        var originalEquivalentLineNumber = lineChange.originalStartLineNumber + (lineChange.originalEndLineNumber > 0 ? -1 : 0);
        var modifiedEquivalentLineNumber = lineChange.modifiedStartLineNumber + (lineChange.modifiedEndLineNumber > 0 ? -1 : 0);
        var lineChangeOriginalLength = (lineChange.originalEndLineNumber > 0 ? (lineChange.originalEndLineNumber - lineChange.originalStartLineNumber + 1) : 0);
        var lineChangeModifiedLength = (lineChange.modifiedEndLineNumber > 0 ? (lineChange.modifiedEndLineNumber - lineChange.modifiedStartLineNumber + 1) : 0);
        var delta = lineNumber - modifiedEquivalentLineNumber;
        if (delta <= lineChangeModifiedLength) {
            return originalEquivalentLineNumber + Math.min(delta, lineChangeOriginalLength);
        }
        return originalEquivalentLineNumber + lineChangeOriginalLength - lineChangeModifiedLength + delta;
    };
    DiffEditorWidget.prototype.getDiffLineInformationForOriginal = function (lineNumber) {
        if (!this._diffComputationResult) {
            // Cannot answer that which I don't know
            return null;
        }
        return {
            equivalentLineNumber: this._getEquivalentLineForOriginalLineNumber(lineNumber)
        };
    };
    DiffEditorWidget.prototype.getDiffLineInformationForModified = function (lineNumber) {
        if (!this._diffComputationResult) {
            // Cannot answer that which I don't know
            return null;
        }
        return {
            equivalentLineNumber: this._getEquivalentLineForModifiedLineNumber(lineNumber)
        };
    };
    DiffEditorWidget.ONE_OVERVIEW_WIDTH = 15;
    DiffEditorWidget.ENTIRE_DIFF_OVERVIEW_WIDTH = 30;
    DiffEditorWidget.UPDATE_DIFF_DECORATIONS_DELAY = 200; // ms
    DiffEditorWidget = __decorate([
        __param(3, IClipboardService),
        __param(4, IEditorWorkerService),
        __param(5, IContextKeyService),
        __param(6, IInstantiationService),
        __param(7, ICodeEditorService),
        __param(8, IThemeService),
        __param(9, INotificationService),
        __param(10, IContextMenuService),
        __param(11, IEditorProgressService)
    ], DiffEditorWidget);
    return DiffEditorWidget;
}(Disposable));
export { DiffEditorWidget };
var DiffEditorWidgetStyle = /** @class */ (function (_super) {
    __extends(DiffEditorWidgetStyle, _super);
    function DiffEditorWidgetStyle(dataSource) {
        var _this = _super.call(this) || this;
        _this._dataSource = dataSource;
        _this._insertColor = null;
        _this._removeColor = null;
        return _this;
    }
    DiffEditorWidgetStyle.prototype.applyColors = function (theme) {
        var newInsertColor = (theme.getColor(diffInserted) || defaultInsertColor).transparent(2);
        var newRemoveColor = (theme.getColor(diffRemoved) || defaultRemoveColor).transparent(2);
        var hasChanges = !newInsertColor.equals(this._insertColor) || !newRemoveColor.equals(this._removeColor);
        this._insertColor = newInsertColor;
        this._removeColor = newRemoveColor;
        return hasChanges;
    };
    DiffEditorWidgetStyle.prototype.getEditorsDiffDecorations = function (lineChanges, ignoreTrimWhitespace, renderIndicators, originalWhitespaces, modifiedWhitespaces) {
        // Get view zones
        modifiedWhitespaces = modifiedWhitespaces.sort(function (a, b) {
            return a.afterLineNumber - b.afterLineNumber;
        });
        originalWhitespaces = originalWhitespaces.sort(function (a, b) {
            return a.afterLineNumber - b.afterLineNumber;
        });
        var zones = this._getViewZones(lineChanges, originalWhitespaces, modifiedWhitespaces, renderIndicators);
        // Get decorations & overview ruler zones
        var originalDecorations = this._getOriginalEditorDecorations(lineChanges, ignoreTrimWhitespace, renderIndicators);
        var modifiedDecorations = this._getModifiedEditorDecorations(lineChanges, ignoreTrimWhitespace, renderIndicators);
        return {
            original: {
                decorations: originalDecorations.decorations,
                overviewZones: originalDecorations.overviewZones,
                zones: zones.original
            },
            modified: {
                decorations: modifiedDecorations.decorations,
                overviewZones: modifiedDecorations.overviewZones,
                zones: zones.modified
            }
        };
    };
    return DiffEditorWidgetStyle;
}(Disposable));
var ForeignViewZonesIterator = /** @class */ (function () {
    function ForeignViewZonesIterator(source) {
        this._source = source;
        this._index = -1;
        this.current = null;
        this.advance();
    }
    ForeignViewZonesIterator.prototype.advance = function () {
        this._index++;
        if (this._index < this._source.length) {
            this.current = this._source[this._index];
        }
        else {
            this.current = null;
        }
    };
    return ForeignViewZonesIterator;
}());
var ViewZonesComputer = /** @class */ (function () {
    function ViewZonesComputer(_lineChanges, _originalForeignVZ, _modifiedForeignVZ, _originalEditor, _modifiedEditor) {
        this._lineChanges = _lineChanges;
        this._originalForeignVZ = _originalForeignVZ;
        this._modifiedForeignVZ = _modifiedForeignVZ;
        this._originalEditor = _originalEditor;
        this._modifiedEditor = _modifiedEditor;
    }
    ViewZonesComputer._getViewLineCount = function (editor, startLineNumber, endLineNumber) {
        var model = editor.getModel();
        var viewModel = editor._getViewModel();
        if (model && viewModel) {
            var viewRange = getViewRange(model, viewModel, startLineNumber, endLineNumber);
            return (viewRange.endLineNumber - viewRange.startLineNumber + 1);
        }
        return (endLineNumber - startLineNumber + 1);
    };
    ViewZonesComputer.prototype.getViewZones = function () {
        var originalLineHeight = this._originalEditor.getOption(53 /* lineHeight */);
        var modifiedLineHeight = this._modifiedEditor.getOption(53 /* lineHeight */);
        var originalHasWrapping = (this._originalEditor.getOption(125 /* wrappingInfo */).wrappingColumn !== -1);
        var modifiedHasWrapping = (this._modifiedEditor.getOption(125 /* wrappingInfo */).wrappingColumn !== -1);
        var hasWrapping = (originalHasWrapping || modifiedHasWrapping);
        var originalModel = this._originalEditor.getModel();
        var originalCoordinatesConverter = this._originalEditor._getViewModel().coordinatesConverter;
        var modifiedCoordinatesConverter = this._modifiedEditor._getViewModel().coordinatesConverter;
        var result = {
            original: [],
            modified: []
        };
        var lineChangeModifiedLength = 0;
        var lineChangeOriginalLength = 0;
        var originalEquivalentLineNumber = 0;
        var modifiedEquivalentLineNumber = 0;
        var originalEndEquivalentLineNumber = 0;
        var modifiedEndEquivalentLineNumber = 0;
        var sortMyViewZones = function (a, b) {
            return a.afterLineNumber - b.afterLineNumber;
        };
        var addAndCombineIfPossible = function (destination, item) {
            if (item.domNode === null && destination.length > 0) {
                var lastItem = destination[destination.length - 1];
                if (lastItem.afterLineNumber === item.afterLineNumber && lastItem.domNode === null) {
                    lastItem.heightInLines += item.heightInLines;
                    return;
                }
            }
            destination.push(item);
        };
        var modifiedForeignVZ = new ForeignViewZonesIterator(this._modifiedForeignVZ);
        var originalForeignVZ = new ForeignViewZonesIterator(this._originalForeignVZ);
        var lastOriginalLineNumber = 1;
        var lastModifiedLineNumber = 1;
        // In order to include foreign view zones after the last line change, the for loop will iterate once more after the end of the `lineChanges` array
        for (var i = 0, length_2 = this._lineChanges.length; i <= length_2; i++) {
            var lineChange = (i < length_2 ? this._lineChanges[i] : null);
            if (lineChange !== null) {
                originalEquivalentLineNumber = lineChange.originalStartLineNumber + (lineChange.originalEndLineNumber > 0 ? -1 : 0);
                modifiedEquivalentLineNumber = lineChange.modifiedStartLineNumber + (lineChange.modifiedEndLineNumber > 0 ? -1 : 0);
                lineChangeOriginalLength = (lineChange.originalEndLineNumber > 0 ? ViewZonesComputer._getViewLineCount(this._originalEditor, lineChange.originalStartLineNumber, lineChange.originalEndLineNumber) : 0);
                lineChangeModifiedLength = (lineChange.modifiedEndLineNumber > 0 ? ViewZonesComputer._getViewLineCount(this._modifiedEditor, lineChange.modifiedStartLineNumber, lineChange.modifiedEndLineNumber) : 0);
                originalEndEquivalentLineNumber = Math.max(lineChange.originalStartLineNumber, lineChange.originalEndLineNumber);
                modifiedEndEquivalentLineNumber = Math.max(lineChange.modifiedStartLineNumber, lineChange.modifiedEndLineNumber);
            }
            else {
                // Increase to very large value to get the producing tests of foreign view zones running
                originalEquivalentLineNumber += 10000000 + lineChangeOriginalLength;
                modifiedEquivalentLineNumber += 10000000 + lineChangeModifiedLength;
                originalEndEquivalentLineNumber = originalEquivalentLineNumber;
                modifiedEndEquivalentLineNumber = modifiedEquivalentLineNumber;
            }
            // Each step produces view zones, and after producing them, we try to cancel them out, to avoid empty-empty view zone cases
            var stepOriginal = [];
            var stepModified = [];
            // ---------------------------- PRODUCE VIEW ZONES
            // [PRODUCE] View zones due to line mapping differences (equal lines but wrapped differently)
            if (hasWrapping) {
                var count = void 0;
                if (lineChange) {
                    if (lineChange.originalEndLineNumber > 0) {
                        count = lineChange.originalStartLineNumber - lastOriginalLineNumber;
                    }
                    else {
                        count = lineChange.modifiedStartLineNumber - lastModifiedLineNumber;
                    }
                }
                else {
                    count = originalModel.getLineCount() - lastOriginalLineNumber;
                }
                for (var i_1 = 0; i_1 < count; i_1++) {
                    var originalLineNumber = lastOriginalLineNumber + i_1;
                    var modifiedLineNumber = lastModifiedLineNumber + i_1;
                    var originalViewLineCount = originalCoordinatesConverter.getModelLineViewLineCount(originalLineNumber);
                    var modifiedViewLineCount = modifiedCoordinatesConverter.getModelLineViewLineCount(modifiedLineNumber);
                    if (originalViewLineCount < modifiedViewLineCount) {
                        stepOriginal.push({
                            afterLineNumber: originalLineNumber,
                            heightInLines: modifiedViewLineCount - originalViewLineCount,
                            domNode: null,
                            marginDomNode: null
                        });
                    }
                    else if (originalViewLineCount > modifiedViewLineCount) {
                        stepModified.push({
                            afterLineNumber: modifiedLineNumber,
                            heightInLines: originalViewLineCount - modifiedViewLineCount,
                            domNode: null,
                            marginDomNode: null
                        });
                    }
                }
                if (lineChange) {
                    lastOriginalLineNumber = (lineChange.originalEndLineNumber > 0 ? lineChange.originalEndLineNumber : lineChange.originalStartLineNumber) + 1;
                    lastModifiedLineNumber = (lineChange.modifiedEndLineNumber > 0 ? lineChange.modifiedEndLineNumber : lineChange.modifiedStartLineNumber) + 1;
                }
            }
            // [PRODUCE] View zone(s) in original-side due to foreign view zone(s) in modified-side
            while (modifiedForeignVZ.current && modifiedForeignVZ.current.afterLineNumber <= modifiedEndEquivalentLineNumber) {
                var viewZoneLineNumber = void 0;
                if (modifiedForeignVZ.current.afterLineNumber <= modifiedEquivalentLineNumber) {
                    viewZoneLineNumber = originalEquivalentLineNumber - modifiedEquivalentLineNumber + modifiedForeignVZ.current.afterLineNumber;
                }
                else {
                    viewZoneLineNumber = originalEndEquivalentLineNumber;
                }
                var marginDomNode = null;
                if (lineChange && lineChange.modifiedStartLineNumber <= modifiedForeignVZ.current.afterLineNumber && modifiedForeignVZ.current.afterLineNumber <= lineChange.modifiedEndLineNumber) {
                    marginDomNode = this._createOriginalMarginDomNodeForModifiedForeignViewZoneInAddedRegion();
                }
                stepOriginal.push({
                    afterLineNumber: viewZoneLineNumber,
                    heightInLines: modifiedForeignVZ.current.height / modifiedLineHeight,
                    domNode: null,
                    marginDomNode: marginDomNode
                });
                modifiedForeignVZ.advance();
            }
            // [PRODUCE] View zone(s) in modified-side due to foreign view zone(s) in original-side
            while (originalForeignVZ.current && originalForeignVZ.current.afterLineNumber <= originalEndEquivalentLineNumber) {
                var viewZoneLineNumber = void 0;
                if (originalForeignVZ.current.afterLineNumber <= originalEquivalentLineNumber) {
                    viewZoneLineNumber = modifiedEquivalentLineNumber - originalEquivalentLineNumber + originalForeignVZ.current.afterLineNumber;
                }
                else {
                    viewZoneLineNumber = modifiedEndEquivalentLineNumber;
                }
                stepModified.push({
                    afterLineNumber: viewZoneLineNumber,
                    heightInLines: originalForeignVZ.current.height / originalLineHeight,
                    domNode: null
                });
                originalForeignVZ.advance();
            }
            if (lineChange !== null && isChangeOrInsert(lineChange)) {
                var r = this._produceOriginalFromDiff(lineChange, lineChangeOriginalLength, lineChangeModifiedLength);
                if (r) {
                    stepOriginal.push(r);
                }
            }
            if (lineChange !== null && isChangeOrDelete(lineChange)) {
                var r = this._produceModifiedFromDiff(lineChange, lineChangeOriginalLength, lineChangeModifiedLength);
                if (r) {
                    stepModified.push(r);
                }
            }
            // ---------------------------- END PRODUCE VIEW ZONES
            // ---------------------------- EMIT MINIMAL VIEW ZONES
            // [CANCEL & EMIT] Try to cancel view zones out
            var stepOriginalIndex = 0;
            var stepModifiedIndex = 0;
            stepOriginal = stepOriginal.sort(sortMyViewZones);
            stepModified = stepModified.sort(sortMyViewZones);
            while (stepOriginalIndex < stepOriginal.length && stepModifiedIndex < stepModified.length) {
                var original = stepOriginal[stepOriginalIndex];
                var modified = stepModified[stepModifiedIndex];
                var originalDelta = original.afterLineNumber - originalEquivalentLineNumber;
                var modifiedDelta = modified.afterLineNumber - modifiedEquivalentLineNumber;
                if (originalDelta < modifiedDelta) {
                    addAndCombineIfPossible(result.original, original);
                    stepOriginalIndex++;
                }
                else if (modifiedDelta < originalDelta) {
                    addAndCombineIfPossible(result.modified, modified);
                    stepModifiedIndex++;
                }
                else if (original.shouldNotShrink) {
                    addAndCombineIfPossible(result.original, original);
                    stepOriginalIndex++;
                }
                else if (modified.shouldNotShrink) {
                    addAndCombineIfPossible(result.modified, modified);
                    stepModifiedIndex++;
                }
                else {
                    if (original.heightInLines >= modified.heightInLines) {
                        // modified view zone gets removed
                        original.heightInLines -= modified.heightInLines;
                        stepModifiedIndex++;
                    }
                    else {
                        // original view zone gets removed
                        modified.heightInLines -= original.heightInLines;
                        stepOriginalIndex++;
                    }
                }
            }
            // [EMIT] Remaining original view zones
            while (stepOriginalIndex < stepOriginal.length) {
                addAndCombineIfPossible(result.original, stepOriginal[stepOriginalIndex]);
                stepOriginalIndex++;
            }
            // [EMIT] Remaining modified view zones
            while (stepModifiedIndex < stepModified.length) {
                addAndCombineIfPossible(result.modified, stepModified[stepModifiedIndex]);
                stepModifiedIndex++;
            }
            // ---------------------------- END EMIT MINIMAL VIEW ZONES
        }
        return {
            original: ViewZonesComputer._ensureDomNodes(result.original),
            modified: ViewZonesComputer._ensureDomNodes(result.modified),
        };
    };
    ViewZonesComputer._ensureDomNodes = function (zones) {
        return zones.map(function (z) {
            if (!z.domNode) {
                z.domNode = createFakeLinesDiv();
            }
            return z;
        });
    };
    return ViewZonesComputer;
}());
function createDecoration(startLineNumber, startColumn, endLineNumber, endColumn, options) {
    return {
        range: new Range(startLineNumber, startColumn, endLineNumber, endColumn),
        options: options
    };
}
var DECORATIONS = {
    charDelete: ModelDecorationOptions.register({
        className: 'char-delete'
    }),
    charDeleteWholeLine: ModelDecorationOptions.register({
        className: 'char-delete',
        isWholeLine: true
    }),
    charInsert: ModelDecorationOptions.register({
        className: 'char-insert'
    }),
    charInsertWholeLine: ModelDecorationOptions.register({
        className: 'char-insert',
        isWholeLine: true
    }),
    lineInsert: ModelDecorationOptions.register({
        className: 'line-insert',
        marginClassName: 'line-insert',
        isWholeLine: true
    }),
    lineInsertWithSign: ModelDecorationOptions.register({
        className: 'line-insert',
        linesDecorationsClassName: 'insert-sign ' + ThemeIcon.asClassName(diffInsertIcon),
        marginClassName: 'line-insert',
        isWholeLine: true
    }),
    lineDelete: ModelDecorationOptions.register({
        className: 'line-delete',
        marginClassName: 'line-delete',
        isWholeLine: true
    }),
    lineDeleteWithSign: ModelDecorationOptions.register({
        className: 'line-delete',
        linesDecorationsClassName: 'delete-sign ' + ThemeIcon.asClassName(diffRemoveIcon),
        marginClassName: 'line-delete',
        isWholeLine: true
    }),
    lineDeleteMargin: ModelDecorationOptions.register({
        marginClassName: 'line-delete',
    })
};
var DiffEditorWidgetSideBySide = /** @class */ (function (_super) {
    __extends(DiffEditorWidgetSideBySide, _super);
    function DiffEditorWidgetSideBySide(dataSource, enableSplitViewResizing) {
        var _this = _super.call(this, dataSource) || this;
        _this._disableSash = (enableSplitViewResizing === false);
        _this._sashRatio = null;
        _this._sashPosition = null;
        _this._startSashPosition = null;
        _this._sash = _this._register(new Sash(_this._dataSource.getContainerDomNode(), _this, { orientation: 0 /* VERTICAL */ }));
        if (_this._disableSash) {
            _this._sash.state = 0 /* Disabled */;
        }
        _this._sash.onDidStart(function () { return _this._onSashDragStart(); });
        _this._sash.onDidChange(function (e) { return _this._onSashDrag(e); });
        _this._sash.onDidEnd(function () { return _this._onSashDragEnd(); });
        _this._sash.onDidReset(function () { return _this._onSashReset(); });
        return _this;
    }
    DiffEditorWidgetSideBySide.prototype.setEnableSplitViewResizing = function (enableSplitViewResizing) {
        var newDisableSash = (enableSplitViewResizing === false);
        if (this._disableSash !== newDisableSash) {
            this._disableSash = newDisableSash;
            this._sash.state = this._disableSash ? 0 /* Disabled */ : 3 /* Enabled */;
        }
    };
    DiffEditorWidgetSideBySide.prototype.layout = function (sashRatio) {
        if (sashRatio === void 0) { sashRatio = this._sashRatio; }
        var w = this._dataSource.getWidth();
        var contentWidth = w - (this._dataSource.getOptions().renderOverviewRuler ? DiffEditorWidget.ENTIRE_DIFF_OVERVIEW_WIDTH : 0);
        var sashPosition = Math.floor((sashRatio || 0.5) * contentWidth);
        var midPoint = Math.floor(0.5 * contentWidth);
        sashPosition = this._disableSash ? midPoint : sashPosition || midPoint;
        if (contentWidth > DiffEditorWidgetSideBySide.MINIMUM_EDITOR_WIDTH * 2) {
            if (sashPosition < DiffEditorWidgetSideBySide.MINIMUM_EDITOR_WIDTH) {
                sashPosition = DiffEditorWidgetSideBySide.MINIMUM_EDITOR_WIDTH;
            }
            if (sashPosition > contentWidth - DiffEditorWidgetSideBySide.MINIMUM_EDITOR_WIDTH) {
                sashPosition = contentWidth - DiffEditorWidgetSideBySide.MINIMUM_EDITOR_WIDTH;
            }
        }
        else {
            sashPosition = midPoint;
        }
        if (this._sashPosition !== sashPosition) {
            this._sashPosition = sashPosition;
            this._sash.layout();
        }
        return this._sashPosition;
    };
    DiffEditorWidgetSideBySide.prototype._onSashDragStart = function () {
        this._startSashPosition = this._sashPosition;
    };
    DiffEditorWidgetSideBySide.prototype._onSashDrag = function (e) {
        var w = this._dataSource.getWidth();
        var contentWidth = w - (this._dataSource.getOptions().renderOverviewRuler ? DiffEditorWidget.ENTIRE_DIFF_OVERVIEW_WIDTH : 0);
        var sashPosition = this.layout((this._startSashPosition + (e.currentX - e.startX)) / contentWidth);
        this._sashRatio = sashPosition / contentWidth;
        this._dataSource.relayoutEditors();
    };
    DiffEditorWidgetSideBySide.prototype._onSashDragEnd = function () {
        this._sash.layout();
    };
    DiffEditorWidgetSideBySide.prototype._onSashReset = function () {
        this._sashRatio = 0.5;
        this._dataSource.relayoutEditors();
        this._sash.layout();
    };
    DiffEditorWidgetSideBySide.prototype.getVerticalSashTop = function (sash) {
        return 0;
    };
    DiffEditorWidgetSideBySide.prototype.getVerticalSashLeft = function (sash) {
        return this._sashPosition;
    };
    DiffEditorWidgetSideBySide.prototype.getVerticalSashHeight = function (sash) {
        return this._dataSource.getHeight();
    };
    DiffEditorWidgetSideBySide.prototype._getViewZones = function (lineChanges, originalForeignVZ, modifiedForeignVZ) {
        var originalEditor = this._dataSource.getOriginalEditor();
        var modifiedEditor = this._dataSource.getModifiedEditor();
        var c = new SideBySideViewZonesComputer(lineChanges, originalForeignVZ, modifiedForeignVZ, originalEditor, modifiedEditor);
        return c.getViewZones();
    };
    DiffEditorWidgetSideBySide.prototype._getOriginalEditorDecorations = function (lineChanges, ignoreTrimWhitespace, renderIndicators) {
        var e_5, _a, e_6, _b;
        var originalEditor = this._dataSource.getOriginalEditor();
        var overviewZoneColor = String(this._removeColor);
        var result = {
            decorations: [],
            overviewZones: []
        };
        var originalModel = originalEditor.getModel();
        var originalViewModel = originalEditor._getViewModel();
        try {
            for (var lineChanges_1 = __values(lineChanges), lineChanges_1_1 = lineChanges_1.next(); !lineChanges_1_1.done; lineChanges_1_1 = lineChanges_1.next()) {
                var lineChange = lineChanges_1_1.value;
                if (isChangeOrDelete(lineChange)) {
                    result.decorations.push({
                        range: new Range(lineChange.originalStartLineNumber, 1, lineChange.originalEndLineNumber, 1073741824 /* MAX_SAFE_SMALL_INTEGER */),
                        options: (renderIndicators ? DECORATIONS.lineDeleteWithSign : DECORATIONS.lineDelete)
                    });
                    if (!isChangeOrInsert(lineChange) || !lineChange.charChanges) {
                        result.decorations.push(createDecoration(lineChange.originalStartLineNumber, 1, lineChange.originalEndLineNumber, 1073741824 /* MAX_SAFE_SMALL_INTEGER */, DECORATIONS.charDeleteWholeLine));
                    }
                    var viewRange = getViewRange(originalModel, originalViewModel, lineChange.originalStartLineNumber, lineChange.originalEndLineNumber);
                    result.overviewZones.push(new OverviewRulerZone(viewRange.startLineNumber, viewRange.endLineNumber, overviewZoneColor));
                    if (lineChange.charChanges) {
                        try {
                            for (var _c = (e_6 = void 0, __values(lineChange.charChanges)), _d = _c.next(); !_d.done; _d = _c.next()) {
                                var charChange = _d.value;
                                if (isChangeOrDelete(charChange)) {
                                    if (ignoreTrimWhitespace) {
                                        for (var lineNumber = charChange.originalStartLineNumber; lineNumber <= charChange.originalEndLineNumber; lineNumber++) {
                                            var startColumn = void 0;
                                            var endColumn = void 0;
                                            if (lineNumber === charChange.originalStartLineNumber) {
                                                startColumn = charChange.originalStartColumn;
                                            }
                                            else {
                                                startColumn = originalModel.getLineFirstNonWhitespaceColumn(lineNumber);
                                            }
                                            if (lineNumber === charChange.originalEndLineNumber) {
                                                endColumn = charChange.originalEndColumn;
                                            }
                                            else {
                                                endColumn = originalModel.getLineLastNonWhitespaceColumn(lineNumber);
                                            }
                                            result.decorations.push(createDecoration(lineNumber, startColumn, lineNumber, endColumn, DECORATIONS.charDelete));
                                        }
                                    }
                                    else {
                                        result.decorations.push(createDecoration(charChange.originalStartLineNumber, charChange.originalStartColumn, charChange.originalEndLineNumber, charChange.originalEndColumn, DECORATIONS.charDelete));
                                    }
                                }
                            }
                        }
                        catch (e_6_1) { e_6 = { error: e_6_1 }; }
                        finally {
                            try {
                                if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
                            }
                            finally { if (e_6) throw e_6.error; }
                        }
                    }
                }
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (lineChanges_1_1 && !lineChanges_1_1.done && (_a = lineChanges_1.return)) _a.call(lineChanges_1);
            }
            finally { if (e_5) throw e_5.error; }
        }
        return result;
    };
    DiffEditorWidgetSideBySide.prototype._getModifiedEditorDecorations = function (lineChanges, ignoreTrimWhitespace, renderIndicators) {
        var e_7, _a, e_8, _b;
        var modifiedEditor = this._dataSource.getModifiedEditor();
        var overviewZoneColor = String(this._insertColor);
        var result = {
            decorations: [],
            overviewZones: []
        };
        var modifiedModel = modifiedEditor.getModel();
        var modifiedViewModel = modifiedEditor._getViewModel();
        try {
            for (var lineChanges_2 = __values(lineChanges), lineChanges_2_1 = lineChanges_2.next(); !lineChanges_2_1.done; lineChanges_2_1 = lineChanges_2.next()) {
                var lineChange = lineChanges_2_1.value;
                if (isChangeOrInsert(lineChange)) {
                    result.decorations.push({
                        range: new Range(lineChange.modifiedStartLineNumber, 1, lineChange.modifiedEndLineNumber, 1073741824 /* MAX_SAFE_SMALL_INTEGER */),
                        options: (renderIndicators ? DECORATIONS.lineInsertWithSign : DECORATIONS.lineInsert)
                    });
                    if (!isChangeOrDelete(lineChange) || !lineChange.charChanges) {
                        result.decorations.push(createDecoration(lineChange.modifiedStartLineNumber, 1, lineChange.modifiedEndLineNumber, 1073741824 /* MAX_SAFE_SMALL_INTEGER */, DECORATIONS.charInsertWholeLine));
                    }
                    var viewRange = getViewRange(modifiedModel, modifiedViewModel, lineChange.modifiedStartLineNumber, lineChange.modifiedEndLineNumber);
                    result.overviewZones.push(new OverviewRulerZone(viewRange.startLineNumber, viewRange.endLineNumber, overviewZoneColor));
                    if (lineChange.charChanges) {
                        try {
                            for (var _c = (e_8 = void 0, __values(lineChange.charChanges)), _d = _c.next(); !_d.done; _d = _c.next()) {
                                var charChange = _d.value;
                                if (isChangeOrInsert(charChange)) {
                                    if (ignoreTrimWhitespace) {
                                        for (var lineNumber = charChange.modifiedStartLineNumber; lineNumber <= charChange.modifiedEndLineNumber; lineNumber++) {
                                            var startColumn = void 0;
                                            var endColumn = void 0;
                                            if (lineNumber === charChange.modifiedStartLineNumber) {
                                                startColumn = charChange.modifiedStartColumn;
                                            }
                                            else {
                                                startColumn = modifiedModel.getLineFirstNonWhitespaceColumn(lineNumber);
                                            }
                                            if (lineNumber === charChange.modifiedEndLineNumber) {
                                                endColumn = charChange.modifiedEndColumn;
                                            }
                                            else {
                                                endColumn = modifiedModel.getLineLastNonWhitespaceColumn(lineNumber);
                                            }
                                            result.decorations.push(createDecoration(lineNumber, startColumn, lineNumber, endColumn, DECORATIONS.charInsert));
                                        }
                                    }
                                    else {
                                        result.decorations.push(createDecoration(charChange.modifiedStartLineNumber, charChange.modifiedStartColumn, charChange.modifiedEndLineNumber, charChange.modifiedEndColumn, DECORATIONS.charInsert));
                                    }
                                }
                            }
                        }
                        catch (e_8_1) { e_8 = { error: e_8_1 }; }
                        finally {
                            try {
                                if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
                            }
                            finally { if (e_8) throw e_8.error; }
                        }
                    }
                }
            }
        }
        catch (e_7_1) { e_7 = { error: e_7_1 }; }
        finally {
            try {
                if (lineChanges_2_1 && !lineChanges_2_1.done && (_a = lineChanges_2.return)) _a.call(lineChanges_2);
            }
            finally { if (e_7) throw e_7.error; }
        }
        return result;
    };
    DiffEditorWidgetSideBySide.MINIMUM_EDITOR_WIDTH = 100;
    return DiffEditorWidgetSideBySide;
}(DiffEditorWidgetStyle));
var SideBySideViewZonesComputer = /** @class */ (function (_super) {
    __extends(SideBySideViewZonesComputer, _super);
    function SideBySideViewZonesComputer(lineChanges, originalForeignVZ, modifiedForeignVZ, originalEditor, modifiedEditor) {
        return _super.call(this, lineChanges, originalForeignVZ, modifiedForeignVZ, originalEditor, modifiedEditor) || this;
    }
    SideBySideViewZonesComputer.prototype._createOriginalMarginDomNodeForModifiedForeignViewZoneInAddedRegion = function () {
        return null;
    };
    SideBySideViewZonesComputer.prototype._produceOriginalFromDiff = function (lineChange, lineChangeOriginalLength, lineChangeModifiedLength) {
        if (lineChangeModifiedLength > lineChangeOriginalLength) {
            return {
                afterLineNumber: Math.max(lineChange.originalStartLineNumber, lineChange.originalEndLineNumber),
                heightInLines: (lineChangeModifiedLength - lineChangeOriginalLength),
                domNode: null
            };
        }
        return null;
    };
    SideBySideViewZonesComputer.prototype._produceModifiedFromDiff = function (lineChange, lineChangeOriginalLength, lineChangeModifiedLength) {
        if (lineChangeOriginalLength > lineChangeModifiedLength) {
            return {
                afterLineNumber: Math.max(lineChange.modifiedStartLineNumber, lineChange.modifiedEndLineNumber),
                heightInLines: (lineChangeOriginalLength - lineChangeModifiedLength),
                domNode: null
            };
        }
        return null;
    };
    return SideBySideViewZonesComputer;
}(ViewZonesComputer));
var DiffEditorWidgetInline = /** @class */ (function (_super) {
    __extends(DiffEditorWidgetInline, _super);
    function DiffEditorWidgetInline(dataSource, enableSplitViewResizing) {
        var _this = _super.call(this, dataSource) || this;
        _this._decorationsLeft = dataSource.getOriginalEditor().getLayoutInfo().decorationsLeft;
        _this._register(dataSource.getOriginalEditor().onDidLayoutChange(function (layoutInfo) {
            if (_this._decorationsLeft !== layoutInfo.decorationsLeft) {
                _this._decorationsLeft = layoutInfo.decorationsLeft;
                dataSource.relayoutEditors();
            }
        }));
        return _this;
    }
    DiffEditorWidgetInline.prototype.setEnableSplitViewResizing = function (enableSplitViewResizing) {
        // Nothing to do..
    };
    DiffEditorWidgetInline.prototype._getViewZones = function (lineChanges, originalForeignVZ, modifiedForeignVZ, renderIndicators) {
        var originalEditor = this._dataSource.getOriginalEditor();
        var modifiedEditor = this._dataSource.getModifiedEditor();
        var computer = new InlineViewZonesComputer(lineChanges, originalForeignVZ, modifiedForeignVZ, originalEditor, modifiedEditor, renderIndicators);
        return computer.getViewZones();
    };
    DiffEditorWidgetInline.prototype._getOriginalEditorDecorations = function (lineChanges, ignoreTrimWhitespace, renderIndicators) {
        var e_9, _a;
        var overviewZoneColor = String(this._removeColor);
        var result = {
            decorations: [],
            overviewZones: []
        };
        var originalEditor = this._dataSource.getOriginalEditor();
        var originalModel = originalEditor.getModel();
        var originalViewModel = originalEditor._getViewModel();
        try {
            for (var lineChanges_3 = __values(lineChanges), lineChanges_3_1 = lineChanges_3.next(); !lineChanges_3_1.done; lineChanges_3_1 = lineChanges_3.next()) {
                var lineChange = lineChanges_3_1.value;
                // Add overview zones in the overview ruler
                if (isChangeOrDelete(lineChange)) {
                    result.decorations.push({
                        range: new Range(lineChange.originalStartLineNumber, 1, lineChange.originalEndLineNumber, 1073741824 /* MAX_SAFE_SMALL_INTEGER */),
                        options: DECORATIONS.lineDeleteMargin
                    });
                    var viewRange = getViewRange(originalModel, originalViewModel, lineChange.originalStartLineNumber, lineChange.originalEndLineNumber);
                    result.overviewZones.push(new OverviewRulerZone(viewRange.startLineNumber, viewRange.endLineNumber, overviewZoneColor));
                }
            }
        }
        catch (e_9_1) { e_9 = { error: e_9_1 }; }
        finally {
            try {
                if (lineChanges_3_1 && !lineChanges_3_1.done && (_a = lineChanges_3.return)) _a.call(lineChanges_3);
            }
            finally { if (e_9) throw e_9.error; }
        }
        return result;
    };
    DiffEditorWidgetInline.prototype._getModifiedEditorDecorations = function (lineChanges, ignoreTrimWhitespace, renderIndicators) {
        var e_10, _a, e_11, _b;
        var modifiedEditor = this._dataSource.getModifiedEditor();
        var overviewZoneColor = String(this._insertColor);
        var result = {
            decorations: [],
            overviewZones: []
        };
        var modifiedModel = modifiedEditor.getModel();
        var modifiedViewModel = modifiedEditor._getViewModel();
        try {
            for (var lineChanges_4 = __values(lineChanges), lineChanges_4_1 = lineChanges_4.next(); !lineChanges_4_1.done; lineChanges_4_1 = lineChanges_4.next()) {
                var lineChange = lineChanges_4_1.value;
                // Add decorations & overview zones
                if (isChangeOrInsert(lineChange)) {
                    result.decorations.push({
                        range: new Range(lineChange.modifiedStartLineNumber, 1, lineChange.modifiedEndLineNumber, 1073741824 /* MAX_SAFE_SMALL_INTEGER */),
                        options: (renderIndicators ? DECORATIONS.lineInsertWithSign : DECORATIONS.lineInsert)
                    });
                    var viewRange = getViewRange(modifiedModel, modifiedViewModel, lineChange.modifiedStartLineNumber, lineChange.modifiedEndLineNumber);
                    result.overviewZones.push(new OverviewRulerZone(viewRange.startLineNumber, viewRange.endLineNumber, overviewZoneColor));
                    if (lineChange.charChanges) {
                        try {
                            for (var _c = (e_11 = void 0, __values(lineChange.charChanges)), _d = _c.next(); !_d.done; _d = _c.next()) {
                                var charChange = _d.value;
                                if (isChangeOrInsert(charChange)) {
                                    if (ignoreTrimWhitespace) {
                                        for (var lineNumber = charChange.modifiedStartLineNumber; lineNumber <= charChange.modifiedEndLineNumber; lineNumber++) {
                                            var startColumn = void 0;
                                            var endColumn = void 0;
                                            if (lineNumber === charChange.modifiedStartLineNumber) {
                                                startColumn = charChange.modifiedStartColumn;
                                            }
                                            else {
                                                startColumn = modifiedModel.getLineFirstNonWhitespaceColumn(lineNumber);
                                            }
                                            if (lineNumber === charChange.modifiedEndLineNumber) {
                                                endColumn = charChange.modifiedEndColumn;
                                            }
                                            else {
                                                endColumn = modifiedModel.getLineLastNonWhitespaceColumn(lineNumber);
                                            }
                                            result.decorations.push(createDecoration(lineNumber, startColumn, lineNumber, endColumn, DECORATIONS.charInsert));
                                        }
                                    }
                                    else {
                                        result.decorations.push(createDecoration(charChange.modifiedStartLineNumber, charChange.modifiedStartColumn, charChange.modifiedEndLineNumber, charChange.modifiedEndColumn, DECORATIONS.charInsert));
                                    }
                                }
                            }
                        }
                        catch (e_11_1) { e_11 = { error: e_11_1 }; }
                        finally {
                            try {
                                if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
                            }
                            finally { if (e_11) throw e_11.error; }
                        }
                    }
                    else {
                        result.decorations.push(createDecoration(lineChange.modifiedStartLineNumber, 1, lineChange.modifiedEndLineNumber, 1073741824 /* MAX_SAFE_SMALL_INTEGER */, DECORATIONS.charInsertWholeLine));
                    }
                }
            }
        }
        catch (e_10_1) { e_10 = { error: e_10_1 }; }
        finally {
            try {
                if (lineChanges_4_1 && !lineChanges_4_1.done && (_a = lineChanges_4.return)) _a.call(lineChanges_4);
            }
            finally { if (e_10) throw e_10.error; }
        }
        return result;
    };
    DiffEditorWidgetInline.prototype.layout = function () {
        // An editor should not be smaller than 5px
        return Math.max(5, this._decorationsLeft);
    };
    return DiffEditorWidgetInline;
}(DiffEditorWidgetStyle));
var InlineViewZonesComputer = /** @class */ (function (_super) {
    __extends(InlineViewZonesComputer, _super);
    function InlineViewZonesComputer(lineChanges, originalForeignVZ, modifiedForeignVZ, originalEditor, modifiedEditor, renderIndicators) {
        var _this = _super.call(this, lineChanges, originalForeignVZ, modifiedForeignVZ, originalEditor, modifiedEditor) || this;
        _this._originalModel = originalEditor.getModel();
        _this._renderIndicators = renderIndicators;
        _this._pendingLineChange = [];
        _this._pendingViewZones = [];
        _this._lineBreaksComputer = _this._modifiedEditor._getViewModel().createLineBreaksComputer();
        return _this;
    }
    InlineViewZonesComputer.prototype.getViewZones = function () {
        var result = _super.prototype.getViewZones.call(this);
        this._finalize(result);
        return result;
    };
    InlineViewZonesComputer.prototype._createOriginalMarginDomNodeForModifiedForeignViewZoneInAddedRegion = function () {
        var result = document.createElement('div');
        result.className = 'inline-added-margin-view-zone';
        return result;
    };
    InlineViewZonesComputer.prototype._produceOriginalFromDiff = function (lineChange, lineChangeOriginalLength, lineChangeModifiedLength) {
        var marginDomNode = document.createElement('div');
        marginDomNode.className = 'inline-added-margin-view-zone';
        return {
            afterLineNumber: Math.max(lineChange.originalStartLineNumber, lineChange.originalEndLineNumber),
            heightInLines: lineChangeModifiedLength,
            domNode: document.createElement('div'),
            marginDomNode: marginDomNode
        };
    };
    InlineViewZonesComputer.prototype._produceModifiedFromDiff = function (lineChange, lineChangeOriginalLength, lineChangeModifiedLength) {
        var domNode = document.createElement('div');
        domNode.className = "view-lines line-delete " + MOUSE_CURSOR_TEXT_CSS_CLASS_NAME;
        var marginDomNode = document.createElement('div');
        marginDomNode.className = 'inline-deleted-margin-view-zone';
        var viewZone = {
            shouldNotShrink: true,
            afterLineNumber: (lineChange.modifiedEndLineNumber === 0 ? lineChange.modifiedStartLineNumber : lineChange.modifiedStartLineNumber - 1),
            heightInLines: lineChangeOriginalLength,
            minWidthInPx: 0,
            domNode: domNode,
            marginDomNode: marginDomNode,
            diff: {
                originalStartLineNumber: lineChange.originalStartLineNumber,
                originalEndLineNumber: lineChange.originalEndLineNumber,
                modifiedStartLineNumber: lineChange.modifiedStartLineNumber,
                modifiedEndLineNumber: lineChange.modifiedEndLineNumber,
                originalModel: this._originalModel,
                viewLineCounts: null,
            }
        };
        for (var lineNumber = lineChange.originalStartLineNumber; lineNumber <= lineChange.originalEndLineNumber; lineNumber++) {
            this._lineBreaksComputer.addRequest(this._originalModel.getLineContent(lineNumber), null);
        }
        this._pendingLineChange.push(lineChange);
        this._pendingViewZones.push(viewZone);
        return viewZone;
    };
    InlineViewZonesComputer.prototype._finalize = function (result) {
        var e_12, _a, e_13, _b;
        var modifiedEditorOptions = this._modifiedEditor.getOptions();
        var tabSize = this._modifiedEditor.getModel().getOptions().tabSize;
        var fontInfo = modifiedEditorOptions.get(38 /* fontInfo */);
        var disableMonospaceOptimizations = modifiedEditorOptions.get(26 /* disableMonospaceOptimizations */);
        var typicalHalfwidthCharacterWidth = fontInfo.typicalHalfwidthCharacterWidth;
        var scrollBeyondLastColumn = modifiedEditorOptions.get(88 /* scrollBeyondLastColumn */);
        var mightContainNonBasicASCII = this._originalModel.mightContainNonBasicASCII();
        var mightContainRTL = this._originalModel.mightContainRTL();
        var lineHeight = modifiedEditorOptions.get(53 /* lineHeight */);
        var layoutInfo = modifiedEditorOptions.get(124 /* layoutInfo */);
        var lineDecorationsWidth = layoutInfo.decorationsWidth;
        var stopRenderingLineAfter = modifiedEditorOptions.get(100 /* stopRenderingLineAfter */);
        var renderWhitespace = modifiedEditorOptions.get(83 /* renderWhitespace */);
        var renderControlCharacters = modifiedEditorOptions.get(77 /* renderControlCharacters */);
        var fontLigatures = modifiedEditorOptions.get(39 /* fontLigatures */);
        var lineBreaks = this._lineBreaksComputer.finalize();
        var lineBreakIndex = 0;
        for (var i = 0; i < this._pendingLineChange.length; i++) {
            var lineChange = this._pendingLineChange[i];
            var viewZone = this._pendingViewZones[i];
            var domNode = viewZone.domNode;
            Configuration.applyFontInfoSlow(domNode, fontInfo);
            var marginDomNode = viewZone.marginDomNode;
            Configuration.applyFontInfoSlow(marginDomNode, fontInfo);
            var decorations = [];
            if (lineChange.charChanges) {
                try {
                    for (var _c = (e_12 = void 0, __values(lineChange.charChanges)), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var charChange = _d.value;
                        if (isChangeOrDelete(charChange)) {
                            decorations.push(new InlineDecoration(new Range(charChange.originalStartLineNumber, charChange.originalStartColumn, charChange.originalEndLineNumber, charChange.originalEndColumn), 'char-delete', 0 /* Regular */));
                        }
                    }
                }
                catch (e_12_1) { e_12 = { error: e_12_1 }; }
                finally {
                    try {
                        if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                    }
                    finally { if (e_12) throw e_12.error; }
                }
            }
            var hasCharChanges = (decorations.length > 0);
            var sb = createStringBuilder(10000);
            var maxCharsPerLine = 0;
            var renderedLineCount = 0;
            var viewLineCounts = null;
            for (var lineNumber = lineChange.originalStartLineNumber; lineNumber <= lineChange.originalEndLineNumber; lineNumber++) {
                var lineIndex = lineNumber - lineChange.originalStartLineNumber;
                var lineTokens = this._originalModel.getLineTokens(lineNumber);
                var lineContent = lineTokens.getLineContent();
                var lineBreakData = lineBreaks[lineBreakIndex++];
                var actualDecorations = LineDecoration.filter(decorations, lineNumber, 1, lineContent.length + 1);
                if (lineBreakData) {
                    var lastBreakOffset = 0;
                    try {
                        for (var _e = (e_13 = void 0, __values(lineBreakData.breakOffsets)), _f = _e.next(); !_f.done; _f = _e.next()) {
                            var breakOffset = _f.value;
                            var viewLineTokens = lineTokens.sliceAndInflate(lastBreakOffset, breakOffset, 0);
                            var viewLineContent = lineContent.substring(lastBreakOffset, breakOffset);
                            maxCharsPerLine = Math.max(maxCharsPerLine, this._renderOriginalLine(renderedLineCount++, viewLineContent, viewLineTokens, LineDecoration.extractWrapped(actualDecorations, lastBreakOffset, breakOffset), hasCharChanges, mightContainNonBasicASCII, mightContainRTL, fontInfo, disableMonospaceOptimizations, lineHeight, lineDecorationsWidth, stopRenderingLineAfter, renderWhitespace, renderControlCharacters, fontLigatures, tabSize, sb, marginDomNode));
                            lastBreakOffset = breakOffset;
                        }
                    }
                    catch (e_13_1) { e_13 = { error: e_13_1 }; }
                    finally {
                        try {
                            if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                        }
                        finally { if (e_13) throw e_13.error; }
                    }
                    if (!viewLineCounts) {
                        viewLineCounts = [];
                    }
                    // make sure all lines before this one have an entry in `viewLineCounts`
                    while (viewLineCounts.length < lineIndex) {
                        viewLineCounts[viewLineCounts.length] = 1;
                    }
                    viewLineCounts[lineIndex] = lineBreakData.breakOffsets.length;
                    viewZone.heightInLines += (lineBreakData.breakOffsets.length - 1);
                    var marginDomNode2 = document.createElement('div');
                    marginDomNode2.className = 'line-delete';
                    result.original.push({
                        afterLineNumber: lineNumber,
                        afterColumn: 0,
                        heightInLines: lineBreakData.breakOffsets.length - 1,
                        domNode: createFakeLinesDiv(),
                        marginDomNode: marginDomNode2
                    });
                }
                else {
                    maxCharsPerLine = Math.max(maxCharsPerLine, this._renderOriginalLine(renderedLineCount++, lineContent, lineTokens, actualDecorations, hasCharChanges, mightContainNonBasicASCII, mightContainRTL, fontInfo, disableMonospaceOptimizations, lineHeight, lineDecorationsWidth, stopRenderingLineAfter, renderWhitespace, renderControlCharacters, fontLigatures, tabSize, sb, marginDomNode));
                }
            }
            maxCharsPerLine += scrollBeyondLastColumn;
            var html = sb.build();
            var trustedhtml = ttPolicy ? ttPolicy.createHTML(html) : html;
            domNode.innerHTML = trustedhtml;
            viewZone.minWidthInPx = (maxCharsPerLine * typicalHalfwidthCharacterWidth);
            if (viewLineCounts) {
                // make sure all lines have an entry in `viewLineCounts`
                var cnt = lineChange.originalEndLineNumber - lineChange.originalStartLineNumber;
                while (viewLineCounts.length <= cnt) {
                    viewLineCounts[viewLineCounts.length] = 1;
                }
            }
            viewZone.diff.viewLineCounts = viewLineCounts;
        }
        result.original.sort(function (a, b) {
            return a.afterLineNumber - b.afterLineNumber;
        });
    };
    InlineViewZonesComputer.prototype._renderOriginalLine = function (renderedLineCount, lineContent, lineTokens, decorations, hasCharChanges, mightContainNonBasicASCII, mightContainRTL, fontInfo, disableMonospaceOptimizations, lineHeight, lineDecorationsWidth, stopRenderingLineAfter, renderWhitespace, renderControlCharacters, fontLigatures, tabSize, sb, marginDomNode) {
        sb.appendASCIIString('<div class="view-line');
        if (!hasCharChanges) {
            // No char changes
            sb.appendASCIIString(' char-delete');
        }
        sb.appendASCIIString('" style="top:');
        sb.appendASCIIString(String(renderedLineCount * lineHeight));
        sb.appendASCIIString('px;width:1000000px;">');
        var isBasicASCII = ViewLineRenderingData.isBasicASCII(lineContent, mightContainNonBasicASCII);
        var containsRTL = ViewLineRenderingData.containsRTL(lineContent, isBasicASCII, mightContainRTL);
        var output = renderViewLine(new RenderLineInput((fontInfo.isMonospace && !disableMonospaceOptimizations), fontInfo.canUseHalfwidthRightwardsArrow, lineContent, false, isBasicASCII, containsRTL, 0, lineTokens, decorations, tabSize, 0, fontInfo.spaceWidth, fontInfo.middotWidth, fontInfo.wsmiddotWidth, stopRenderingLineAfter, renderWhitespace, renderControlCharacters, fontLigatures !== EditorFontLigatures.OFF, null // Send no selections, original line cannot be selected
        ), sb);
        sb.appendASCIIString('</div>');
        if (this._renderIndicators) {
            var marginElement = document.createElement('div');
            marginElement.className = "delete-sign " + ThemeIcon.asClassName(diffRemoveIcon);
            marginElement.setAttribute('style', "position:absolute;top:" + renderedLineCount * lineHeight + "px;width:" + lineDecorationsWidth + "px;height:" + lineHeight + "px;right:0;");
            marginDomNode.appendChild(marginElement);
        }
        var absoluteOffsets = output.characterMapping.getAbsoluteOffsets();
        return absoluteOffsets.length > 0 ? absoluteOffsets[absoluteOffsets.length - 1] : 0;
    };
    return InlineViewZonesComputer;
}(ViewZonesComputer));
function validateDiffWordWrap(value, defaultValue) {
    return validateStringSetOption(value, defaultValue, ['off', 'on', 'inherit']);
}
function isChangeOrInsert(lineChange) {
    return lineChange.modifiedEndLineNumber > 0;
}
function isChangeOrDelete(lineChange) {
    return lineChange.originalEndLineNumber > 0;
}
function createFakeLinesDiv() {
    var r = document.createElement('div');
    r.className = 'diagonal-fill';
    return r;
}
function getViewRange(model, viewModel, startLineNumber, endLineNumber) {
    var lineCount = model.getLineCount();
    startLineNumber = Math.min(lineCount, Math.max(1, startLineNumber));
    endLineNumber = Math.min(lineCount, Math.max(1, endLineNumber));
    return viewModel.coordinatesConverter.convertModelRangeToViewRange(new Range(startLineNumber, model.getLineMinColumn(startLineNumber), endLineNumber, model.getLineMaxColumn(endLineNumber)));
}
registerThemingParticipant(function (theme, collector) {
    var added = theme.getColor(diffInserted);
    if (added) {
        collector.addRule(".monaco-editor .line-insert, .monaco-editor .char-insert { background-color: " + added + "; }");
        collector.addRule(".monaco-diff-editor .line-insert, .monaco-diff-editor .char-insert { background-color: " + added + "; }");
        collector.addRule(".monaco-editor .inline-added-margin-view-zone { background-color: " + added + "; }");
    }
    var removed = theme.getColor(diffRemoved);
    if (removed) {
        collector.addRule(".monaco-editor .line-delete, .monaco-editor .char-delete { background-color: " + removed + "; }");
        collector.addRule(".monaco-diff-editor .line-delete, .monaco-diff-editor .char-delete { background-color: " + removed + "; }");
        collector.addRule(".monaco-editor .inline-deleted-margin-view-zone { background-color: " + removed + "; }");
    }
    var addedOutline = theme.getColor(diffInsertedOutline);
    if (addedOutline) {
        collector.addRule(".monaco-editor .line-insert, .monaco-editor .char-insert { border: 1px " + (theme.type === 'hc' ? 'dashed' : 'solid') + " " + addedOutline + "; }");
    }
    var removedOutline = theme.getColor(diffRemovedOutline);
    if (removedOutline) {
        collector.addRule(".monaco-editor .line-delete, .monaco-editor .char-delete { border: 1px " + (theme.type === 'hc' ? 'dashed' : 'solid') + " " + removedOutline + "; }");
    }
    var shadow = theme.getColor(scrollbarShadow);
    if (shadow) {
        collector.addRule(".monaco-diff-editor.side-by-side .editor.modified { box-shadow: -6px 0 5px -5px " + shadow + "; }");
    }
    var border = theme.getColor(diffBorder);
    if (border) {
        collector.addRule(".monaco-diff-editor.side-by-side .editor.modified { border-left: 1px solid " + border + "; }");
    }
    var scrollbarSliderBackgroundColor = theme.getColor(scrollbarSliderBackground);
    if (scrollbarSliderBackgroundColor) {
        collector.addRule("\n\t\t\t.monaco-diff-editor .diffViewport {\n\t\t\t\tbackground: " + scrollbarSliderBackgroundColor + ";\n\t\t\t}\n\t\t");
    }
    var scrollbarSliderHoverBackgroundColor = theme.getColor(scrollbarSliderHoverBackground);
    if (scrollbarSliderHoverBackgroundColor) {
        collector.addRule("\n\t\t\t.monaco-diff-editor .diffViewport:hover {\n\t\t\t\tbackground: " + scrollbarSliderHoverBackgroundColor + ";\n\t\t\t}\n\t\t");
    }
    var scrollbarSliderActiveBackgroundColor = theme.getColor(scrollbarSliderActiveBackground);
    if (scrollbarSliderActiveBackgroundColor) {
        collector.addRule("\n\t\t\t.monaco-diff-editor .diffViewport:active {\n\t\t\t\tbackground: " + scrollbarSliderActiveBackgroundColor + ";\n\t\t\t}\n\t\t");
    }
    var diffDiagonalFillColor = theme.getColor(diffDiagonalFill);
    collector.addRule("\n\t.monaco-editor .diagonal-fill {\n\t\tbackground-image: linear-gradient(\n\t\t\t-45deg,\n\t\t\t" + diffDiagonalFillColor + " 12.5%,\n\t\t\t#0000 12.5%, #0000 50%,\n\t\t\t" + diffDiagonalFillColor + " 50%, " + diffDiagonalFillColor + " 62.5%,\n\t\t\t#0000 62.5%, #0000 100%\n\t\t);\n\t\tbackground-size: 8px 8px;\n\t}\n\t");
});
