"use strict";
/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const inversify_1 = require("@theia/core/shared/inversify");
const env_variables_1 = require("@theia/core/lib/common/env-variables");
const theia_blueprint_variables_server_1 = require("./theia-blueprint-variables-server");
exports.default = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    rebind(env_variables_1.EnvVariablesServer).to(theia_blueprint_variables_server_1.TheiaBlueprintEnvVariableServer).inSingletonScope();
});
//# sourceMappingURL=theia-blueprint-backend-module.js.map