"use strict";
/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.VSXExtensionsCommands = void 0;
var VSXExtensionsCommands;
(function (VSXExtensionsCommands) {
    const EXTENSIONS_CATEGORY = 'Extensions';
    VSXExtensionsCommands.CLEAR_ALL = {
        id: 'vsxExtensions.clearAll',
        category: EXTENSIONS_CATEGORY,
        label: 'Clear Search Results',
        iconClass: 'clear-all'
    };
    VSXExtensionsCommands.INSTALL_FROM_VSIX = {
        id: 'vsxExtensions.installFromVSIX',
        category: EXTENSIONS_CATEGORY,
        label: 'Install from VSIX...',
        dialogLabel: 'Install from VSIX'
    };
    VSXExtensionsCommands.COPY = {
        id: 'vsxExtensions.copy'
    };
    VSXExtensionsCommands.COPY_EXTENSION_ID = {
        id: 'vsxExtensions.copyExtensionId'
    };
    VSXExtensionsCommands.SHOW_BUILTINS = {
        id: 'vsxExtension.showBuiltins',
        label: 'Show Built-in Extensions',
        category: EXTENSIONS_CATEGORY,
    };
    VSXExtensionsCommands.SHOW_INSTALLED = {
        id: 'vsxExtension.showInstalled',
        label: 'Show Installed Extensions',
        category: EXTENSIONS_CATEGORY,
    };
    VSXExtensionsCommands.SHOW_RECOMMENDATIONS = {
        id: 'vsxExtension.showRecommendations',
        label: 'Show Recommended Extensions',
        category: EXTENSIONS_CATEGORY,
    };
})(VSXExtensionsCommands = exports.VSXExtensionsCommands || (exports.VSXExtensionsCommands = {}));
//# sourceMappingURL=vsx-extension-commands.js.map