"use strict";
/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommonVariableContribution = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const application_protocol_1 = require("@theia/core/lib/common/application-protocol");
const env_variables_1 = require("@theia/core/lib/common/env-variables");
const command_1 = require("@theia/core/lib/common/command");
const os_1 = require("@theia/core/lib/common/os");
const preference_service_1 = require("@theia/core/lib/browser/preferences/preference-service");
const resource_context_key_1 = require("@theia/core/lib/browser/resource-context-key");
const browser_1 = require("@theia/core/lib/browser");
let CommonVariableContribution = class CommonVariableContribution {
    async registerVariables(variables) {
        const [execPath, backendOS] = await Promise.all([
            this.env.getExecPath(),
            this.appServer.getBackendOS()
        ]);
        variables.registerVariable({
            name: 'execPath',
            resolve: () => execPath
        });
        variables.registerVariable({
            name: 'pathSeparator',
            resolve: () => backendOS === os_1.OS.Type.Windows ? '\\' : '/'
        });
        variables.registerVariable({
            name: 'env',
            resolve: async (_, envVariableName) => {
                const envVariable = envVariableName && await this.env.getValue(envVariableName);
                const envValue = envVariable && envVariable.value;
                return envValue || '';
            }
        });
        variables.registerVariable({
            name: 'config',
            resolve: (resourceUri = this.resourceContextKey.get(), preferenceName) => {
                if (!preferenceName) {
                    return undefined;
                }
                return this.preferences.get(preferenceName, undefined, resourceUri && resourceUri.toString());
            }
        });
        variables.registerVariable({
            name: 'command',
            resolve: async (_, command) => 
            // eslint-disable-next-line no-return-await
            command && await this.commands.executeCommand(command)
        });
        variables.registerVariable({
            name: 'input',
            resolve: async (resourceUri = this.resourceContextKey.get(), variable, section) => {
                var _a, _b;
                if (!variable || !section) {
                    return undefined;
                }
                const configuration = this.preferences.get(section, undefined, resourceUri && resourceUri.toString());
                const inputs = !!configuration && 'inputs' in configuration ? configuration.inputs : undefined;
                const input = Array.isArray(inputs) && inputs.find(item => !!item && item.id === variable);
                if (!input) {
                    return undefined;
                }
                if (input.type === 'promptString') {
                    if (typeof input.description !== 'string') {
                        return undefined;
                    }
                    return (_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.input({
                        prompt: input.description,
                        value: input.default
                    });
                }
                if (input.type === 'pickString') {
                    if (typeof input.description !== 'string' || !Array.isArray(input.options)) {
                        return undefined;
                    }
                    const elements = [];
                    for (const option of input.options) {
                        if (typeof option !== 'string') {
                            return undefined;
                        }
                        if (option === input.default) {
                            elements.unshift({
                                description: 'Default',
                                label: option,
                                value: option
                            });
                        }
                        else {
                            elements.push({
                                label: option,
                                value: option
                            });
                        }
                    }
                    return (_b = this.quickInputService) === null || _b === void 0 ? void 0 : _b.showQuickPick(elements, { placeholder: input.description });
                }
                if (input.type === 'command') {
                    if (typeof input.command !== 'string') {
                        return undefined;
                    }
                    return this.commands.executeCommand(input.command, input.args);
                }
                return undefined;
            }
        });
    }
};
__decorate([
    inversify_1.inject(env_variables_1.EnvVariablesServer),
    __metadata("design:type", Object)
], CommonVariableContribution.prototype, "env", void 0);
__decorate([
    inversify_1.inject(command_1.CommandService),
    __metadata("design:type", Object)
], CommonVariableContribution.prototype, "commands", void 0);
__decorate([
    inversify_1.inject(preference_service_1.PreferenceService),
    __metadata("design:type", Object)
], CommonVariableContribution.prototype, "preferences", void 0);
__decorate([
    inversify_1.inject(resource_context_key_1.ResourceContextKey),
    __metadata("design:type", resource_context_key_1.ResourceContextKey)
], CommonVariableContribution.prototype, "resourceContextKey", void 0);
__decorate([
    inversify_1.inject(browser_1.QuickInputService),
    inversify_1.optional(),
    __metadata("design:type", Object)
], CommonVariableContribution.prototype, "quickInputService", void 0);
__decorate([
    inversify_1.inject(application_protocol_1.ApplicationServer),
    __metadata("design:type", Object)
], CommonVariableContribution.prototype, "appServer", void 0);
CommonVariableContribution = __decorate([
    inversify_1.injectable()
], CommonVariableContribution);
exports.CommonVariableContribution = CommonVariableContribution;
//# sourceMappingURL=common-variable-contribution.js.map