"use strict";
/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreferenceSelectInputRenderer = void 0;
const preference_node_renderer_1 = require("./preference-node-renderer");
const inversify_1 = require("@theia/core/shared/inversify");
let PreferenceSelectInputRenderer = class PreferenceSelectInputRenderer extends preference_node_renderer_1.PreferenceLeafNodeRenderer {
    createInteractable(parent) {
        const options = this.preferenceNode.preference.data.enum;
        const interactable = document.createElement('select');
        this.interactable = interactable;
        interactable.classList.add('theia-select');
        interactable.onchange = this.handleUserInteraction.bind(this);
        for (const value of options) {
            const option = document.createElement('option');
            option.value = value;
            option.textContent = value;
            interactable.appendChild(option);
        }
        interactable.value = this.getValue();
        parent.appendChild(interactable);
    }
    getFallbackValue() {
        return this.preferenceNode.preference.data.enum[0];
    }
    doHandleValueChange() {
        const currentValue = this.interactable.value || undefined;
        this.updateInspection();
        const newValue = this.getValue();
        this.updateModificationStatus(newValue);
        if (newValue !== currentValue && document.activeElement !== this.interactable) {
            this.interactable.value = newValue;
        }
    }
    handleUserInteraction() {
        this.setPreferenceImmediately(this.interactable.value || undefined);
    }
};
PreferenceSelectInputRenderer = __decorate([
    inversify_1.injectable()
], PreferenceSelectInputRenderer);
exports.PreferenceSelectInputRenderer = PreferenceSelectInputRenderer;
//# sourceMappingURL=preference-select-input.js.map