/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { IQuickInputService } from '../common/quickInput';
import { Extensions } from '../common/quickAccess';
import { Registry } from '../../registry/common/platform';
import { localize } from '../../../nls';
import { DisposableStore } from '../../../base/common/lifecycle';
var HelpQuickAccessProvider = /** @class */ (function () {
    function HelpQuickAccessProvider(quickInputService) {
        this.quickInputService = quickInputService;
        this.registry = Registry.as(Extensions.Quickaccess);
    }
    HelpQuickAccessProvider.prototype.provide = function (picker) {
        var _this = this;
        var disposables = new DisposableStore();
        // Open a picker with the selected value if picked
        disposables.add(picker.onDidAccept(function () {
            var _a = __read(picker.selectedItems, 1), item = _a[0];
            if (item) {
                _this.quickInputService.quickAccess.show(item.prefix, { preserveValue: true });
            }
        }));
        // Also open a picker when we detect the user typed the exact
        // name of a provider (e.g. `?term` for terminals)
        disposables.add(picker.onDidChangeValue(function (value) {
            var providerDescriptor = _this.registry.getQuickAccessProvider(value.substr(HelpQuickAccessProvider.PREFIX.length));
            if (providerDescriptor && providerDescriptor.prefix && providerDescriptor.prefix !== HelpQuickAccessProvider.PREFIX) {
                _this.quickInputService.quickAccess.show(providerDescriptor.prefix, { preserveValue: true });
            }
        }));
        // Fill in all providers separated by editor/global scope
        var _a = this.getQuickAccessProviders(), editorProviders = _a.editorProviders, globalProviders = _a.globalProviders;
        picker.items = editorProviders.length === 0 || globalProviders.length === 0 ? __spreadArray([], __read((editorProviders.length === 0 ? globalProviders : editorProviders))) : __spreadArray(__spreadArray(__spreadArray([
            { label: localize('globalCommands', "global commands"), type: 'separator' }
        ], __read(globalProviders)), [
            { label: localize('editorCommands', "editor commands"), type: 'separator' }
        ]), __read(editorProviders));
        return disposables;
    };
    HelpQuickAccessProvider.prototype.getQuickAccessProviders = function () {
        var e_1, _a, e_2, _b;
        var globalProviders = [];
        var editorProviders = [];
        try {
            for (var _c = __values(this.registry.getQuickAccessProviders().sort(function (providerA, providerB) { return providerA.prefix.localeCompare(providerB.prefix); })), _d = _c.next(); !_d.done; _d = _c.next()) {
                var provider = _d.value;
                if (provider.prefix === HelpQuickAccessProvider.PREFIX) {
                    continue; // exclude help which is already active
                }
                try {
                    for (var _e = (e_2 = void 0, __values(provider.helpEntries)), _f = _e.next(); !_f.done; _f = _e.next()) {
                        var helpEntry = _f.value;
                        var prefix = helpEntry.prefix || provider.prefix;
                        var label = prefix || '\u2026' /* ... */;
                        (helpEntry.needsEditor ? editorProviders : globalProviders).push({
                            prefix: prefix,
                            label: label,
                            ariaLabel: localize('helpPickAriaLabel', "{0}, {1}", label, helpEntry.description),
                            description: helpEntry.description
                        });
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return { editorProviders: editorProviders, globalProviders: globalProviders };
    };
    HelpQuickAccessProvider.PREFIX = '?';
    HelpQuickAccessProvider = __decorate([
        __param(0, IQuickInputService)
    ], HelpQuickAccessProvider);
    return HelpQuickAccessProvider;
}());
export { HelpQuickAccessProvider };
