/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { localize } from '../../../nls';
import { PickerQuickAccessProvider } from './pickerQuickAccess';
import { Disposable } from '../../../base/common/lifecycle';
import { or, matchesPrefix, matchesWords, matchesContiguousSubString } from '../../../base/common/filters';
import { withNullAsUndefined } from '../../../base/common/types';
import { LRUCache } from '../../../base/common/map';
import { IStorageService } from '../../storage/common/storage';
import { IConfigurationService } from '../../configuration/common/configuration';
import { IInstantiationService } from '../../instantiation/common/instantiation';
import { IKeybindingService } from '../../keybinding/common/keybinding';
import { ICommandService } from '../../commands/common/commands';
import { ITelemetryService } from '../../telemetry/common/telemetry';
import { isPromiseCanceledError } from '../../../base/common/errors';
import { INotificationService } from '../../notification/common/notification';
import { toErrorMessage } from '../../../base/common/errorMessage';
var AbstractCommandsQuickAccessProvider = /** @class */ (function (_super) {
    __extends(AbstractCommandsQuickAccessProvider, _super);
    function AbstractCommandsQuickAccessProvider(options, instantiationService, keybindingService, commandService, telemetryService, notificationService) {
        var _this = _super.call(this, AbstractCommandsQuickAccessProvider.PREFIX, options) || this;
        _this.options = options;
        _this.instantiationService = instantiationService;
        _this.keybindingService = keybindingService;
        _this.commandService = commandService;
        _this.telemetryService = telemetryService;
        _this.notificationService = notificationService;
        _this.commandsHistory = _this._register(_this.instantiationService.createInstance(CommandsHistory));
        return _this;
    }
    AbstractCommandsQuickAccessProvider.prototype.getPicks = function (filter, disposables, token) {
        return __awaiter(this, void 0, void 0, function () {
            var allCommandPicks, filteredCommandPicks, allCommandPicks_1, allCommandPicks_1_1, commandPick, labelHighlights, aliasHighlights, mapLabelToCommand, filteredCommandPicks_1, filteredCommandPicks_1_1, commandPick, existingCommandForLabel, commandPicks, addSeparator, _loop_1, this_1, i;
            var e_1, _a, e_2, _b;
            var _this = this;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0: return [4 /*yield*/, this.getCommandPicks(disposables, token)];
                    case 1:
                        allCommandPicks = _c.sent();
                        if (token.isCancellationRequested) {
                            return [2 /*return*/, []];
                        }
                        filteredCommandPicks = [];
                        try {
                            for (allCommandPicks_1 = __values(allCommandPicks), allCommandPicks_1_1 = allCommandPicks_1.next(); !allCommandPicks_1_1.done; allCommandPicks_1_1 = allCommandPicks_1.next()) {
                                commandPick = allCommandPicks_1_1.value;
                                labelHighlights = withNullAsUndefined(AbstractCommandsQuickAccessProvider.WORD_FILTER(filter, commandPick.label));
                                aliasHighlights = commandPick.commandAlias ? withNullAsUndefined(AbstractCommandsQuickAccessProvider.WORD_FILTER(filter, commandPick.commandAlias)) : undefined;
                                // Add if matching in label or alias
                                if (labelHighlights || aliasHighlights) {
                                    commandPick.highlights = {
                                        label: labelHighlights,
                                        detail: this.options.showAlias ? aliasHighlights : undefined
                                    };
                                    filteredCommandPicks.push(commandPick);
                                }
                                // Also add if we have a 100% command ID match
                                else if (filter === commandPick.commandId) {
                                    filteredCommandPicks.push(commandPick);
                                }
                            }
                        }
                        catch (e_1_1) { e_1 = { error: e_1_1 }; }
                        finally {
                            try {
                                if (allCommandPicks_1_1 && !allCommandPicks_1_1.done && (_a = allCommandPicks_1.return)) _a.call(allCommandPicks_1);
                            }
                            finally { if (e_1) throw e_1.error; }
                        }
                        mapLabelToCommand = new Map();
                        try {
                            for (filteredCommandPicks_1 = __values(filteredCommandPicks), filteredCommandPicks_1_1 = filteredCommandPicks_1.next(); !filteredCommandPicks_1_1.done; filteredCommandPicks_1_1 = filteredCommandPicks_1.next()) {
                                commandPick = filteredCommandPicks_1_1.value;
                                existingCommandForLabel = mapLabelToCommand.get(commandPick.label);
                                if (existingCommandForLabel) {
                                    commandPick.description = commandPick.commandId;
                                    existingCommandForLabel.description = existingCommandForLabel.commandId;
                                }
                                else {
                                    mapLabelToCommand.set(commandPick.label, commandPick);
                                }
                            }
                        }
                        catch (e_2_1) { e_2 = { error: e_2_1 }; }
                        finally {
                            try {
                                if (filteredCommandPicks_1_1 && !filteredCommandPicks_1_1.done && (_b = filteredCommandPicks_1.return)) _b.call(filteredCommandPicks_1);
                            }
                            finally { if (e_2) throw e_2.error; }
                        }
                        // Sort by MRU order and fallback to name otherwise
                        filteredCommandPicks.sort(function (commandPickA, commandPickB) {
                            var commandACounter = _this.commandsHistory.peek(commandPickA.commandId);
                            var commandBCounter = _this.commandsHistory.peek(commandPickB.commandId);
                            if (commandACounter && commandBCounter) {
                                return commandACounter > commandBCounter ? -1 : 1; // use more recently used command before older
                            }
                            if (commandACounter) {
                                return -1; // first command was used, so it wins over the non used one
                            }
                            if (commandBCounter) {
                                return 1; // other command was used so it wins over the command
                            }
                            // both commands were never used, so we sort by name
                            return commandPickA.label.localeCompare(commandPickB.label);
                        });
                        commandPicks = [];
                        addSeparator = false;
                        _loop_1 = function (i) {
                            var commandPick = filteredCommandPicks[i];
                            var keybinding = this_1.keybindingService.lookupKeybinding(commandPick.commandId);
                            var ariaLabel = keybinding ?
                                localize('commandPickAriaLabelWithKeybinding', "{0}, {1}", commandPick.label, keybinding.getAriaLabel()) :
                                commandPick.label;
                            // Separator: recently used
                            if (i === 0 && this_1.commandsHistory.peek(commandPick.commandId)) {
                                commandPicks.push({ type: 'separator', label: localize('recentlyUsed', "recently used") });
                                addSeparator = true;
                            }
                            // Separator: other commands
                            if (i !== 0 && addSeparator && !this_1.commandsHistory.peek(commandPick.commandId)) {
                                commandPicks.push({ type: 'separator', label: localize('morecCommands', "other commands") });
                                addSeparator = false; // only once
                            }
                            // Command
                            commandPicks.push(__assign(__assign({}, commandPick), { ariaLabel: ariaLabel, detail: this_1.options.showAlias && commandPick.commandAlias !== commandPick.label ? commandPick.commandAlias : undefined, keybinding: keybinding, accept: function () { return __awaiter(_this, void 0, void 0, function () {
                                    var error_1;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                // Add to history
                                                this.commandsHistory.push(commandPick.commandId);
                                                // Telementry
                                                this.telemetryService.publicLog2('workbenchActionExecuted', {
                                                    id: commandPick.commandId,
                                                    from: 'quick open'
                                                });
                                                _a.label = 1;
                                            case 1:
                                                _a.trys.push([1, 3, , 4]);
                                                return [4 /*yield*/, this.commandService.executeCommand(commandPick.commandId)];
                                            case 2:
                                                _a.sent();
                                                return [3 /*break*/, 4];
                                            case 3:
                                                error_1 = _a.sent();
                                                if (!isPromiseCanceledError(error_1)) {
                                                    this.notificationService.error(localize('canNotRun', "Command '{0}' resulted in an error ({1})", commandPick.label, toErrorMessage(error_1)));
                                                }
                                                return [3 /*break*/, 4];
                                            case 4: return [2 /*return*/];
                                        }
                                    });
                                }); } }));
                        };
                        this_1 = this;
                        for (i = 0; i < filteredCommandPicks.length; i++) {
                            _loop_1(i);
                        }
                        return [2 /*return*/, commandPicks];
                }
            });
        });
    };
    AbstractCommandsQuickAccessProvider.PREFIX = '>';
    AbstractCommandsQuickAccessProvider.WORD_FILTER = or(matchesPrefix, matchesWords, matchesContiguousSubString);
    AbstractCommandsQuickAccessProvider = __decorate([
        __param(1, IInstantiationService),
        __param(2, IKeybindingService),
        __param(3, ICommandService),
        __param(4, ITelemetryService),
        __param(5, INotificationService)
    ], AbstractCommandsQuickAccessProvider);
    return AbstractCommandsQuickAccessProvider;
}(PickerQuickAccessProvider));
export { AbstractCommandsQuickAccessProvider };
var CommandsHistory = /** @class */ (function (_super) {
    __extends(CommandsHistory, _super);
    function CommandsHistory(storageService, configurationService) {
        var _this = _super.call(this) || this;
        _this.storageService = storageService;
        _this.configurationService = configurationService;
        _this.configuredCommandsHistoryLength = 0;
        _this.updateConfiguration();
        _this.load();
        _this.registerListeners();
        return _this;
    }
    CommandsHistory.prototype.registerListeners = function () {
        var _this = this;
        this._register(this.configurationService.onDidChangeConfiguration(function () { return _this.updateConfiguration(); }));
    };
    CommandsHistory.prototype.updateConfiguration = function () {
        this.configuredCommandsHistoryLength = CommandsHistory.getConfiguredCommandHistoryLength(this.configurationService);
        if (CommandsHistory.cache && CommandsHistory.cache.limit !== this.configuredCommandsHistoryLength) {
            CommandsHistory.cache.limit = this.configuredCommandsHistoryLength;
            CommandsHistory.saveState(this.storageService);
        }
    };
    CommandsHistory.prototype.load = function () {
        var raw = this.storageService.get(CommandsHistory.PREF_KEY_CACHE, 0 /* GLOBAL */);
        var serializedCache;
        if (raw) {
            try {
                serializedCache = JSON.parse(raw);
            }
            catch (error) {
                // invalid data
            }
        }
        var cache = CommandsHistory.cache = new LRUCache(this.configuredCommandsHistoryLength, 1);
        if (serializedCache) {
            var entries = void 0;
            if (serializedCache.usesLRU) {
                entries = serializedCache.entries;
            }
            else {
                entries = serializedCache.entries.sort(function (a, b) { return a.value - b.value; });
            }
            entries.forEach(function (entry) { return cache.set(entry.key, entry.value); });
        }
        CommandsHistory.counter = this.storageService.getNumber(CommandsHistory.PREF_KEY_COUNTER, 0 /* GLOBAL */, CommandsHistory.counter);
    };
    CommandsHistory.prototype.push = function (commandId) {
        if (!CommandsHistory.cache) {
            return;
        }
        CommandsHistory.cache.set(commandId, CommandsHistory.counter++); // set counter to command
        CommandsHistory.saveState(this.storageService);
    };
    CommandsHistory.prototype.peek = function (commandId) {
        var _a;
        return (_a = CommandsHistory.cache) === null || _a === void 0 ? void 0 : _a.peek(commandId);
    };
    CommandsHistory.saveState = function (storageService) {
        if (!CommandsHistory.cache) {
            return;
        }
        var serializedCache = { usesLRU: true, entries: [] };
        CommandsHistory.cache.forEach(function (value, key) { return serializedCache.entries.push({ key: key, value: value }); });
        storageService.store(CommandsHistory.PREF_KEY_CACHE, JSON.stringify(serializedCache), 0 /* GLOBAL */, 0 /* USER */);
        storageService.store(CommandsHistory.PREF_KEY_COUNTER, CommandsHistory.counter, 0 /* GLOBAL */, 0 /* USER */);
    };
    CommandsHistory.getConfiguredCommandHistoryLength = function (configurationService) {
        var _a, _b;
        var config = configurationService.getValue();
        var configuredCommandHistoryLength = (_b = (_a = config.workbench) === null || _a === void 0 ? void 0 : _a.commandPalette) === null || _b === void 0 ? void 0 : _b.history;
        if (typeof configuredCommandHistoryLength === 'number') {
            return configuredCommandHistoryLength;
        }
        return CommandsHistory.DEFAULT_COMMANDS_HISTORY_LENGTH;
    };
    CommandsHistory.clearHistory = function (configurationService, storageService) {
        var commandHistoryLength = CommandsHistory.getConfiguredCommandHistoryLength(configurationService);
        CommandsHistory.cache = new LRUCache(commandHistoryLength);
        CommandsHistory.counter = 1;
        CommandsHistory.saveState(storageService);
    };
    CommandsHistory.DEFAULT_COMMANDS_HISTORY_LENGTH = 50;
    CommandsHistory.PREF_KEY_CACHE = 'commandPalette.mru.cache';
    CommandsHistory.PREF_KEY_COUNTER = 'commandPalette.mru.counter';
    CommandsHistory.counter = 1;
    CommandsHistory = __decorate([
        __param(0, IStorageService),
        __param(1, IConfigurationService)
    ], CommandsHistory);
    return CommandsHistory;
}(Disposable));
export { CommandsHistory };
