/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import * as nls from '../../../nls';
import { Disposable } from '../../../base/common/lifecycle';
import { registerEditorContribution } from '../../browser/editorExtensions';
import { ICodeEditorService } from '../../browser/services/codeEditorService';
import { IDialogService } from '../../../platform/dialogs/common/dialogs';
var ignoreUnusualLineTerminators = 'ignoreUnusualLineTerminators';
function writeIgnoreState(codeEditorService, model, state) {
    codeEditorService.setModelProperty(model.uri, ignoreUnusualLineTerminators, state);
}
function readIgnoreState(codeEditorService, model) {
    return codeEditorService.getModelProperty(model.uri, ignoreUnusualLineTerminators);
}
var UnusualLineTerminatorsDetector = /** @class */ (function (_super) {
    __extends(UnusualLineTerminatorsDetector, _super);
    function UnusualLineTerminatorsDetector(_editor, _dialogService, _codeEditorService) {
        var _this = _super.call(this) || this;
        _this._editor = _editor;
        _this._dialogService = _dialogService;
        _this._codeEditorService = _codeEditorService;
        _this._config = _this._editor.getOption(108 /* unusualLineTerminators */);
        _this._register(_this._editor.onDidChangeConfiguration(function (e) {
            if (e.hasChanged(108 /* unusualLineTerminators */)) {
                _this._config = _this._editor.getOption(108 /* unusualLineTerminators */);
                _this._checkForUnusualLineTerminators();
            }
        }));
        _this._register(_this._editor.onDidChangeModel(function () {
            _this._checkForUnusualLineTerminators();
        }));
        _this._register(_this._editor.onDidChangeModelContent(function (e) {
            if (e.isUndoing) {
                // skip checking in case of undoing
                return;
            }
            _this._checkForUnusualLineTerminators();
        }));
        return _this;
    }
    UnusualLineTerminatorsDetector.prototype._checkForUnusualLineTerminators = function () {
        return __awaiter(this, void 0, void 0, function () {
            var model, ignoreState, result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (this._config === 'off') {
                            return [2 /*return*/];
                        }
                        if (!this._editor.hasModel()) {
                            return [2 /*return*/];
                        }
                        model = this._editor.getModel();
                        if (!model.mightContainUnusualLineTerminators()) {
                            return [2 /*return*/];
                        }
                        ignoreState = readIgnoreState(this._codeEditorService, model);
                        if (ignoreState === true) {
                            // this model should be ignored
                            return [2 /*return*/];
                        }
                        if (this._editor.getOption(75 /* readOnly */)) {
                            // read only editor => sorry!
                            return [2 /*return*/];
                        }
                        if (this._config === 'auto') {
                            // just do it!
                            model.removeUnusualLineTerminators(this._editor.getSelections());
                            return [2 /*return*/];
                        }
                        return [4 /*yield*/, this._dialogService.confirm({
                                title: nls.localize('unusualLineTerminators.title', "Unusual Line Terminators"),
                                message: nls.localize('unusualLineTerminators.message', "Detected unusual line terminators"),
                                detail: nls.localize('unusualLineTerminators.detail', "This file contains one or more unusual line terminator characters, like Line Separator (LS) or Paragraph Separator (PS).\n\nIt is recommended to remove them from the file. This can be configured via `editor.unusualLineTerminators`."),
                                primaryButton: nls.localize('unusualLineTerminators.fix', "Fix this file"),
                                secondaryButton: nls.localize('unusualLineTerminators.ignore', "Ignore problem for this file")
                            })];
                    case 1:
                        result = _a.sent();
                        if (!result.confirmed) {
                            // this model should be ignored
                            writeIgnoreState(this._codeEditorService, model, true);
                            return [2 /*return*/];
                        }
                        model.removeUnusualLineTerminators(this._editor.getSelections());
                        return [2 /*return*/];
                }
            });
        });
    };
    UnusualLineTerminatorsDetector.ID = 'editor.contrib.unusualLineTerminatorsDetector';
    UnusualLineTerminatorsDetector = __decorate([
        __param(1, IDialogService),
        __param(2, ICodeEditorService)
    ], UnusualLineTerminatorsDetector);
    return UnusualLineTerminatorsDetector;
}(Disposable));
registerEditorContribution(UnusualLineTerminatorsDetector.ID, UnusualLineTerminatorsDetector);
