/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import * as nls from '../../../nls';
import { DisposableStore } from '../../../base/common/lifecycle';
import * as dom from '../../../base/browser/dom';
import { DomScrollableElement } from '../../../base/browser/ui/scrollbar/scrollableElement';
import { MarkdownRenderer } from '../../browser/core/markdownRenderer';
import { MarkdownString } from '../../../base/common/htmlContent';
import { Codicon } from '../../../base/common/codicons';
import { Emitter } from '../../../base/common/event';
import { ResizableHTMLElement } from './resizable';
import { IInstantiationService } from '../../../platform/instantiation/common/instantiation';
export function canExpandCompletionItem(item) {
    return !!item && Boolean(item.completion.documentation || item.completion.detail && item.completion.detail !== item.completion.label);
}
var SuggestDetailsWidget = /** @class */ (function () {
    function SuggestDetailsWidget(_editor, instaService) {
        var _this = this;
        this._editor = _editor;
        this._onDidClose = new Emitter();
        this.onDidClose = this._onDidClose.event;
        this._onDidChangeContents = new Emitter();
        this.onDidChangeContents = this._onDidChangeContents.event;
        this._disposables = new DisposableStore();
        this._renderDisposeable = new DisposableStore();
        this._borderWidth = 1;
        this._size = new dom.Dimension(330, 0);
        this.domNode = dom.$('.suggest-details');
        this.domNode.classList.add('no-docs');
        this._markdownRenderer = instaService.createInstance(MarkdownRenderer, { editor: _editor });
        this._body = dom.$('.body');
        this._scrollbar = new DomScrollableElement(this._body, {});
        dom.append(this.domNode, this._scrollbar.getDomNode());
        this._disposables.add(this._scrollbar);
        this._header = dom.append(this._body, dom.$('.header'));
        this._close = dom.append(this._header, dom.$('span' + Codicon.close.cssSelector));
        this._close.title = nls.localize('details.close', "Close");
        this._type = dom.append(this._header, dom.$('p.type'));
        this._docs = dom.append(this._body, dom.$('p.docs'));
        this._configureFont();
        this._disposables.add(this._editor.onDidChangeConfiguration(function (e) {
            if (e.hasChanged(38 /* fontInfo */)) {
                _this._configureFont();
            }
        }));
    }
    SuggestDetailsWidget.prototype.dispose = function () {
        this._disposables.dispose();
        this._renderDisposeable.dispose();
    };
    SuggestDetailsWidget.prototype._configureFont = function () {
        var options = this._editor.getOptions();
        var fontInfo = options.get(38 /* fontInfo */);
        var fontFamily = fontInfo.fontFamily;
        var fontSize = options.get(102 /* suggestFontSize */) || fontInfo.fontSize;
        var lineHeight = options.get(103 /* suggestLineHeight */) || fontInfo.lineHeight;
        var fontWeight = fontInfo.fontWeight;
        var fontSizePx = fontSize + "px";
        var lineHeightPx = lineHeight + "px";
        this.domNode.style.fontSize = fontSizePx;
        this.domNode.style.lineHeight = lineHeightPx;
        this.domNode.style.fontWeight = fontWeight;
        this.domNode.style.fontFeatureSettings = fontInfo.fontFeatureSettings;
        this._type.style.fontFamily = fontFamily;
        this._close.style.height = lineHeightPx;
        this._close.style.width = lineHeightPx;
    };
    SuggestDetailsWidget.prototype.getLayoutInfo = function () {
        var lineHeight = this._editor.getOption(103 /* suggestLineHeight */) || this._editor.getOption(38 /* fontInfo */).lineHeight;
        var borderWidth = this._borderWidth;
        var borderHeight = borderWidth * 2;
        return {
            lineHeight: lineHeight,
            borderWidth: borderWidth,
            borderHeight: borderHeight,
            verticalPadding: 22,
            horizontalPadding: 14
        };
    };
    SuggestDetailsWidget.prototype.renderLoading = function () {
        this._type.textContent = nls.localize('loading', "Loading...");
        this._docs.textContent = '';
        this.domNode.classList.remove('no-docs', 'no-type');
        this.layout(this.size.width, this.getLayoutInfo().lineHeight * 2);
        this._onDidChangeContents.fire(this);
    };
    SuggestDetailsWidget.prototype.renderItem = function (item, explainMode) {
        var _this = this;
        var _a;
        this._renderDisposeable.clear();
        var _b = item.completion, detail = _b.detail, documentation = _b.documentation;
        if (explainMode) {
            var md = '';
            md += "score: " + item.score[0] + (item.word ? ", compared '" + (item.completion.filterText && (item.completion.filterText + ' (filterText)') || typeof item.completion.label === 'string' ? item.completion.label : item.completion.label.name) + "' with '" + item.word + "'" : ' (no prefix)') + "\n";
            md += "distance: " + item.distance + ", see localityBonus-setting\n";
            md += "index: " + item.idx + ", based on " + (item.completion.sortText && "sortText: \"" + item.completion.sortText + "\"" || 'label') + "\n";
            md += "commit characters: " + ((_a = item.completion.commitCharacters) === null || _a === void 0 ? void 0 : _a.join('')) + "\n";
            documentation = new MarkdownString().appendCodeblock('empty', md);
            detail = "Provider: " + item.provider._debugDisplayName;
        }
        if (!explainMode && !canExpandCompletionItem(item)) {
            this.clearContents();
            return;
        }
        this.domNode.classList.remove('no-docs', 'no-type');
        // --- details
        if (detail) {
            var cappedDetail = detail.length > 100000 ? detail.substr(0, 100000) + "\u2026" : detail;
            this._type.textContent = cappedDetail;
            this._type.title = cappedDetail;
            dom.show(this._type);
            this._type.classList.toggle('auto-wrap', !/\r?\n^\s+/gmi.test(cappedDetail));
        }
        else {
            dom.clearNode(this._type);
            this._type.title = '';
            dom.hide(this._type);
            this.domNode.classList.add('no-type');
        }
        // --- documentation
        dom.clearNode(this._docs);
        if (typeof documentation === 'string') {
            this._docs.classList.remove('markdown-docs');
            this._docs.textContent = documentation;
        }
        else if (documentation) {
            this._docs.classList.add('markdown-docs');
            dom.clearNode(this._docs);
            var renderedContents = this._markdownRenderer.render(documentation);
            this._docs.appendChild(renderedContents.element);
            this._renderDisposeable.add(renderedContents);
            this._renderDisposeable.add(this._markdownRenderer.onDidRenderAsync(function () {
                _this.layout(_this._size.width, _this._type.clientHeight + _this._docs.clientHeight);
                _this._onDidChangeContents.fire(_this);
            }));
        }
        this.domNode.style.userSelect = 'text';
        this.domNode.tabIndex = -1;
        this._close.onmousedown = function (e) {
            e.preventDefault();
            e.stopPropagation();
        };
        this._close.onclick = function (e) {
            e.preventDefault();
            e.stopPropagation();
            _this._onDidClose.fire();
        };
        this._body.scrollTop = 0;
        this.layout(this._size.width, this._type.clientHeight + this._docs.clientHeight);
        this._onDidChangeContents.fire(this);
    };
    SuggestDetailsWidget.prototype.clearContents = function () {
        this.domNode.classList.add('no-docs');
        this._type.textContent = '';
        this._docs.textContent = '';
    };
    Object.defineProperty(SuggestDetailsWidget.prototype, "size", {
        get: function () {
            return this._size;
        },
        enumerable: false,
        configurable: true
    });
    SuggestDetailsWidget.prototype.layout = function (width, height) {
        var newSize = new dom.Dimension(width, height);
        if (!dom.Dimension.equals(newSize, this._size)) {
            this._size = newSize;
            dom.size(this.domNode, width, height);
        }
        this._scrollbar.scanDomNode();
    };
    SuggestDetailsWidget.prototype.scrollDown = function (much) {
        if (much === void 0) { much = 8; }
        this._body.scrollTop += much;
    };
    SuggestDetailsWidget.prototype.scrollUp = function (much) {
        if (much === void 0) { much = 8; }
        this._body.scrollTop -= much;
    };
    SuggestDetailsWidget.prototype.scrollTop = function () {
        this._body.scrollTop = 0;
    };
    SuggestDetailsWidget.prototype.scrollBottom = function () {
        this._body.scrollTop = this._body.scrollHeight;
    };
    SuggestDetailsWidget.prototype.pageDown = function () {
        this.scrollDown(80);
    };
    SuggestDetailsWidget.prototype.pageUp = function () {
        this.scrollUp(80);
    };
    Object.defineProperty(SuggestDetailsWidget.prototype, "borderWidth", {
        get: function () {
            return this._borderWidth;
        },
        set: function (width) {
            this._borderWidth = width;
        },
        enumerable: false,
        configurable: true
    });
    SuggestDetailsWidget = __decorate([
        __param(1, IInstantiationService)
    ], SuggestDetailsWidget);
    return SuggestDetailsWidget;
}());
export { SuggestDetailsWidget };
var SuggestDetailsOverlay = /** @class */ (function () {
    function SuggestDetailsOverlay(widget, _editor) {
        var _this = this;
        this.widget = widget;
        this._editor = _editor;
        this._disposables = new DisposableStore();
        this._added = false;
        this._resizable = new ResizableHTMLElement();
        this._resizable.domNode.classList.add('suggest-details-container');
        this._resizable.domNode.appendChild(widget.domNode);
        this._resizable.enableSashes(false, true, true, false);
        var topLeftNow;
        var sizeNow;
        var deltaTop = 0;
        var deltaLeft = 0;
        this._disposables.add(this._resizable.onDidWillResize(function () {
            topLeftNow = _this._topLeft;
            sizeNow = _this._resizable.size;
        }));
        this._disposables.add(this._resizable.onDidResize(function (e) {
            if (topLeftNow && sizeNow) {
                _this.widget.layout(e.dimension.width, e.dimension.height);
                var updateTopLeft = false;
                if (e.west) {
                    deltaLeft = sizeNow.width - e.dimension.width;
                    updateTopLeft = true;
                }
                if (e.north) {
                    deltaTop = sizeNow.height - e.dimension.height;
                    updateTopLeft = true;
                }
                if (updateTopLeft) {
                    _this._applyTopLeft({
                        top: topLeftNow.top + deltaTop,
                        left: topLeftNow.left + deltaLeft,
                    });
                }
            }
            if (e.done) {
                topLeftNow = undefined;
                sizeNow = undefined;
                deltaTop = 0;
                deltaLeft = 0;
                _this._userSize = e.dimension;
            }
        }));
        this._disposables.add(this.widget.onDidChangeContents(function () {
            var _a;
            if (_this._anchorBox) {
                _this._placeAtAnchor(_this._anchorBox, (_a = _this._userSize) !== null && _a !== void 0 ? _a : _this.widget.size);
            }
        }));
    }
    SuggestDetailsOverlay.prototype.dispose = function () {
        this._disposables.dispose();
        this.hide();
    };
    SuggestDetailsOverlay.prototype.getId = function () {
        return 'suggest.details';
    };
    SuggestDetailsOverlay.prototype.getDomNode = function () {
        return this._resizable.domNode;
    };
    SuggestDetailsOverlay.prototype.getPosition = function () {
        return null;
    };
    SuggestDetailsOverlay.prototype.show = function () {
        if (!this._added) {
            this._editor.addOverlayWidget(this);
            this.getDomNode().style.position = 'fixed';
            this._added = true;
        }
    };
    SuggestDetailsOverlay.prototype.hide = function (sessionEnded) {
        if (sessionEnded === void 0) { sessionEnded = false; }
        if (this._added) {
            this._editor.removeOverlayWidget(this);
            this._added = false;
            this._anchorBox = undefined;
            this._topLeft = undefined;
        }
        if (sessionEnded) {
            this._userSize = undefined;
            this.widget.clearContents();
        }
    };
    SuggestDetailsOverlay.prototype.placeAtAnchor = function (anchor) {
        var _a;
        var anchorBox = dom.getDomNodePagePosition(anchor);
        this._anchorBox = anchorBox;
        this._placeAtAnchor(this._anchorBox, (_a = this._userSize) !== null && _a !== void 0 ? _a : this.widget.size);
    };
    SuggestDetailsOverlay.prototype._placeAtAnchor = function (anchorBox, size) {
        var bodyBox = dom.getClientArea(document.body);
        var info = this.widget.getLayoutInfo();
        var maxSizeTop;
        var maxSizeBottom;
        var minSize = new dom.Dimension(220, 2 * info.lineHeight);
        var left = 0;
        var top = anchorBox.top;
        var bottom = anchorBox.top + anchorBox.height - info.borderHeight;
        var alignAtTop;
        var alignEast;
        // position: EAST, west, south
        var width = bodyBox.width - (anchorBox.left + anchorBox.width + info.borderWidth + info.horizontalPadding);
        left = -info.borderWidth + anchorBox.left + anchorBox.width;
        alignEast = true;
        maxSizeTop = new dom.Dimension(width, bodyBox.height - anchorBox.top - info.borderHeight - info.verticalPadding);
        maxSizeBottom = maxSizeTop.with(undefined, anchorBox.top + anchorBox.height - info.borderHeight - info.verticalPadding);
        // find a better place if the widget is wider than there is space available
        if (size.width > width) {
            // position: east, WEST, south
            if (anchorBox.left > width) {
                // pos = SuggestDetailsPosition.West;
                width = anchorBox.left - info.borderWidth - info.horizontalPadding;
                alignEast = false;
                left = Math.max(info.horizontalPadding, anchorBox.left - size.width - info.borderWidth);
                maxSizeTop = maxSizeTop.with(width);
                maxSizeBottom = maxSizeTop.with(undefined, maxSizeBottom.height);
            }
            // position: east, west, SOUTH
            if (anchorBox.width > width * 1.3 && bodyBox.height - (anchorBox.top + anchorBox.height) > anchorBox.height) {
                width = anchorBox.width;
                left = anchorBox.left;
                top = -info.borderWidth + anchorBox.top + anchorBox.height;
                maxSizeTop = new dom.Dimension(anchorBox.width - info.borderHeight, bodyBox.height - anchorBox.top - anchorBox.height - info.verticalPadding);
                maxSizeBottom = maxSizeTop.with(undefined, anchorBox.top - info.verticalPadding);
                minSize = minSize.with(maxSizeTop.width);
            }
        }
        // top/bottom placement
        var height = size.height;
        var maxHeight = Math.max(maxSizeTop.height, maxSizeBottom.height);
        if (height > maxHeight) {
            height = maxHeight;
        }
        var maxSize;
        if (height <= maxSizeTop.height) {
            alignAtTop = true;
            maxSize = maxSizeTop;
        }
        else {
            alignAtTop = false;
            maxSize = maxSizeBottom;
        }
        this._applyTopLeft({ left: left, top: alignAtTop ? top : bottom - height });
        this.getDomNode().style.position = 'fixed';
        this._resizable.enableSashes(!alignAtTop, alignEast, alignAtTop, !alignEast);
        this._resizable.minSize = minSize;
        this._resizable.maxSize = maxSize;
        this._resizable.layout(height, Math.min(maxSize.width, size.width));
        this.widget.layout(this._resizable.size.width, this._resizable.size.height);
    };
    SuggestDetailsOverlay.prototype._applyTopLeft = function (topLeft) {
        this._topLeft = topLeft;
        this.getDomNode().style.left = this._topLeft.left + "px";
        this.getDomNode().style.top = this._topLeft.top + "px";
    };
    return SuggestDetailsOverlay;
}());
export { SuggestDetailsOverlay };
