/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { alert } from '../../../base/browser/ui/aria/aria';
import { isNonEmptyArray } from '../../../base/common/arrays';
import { onUnexpectedError } from '../../../base/common/errors';
import { SimpleKeybinding } from '../../../base/common/keyCodes';
import { dispose, DisposableStore, toDisposable, MutableDisposable } from '../../../base/common/lifecycle';
import { StableEditorScrollState } from '../../browser/core/editorState';
import { EditorAction, EditorCommand, registerEditorAction, registerEditorCommand, registerEditorContribution } from '../../browser/editorExtensions';
import { EditOperation } from '../../common/core/editOperation';
import { Range } from '../../common/core/range';
import { EditorContextKeys } from '../../common/editorContextKeys';
import { SnippetController2 } from '../snippet/snippetController2';
import { SnippetParser } from '../snippet/snippetParser';
import { ISuggestMemoryService } from './suggestMemory';
import * as nls from '../../../nls';
import { ICommandService, CommandsRegistry } from '../../../platform/commands/common/commands';
import { ContextKeyExpr, IContextKeyService } from '../../../platform/contextkey/common/contextkey';
import { IInstantiationService } from '../../../platform/instantiation/common/instantiation';
import { KeybindingsRegistry } from '../../../platform/keybinding/common/keybindingsRegistry';
import { Context as SuggestContext, suggestWidgetStatusbarMenu } from './suggest';
import { SuggestAlternatives } from './suggestAlternatives';
import { SuggestModel } from './suggestModel';
import { SuggestWidget } from './suggestWidget';
import { WordContextKey } from './wordContextKey';
import { Event } from '../../../base/common/event';
import { IdleValue } from '../../../base/common/async';
import { isObject, assertType } from '../../../base/common/types';
import { CommitCharacterController } from './suggestCommitCharacters';
import { OvertypingCapturer } from './suggestOvertypingCapturer';
import { Position } from '../../common/core/position';
import * as platform from '../../../base/common/platform';
import { MenuRegistry } from '../../../platform/actions/common/actions';
import { CancellationTokenSource } from '../../../base/common/cancellation';
import { ILogService } from '../../../platform/log/common/log';
import { StopWatch } from '../../../base/common/stopwatch';
// sticky suggest widget which doesn't disappear on focus out and such
var _sticky = false;
// _sticky = Boolean("true"); // done "weirdly" so that a lint warning prevents you from pushing this
var LineSuffix = /** @class */ (function () {
    function LineSuffix(_model, _position) {
        this._model = _model;
        this._position = _position;
        // spy on what's happening right of the cursor. two cases:
        // 1. end of line -> check that it's still end of line
        // 2. mid of line -> add a marker and compute the delta
        var maxColumn = _model.getLineMaxColumn(_position.lineNumber);
        if (maxColumn !== _position.column) {
            var offset = _model.getOffsetAt(_position);
            var end = _model.getPositionAt(offset + 1);
            this._marker = _model.deltaDecorations([], [{
                    range: Range.fromPositions(_position, end),
                    options: { stickiness: 1 /* NeverGrowsWhenTypingAtEdges */ }
                }]);
        }
    }
    LineSuffix.prototype.dispose = function () {
        if (this._marker && !this._model.isDisposed()) {
            this._model.deltaDecorations(this._marker, []);
        }
    };
    LineSuffix.prototype.delta = function (position) {
        if (this._model.isDisposed() || this._position.lineNumber !== position.lineNumber) {
            // bail out early if things seems fishy
            return 0;
        }
        // read the marker (in case suggest was triggered at line end) or compare
        // the cursor to the line end.
        if (this._marker) {
            var range = this._model.getDecorationRange(this._marker[0]);
            var end = this._model.getOffsetAt(range.getStartPosition());
            return end - this._model.getOffsetAt(position);
        }
        else {
            return this._model.getLineMaxColumn(position.lineNumber) - position.column;
        }
    };
    return LineSuffix;
}());
var SuggestController = /** @class */ (function () {
    function SuggestController(editor, _memoryService, _commandService, _contextKeyService, _instantiationService, _logService) {
        var _this = this;
        this._memoryService = _memoryService;
        this._commandService = _commandService;
        this._contextKeyService = _contextKeyService;
        this._instantiationService = _instantiationService;
        this._logService = _logService;
        this._lineSuffix = new MutableDisposable();
        this._toDispose = new DisposableStore();
        this.editor = editor;
        this.model = _instantiationService.createInstance(SuggestModel, this.editor);
        // context key: update insert/replace mode
        var ctxInsertMode = SuggestContext.InsertMode.bindTo(_contextKeyService);
        ctxInsertMode.set(editor.getOption(101 /* suggest */).insertMode);
        this.model.onDidTrigger(function () { return ctxInsertMode.set(editor.getOption(101 /* suggest */).insertMode); });
        this.widget = this._toDispose.add(new IdleValue(function () {
            var widget = _this._instantiationService.createInstance(SuggestWidget, _this.editor);
            _this._toDispose.add(widget);
            _this._toDispose.add(widget.onDidSelect(function (item) { return _this._insertSuggestion(item, 0); }, _this));
            // Wire up logic to accept a suggestion on certain characters
            var commitCharacterController = new CommitCharacterController(_this.editor, widget, function (item) { return _this._insertSuggestion(item, 2 /* NoAfterUndoStop */); });
            _this._toDispose.add(commitCharacterController);
            _this._toDispose.add(_this.model.onDidSuggest(function (e) {
                if (e.completionModel.items.length === 0) {
                    commitCharacterController.reset();
                }
            }));
            // Wire up makes text edit context key
            var ctxMakesTextEdit = SuggestContext.MakesTextEdit.bindTo(_this._contextKeyService);
            var ctxHasInsertAndReplace = SuggestContext.HasInsertAndReplaceRange.bindTo(_this._contextKeyService);
            var ctxCanResolve = SuggestContext.CanResolve.bindTo(_this._contextKeyService);
            _this._toDispose.add(toDisposable(function () {
                ctxMakesTextEdit.reset();
                ctxHasInsertAndReplace.reset();
                ctxCanResolve.reset();
            }));
            _this._toDispose.add(widget.onDidFocus(function (_a) {
                var item = _a.item;
                // (ctx: makesTextEdit)
                var position = _this.editor.getPosition();
                var startColumn = item.editStart.column;
                var endColumn = position.column;
                var value = true;
                if (_this.editor.getOption(1 /* acceptSuggestionOnEnter */) === 'smart'
                    && _this.model.state === 2 /* Auto */
                    && !item.completion.command
                    && !item.completion.additionalTextEdits
                    && !(item.completion.insertTextRules & 4 /* InsertAsSnippet */)
                    && endColumn - startColumn === item.completion.insertText.length) {
                    var oldText = _this.editor.getModel().getValueInRange({
                        startLineNumber: position.lineNumber,
                        startColumn: startColumn,
                        endLineNumber: position.lineNumber,
                        endColumn: endColumn
                    });
                    value = oldText !== item.completion.insertText;
                }
                ctxMakesTextEdit.set(value);
                // (ctx: hasInsertAndReplaceRange)
                ctxHasInsertAndReplace.set(!Position.equals(item.editInsertEnd, item.editReplaceEnd));
                // (ctx: canResolve)
                ctxCanResolve.set(Boolean(item.provider.resolveCompletionItem) || Boolean(item.completion.documentation) || item.completion.detail !== item.completion.label);
            }));
            _this._toDispose.add(widget.onDetailsKeyDown(function (e) {
                // cmd + c on macOS, ctrl + c on Win / Linux
                if (e.toKeybinding().equals(new SimpleKeybinding(true, false, false, false, 33 /* KEY_C */)) ||
                    (platform.isMacintosh && e.toKeybinding().equals(new SimpleKeybinding(false, false, false, true, 33 /* KEY_C */)))) {
                    e.stopPropagation();
                    return;
                }
                if (!e.toKeybinding().isModifierKey()) {
                    _this.editor.focus();
                }
            }));
            return widget;
        }));
        // Wire up text overtyping capture
        this._overtypingCapturer = this._toDispose.add(new IdleValue(function () {
            return _this._toDispose.add(new OvertypingCapturer(_this.editor, _this.model));
        }));
        this._alternatives = this._toDispose.add(new IdleValue(function () {
            return _this._toDispose.add(new SuggestAlternatives(_this.editor, _this._contextKeyService));
        }));
        this._toDispose.add(_instantiationService.createInstance(WordContextKey, editor));
        this._toDispose.add(this.model.onDidTrigger(function (e) {
            _this.widget.value.showTriggered(e.auto, e.shy ? 250 : 50);
            _this._lineSuffix.value = new LineSuffix(_this.editor.getModel(), e.position);
        }));
        this._toDispose.add(this.model.onDidSuggest(function (e) {
            if (!e.shy) {
                var index = _this._memoryService.select(_this.editor.getModel(), _this.editor.getPosition(), e.completionModel.items);
                _this.widget.value.showSuggestions(e.completionModel, index, e.isFrozen, e.auto);
            }
        }));
        this._toDispose.add(this.model.onDidCancel(function (e) {
            if (!e.retrigger) {
                _this.widget.value.hideWidget();
            }
        }));
        this._toDispose.add(this.editor.onDidBlurEditorWidget(function () {
            if (!_sticky) {
                _this.model.cancel();
                _this.model.clear();
            }
        }));
        // Manage the acceptSuggestionsOnEnter context key
        var acceptSuggestionsOnEnter = SuggestContext.AcceptSuggestionsOnEnter.bindTo(_contextKeyService);
        var updateFromConfig = function () {
            var acceptSuggestionOnEnter = _this.editor.getOption(1 /* acceptSuggestionOnEnter */);
            acceptSuggestionsOnEnter.set(acceptSuggestionOnEnter === 'on' || acceptSuggestionOnEnter === 'smart');
        };
        this._toDispose.add(this.editor.onDidChangeConfiguration(function () { return updateFromConfig(); }));
        updateFromConfig();
    }
    SuggestController.get = function (editor) {
        return editor.getContribution(SuggestController.ID);
    };
    SuggestController.prototype.dispose = function () {
        this._alternatives.dispose();
        this._toDispose.dispose();
        this.widget.dispose();
        this.model.dispose();
        this._lineSuffix.dispose();
    };
    SuggestController.prototype._insertSuggestion = function (event, flags) {
        var _a;
        var _this = this;
        if (!event || !event.item) {
            this._alternatives.value.reset();
            this.model.cancel();
            this.model.clear();
            return;
        }
        if (!this.editor.hasModel()) {
            return;
        }
        var model = this.editor.getModel();
        var modelVersionNow = model.getAlternativeVersionId();
        var item = event.item;
        //
        var tasks = [];
        var cts = new CancellationTokenSource();
        // pushing undo stops *before* additional text edits and
        // *after* the main edit
        if (!(flags & 1 /* NoBeforeUndoStop */)) {
            this.editor.pushUndoStop();
        }
        // compute overwrite[Before|After] deltas BEFORE applying extra edits
        var info = this.getOverwriteInfo(item, Boolean(flags & 8 /* AlternativeOverwriteConfig */));
        // keep item in memory
        this._memoryService.memorize(model, this.editor.getPosition(), item);
        if (Array.isArray(item.completion.additionalTextEdits)) {
            // sync additional edits
            var scrollState = StableEditorScrollState.capture(this.editor);
            this.editor.executeEdits('suggestController.additionalTextEdits.sync', item.completion.additionalTextEdits.map(function (edit) { return EditOperation.replace(Range.lift(edit.range), edit.text); }));
            scrollState.restoreRelativeVerticalPositionOfCursor(this.editor);
        }
        else if (!item.isResolved) {
            // async additional edits
            var sw_1 = new StopWatch(true);
            var position_1;
            var docListener_1 = model.onDidChangeContent(function (e) {
                var e_1, _a;
                if (e.isFlush) {
                    cts.cancel();
                    docListener_1.dispose();
                    return;
                }
                try {
                    for (var _b = __values(e.changes), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var change = _c.value;
                        var thisPosition = Range.getEndPosition(change.range);
                        if (!position_1 || Position.isBefore(thisPosition, position_1)) {
                            position_1 = thisPosition;
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            });
            var oldFlags_1 = flags;
            flags |= 2 /* NoAfterUndoStop */;
            var didType_1 = false;
            var typeListener_1 = this.editor.onWillType(function () {
                typeListener_1.dispose();
                didType_1 = true;
                if (!(oldFlags_1 & 2 /* NoAfterUndoStop */)) {
                    _this.editor.pushUndoStop();
                }
            });
            tasks.push(item.resolve(cts.token).then(function () {
                if (!item.completion.additionalTextEdits || cts.token.isCancellationRequested) {
                    return false;
                }
                if (position_1 && item.completion.additionalTextEdits.some(function (edit) { return Position.isBefore(position_1, Range.getStartPosition(edit.range)); })) {
                    return false;
                }
                if (didType_1) {
                    _this.editor.pushUndoStop();
                }
                var scrollState = StableEditorScrollState.capture(_this.editor);
                _this.editor.executeEdits('suggestController.additionalTextEdits.async', item.completion.additionalTextEdits.map(function (edit) { return EditOperation.replace(Range.lift(edit.range), edit.text); }));
                scrollState.restoreRelativeVerticalPositionOfCursor(_this.editor);
                if (didType_1 || !(oldFlags_1 & 2 /* NoAfterUndoStop */)) {
                    _this.editor.pushUndoStop();
                }
                return true;
            }).then(function (applied) {
                _this._logService.trace('[suggest] async resolving of edits DONE (ms, applied?)', sw_1.elapsed(), applied);
                docListener_1.dispose();
                typeListener_1.dispose();
            }));
        }
        var insertText = item.completion.insertText;
        if (!(item.completion.insertTextRules & 4 /* InsertAsSnippet */)) {
            insertText = SnippetParser.escape(insertText);
        }
        SnippetController2.get(this.editor).insert(insertText, {
            overwriteBefore: info.overwriteBefore,
            overwriteAfter: info.overwriteAfter,
            undoStopBefore: false,
            undoStopAfter: false,
            adjustWhitespace: !(item.completion.insertTextRules & 1 /* KeepWhitespace */),
            clipboardText: event.model.clipboardText,
            overtypingCapturer: this._overtypingCapturer.value
        });
        if (!(flags & 2 /* NoAfterUndoStop */)) {
            this.editor.pushUndoStop();
        }
        if (!item.completion.command) {
            // done
            this.model.cancel();
        }
        else if (item.completion.command.id === TriggerSuggestAction.id) {
            // retigger
            this.model.trigger({ auto: true, shy: false }, true);
        }
        else {
            // exec command, done
            tasks.push((_a = this._commandService).executeCommand.apply(_a, __spreadArray([item.completion.command.id], __read((item.completion.command.arguments ? __spreadArray([], __read(item.completion.command.arguments)) : [])))).catch(onUnexpectedError));
            this.model.cancel();
        }
        if (flags & 4 /* KeepAlternativeSuggestions */) {
            this._alternatives.value.set(event, function (next) {
                // cancel resolving of additional edits
                cts.cancel();
                // this is not so pretty. when inserting the 'next'
                // suggestion we undo until we are at the state at
                // which we were before inserting the previous suggestion...
                while (model.canUndo()) {
                    if (modelVersionNow !== model.getAlternativeVersionId()) {
                        model.undo();
                    }
                    _this._insertSuggestion(next, 1 /* NoBeforeUndoStop */ | 2 /* NoAfterUndoStop */ | (flags & 8 /* AlternativeOverwriteConfig */ ? 8 /* AlternativeOverwriteConfig */ : 0));
                    break;
                }
            });
        }
        this._alertCompletionItem(item);
        // clear only now - after all tasks are done
        Promise.all(tasks).finally(function () {
            _this.model.clear();
            cts.dispose();
        });
    };
    SuggestController.prototype.getOverwriteInfo = function (item, toggleMode) {
        assertType(this.editor.hasModel());
        var replace = this.editor.getOption(101 /* suggest */).insertMode === 'replace';
        if (toggleMode) {
            replace = !replace;
        }
        var overwriteBefore = item.position.column - item.editStart.column;
        var overwriteAfter = (replace ? item.editReplaceEnd.column : item.editInsertEnd.column) - item.position.column;
        var columnDelta = this.editor.getPosition().column - item.position.column;
        var suffixDelta = this._lineSuffix.value ? this._lineSuffix.value.delta(this.editor.getPosition()) : 0;
        return {
            overwriteBefore: overwriteBefore + columnDelta,
            overwriteAfter: overwriteAfter + suffixDelta
        };
    };
    SuggestController.prototype._alertCompletionItem = function (_a) {
        var suggestion = _a.completion;
        var textLabel = typeof suggestion.label === 'string' ? suggestion.label : suggestion.label.name;
        if (isNonEmptyArray(suggestion.additionalTextEdits)) {
            var msg = nls.localize('aria.alert.snippet', "Accepting '{0}' made {1} additional edits", textLabel, suggestion.additionalTextEdits.length);
            alert(msg);
        }
    };
    SuggestController.prototype.triggerSuggest = function (onlyFrom) {
        if (this.editor.hasModel()) {
            this.model.trigger({ auto: false, shy: false }, false, onlyFrom);
            this.editor.revealLine(this.editor.getPosition().lineNumber, 0 /* Smooth */);
            this.editor.focus();
        }
    };
    SuggestController.prototype.triggerSuggestAndAcceptBest = function (arg) {
        var _this = this;
        if (!this.editor.hasModel()) {
            return;
        }
        var positionNow = this.editor.getPosition();
        var fallback = function () {
            if (positionNow.equals(_this.editor.getPosition())) {
                _this._commandService.executeCommand(arg.fallback);
            }
        };
        var makesTextEdit = function (item) {
            if (item.completion.insertTextRules & 4 /* InsertAsSnippet */ || item.completion.additionalTextEdits) {
                // snippet, other editor -> makes edit
                return true;
            }
            var position = _this.editor.getPosition();
            var startColumn = item.editStart.column;
            var endColumn = position.column;
            if (endColumn - startColumn !== item.completion.insertText.length) {
                // unequal lengths -> makes edit
                return true;
            }
            var textNow = _this.editor.getModel().getValueInRange({
                startLineNumber: position.lineNumber,
                startColumn: startColumn,
                endLineNumber: position.lineNumber,
                endColumn: endColumn
            });
            // unequal text -> makes edit
            return textNow !== item.completion.insertText;
        };
        Event.once(this.model.onDidTrigger)(function (_) {
            // wait for trigger because only then the cancel-event is trustworthy
            var listener = [];
            Event.any(_this.model.onDidTrigger, _this.model.onDidCancel)(function () {
                // retrigger or cancel -> try to type default text
                dispose(listener);
                fallback();
            }, undefined, listener);
            _this.model.onDidSuggest(function (_a) {
                var completionModel = _a.completionModel;
                dispose(listener);
                if (completionModel.items.length === 0) {
                    fallback();
                    return;
                }
                var index = _this._memoryService.select(_this.editor.getModel(), _this.editor.getPosition(), completionModel.items);
                var item = completionModel.items[index];
                if (!makesTextEdit(item)) {
                    fallback();
                    return;
                }
                _this.editor.pushUndoStop();
                _this._insertSuggestion({ index: index, item: item, model: completionModel }, 4 /* KeepAlternativeSuggestions */ | 1 /* NoBeforeUndoStop */ | 2 /* NoAfterUndoStop */);
            }, undefined, listener);
        });
        this.model.trigger({ auto: false, shy: true });
        this.editor.revealLine(positionNow.lineNumber, 0 /* Smooth */);
        this.editor.focus();
    };
    SuggestController.prototype.acceptSelectedSuggestion = function (keepAlternativeSuggestions, alternativeOverwriteConfig) {
        var item = this.widget.value.getFocusedItem();
        var flags = 0;
        if (keepAlternativeSuggestions) {
            flags |= 4 /* KeepAlternativeSuggestions */;
        }
        if (alternativeOverwriteConfig) {
            flags |= 8 /* AlternativeOverwriteConfig */;
        }
        this._insertSuggestion(item, flags);
    };
    SuggestController.prototype.acceptNextSuggestion = function () {
        this._alternatives.value.next();
    };
    SuggestController.prototype.acceptPrevSuggestion = function () {
        this._alternatives.value.prev();
    };
    SuggestController.prototype.cancelSuggestWidget = function () {
        this.model.cancel();
        this.model.clear();
        this.widget.value.hideWidget();
    };
    SuggestController.prototype.selectNextSuggestion = function () {
        this.widget.value.selectNext();
    };
    SuggestController.prototype.selectNextPageSuggestion = function () {
        this.widget.value.selectNextPage();
    };
    SuggestController.prototype.selectLastSuggestion = function () {
        this.widget.value.selectLast();
    };
    SuggestController.prototype.selectPrevSuggestion = function () {
        this.widget.value.selectPrevious();
    };
    SuggestController.prototype.selectPrevPageSuggestion = function () {
        this.widget.value.selectPreviousPage();
    };
    SuggestController.prototype.selectFirstSuggestion = function () {
        this.widget.value.selectFirst();
    };
    SuggestController.prototype.toggleSuggestionDetails = function () {
        this.widget.value.toggleDetails();
    };
    SuggestController.prototype.toggleExplainMode = function () {
        this.widget.value.toggleExplainMode();
    };
    SuggestController.prototype.toggleSuggestionFocus = function () {
        this.widget.value.toggleDetailsFocus();
    };
    SuggestController.prototype.resetWidgetSize = function () {
        this.widget.value.resetPersistedSize();
    };
    SuggestController.ID = 'editor.contrib.suggestController';
    SuggestController = __decorate([
        __param(1, ISuggestMemoryService),
        __param(2, ICommandService),
        __param(3, IContextKeyService),
        __param(4, IInstantiationService),
        __param(5, ILogService)
    ], SuggestController);
    return SuggestController;
}());
export { SuggestController };
var TriggerSuggestAction = /** @class */ (function (_super) {
    __extends(TriggerSuggestAction, _super);
    function TriggerSuggestAction() {
        return _super.call(this, {
            id: TriggerSuggestAction.id,
            label: nls.localize('suggest.trigger.label', "Trigger Suggest"),
            alias: 'Trigger Suggest',
            precondition: ContextKeyExpr.and(EditorContextKeys.writable, EditorContextKeys.hasCompletionItemProvider),
            kbOpts: {
                kbExpr: EditorContextKeys.textInputFocus,
                primary: 2048 /* CtrlCmd */ | 10 /* Space */,
                secondary: [2048 /* CtrlCmd */ | 39 /* KEY_I */],
                mac: { primary: 256 /* WinCtrl */ | 10 /* Space */, secondary: [512 /* Alt */ | 9 /* Escape */, 2048 /* CtrlCmd */ | 39 /* KEY_I */] },
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    TriggerSuggestAction.prototype.run = function (accessor, editor) {
        var controller = SuggestController.get(editor);
        if (!controller) {
            return;
        }
        controller.triggerSuggest();
    };
    TriggerSuggestAction.id = 'editor.action.triggerSuggest';
    return TriggerSuggestAction;
}(EditorAction));
export { TriggerSuggestAction };
registerEditorContribution(SuggestController.ID, SuggestController);
registerEditorAction(TriggerSuggestAction);
var weight = 100 /* EditorContrib */ + 90;
var SuggestCommand = EditorCommand.bindToContribution(SuggestController.get);
registerEditorCommand(new SuggestCommand({
    id: 'acceptSelectedSuggestion',
    precondition: SuggestContext.Visible,
    handler: function (x) {
        x.acceptSelectedSuggestion(true, false);
    }
}));
// normal tab
KeybindingsRegistry.registerKeybindingRule({
    id: 'acceptSelectedSuggestion',
    when: ContextKeyExpr.and(SuggestContext.Visible, EditorContextKeys.textInputFocus),
    primary: 2 /* Tab */,
    weight: weight
});
// accept on enter has special rules
KeybindingsRegistry.registerKeybindingRule({
    id: 'acceptSelectedSuggestion',
    when: ContextKeyExpr.and(SuggestContext.Visible, EditorContextKeys.textInputFocus, SuggestContext.AcceptSuggestionsOnEnter, SuggestContext.MakesTextEdit),
    primary: 3 /* Enter */,
    weight: weight,
});
MenuRegistry.appendMenuItem(suggestWidgetStatusbarMenu, {
    command: { id: 'acceptSelectedSuggestion', title: nls.localize('accept.insert', "Insert") },
    group: 'left',
    order: 1,
    when: SuggestContext.HasInsertAndReplaceRange.toNegated()
});
MenuRegistry.appendMenuItem(suggestWidgetStatusbarMenu, {
    command: { id: 'acceptSelectedSuggestion', title: nls.localize('accept.insert', "Insert") },
    group: 'left',
    order: 1,
    when: ContextKeyExpr.and(SuggestContext.HasInsertAndReplaceRange, SuggestContext.InsertMode.isEqualTo('insert'))
});
MenuRegistry.appendMenuItem(suggestWidgetStatusbarMenu, {
    command: { id: 'acceptSelectedSuggestion', title: nls.localize('accept.replace', "Replace") },
    group: 'left',
    order: 1,
    when: ContextKeyExpr.and(SuggestContext.HasInsertAndReplaceRange, SuggestContext.InsertMode.isEqualTo('replace'))
});
registerEditorCommand(new SuggestCommand({
    id: 'acceptAlternativeSelectedSuggestion',
    precondition: ContextKeyExpr.and(SuggestContext.Visible, EditorContextKeys.textInputFocus),
    kbOpts: {
        weight: weight,
        kbExpr: EditorContextKeys.textInputFocus,
        primary: 1024 /* Shift */ | 3 /* Enter */,
        secondary: [1024 /* Shift */ | 2 /* Tab */],
    },
    handler: function (x) {
        x.acceptSelectedSuggestion(false, true);
    },
    menuOpts: [{
            menuId: suggestWidgetStatusbarMenu,
            group: 'left',
            order: 2,
            when: ContextKeyExpr.and(SuggestContext.HasInsertAndReplaceRange, SuggestContext.InsertMode.isEqualTo('insert')),
            title: nls.localize('accept.replace', "Replace")
        }, {
            menuId: suggestWidgetStatusbarMenu,
            group: 'left',
            order: 2,
            when: ContextKeyExpr.and(SuggestContext.HasInsertAndReplaceRange, SuggestContext.InsertMode.isEqualTo('replace')),
            title: nls.localize('accept.insert', "Insert")
        }]
}));
// continue to support the old command
CommandsRegistry.registerCommandAlias('acceptSelectedSuggestionOnEnter', 'acceptSelectedSuggestion');
registerEditorCommand(new SuggestCommand({
    id: 'hideSuggestWidget',
    precondition: SuggestContext.Visible,
    handler: function (x) { return x.cancelSuggestWidget(); },
    kbOpts: {
        weight: weight,
        kbExpr: EditorContextKeys.textInputFocus,
        primary: 9 /* Escape */,
        secondary: [1024 /* Shift */ | 9 /* Escape */]
    }
}));
registerEditorCommand(new SuggestCommand({
    id: 'selectNextSuggestion',
    precondition: ContextKeyExpr.and(SuggestContext.Visible, SuggestContext.MultipleSuggestions),
    handler: function (c) { return c.selectNextSuggestion(); },
    kbOpts: {
        weight: weight,
        kbExpr: EditorContextKeys.textInputFocus,
        primary: 18 /* DownArrow */,
        secondary: [2048 /* CtrlCmd */ | 18 /* DownArrow */],
        mac: { primary: 18 /* DownArrow */, secondary: [2048 /* CtrlCmd */ | 18 /* DownArrow */, 256 /* WinCtrl */ | 44 /* KEY_N */] }
    }
}));
registerEditorCommand(new SuggestCommand({
    id: 'selectNextPageSuggestion',
    precondition: ContextKeyExpr.and(SuggestContext.Visible, SuggestContext.MultipleSuggestions),
    handler: function (c) { return c.selectNextPageSuggestion(); },
    kbOpts: {
        weight: weight,
        kbExpr: EditorContextKeys.textInputFocus,
        primary: 12 /* PageDown */,
        secondary: [2048 /* CtrlCmd */ | 12 /* PageDown */]
    }
}));
registerEditorCommand(new SuggestCommand({
    id: 'selectLastSuggestion',
    precondition: ContextKeyExpr.and(SuggestContext.Visible, SuggestContext.MultipleSuggestions),
    handler: function (c) { return c.selectLastSuggestion(); }
}));
registerEditorCommand(new SuggestCommand({
    id: 'selectPrevSuggestion',
    precondition: ContextKeyExpr.and(SuggestContext.Visible, SuggestContext.MultipleSuggestions),
    handler: function (c) { return c.selectPrevSuggestion(); },
    kbOpts: {
        weight: weight,
        kbExpr: EditorContextKeys.textInputFocus,
        primary: 16 /* UpArrow */,
        secondary: [2048 /* CtrlCmd */ | 16 /* UpArrow */],
        mac: { primary: 16 /* UpArrow */, secondary: [2048 /* CtrlCmd */ | 16 /* UpArrow */, 256 /* WinCtrl */ | 46 /* KEY_P */] }
    }
}));
registerEditorCommand(new SuggestCommand({
    id: 'selectPrevPageSuggestion',
    precondition: ContextKeyExpr.and(SuggestContext.Visible, SuggestContext.MultipleSuggestions),
    handler: function (c) { return c.selectPrevPageSuggestion(); },
    kbOpts: {
        weight: weight,
        kbExpr: EditorContextKeys.textInputFocus,
        primary: 11 /* PageUp */,
        secondary: [2048 /* CtrlCmd */ | 11 /* PageUp */]
    }
}));
registerEditorCommand(new SuggestCommand({
    id: 'selectFirstSuggestion',
    precondition: ContextKeyExpr.and(SuggestContext.Visible, SuggestContext.MultipleSuggestions),
    handler: function (c) { return c.selectFirstSuggestion(); }
}));
registerEditorCommand(new SuggestCommand({
    id: 'toggleSuggestionDetails',
    precondition: SuggestContext.Visible,
    handler: function (x) { return x.toggleSuggestionDetails(); },
    kbOpts: {
        weight: weight,
        kbExpr: EditorContextKeys.textInputFocus,
        primary: 2048 /* CtrlCmd */ | 10 /* Space */,
        mac: { primary: 256 /* WinCtrl */ | 10 /* Space */ }
    },
    menuOpts: [{
            menuId: suggestWidgetStatusbarMenu,
            group: 'right',
            order: 1,
            when: ContextKeyExpr.and(SuggestContext.DetailsVisible, SuggestContext.CanResolve),
            title: nls.localize('detail.more', "show less")
        }, {
            menuId: suggestWidgetStatusbarMenu,
            group: 'right',
            order: 1,
            when: ContextKeyExpr.and(SuggestContext.DetailsVisible.toNegated(), SuggestContext.CanResolve),
            title: nls.localize('detail.less', "show more")
        }]
}));
registerEditorCommand(new SuggestCommand({
    id: 'toggleExplainMode',
    precondition: SuggestContext.Visible,
    handler: function (x) { return x.toggleExplainMode(); },
    kbOpts: {
        weight: 100 /* EditorContrib */,
        primary: 2048 /* CtrlCmd */ | 85 /* US_SLASH */,
    }
}));
registerEditorCommand(new SuggestCommand({
    id: 'toggleSuggestionFocus',
    precondition: SuggestContext.Visible,
    handler: function (x) { return x.toggleSuggestionFocus(); },
    kbOpts: {
        weight: weight,
        kbExpr: EditorContextKeys.textInputFocus,
        primary: 2048 /* CtrlCmd */ | 512 /* Alt */ | 10 /* Space */,
        mac: { primary: 256 /* WinCtrl */ | 512 /* Alt */ | 10 /* Space */ }
    }
}));
//#region tab completions
registerEditorCommand(new SuggestCommand({
    id: 'insertBestCompletion',
    precondition: ContextKeyExpr.and(EditorContextKeys.textInputFocus, ContextKeyExpr.equals('config.editor.tabCompletion', 'on'), WordContextKey.AtEnd, SuggestContext.Visible.toNegated(), SuggestAlternatives.OtherSuggestions.toNegated(), SnippetController2.InSnippetMode.toNegated()),
    handler: function (x, arg) {
        x.triggerSuggestAndAcceptBest(isObject(arg) ? __assign({ fallback: 'tab' }, arg) : { fallback: 'tab' });
    },
    kbOpts: {
        weight: weight,
        primary: 2 /* Tab */
    }
}));
registerEditorCommand(new SuggestCommand({
    id: 'insertNextSuggestion',
    precondition: ContextKeyExpr.and(EditorContextKeys.textInputFocus, ContextKeyExpr.equals('config.editor.tabCompletion', 'on'), SuggestAlternatives.OtherSuggestions, SuggestContext.Visible.toNegated(), SnippetController2.InSnippetMode.toNegated()),
    handler: function (x) { return x.acceptNextSuggestion(); },
    kbOpts: {
        weight: weight,
        kbExpr: EditorContextKeys.textInputFocus,
        primary: 2 /* Tab */
    }
}));
registerEditorCommand(new SuggestCommand({
    id: 'insertPrevSuggestion',
    precondition: ContextKeyExpr.and(EditorContextKeys.textInputFocus, ContextKeyExpr.equals('config.editor.tabCompletion', 'on'), SuggestAlternatives.OtherSuggestions, SuggestContext.Visible.toNegated(), SnippetController2.InSnippetMode.toNegated()),
    handler: function (x) { return x.acceptPrevSuggestion(); },
    kbOpts: {
        weight: weight,
        kbExpr: EditorContextKeys.textInputFocus,
        primary: 1024 /* Shift */ | 2 /* Tab */
    }
}));
registerEditorAction(/** @class */ (function (_super) {
    __extends(class_1, _super);
    function class_1() {
        return _super.call(this, {
            id: 'editor.action.resetSuggestSize',
            label: nls.localize('suggest.reset.label', "Reset Suggest Widget Size"),
            alias: 'Reset Suggest Widget Size',
            precondition: undefined
        }) || this;
    }
    class_1.prototype.run = function (_accessor, editor) {
        SuggestController.get(editor).resetWidgetSize();
    };
    return class_1;
}(EditorAction)));
